/* mg-work-grid.h
 *
 * Copyright (C) 2002 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __MG_WORK_GRID__
#define __MG_WORK_GRID__

#include <gtk/gtk.h>
#include "mg-conf.h"
#include "mg-enums.h"

G_BEGIN_DECLS

#define MG_WORK_GRID_TYPE          (mg_work_grid_get_type())
#define MG_WORK_GRID(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, mg_work_grid_get_type(), MgWorkGrid)
#define MG_WORK_GRID_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, mg_work_grid_get_type (), MgWorkGridClass)
#define IS_MG_WORK_GRID(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, mg_work_grid_get_type ())


typedef struct _MgWorkGrid      MgWorkGrid;
typedef struct _MgWorkGridClass MgWorkGridClass;
typedef struct _MgWorkGridPriv  MgWorkGridPriv;

/* struct for the object's data */
struct _MgWorkGrid
{
	GtkVBox             object;

	MgWorkGridPriv     *priv;
};

/* struct for the object's class */
struct _MgWorkGridClass
{
	GtkVBoxClass       parent_class;

	void             (*selection_changed) (MgWorkGrid *grid, gboolean row_selected);
};

/* 
 * Generic widget's methods 
 */
guint        mg_work_grid_get_type            (void);
GtkWidget   *mg_work_grid_new                 (MgQuery *query, MgTarget *modified);

void         mg_work_grid_set_sample_size     (MgWorkGrid *grid, gint sample_size);
void         mg_work_grid_set_sample_start    (MgWorkGrid *grid, gint sample_start);

G_END_DECLS

#endif



