/* Copyright 2005 Matt Flax <flatmax@ieee.org>
   This file is part of MFFM GTK wrapper class set

   MFFM GTK wrapper class set is free software; you can redistribute
   it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   MFFM GTK wrapper class set is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You have received a copy of the GNU General Public License
   along with MFFM GTK wrapper class set
 */
/* Compile with ...
g++ -ggdb `gtk-config --cflags` ButtonsTest.C -o ButtonsTest `gtk-config --libs`
*/
#include "gtkInterface.H"
#include "Buttons.H"

static void quit(void *wid, gpointer data){
  gtk_main_quit();
}

static void toggleButton(void *widget, gpointer data){
  cout<<"ToggleButton "<<data<<endl;
}

int main(int argc, char *argv[]){
  gtk_init( &argc, &argv );

  GtkInterface topWindow;

  Buttons buttons;
  buttons<<BUTTONLABELSTRUCT{"Quit", quit, NULL}<<BUTTONTOGGLESTRUCT{"TOGGLE",toggleButton, 0};

  HBox hBox;
  hBox<< buttons.grab(1)<< buttons.grab(2);
  hBox.show();
  topWindow<< hBox.getWidget();


  //topWindow<<buttons.grab(1)<<buttons.grab(2);

  gtk_main();
}
