/*
 * Copyright (C) 2002 2003 2004 2005, Magnus Hjorth
 *
 * This file is part of mhWaveEdit.
 *
 * mhWaveEdit is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by        
 * the Free Software Foundation; either version 2 of the License, or  
 * (at your option) any later version.
 *
 * mhWaveEdit is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of  
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with mhWaveEdit; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 */


/* Automatically generated by gendocs.sh */
#include <stdio.h>
#include "gettext.h"
#include "help.h"

int help_page_count = 13
;
char *help_page_titles[] = {
     N_("General"),
     N_("Sample view"),
     N_("Playing"),
     N_("Recording"),
     N_("Editing"),
     N_("Effects"),
     N_("Quality"),
     N_("File formats"),
     N_("Files"),
     N_("Keyboard shortcuts"),
     N_("Bug reporting"),
     N_("Helping out"),
     N_("Contact"),
     NULL };

char *help_page_contents[] = {
     /* xgettext:no-c-format */ N_(
     "\n"
     "mhWaveEdit is a graphical program for editing sound files. It is completely free (GPL).\n"
     "\n"
     "You can find the latest release of mhWaveEdit at:\n"
     "http://gna.org/projects/mhwaveedit/\n"
     ),
     /* xgettext:no-c-format */ N_(
     "\n"
     "The area where you 'see' the contents of the file you are editing, is called the 'sample view'. \n"
     "\n"
     "In the sample view there is a grey vertical bar called the 'cursor'. The cursor follows the sound wave when you play the sound. You can position the cursor by clicking with the right (2:nd) mouse button. If you do this while you're playing a file, the playing will continue from the new cursor position. You can also position the cursor more exact by using the 'Position Cursor...' command on the Edit menu.\n"
     "\n"
     "You can place marks in your file by holding down Ctrl and pressing a number from 0 to 9. This will place a mark (green vertical bar) with the same number at the current cursor position. You can later make the cursor go to that position again by just pressing the number. Setting and jumping to marks can be done while playing. To remove a mark, jump to the mark and set it again.\n"
     ),
     /* xgettext:no-c-format */ N_(
     "\n"
     "Playing a file is simple, just load the file and press the play button. The green play button plays from the current position. The yellow play button plays the current selection, or the entire file if nothing is selected. Stop the playback with the stop button (with the red square). \n"
     "\n"
     "The playback speed can be varied by adjusting the slider to the far right. \n"
     "\n"
     "You can do normal editing while the file is playing.\n"
     ),
     /* xgettext:no-c-format */ N_(
     "\n"
     "Recording is done with 'Record...' on the Play menu, or the Record button (the red circle). A dialog box will pop up where you can select what format you want to record in. After selecting the format, meters and numbers will appear showing info about the volume level of the sound input. \n"
     "\n"
     "When you want to start recording, press the \"Start recording\" button. When you've recorded everything you wanted to, press the Finish button and the record dialog will disappear and newly recorded sound will show up in a new window.\n"
     "\n"
     "Currently it is impossible to play and record at the same time, so the playback will stop when you record.\n"
     ),
     /* xgettext:no-c-format */ N_(
     "\n"
     "You make selections by dragging the mouse over the sample view. You can hear what you've currently selected by clicking on the \"play selection\" button (the button with the yellow arrow) or by selecting 'Play selection' from the Play menu.\n"
     "\n"
     "You can use the cursor to refine the selection. Use the 'Selection start at cursor' and 'Selection end at cursor' buttons to move the selection starting point or the selection end point to the current cursor position. You can also drag the selection endpoints using the mouse.\n"
     "\n"
     "The 'Cut' and 'Copy' functions work like in any other software. \n"
     "\n"
     "The 'Paste' function insert the clipboard contents at the cursor position. The 'Paste over' function works like 'Paste', except that it overwrites the data after the insert position. \n"
     "\n"
     "The 'Paste mix' function combines the clipboard data with the data at the cursor position.\n"
     "\n"
     "The 'Paste as new' function opens a new window and puts the clipboard contents into it. \n"
     "\n"
     "The 'Crop' function deletes all parts of the file that are not selected.\n"
     "\n"
     "The 'Silence selection' function replaces the selected part with silence. To avoid clicks, the silent part is a line that meets the wave at the endpoints.\n"
     "\n"
     "All editing functions work non-destructively, that is, the file you're editing isn't actually changed until you save it (the effects also work this way).\n"
     "\n"
     ),
     /* xgettext:no-c-format */ N_(
     "\n"
     "mhWaveEdit has a few simple effects, which are available from the 'Effects' menu. \n"
     "\n"
     " * Fade in/out\n"
     "\n"
     "   This creates a linear fade in or fade out effect.\n"
     "\n"
     " * Normalize, Normalize to...\n"
     "\n"
     "   This amplifies the sound as much as possible without getting clipping distortion. The \"Normalize to...\" item lets you specify which level to normalize to.\n"
     "\n"
     " * Volume adjust/fade...\n"
     "\n"
     "   This effect lets you select a starting volume and a ending volume and amplifies the selection fading from the starting volume to the ending volume.\n"
     "\n"
     "   Note that volumes above 100% may cause sound distortion. Use the 'Find top volume' to find out the maximum amplification possible without distortion. (You can use this for normalizing samples.) \n"
     "\n"
     "   By setting starting volume and ending volume to the same value you get a simple amplification of the sound. \n"
     "\n"
     " * Convert samplerate...\n"
     "\n"
     "   This converts the samplerate of the entire file to one you specify. There are different methods for doing this, usually the one in the top has the best quality but can take longer than the other methode.\n"
     "\n"
     " * Convert sample format...\n"
     "\n"
     "   This converts the sample format of the entire file.\n"
     "\n"
     "   The 'Don't actually change the data' option can be used if the program was wrong about the file's format.\n"
     "\n"
     " * Byte swap\n"
     "\n"
     "   This \"byte swaps\" the selected part. It can be used to repair damaged files where the byte order is wrong. Note that if the sound looks alright but plays wrong, you should not use this option, instead you should use the \"byte-swap output\" option in the Preferences dialog.\n"
     "\n"
     " * Mix to mono\n"
     "\n"
     "   This mixes all channels of the file together to a mono sound.\n"
     "\n"
     " * Add channel\n"
     "\n"
     "   This copies the first channel to a new channel in the sound, converting mono to stereo etc.\n"
     "\n"
     " * Map channels...\n"
     "   \n"
     "   With this effect, you can change the number of channels in the file. You can also rearrange and add (i.e. mix) channels.\n"
     "\n"
     " * Combine channels...\n"
     "\n"
     "   This effect lets you create a new sound by a linear combination of the old channels. This means you can do channel mixing / swapping / balance / panning / amplification etc. by entering different values. For example, to swap the left and right channel, you select that the new Channel 1 should be 0% of the old Channel 1 and 100% of the old Channel 2, and the new Channel 2 should be 100% of the old Channel 1 and 0% of the old Channel 2 \n"
     "\n"
     " * Speed adjustment...\n"
     "\n"
     "   This effect changes the speed of the selection. The tone will change as well.\n"
     " * Pipe through program...\n"
     " \n"
     "   This effect is for advanced users wanting to pipe raw audio data through an external program. The output of the program is read back and replaces the processed part. \n"
     "\n"
     "mhWaveEdit supports LADSPA effects and can also make use of most of the SoX utility's effects. To find the LADSPA plugins the environment variable LADSPA_PATH must be properly set up. \n"
     "\n"
     "All supported effects can be found by choosing the 'Effects...' menu item. The effects are listed with names beginning with [B] for builtin effects, [L] for LADSPA effects, and [S] for SoX effects.\n"
     "\n"
     ),
     /* xgettext:no-c-format */ N_(
     "\n"
     "Some notes on sound quality.\n"
     "\n"
     "The general rule when doing audio editing/processing is to not manipulate the data more than necessary and keep an original copy whenever you're processing your important files. \n"
     "\n"
     "Cut, copy and paste operations move the data around without modifying it, so these don't degrade the sound quality. Because of level differences, you may get a \"step\" at the start and end of the inserted part, which can cause a small clicking sound. \n"
     "\n"
     "The mix paste function doesn't decrease quality, unless the peaks become too high and you get clipping. In that case you will get a warning message.\n"
     "\n"
     "Sound data is normally stored as integer values. Therefore, whenever you normalize, adjust volume, decrease sample size or filter a sound, the result must be rounded. If you use 24 or 32 bit sample sizes, this is not really a problem, but if you use 8 or 16 bits sample size, this rounding causes a decrease in quality. \n"
     "\n"
     "The quality decrease that the rounding causes can be masked by adding a small amount of noise before rounding. This is called \"dithering\". mhWaveEdit supports basic triangular dithering and it's enabled by default. \n"
     "\n"
     "By default, mhWaveEdit uses floating-point temporary files for storing processed results to avoid rounding until the file is saved.\n"
     ),
     /* xgettext:no-c-format */ N_(
     "\n"
     "Even if mhWaveEdit was originally built for editing wav files, it's also possible to load and save in a few other formats. mhWaveEdit always supports wav and raw files, but if it's compiled with the libsndfile library, mhWaveEdit supports a couple of other formats as well. \n"
     "\n"
     "To save a file with a different file format, use \"Save as...\" and choose a format in the file type selection box. \n"
     "\n"
     "mhWaveEdit has basic support for mp3 and ogg formats. For this to work you need to have LAME installed for mp3 support, and OggDec/OggEnc for Ogg support. If you have these programs, you can open and save mp3/ogg files just like any other file format.\n"
     "\n"
     "If mplayer is installed, mhwaveedit can open all formats that it supports, for example the soundtrack of a video file. Since mplayer is only a player, these files can not be saved back after editing, you have to save the file into a supported format.\n"
     ),
     /* xgettext:no-c-format */ N_(
     "\n"
     "mhWaveEdit creates a directory ~/.mhwaveedit where it stores configuration information. \n"
     "\n"
     "The configuration file is called config. It can be hand edited, but the easiest way is through 'Preferences' on the Edit menu.\n"
     "\n"
     "Each mhwaveedit process creates a session file in the .mhwaveedit directory called mhwaveedit-session-<pid>-<session>-<state>, where <session> is the session ID number and <state> is a character code showing the state of the session ('r' for running sessions). \n"
     "\n"
     "Temporary files are by default also stored in the ~/.mhwaveedit directory. Which directories to use can be set through the preferences dialog. To get the best performance, you should have one temporary directory for each local filesystem. The temporary files have names of the form \"mhwaveedit-temp-<pid>-nnnn-<session>\". Do NOT open or remove temporary files with the same pid number as a currently running mhWaveEdit.\n"
     "\n"
     "mhWaveEdit checks on startup for leftover temporary files and lets the user open them. After opening a crashed session, the files can be saved or thrown away.\n"
     ),
     /* xgettext:no-c-format */ N_(
     "\n"
     "F1            Help\n"
     "F12           Record\n"
     "\n"
     "Ctrl+(number) Set mark\n"
     "(number)      Goto mark\n"
     "\n"
     "Ctrl+P        Preferences\n"
     "Ctrl+E        Effects\n"
     "\n"
     "Ctrl+O        Open file\n"
     "Ctrl+S        Save file\n"
     "Ctrl+U        Save selection as\n"
     "\n"
     "Ctrl+C        Copy\n"
     "Ctrl+X        Cut\n"
     "Ctrl+D        Delete\n"
     "Ctrl+V        Paste\n"
     "Ctrl+Z        Undo\n"
     "Ctrl+A        Select all\n"
     "\n"
     "Ctrl+G        Position cursor (Go to)\n"
     "Ctrl+H        Position cursor at file start\n"
     "Ctrl+J        Position cursor at file end\n"
     "Ctrl+K        Position cursor at selection start\n"
     "Ctrl+L        Position cursor at selection end\n"
     "Y,U           Move cursor to nearest all-channel zero-crossing\n"
     "I,O           Move cursor to nearest any-channel zero-crossing\n"
     "\n"
     "Ctrl+Q        Selection start at cursor\n"
     "Ctrl+W        Selection end at cursor\n"
     "\n"
     "+,=           Zoom in\n"
     "-             Zoom out\n"
     ">             Zoom to selection\n"
     "<             Zoom all\n"
     "Arrow keys    Scroll left/right\n"
     "\n"
     "<space>       Play/Stop\n"
     ",             Play from cursor pos\n"
     ".             Stop\n"
     "/             Play selection\n"
     "H,J           Move cursor (and playback) 1/8 of view\n"
     "K,L           Move cursor one sample\n"
     "Ctrl+arrow    Move cursor (and playback) half second\n"
     "(             Play first 3 seconds of selection\n"
     ")             Play last 3 seconds of selection\n"
     ),
     /* xgettext:no-c-format */ N_(
     "\n"
     "If you find a bug or flaw in the program that's not mentioned in the BUGS file, report the bug in the bug tracker (see contact info) or mail a bug report describing the bug to: magnus.hjorth@home.se\n"
     "\n"
     "In case of a crash, please do not send me any core dumps. They are huge and completely useless to me. Instead, create a backtrace. Backtraces tell you exactly where the program crashed.\n"
     "\n"
     "How to create a backtrace:\n"
     "1. Enable core dumps: ulimit -c unlimited\n"
     "2. Run the program:   mhwaveedit\n"
     "3. Make the program crash. You should now get a file named core or core.1234 in the directory you're in.\n"
     "4. Run gdb with the program and core file: \n"
     "   gdb /usr/local/bin/mhwaveedit core | tee backtrace.txt\n"
     "5. After gdb has loaded, use the command: bt\n"
     "6. Quit gdb with the command: quit\n"
     "7. Now you should have a back trace in the file backtrace.txt\n"
     ),
     /* xgettext:no-c-format */ N_(
     "\n"
     "There are plenty of things you can do if you want to help the development of mhWaveEdit. \n"
     "\n"
     "First of all, look for bugs and report all bugs you find into the bug tracker or through e-mail. Sometimes a bug can get overlooked for a long time because nobody reports it, so don't be afraid to report bugs that have been there for a few releases. You don't have to provide fixes or very detailed information, although it helps of course.\n"
     "\n"
     "Feature requests are also welcome, report them to the mailing list or to the bug tracker.\n"
     "\n"
     "If you speak a language other than English and mhWaveEdit isn't translated to your language, you can contribute a translation. To do that, copy the template mhwaveedit.pot in the po directory into a new file ll.po, where ll is your language code (see http://www.gnu.org/software/gettext/manual/html_node/gettext_221.html for a list of language codes). \n"
     "\n"
     "It's possible to edit po-files by hand, but I recommend a program such as poEdit (http://www.poedit.org) for editing translations. \n"
     "\n"
     "Note that for those translatable strings that look like \"RecordStatus|Paused\", you should ignore what's to the left and only translate the string to the right (\"Paused\" in this example). This convention is there to make it possible to translate the same string to different things depending on context. \n"
     "\n"
     "After you've filled in all the translations you want (you don't have to translate all the strings), mail in the po file to me (see contact info) and I'll add it to the next release. \n"
     "\n"
     "If a translation is incomplete, you're very welcome to translate the remaining untranslated messages and mail them in. Corrections to translations are also appreciated, but they may need to be checked with the previous translator before including them. \n"
     "\n"
     "Money donations through PayPal are also gratefully accepted. For the address, see the contact information. Donors of $10 or more will be credited with the donor's name ($25 for a company name), email and web site as a sponsor in the AUTHORS file of future releases and also in other places in the future. Note that any donations are gifts to me (Magnus Hjorth) personally, not payment for a service of any kind. If you want some other arrangement, send me an email. \n"
     ),
     /* xgettext:no-c-format */ N_(
     "\n"
     "For bug reports, translation updates, patches and PayPal donations:\n"
     "magnus.hjorth@home.se\n"
     "\n"
     "Project page with bug tracker, mailing list membership:\n"
     "http://gna.org/projects/mhwaveedit\n"
     "\n"
     "Mailing list (you must be a subscriber before you can post messages):\n"
     "mhwaveedit-discuss@gna.org\n"
     "\n"
     ),
     NULL };
