/* netrc.c and netrc.h are for processing the ~/.netrc file
   This has nothing to do with cryptography.
   Copyright (C) 1998 Egil Kvaleberg

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
      
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
    The format of the ~/.netrc file is basically:

	machine ftp.somewhere.net
	    login somename
	    password secret

    This sequence is of course repeated once for every machine.

    The file typically ends in:

	default
	    login anonymous
	    password someone@somewhere.net

    See man ftp for further detail.

    The function 
	char *lookup_netrc(char *host, char *user)
    returns an allocated string containing a password if such a thing
    is found in the ~/.netrc file.
*/

#ifndef _NETRC_H
#define _NETRC_H

#define NETRC PATH_SEP_STR ".netrc"	/* in home directory */
#define MAXLEN (1024+1)

#define ST_IDLE     0
#define ST_COMMENT  1
#define ST_ACCOUNT  2
#define ST_DEFAULT  3
#define ST_LOGIN    4
#define ST_MACDEF   5
#define ST_MACHINE  6
#define ST_PASSWORD 7

char *lookup_netrc (char *host, char *user);

#endif				/* !_NETRC_H */
