/* 
   This has nothing to do with cryptography.
   This file is what actually does the `porting' of the vfs code
   to standalone format.
 */

#ifndef _VFS_UTIL_H
#define _VFS_UTIL_H

#define STANDALONE_VFS 1
#define HAVE_FTPFS 1
#define HAVE_MCFS 1

#define enable_interrupt_key() 
#define disable_interrupt_key() 

#define message_1s(x,y,z) (*vfs_message_callback) (z)
#define message_2s(w,x,y,z) (*vfs_message_callback) (y, z)

#ifdef WIN32
#define PATH_SEP_STR "\\"
#define PATH_SEP '\\'
#else
#define PATH_SEP_STR "/"
#define PATH_SEP '/'
#endif

#define tilde_expand(x) x

#ifndef HAVE_GETCWD
#define get_current_wd(b,s) getwd(b)
#else
#define get_current_wd(b,s) getcwd(b,s)
#endif

#define cpanel 0

#ifndef mcserver_port
#define mcserver_port 9876
#endif

#define print_vfs_message (*vfs_message_callback)
#define load_anon_passwd(h) (*vfs_getanonpasswd_callback) (h) /*EK*/
#define input_dialog(x,y,z,h,u) (*vfs_getpasswd_callback) (x,y,z,h,u) /*EK*/
#define got_interrupt() (*vfs_gotinterrupt_callback) ()

void vfs_default_message_callback (char *p,...);
char *vfs_default_getpasswd_callback (char *, char *, char *, char *, char *); /*EK*/
char *vfs_default_getanonpasswd_callback (char *);
int vfs_default_gotinterrupt_callback (void);

#ifdef _VFS_VFS_C
void (*vfs_message_callback) (char *,...) = vfs_default_message_callback;
char *(*vfs_getpasswd_callback) (char *, char *, char *, char *, char *) 
				   = vfs_default_getpasswd_callback; /*EK*/
char *(*vfs_getanonpasswd_callback) (char *) 
				   = vfs_default_getanonpasswd_callback; /*EK*/
int (*vfs_gotinterrupt_callback) (void) = vfs_default_gotinterrupt_callback;
#else
extern void (*vfs_message_callback) (char *,...);
extern char *(*vfs_getpasswd_callback) (char *, char *, char *, char *, char *); /*EK*/
extern char *(*vfs_getanonpasswd_callback) (char *); /*EK*/
extern int (*vfs_gotinterrupt_callback) (void);
#endif

void vfs_set_message_callback (void (*callback) (char *,...));
void vfs_set_getpasswd_callback (char *(*callback) (char *, char *, char *, char *, char *)); /*EK*/
void vfs_set_getanonpasswd_callback (char *(*callback) (char *)); /*EK*/
void vfs_set_gotinterrupt_callback (int (*callback) (void));

char *canonicalize_pathname (char *path);
#ifdef HAVE_MAD
#define wipe_password(p) mad_wipe_password(p, __FILE__, __LINE__)
void mad_wipe_password (char *passwd, char *file, int line);
#else
void wipe_password (char *passwd);
#endif
char *unix_error_string (int error_num);
#ifdef HAVE_MAD
char *mad_copy_strings (char *file, int line, const char *first, ...);
#define copy_strings(p...) mad_copy_strings(__FILE__, __LINE__, p)
#else
char *copy_strings (const char *first, ...);
#endif
int exist_file (char *name);
void ftpfs_init_passwd(void);
void ftpfs_set_anonymous_password (char *p);

#ifndef S_IFMT
#define	S_IFMT	0170000
#endif
#ifndef S_IFDIR
#define	S_IFDIR	0040000
#endif
#ifndef S_IFCHR
#define	S_IFCHR	0020000
#endif
#ifndef S_IFBLK
#define	S_IFBLK	0060000
#endif
#ifndef S_IFREG
#define	S_IFREG	0100000
#endif
#ifndef S_IFIFO
#define	S_IFIFO	0010000
#endif
#ifndef S_IFLNK
#define	S_IFLNK		0120000
#endif
#ifndef S_IFSOCK
#define	S_IFSOCK	0140000
#endif
#ifndef S_ISUID
#define	S_ISUID		04000
#endif
#ifndef S_ISGID
#define	S_ISGID		02000
#endif
#ifndef S_ISVTX
#define	S_ISVTX		01000
#endif
#ifndef S_IREAD
#define	S_IREAD		0400
#endif
#ifndef S_IWRITE
#define	S_IWRITE	0200
#endif
#ifndef S_IEXEC
#define	S_IEXEC		0100
#endif
#ifndef S_ISTYPE
#define	S_ISTYPE(mode, mask)	(((mode) & S_IFMT) == (mask))
#endif
#ifndef S_ISDIR
#define	S_ISDIR(mode)	S_ISTYPE((mode), S_IFDIR)
#endif
#ifndef S_ISCHR
#define	S_ISCHR(mode)	S_ISTYPE((mode), S_IFCHR)
#endif
#ifndef S_ISBLK
#define	S_ISBLK(mode)	S_ISTYPE((mode), S_IFBLK)
#endif
#ifndef S_ISREG
#define	S_ISREG(mode)	S_ISTYPE((mode), S_IFREG)
#endif
#ifndef S_ISFIFO
#define	S_ISFIFO(mode)	S_ISTYPE((mode), S_IFIFO)
#endif
#ifndef S_ISLNK
#define	S_ISLNK(mode)	S_ISTYPE((mode), S_IFLNK)
#endif
#ifndef S_ISSOCK
#define	S_ISSOCK(mode)	S_ISTYPE((mode), S_IFSOCK)
#endif
#ifndef S_IRWXU
#define	S_IRWXU	(__S_IREAD|__S_IWRITE|__S_IEXEC)
#endif

#endif

