/*
   mkvmerge -- utility for splicing together matroska files
   from component media subtypes

   Distributed under the GPL
   see the file COPYING for details
   or visit http://www.gnu.org/copyleft/gpl.html

   $Id: p_passthrough.h 2932 2005-05-25 21:31:26Z mosu $

   class definition for the pass through output module

   Written by Moritz Bunkus <moritz@bunkus.org>.
*/

#ifndef __P_PASSTHROUGH_H
#define __P_PASSTHROUGH_H

#include "os.h"

#include "common.h"
#include "pr_generic.h"

class passthrough_packetizer_c: public generic_packetizer_c {
private:
  int64_t packets_processed, bytes_processed;
  bool sync_to_keyframe, sync_complete_group;

public:
  passthrough_packetizer_c(generic_reader_c *_reader, track_info_c &_ti)
    throw (error_c);

  virtual int process(packet_cptr packet);
  virtual void set_headers();
  virtual void always_sync_complete_group(bool sync);

  virtual void dump_debug_info();

  virtual const char *get_format_name() {
    return "passthrough";
  }
  virtual connection_result_e can_connect_to(generic_packetizer_c *src,
                                             string &error_message);
};

#endif // __P_PASSTHROUGH_H
