# Copyright 2006 Soeren Boll Overgaard <boll@fork.dk>
#
# This file is part of mlmmjadmd.
#
# mlmmjadmd is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# mlmmjadmd is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with mlmmjadmd; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

from ConfigParser import SafeConfigParser;
import conf;
import crypt;
import logging;
import sys;
import mlmmjadm.util;
import mlmmjadm.conf;

class Authenticator:
    
    configuration = None;
    usersParser = None;
    usersFile = None;
    #makeUsersFile = None;
    
    def __init__(self):
        self.configuration = mlmmjadm.conf.Configuration();
    
    def usersFileOk(self):
        if not self.createUsersParser():
            logging.warn("Unable to create a users parser");
            return False;
        if not self.usersParser:
            logging.warn("No users parser available. Returning False");
            return False;
        if not self.usersParser.has_section("Users"):
            logging.warn("Users file has no Users section. Returning False");
            return False;
        return True;
    
    def fixUsersFile(self):
        if not mlmmjadm.util.fileExists(self.configuration.getUsersFile()):
            logging.info("Creating new users file");
            mlmmjadm.util.createFile(self.configuration.getUsersFile());
        if not self.createUsersParser():
            logging.warn("Unable to create a users parser");
            return False;
        if not self.usersParser.has_section("Users"):
            self.usersParser.add_section("Users");
            self.flushUsersParser();
        return True;
        
    
    def openUsersFileWrite(self):
        try:
            self.usersFile = open(self.configuration.getUsersFile(), "w");
            return True;
        except IOError, e:
            logging.warning("Unable to open "+self.configuration.getUsersFile()+" ("+str(e)+") for writing.");
            return False;
    
    def openUsersFileRead(self):
        try:
            self.usersFile = open(self.configuration.getUsersFile(), "r");
            return True;
        except IOError, e:
            logging.warning("Unable to open user database "+self.configuration.getUsersFile()+" ("+str(e)+") for reading.");
            return False;
    
    def closeUsersFile(self):
        if self.usersFile and not self.usersFile.closed:
            self.usersFile.close();
        else:
            logging.warn("Unable to close configuration file, since it is not open");
    
    def createUsersParser(self):
        if not self.openUsersFileRead():
            logging.warn("Unable to open users file for reading");
            return False;
        self.usersParser = SafeConfigParser();
        self.usersParser.readfp(self.usersFile);
        self.closeUsersFile();
        return True;
    
    def flushUsersParser(self):
        if not self.usersParser:
            logging.warn("No users parser available to flush.");
            return False;
        if not self.openUsersFileWrite():
            logging.warn("Unable to open users file for writing");
            return False;
        self.usersParser.write(self.usersFile);
        self.closeUsersFile();
        return True;
    
    def authenticate(self, username, password):
        if not self.createUsersParser():
            logging.warn("Unable to create users parser in authenticate. Returning false.");
            return False;
        if self.usersParser.has_option("Users", username):
            storedPassword = self.usersParser.get("Users", username);
            logging.debug("Stored password for user "+username+": "+storedPassword);
            logging.debug("Crypted provided password: "+crypt.crypt(password,password[0:1]));
            if self.usersParser.get("Users", username) == crypt.crypt(password,password[0:1]):
                logging.debug("Successfully authenticated user "+username);
                return True;
        return False;
    
    def addUser(self, username, password):
        if not self.createUsersParser():
            logging.debug("Unable to create a config parser");
            return False;
        self.usersParser.set("Users", username, crypt.crypt(password,password[0:1]));
        if not self.flushUsersParser():
            return False;
        return True;
    