# Copyright 2006 Soeren Boll Overgaard <boll@fork.dk>
#
# This file is part of mlmmjadmd.
#
# mlmmjadmd is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# mlmmjadmd is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with mlmmjadmd; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import logging;
import os.path;
import os;
import os.path;
import time;
import sys;
import fcntl as f;
import pwd;
import grp;
import conf;
import mlmmjadm.conf;

def userNameToUid(userName):
    try:
        user = pwd.getpwnam(userName);
        return user[2];
    except KeyError, e:
        logging.warning("Unable to look up user "+userName+": "+str(e));
        return None;

def groupNameToGid(groupName):
    try:
        group = grp.getgrnam(groupName);
        return group[2];
    except KeyError, e:
        logging.warning("Unable to look up group "+groupName+": "+str(e));
        return None;

def setEffectiveUser(userName):
    uid = userNameToUid(userName);
    if not uid:
        logging.warn("Unable to switch user. No such username "+userName);
        return;
    try:
        os.seteuid(uid);
    except OSError, e:
        logging.warn("Unable to switch UID to "+str(uid)+": "+str(e));
        return;
    logging.debug("Successfully switched to user "+userName+" ("+str(uid)+")");

def setEffectiveGroup(groupName):
    gid = groupNameToGid(groupName);
    if not gid:
        logging.warn("Unable to switch group. No such group name "+groupName);
        return;
    try:
        os.setegid(gid);
    except OSError, e:
        logging.warn("Unable to switch GID to "+str(gid)+": "+str(e));
        return;
    logging.debug("Successfully switched to group "+groupName+" ("+str(gid)+")");

# This was originally written by Coy Krill <ckrill@qvlinc.com>
# Retrieved from http://mail.python.org/pipermail/python-list/2001-March/034951.html
class NullDevice:
    def write(self, s):
        pass

def daemonize():
    if (not os.fork()):
        # get our own session and fixup std[in,out,err]
        os.setsid()
        sys.stdin.close()
        sys.stdout = NullDevice()
        sys.stderr = NullDevice()
        if (not os.fork()):
            # hang around till adopted by init
            ppid = os.getppid()
            while (ppid != 1):
                time.sleep(0.5)
                ppid = os.getppid()
        else:
            # time for child to die
            os._exit(0)
    else:
        # wait for child to die and then bail
        os.wait()
        sys.exit()

def getFileLines(path):
    result = [];
    try:
        fh = open(path, "r",);
        f.flock(fh, f.LOCK_SH);
        lines = fh.readlines();
        f.flock(fh, f.LOCK_UN);
        fh.close();
    except IOError, e:
        logging.error("Unable to read lines from "+path+": "+str(e));
        return result;
    
    for i in range(len(lines)):
        result.append(lines[i].strip());
        
    return result;

def writeSingleLineFile(path, line):
    logging.debug("Removing "+path);
    removeFile(path)
    logging.debug("Adding "+line+" to "+path);
    return addLine(path, line);

def readSingleLineFile(path):
    logging.debug("Reading single line from "+path);
    if not fileExists(path):
        return None;
    lines = getFileLines(path);
    if lines:
        return lines[0];
    else:
        return None;

def removeLine(path, line):
    # Make a backup
    # Read contents
    try:
        fh = open(path, "r");
        # Aquire an exclusive lock on this file
        f.flock(fh, f.LOCK_EX);
        lines = fh.readlines();
        # Remember to unlock the file
        #f.flock(fh, f.LOCK_UN);
        fh.close();
        
        fh = open(path, "w");
        # Aquire an exclusive lock on this file
        #f.flock(fh,f.LOCK_EX);
        for entry in lines:
            if entry.strip().startswith(line.strip()):
                # Skip this entry
                logging.debug("Succesfully removed "+line+" from "+path)
            else:
                fh.write(entry);
        # Remember to unlock the file
        fh.flush();
        f.flock(fh,f.LOCK_UN);
        fh.close();
    except IOError:
        logging.error("Unable to remove "+line+" from "+path);
    

def addLine(path, line):
    try:
        fh = open(path, "a+");
        # Remember to lock/unlock the file
        f.flock(fh,f.LOCK_EX);
        fh.write(line.strip()+"\n");
        fh.flush();
        f.flock(fh,f.LOCK_UN);
        fh.close();
        return True;
    except IOError, e:
        logging.debug("Unable to add "+line+" to "+path+". "+str(e));
        return False;
    
def fileExists(path):
    return os.path.isfile(path);
    
def dirExists(path):
    return os.path.isdir(path);
    
def createFile(path):
    try:
        fh = open(path, "w");
        f.flock(fh,f.LOCK_EX);
        fh.truncate();
        fh.flush();
        f.flock(fh,f.LOCK_UN);
        fh.close();
        return True;
    except IOError :
        logging.error("Unable to create file "+path);
        return False;

def removeFile(path):
    if fileExists(path):
        try:
            fh = open(path,"r");
            f.flock(fh,f.LOCK_EX);
            os.unlink(path);
            f.flock(fh,f.LOCK_UN);
            fh.close();
            logging.debug("Successfully removed "+path);
            return True;
        except IOError:
            logging.error("Unable to remove file "+path);
            return False;
    logging.error("Unable to remove "+path+". Nu such file exists.");
    return False;

def lockList(list):
    logging.debug("lockList not yet implemented");

def unlockList(list):
    logging.debug("unlockList not yet implemented");
    pass;

def buildListDir(list):
    return mlmmjadm.conf.Configuration().getListBase() + "/"+list+"/";

def buildListControlDir(list):
    return buildListDir(list)+"/control/";
    
def listExists(list):
    if dirExists(buildListDir(list)) and dirExists(buildListControlDir(list)):
        return True;
    else:
        return False;

def writePidFile(pidFile):
    try:
        fh = open(pidFile,"w");
    except IOError, e:
        logging.error("Unable to open pid file for writing: "+str(e));
        return;
    fh.write(str(os.getpid()));
    fh.close();
    
def removePidFile(pidFile):
    try:
        os.path.unlink(pidFile);
    except IOError, e:
        logging.error("Unable to remove pid file "+pidFile+": "+str(e));
        return;
    