      SUBROUTINE TVSEG(XX, YY, SAGITTA
     + ,NSYM, NCOL, THICK, nhat, npat, nhcol, npcol)
C
C     Routine for drawing the segment of a circle - uses HIGZ IGARC
C
#include "mngrn.inc"
#include "mnpij.inc"
C
      REAL XX(2),YY(2),SAGITTA,THICK
      INTEGER NCOL
C
      integer npt,mpt
      parameter (mpt=101)
      REAL XPT(mpt),YPT(mpt)
      real aunit,dist,rad,xs,ys,phis,x0,y0,phi1,phi2,dphi1,dphi2,delphi
      integer i
C
C     Don't do anything if no or null output device selected
C
      IF(LPDEV.LE.1) RETURN
C
#if ( defined(HIGZ) )
C
C     Setup filling if requested
C
      CALL ISLN(NSYM)
      CALL ISPLCI(NCOL)
      IF(NHAT.NE.0) THEN
          CALL ISFAIS(3)
          CALL ISFASI(NHAT)
          CALL ISFACI(NhCOL)
      ELSEIF(NPAT.EQ.100) THEN
          CALL ISFAIS(1)
          CALL ISFACI(NpCOL)
      ELSEIF(NPAT.EQ.200) THEN
          CALL ISFAIS(0)
      ELSEIF(NPAT.NE.0) THEN
          CALL ISFAIS(2)
          CALL ISFASI(NPAT)
          CALL ISFACI(NpCOL)
      ELSE
          CALL ISFAIS(0)
      ENDIF
      CALL ISLWSC(THICK)
      CALL IGSET('LTYP',FLOAT(NSYM))
      CALL IGSET('BORD',1.0)
C
C     Check for zero distance
C
      if(xx(1).eq.xx(2) .and. yy(1).eq.yy(2)) return
C
C     Check for zero sagitta
C
      if(sagitta.eq.0.0) then
        call ipl(2,xx,yy)
C
C     Calculate the circle coordinates
C
      else
        dist = sqrt((xx(2)-xx(1))**2 + (yy(2) - yy(1))**2)
        if(dist.eq.0.0) return
        if(2.0*sagitta.gt.dist) then
          call mn_err('TVSEG','Sagitta must be less than 2 times ' //
     +     'distance between points')
          return
        endif
        rad  = (sagitta**2 + 0.25*dist**2)/(2.0*sagitta)
        xs   = 0.5*(xx(1) + xx(2))
        ys   = 0.5*(yy(1) + yy(2))
        x0   = xs - (rad-sagitta)/dist*(yy(2)-yy(1))
        y0   = ys + (rad-sagitta)/dist*(xx(2)-xx(1))
        phi1 = atan2(yy(1)-y0,xx(1)-x0)
        phi2 = atan2(yy(2)-y0,xx(2)-x0)
        dphi1 = phi1 * rdeg
        dphi2 = phi2 * rdeg
C
C       Use HIGZ routines if required
C
        if(qigarc) then
          CALL IGARC(X0,Y0,rad,rad,dphi1,dphi2)
C
C         Use my code to get round HIGZ bug that sometimes uses
C         wrong symbol and colour
C
        else
          npt = min(mpt,max(9,nint(100.0*rad1)))
          delphi = phi2 - phi1
          if(delphi.eq.0.0) delphi = twopi
          do i=1,npt
            phi = phi1 + float(i-1)/float(npt-1) * delphi
            xpt(i) = x0 + rad*cos(phi)
            ypt(i) = y0 + rad*sin(phi)
          enddo
C
          IF(nhat.ne.0 .or. npat.ne.0) THEN
            call ifa(npt,xpt,ypt)
          ENDIF
C
          call ipl(npt,xpt,ypt)
        endif
      endif
C
#endif
#if ( defined(PLTSUB) )
      WRITE(6,'(
     + '' *** TVSEG: Circle segment drawing not supported in PLTSUB'')')
#endif

      END
