C
      SUBROUTINE M_CUSE(IDELIM,IERR)
C
C     SPECIFIES WHICH CUTS ARE TO BE USED IN PROJECTIONS
C     -2 means .OR.  all cuts
C     -1 means .AND. all cuts
C      0 means no cuts
C     OTHERWISE SYNTAX IS (n .OR. m .and. (l .and. k))
C
      implicit none
C
#include "mnpar.inc"
#include "mncut.inc"
#include "mncmd.inc"
#include "mnlun.inc"
C
      INTEGER IDELIM,IERR
C
      INTEGER NC,NANDOR,NPARI,NPARO,NDEP,NDEPMN
      INTEGER I,NVAL,LENT,LNBLNK,NCHFND,NCHR,NN
      REAL    ARG
      CHARACTER TNAME*10
C
      INTEGER  INTTYQ,ISTTYQ,ICMTYQ,LCHTYP,NCHSCN
      REAL     VALTYQ
      EXTERNAL INTTYQ,ISTTYQ,ICMTYQ,LCHTYP,NCHSCN,VALTYQ
C
      IERR = 0
C
C     ALLOW ., &, | AND ( AND ) TO BE DELIMITERS
C
      TSVSCN = TSDSCN
      TSDSCN = '.&|()'
      LENT = LNBLNK(TSDSCN)
      CALL SDLSCN(TSDSCN(1:LENT))
C
      IF(IDELIM.LT.0) THEN
          CALL MN_MES(LUNTTO,'IE',' The following cuts exist:')
          CALL MN_CDP(-1)
      ENDIF
C
      NANDOR= 0
      IF(.NOT.QRFILE .AND. IDELIM.LT.0) THEN
          CALL MN_MES(LUNTTO,'M', ' -2   means .OR. all cuts')
          CALL MN_MES(LUNTTO,'M', ' -1   means .AND. all cuts')
          CALL MN_MES(LUNTTO,'M', '  0   means use no cuts')
          CALL MN_MES(LUNTTO,'ME',' <CR> means use the current cuts')
      ENDIF
      NC = 0
      CALL WAITYQ('Give the cuts to be used: ')
2000  CONTINUE
      IF(NC.GT.0) THEN
          ICPARI(NC) = NPARI
          ICPARO(NC) = NPARO
      ENDIF
C
      NC = NC + 1
      NPARI = 0
      NPARO = 0
C
C     First look for the cut number and if that fails the name
C
2100  CONTINUE
      NVAL = INTTYQ(.TRUE.,IDELIM)
C
      NCHFND = NCHSCN()
      IF(NC.EQ.1 .AND. NCHFND.EQ.0 .AND. IDELIM.LT.0) THEN
          GOTO 9000
      ENDIF
C
C     Try for a cut name
C
      IF(IDELIM.GT.0) THEN
          CALL RESTYQ
          NCHR = ISTTYQ(.TRUE.,IDELIM,TNAME)
          CALL M_CNAM(TNAME,NVAL)
          IF(NVAL.LE.0) THEN
              CALL MN_ERR('M_CUSE'
     +         ,'Unknown cut name or illegal character in cuts')
              GOTO 9000
          ENDIF
      ENDIF
C
C     Check first for parentheses in case it is the end of the line
C
      IF(NCHFND.EQ.0 .AND. LCHTYP().EQ.ICHAR('(')) THEN
          NPARI = NPARI + 1
      ELSE IF(LCHTYP().EQ.ICHAR(')')) THEN
          NPARO = NPARO + 1
      ENDIF
C
C     Now check out the number
C
      IF(NVAL.EQ.-1 .OR. NVAL.EQ.-2) THEN
          NCUSE = 0
          DO 2500 NN=1,NCCUT
              ICUSE(NN)  = NN
              ICPARI(NN) = 0
              ICPARO(NN) = 0
              IF(NVAL.EQ.-1) THEN
                  ICAND(NN) = 0
              ELSE
                  ICAND(NN) = 1
              ENDIF
2500      CONTINUE
          ICPARI(1) = 1
          NC = NCCUT
          NPARI = 0
          IF(NC.EQ.1) NPARI = 1
          NPARO = 1
          GOTO 8000
      ELSE IF(NVAL.EQ.0 .AND. NCHFND.GT.0) THEN
          NCUSE = 0
          GOTO 9000
      ENDIF
C
      IF((NVAL.LE.0 .AND. NCHFND.GT.0) .OR. NVAL.GT.NCCUT) THEN
          WRITE(TXTERR,'(I4
     1     ,'' is an invalid cut number'')') NVAL
          CALL MN_ERR('M_CUSE',TXTERR)
          IERR = 2
          GOTO 9000
C
C     If this is a Comis cut, see if an argument is given
C
      ELSE IF(NVAL.GT.0) THEN
          ICUSE(NC) = NVAL
          IF(ICTYPE(NVAL).EQ.4) THEN
              IF(LCHTYP().EQ.ICHAR('(')) THEN
                  ARG = VALTYQ(.TRUE.,IDELIM)
                  IF(IDELIM.LE.0 .AND. LCHTYP().EQ.ICHAR(')')) THEN
                      RCVAL(1,NVAL) = ARG
                  ELSE
                      CALL MN_ERR('M_CUSE'
     +                 ,'Error in argument for COMIS function')
                      IERR = 3
                  ENDIF
              ELSE
                  RCVAL(1,NVAL) = 0.0
              ENDIF
          ENDIF
      ENDIF
C
C     Look for AND's and OR's
C
      IF(LCHTYP().EQ.ICHAR('.')) THEN
          NANDOR = ICMTYQ(.TRUE.,IDELIM,ANDNAM)
C
C         CHECK THAT A . WAS THE DELIMITER
C
          IF(LCHTYP().NE.ICHAR('.')) THEN
              CALL MN_ERR('M_CUSE','Error in AND or OR. Dot missing')
              IERR = 1
              GOTO 9000
          ELSE IF(NANDOR.EQ.1) THEN
              ICAND(NC) = 0
              GOTO 2000
          ELSE IF(NANDOR.EQ.2) THEN
              ICAND(NC) = 1
              GOTO 2000
          ELSE
              CALL MN_ERR('M_CUSE','Error in specifying cuts to use')
              IERR = 1
              GOTO 9000
          ENDIF
      ELSE IF(LCHTYP().EQ.ICHAR('&')) THEN
          ICAND(NC) = 0
          GOTO 2000
      ELSE IF(LCHTYP().EQ.ICHAR('|')) THEN
          ICAND(NC) = 1
          GOTO 2000
      ENDIF
      IF(IDELIM.EQ.0) GOTO 2100
C
8000  CONTINUE
      IF(NC.GT.0) THEN
          ICPARI(NC) = NPARI
          ICPARO(NC) = NPARO
      ENDIF
      NCUSE = NC
C
C     CHECK THE CONSISTENCY OF THE CUTS
C
      NDEP   = 0
      NDEPMN = 9999
      DO 8100 I=1,NCUSE
          NDEP = NDEP + ICPARI(I) - ICPARO(I)
          IF(I.LT.NCUSE .AND. NDEP.LT.0) THEN
              CALL MN_ERR('M_CUSE','A left parentheses' //
     1         ' is missing somewhere')
              NCUSE = 0
          ENDIF
          IF(I.LT.NCUSE) NDEPMN = MIN0(NDEP,NDEPMN)
8100  CONTINUE
      IF(NDEP.NE.0) THEN
          CALL MN_ERR('M_CUSE','The number of parentheses' //
     1     ' in your cuts is not balanced')
          NCUSE = 0
      ENDIF
C
      IF(ICPARI(1).LE.0 .OR. ICPARO(NCUSE).LE.0 .OR.
     +   NDEPMN.LE.0) THEN
           ICPARI(1) = ICPARI(1) + 1
           ICPARO(NCUSE) = ICPARO(NCUSE) + 1
      ENDIF
C
9000  CONTINUE
      TSDSCN = TSVSCN
      LENT = LNBLNK(TSDSCN)
      CALL SDLSCN(TSDSCN(1:LENT))
C
      END
