      SUBROUTINE M_PGET(NMODE,COMAND,IFUN,IPAR,QPASS,IDELIM)
C
C     Get the function and parameter number
C     NMODE = 0  means use INTTYP
C     NMODE = 1  means use VALTYP
C     NMODE = 2  means use VL2TYP
C
#include "mnpar.inc"
#include "mnfit.inc"
#include "mnfun.inc"
#include "mnlun.inc"
C
      CHARACTER*(*) COMAND
C
      LOGICAL QMNLFT,QMNRGT
      LOGICAL QPASS
C
C     GET PARAMETER NUMBER AND FUNCTION NUMBER IN Pifun(ipar)
C
      QPASS = .FALSE.
C
C     Loop over characters in command to get to numeric part
C
100   CONTINUE
      K = ICHTYP(.TRUE.)
      IF(K .EQ. ICHAR(' ')) GOTO 100
C
      LENG = MNLLEN(COMAND)
      DO 110 I=1,LENG-1
          K = ICHTYP(.TRUE.)
110   CONTINUE
C
      NCHSAV = MAX0(0,NCHLFT())
      NMIN = 0
      IFUN = INTTYP(.TRUE.,IDELIM)
      IF(IDELIM .GT. 0) THEN
         CALL MN_ERR('M_PGET','Something wrong with function number')
         RETURN
      END IF
C
C     Check for left parenthesis
C     If it is not there and we are fitting then find out the
C     function and parameter number from the MINUIT parameter number
C
      ICH = LCHTYP()
      IF(.NOT.QMNLFT(CHAR(ICH))) THEN
          IF(NHFIT.GT.0) THEN
              NMIN = IFUN
              IFUN = JMINFX(NMIN)
              IPAR = JMINPX(NMIN)
C
C             Put us at the position just before delimiter
C
              IF(LCHTYP().NE.ICHAR(' ') .OR. IDELIM .GE. 0) THEN
                  IDELIM = 0
                  NSKIP = NCHSAV - MAX0(0,NCHLFT()) - 1
                  CALL RESTYP
                  DO 2000 I=1,NSKIP
                      ICH = ICHTYP(.TRUE.)
2000              CONTINUE
              ENDIF
          ELSE
              CALL MN_ERR('M_PGET','Left parenthesis not found')
              RETURN
          ENDIF
      ENDIF
C
      IF(IFUN.GT.NFUN_MN .OR.
     +   (.NOT.QSNORM .AND. IFUN.LE.0) .OR.
     +   (QSNORM .AND. IFUN.LT.0)) THEN
          WRITE(LUNTTO,10000) IFUN
10000     FORMAT(' *** M_PGET: Function ',I4,' is out of range ***')
          RETURN
      ENDIF
C
      IF(NMIN.LE.0) THEN
          IF(NMODE.EQ.0) THEN
              IPAR = INTTYP(.TRUE.,IDELIM)
          ELSEIF(IABS(NMODE).EQ.1) THEN
              IPAR = IVLTYP(.TRUE.,IDELIM)
          ELSEIF(IABS(NMODE).EQ.2) THEN
              IPAR = NINT(VL2TYP(.TRUE.,IDELIM))
          ENDIF
C
          IF(IDELIM .GT. 0) THEN
              CALL ZERTYP(
     1         '*** M_PGET: Something wrong with parameter number: ')
              RETURN
          END IF
C
C         Check for right parenthesis
C
          ICH = LCHTYP()
          IF(.NOT.QMNRGT(CHAR(ICH))) THEN
              CALL MN_ERR('M_PGET','Right parenthesis not found')
              RETURN
          ENDIF
      ENDIF
C
      IF((IFUN.GT.0 .AND. (IPAR.LE.0 .OR. IPAR.GT.IPARF(IFUN))) .OR.
     +   (IFUN.EQ.0 .AND. IPAR.NE.1)) THEN
          WRITE(TXTERR,11000,IOSTAT=IOERR) IPAR
11000     FORMAT('Parameter ',I4,' is out of range ***')
          CALL MN_ERR('M_PGET',TXTERR)
          RETURN
      ENDIF
C
      QPASS = .TRUE.
C
      END
