      FUNCTION VL2TYP(LWAIT,IDELIM)

C  -------------------------------------------------------------------
C     Get value. Can be number, register, parameter, or function value.
C     Same as VALTYP, except that arg of function must be real number.
C  -------------------------------------------------------------------

#include "mnpar.inc"
#include "mndat.inc"
#include "mnfun.inc"
#include "mnprs.inc"
C
      LOGICAL LWAIT
      LOGICAL QPASS,QMNRGT
      DOUBLE PRECISION XMNFUN,XMNALL,WMNHER
C
      CHARACTER*32 COMAND
C
      VL2TYP = 0.
C
C     See if it's a real number
C
      REL = RELTYP(LWAIT,IDELIM)
      IF(IDELIM .LE. 0) THEN
          VL2TYP = REL
          GOTO 9000
C
C     It's not; see if it's one of our defined entities
C
      ELSE
          CALL RESTYP
          CALL M_CGET(0,COMAND,ICMD,IDELIM)
          IF(ICMD.LE.0 .OR. IDELIM.GT.0) GOTO 9000
      ENDIF
C
C     A variable - leave the pointer on the delimiter
C     and not just before the delimiter
C
      IF(ICMD.GT.MDEPI) THEN
cicb          CALL M_VRES(IDELIM)
C
          NUM = ICMD - MDEPI + MVAR0
          VL2TYP = REGIS(NUM)
C
C     Register
C
      ELSEIF(COMAND .EQ. 'R' .OR. COMAND .EQ. 'IR') THEN
          CALL WAITYP('Register #: ')
          CALL RESTYP
          CALL M_RGET(1,COMAND,NUM,QPASS,IDELIM)
          IF(.NOT.QPASS) GOTO 9000
C
          VL2TYP = REGIS(NUM)
C
C     Parameter
C
      ELSE IF(COMAND .EQ. 'P'   .OR. COMAND.EQ.'ERR' .OR.
     +        COMAND.EQ.'ERP'   .OR. COMAND.EQ.'ERN' .OR.
     +        COMAND.EQ.'LOLIM' .OR. COMAND.EQ.'HILIM') THEN
          CALL WAITYP('Function #: ')
          CALL RESTYP
          CALL M_PGET(0,COMAND,IFUN,IPAR,QPASS,IDELIM)
          IF(.NOT.QPASS) GOTO 9000
C
          IF(COMAND.EQ.'P') THEN
              IF(IFUN.GT.0) THEN
                  VL2TYP = FPAR(IPAR,IFUN)
              ELSE
                  VL2TYP = F00
              ENDIF
          ELSE IF(COMAND.EQ.'ERR') THEN
              IF(IFUN.GT.0) THEN
                  VL2TYP = DFPAR(IPAR,IFUN)
              ELSE
                  VL2TYP = DF00
              ENDIF
          ELSE IF(COMAND.EQ.'ERP') THEN
              IF(IFUN.GT.0) THEN
                  VL2TYP = DPFPAR(IPAR,IFUN)
              ELSE
                  VL2TYP = DPF00
              ENDIF
          ELSE IF(COMAND.EQ.'ERN') THEN
              IF(IFUN.GT.0) THEN
                  VL2TYP = DNFPAR(IPAR,IFUN)
              ELSE
                  VL2TYP = DNF00
              ENDIF
          ELSE IF(COMAND.EQ.'LOLIM') THEN
              IF(IFUN.GT.0) THEN
                  VL2TYP = FPARLO(IPAR,IFUN)
              ELSE
                  VL2TYP = F00LO
              ENDIF
          ELSE IF(COMAND.EQ.'HILIM') THEN
              IF(IFUN.GT.0) THEN
                  VL2TYP = FPARHI(IPAR,IFUN)
              ELSE
                  VL2TYP = F00HI
              ENDIF
          ENDIF
C
C     Function
C
      ELSE IF(COMAND .EQ. 'F') THEN
          CALL WAITYP('Function #: ')
          CALL RESTYP
          CALL M_FGET(0,COMAND,IFUN,QPASS,IDELIM)
          IF(.NOT.QPASS) GOTO 9000
C
          arg = reltyp(lwait,idelim)
C
C         Check for right parenthesis
C
          ICH = LCHTYP()
          IF(.NOT.QMNRGT(CHAR(ICH))) THEN
              CALL MN_ERR('VL2TYP','Right parenthesis not found')
              GOTO 9000
          ENDIF
C
          VAL2 = 0.0
          IF(IFUN .EQ. 0) THEN
            VL2TYP = XMNALL(ARG,VAL2,NNHDT,WMNHER)
          ELSE
            VL2TYP = XMNFUN(ARG,VAL2,IFUN,NNHDT,FPAR(1,IFUN),WMNHER)
          ENDIF
C
C     Data value
C
      ELSE IF(COMAND.EQ.'X'   .OR. COMAND.EQ.'Y'   .OR.
     +        COMAND.EQ.'DX'  .OR. COMAND.EQ.'DY'  .OR.
     +        COMAND.EQ.'DNX' .OR. COMAND.EQ.'DNY' .OR.
     +        COMAND.EQ.'DPX' .OR. COMAND.EQ.'DPY') THEN
          CALL WAITYP('Histogram #: ')
          CALL RESTYP
          CALL M_HGET(0,COMAND,ISET,IBIN,IVAR,QPASS,IDELIM)
          IF(.NOT.QPASS) GOTO 9000
C
          NERR = 0
          IF(COMAND.EQ.'X' .AND. IVAR.GT.0) THEN
              VL2TYP = AMNP(IBIN,ISET,IVAR,1,IERR)
          ELSEIF(COMAND.EQ.'X') THEN
              VL2TYP = AMNX(IBIN,ISET,NERR)
          ELSE IF(COMAND.EQ.'Y') THEN
              VL2TYP = AMNE(IBIN,ISET,NERR)
          ELSE IF(COMAND.EQ.'DX') THEN
              VL2TYP = AMNDXN(IBIN,ISET,NERR)
          ELSE IF(COMAND.EQ.'DY') THEN
              VL2TYP = AMNDEN(IBIN,ISET,NERR)
          ELSE IF(COMAND.EQ.'DNX') THEN
              VL2TYP = AMNDXN(IBIN,ISET,NERR)
          ELSE IF(COMAND.EQ.'DNY') THEN
              VL2TYP = AMNDEN(IBIN,ISET,NERR)
          ELSE IF(COMAND.EQ.'DPX') THEN
              VL2TYP = AMNDXP(IBIN,ISET,NERR)
          ELSE IF(COMAND.EQ.'DPY') THEN
              VL2TYP = AMNDEP(IBIN,ISET,NERR)
          ENDIF
      ENDIF
C
9000  CONTINUE
      END
