//------------------------------------------------------------------------
// Get the header information for a histogram
//
// $Id: m_root_id.cxx,v 1.1 2005/06/06 09:29:18 brock Exp $
//------------------------------------------------------------------------

#include "TDirectory.h"
#include "TKey.h"
#include "TH1.h"
#include <string>
#include <iostream>

using namespace std;

extern "C" {
    int m_root_id_(Int_t &nid, const Int_t &lent, const Int_t &mhstmx,
		   Int_t *lenid, char *tid) {
	
	nid = 0;
	gDirectory->ls();
	TH1 *h; 
	TIter next(gDirectory->GetListOfKeys());
	TKey *key;
	while ((key=(TKey*)next())) {
	    const char *classname;
	    classname = key->GetClassName();
	    const char *name;
	    name = key->GetName();
	    cout << "Key " << key->GetName() << " points to a "
		 << classname << endl;

	    // See if I want this key
	    if ( strncmp(classname,"TH1",3) == 0 ||
		 strncmp(classname,"TH2",3) == 0 ||
		 strncmp(classname,"TH3",3) == 0 ||
		 strncmp(classname,"TProfile",8) == 0 ) {
		cout << "Key " << key->GetName() 
		     << " is a " << classname << endl;
		nid++;
		lenid[nid-1] = strlen(name);
		for (Int_t i=0; i<strlen(name); i++) {
		    tid[(nid-1)*lent+i] = name[i];
		}
	    } else {
		cout << "Key " << key->GetName() 
		     << " is not a 1-D, 2-D, 3-D or Profile histogram: "
		     << classname << endl;
	    }
	}

	return 0;
    }
}
