      SUBROUTINE M_SNTP(NMODE,IDELIM,IERR)
C
C------------------------------------------------------------------------------
C     Subroutine to specify which variables of an Ntuple should be
C     plotted where, or to give a list of Ntuple variables to be fetched.
C------------------------------------------------------------------------------
C
      implicit none
*
#include "mnpar.inc"
#include "mndat.inc"
#include "mncwn.inc"
#include "mntmp.inc"
#include "mncmd.inc"
#include "mnflg.inc"
#include "mnlun.inc"
C
      integer nmode,idelim,ierr
*
      integer mntpl
      parameter (mntpl = 4)
      character ntpnam(mntpl)*10
*
      CHARACTER*10 TCOMM
      CHARACTER*32 TVAR
      integer i,ii,kcmd,ida,idb,nh,nnid,nnum,nchr
     + ,npos,nposmx,nvar,jelem(9),lent
*
      INTEGER NHSAV
      SAVE NHSAV
*
      integer  icmtyq,isttyq,isltyq,lnblnk
      external icmtyq,isttyq,isltyq,lnblnk
*
      data ntpnam/'PLOT','VARIABLE','NAME',' '/
      DATA NHSAV/0/
C
      IERR = 0
C
      IF(COMND1.EQ.'SHOW') THEN
          IF(INTPMN(1).LE.0) THEN
              CALL MN_MES(LUNTTO,'I'
     +         ,' No valid SET NTUPLE PLOT command given yet')
          ELSE
              CALL MN_MES(LUNTTO,'I'
     +         ,' The following variables will be plotted:')
          ENDIF
          DO 1000 II=1,9
              IF(II.GT.3) THEN
                  I = II + 3
              ELSE
                  I = II
              ENDIF
              IF(INTPMN(II).LE.0) GOTO 1000
              IF(NHSAV.GT.0) THEN
                  WRITE(TXTMES,'(1X,A,1X,I3,'' = '',A)')
     +             NTONAM(I),INTPMN(II),TDNAM(INTPMN(II),NHSAV)
              ELSE
                  WRITE(TXTMES,'(1X,A,1X,I3)') NTONAM(I),INTPMN(II)
              ENDIF
              CALL MN_MES(LUNTTO,'I',TXTMES)
1000      CONTINUE
*
          IF(NCWN_X.LE.0) THEN
              CALL MN_MES(LUNTTO,'I'
     +         ,' No valid SET NTUPLE VARIABLE command given yet')
          ELSE
              CALL MN_MES(LUNTTO,'I'
     +         ,' The following extra variables will be fetched:')
          ENDIF
          DO 1100 I=1,NCWN_X
              txtmes = '  ' // tcwn_x(i)
              CALL MN_MES(LUNTTO,'I',TXTMES)
1100      CONTINUE
          CALL MN_MES(LUNTTO,'E',' ')
          GOTO 9000
      ENDIF
*
 2000 continue
      call waityq('Give command or ?: ')
      kcmd = icmtyq(.true.,idelim,ntpnam)
      if(kcmd.gt.0) comnd3 = ntpnam(kcmd)
      if(kcmd.lt.0 .and. idelim.eq.ichar('?')) then
          call quotyq('SET NTUPLE')
          idelim = 0
          call mn_hlp(idelim,ierr)
          goto 2000
      elseif(kcmd.lt.0) then
          goto 9000
      elseif(kcmd.eq.0) then
          call mn_dck(idelim,kcmd,mntpl,ntpnam,ierr)
          if(ierr.eq.2) call mn_unk('MN_SET')
          goto 9000
      endif
C
C     Ntuple variables to plot directly
C
      if(COMND3.EQ.'PLOT') THEN
          CALL WAITYQ('Give Ntuple number or 0: ')
          CALL MN_HNO(IDA,IDB,IDELIM,NNID)
          IF(NNID.LE.0) GOTO 9000
          IF(IDA.GT.0) THEN
              CALL MN_HGT(IDA,IDB,NH)
              IF(NH.LE.0) THEN
                  WRITE(TXTERR,'(''Ntuple'',I7,I4,'' does not exist'')')
     +             IDA,IDB
                  CALL MN_ERR('M_SNTP',TXTERR)
                  IERR = 1
                  GOTO 9000
              ENDIF
          ELSE
              NH = 0
          ENDIF
*
          NNUM = 0
          CALL VZERO_i(INTPMN,9)
          NPOSMX = 0
 3000     CONTINUE
          CALL WAITYQ('Give Plot variable, Ntuple variable or ?: ')
          NCHR = ISTTYQ(.TRUE.,IDELIM,TCOMM)
          IF(NCHR.LE.0) GOTO 9000
C
          IF(TCOMM(1:1).EQ.'?') THEN
              CALL QUOTYQ('SET NTUPLE')
              IDELIM = 0
              CALL MN_HLP(IDELIM,IERR)
              GOTO 3000
          ENDIF
C
          IF(IDELIM.GT.0) THEN
              CALL MN_ERR('M_SNTP','Illegal character in variable')
              IERR = 1
              GOTO 9000
          ENDIF
C
          DO 3100 I=1,MNTO-1
              IF(TCOMM.EQ.NTONAM(I)) THEN
                  NNUM = NNUM + 1
                  NPOS = I
                  IF(I.LE.3) THEN
                      NPOSMX = MAX0(NPOSMX,I)
                  ELSEIF(I.GT.6) THEN
                      NPOS = NPOS - 3
                  ENDIF
                  GOTO 3200
              ENDIF
 3100     CONTINUE
          CALL MN_ERR('M_SNTP','Unknown plot variable: ' // TCOMM)
          IERR = 1
          GOTO 9000
 3200     CONTINUE
C
          CALL WAITYQ('Give Ntuple variable: ')
          CALL M_VGET(0,NH,NVAR,TVAR,jELEM,IDELIM,IERR)
          IF(IERR.NE.0) GOTO 9000
          INTPMN(NPOS) = NVAR
C
          IF(IDELIM.EQ.0 .AND. NNUM.LT.9) GOTO 3000
          NHSAV = NH
*
*     List of extra variables to fetch for a CWN
*
      elseif(comnd3.eq.'VARIABLE') then
          nnum = 0
 4000     continue
          CALL WAITYQ('Give Ntuple variable: ')
          nchr = isltyq(.true.,idelim,tvar)
          if(nchr.le.0) goto 9000
*
          nnum = nnum + 1
          tcwn_x(nnum) = tvar(:nchr)
*
*         Check for $CLEAR
*
          call cltou(tvar)
          if(tvar.eq.'$CLEAR') then
              ncwn_x = 0
              goto 9000
          endif
          if(idelim.eq.0) goto 4000
          ncwn_x = nnum
*
*     Name of Ntuple variables for a Mn_Fit booked Ntuple
*
      elseif(comnd3.eq.'NAME') then
          nnum = 0
 5000     continue
          write(txtmes,'('' Variable'',I3,'', give name:'')') nnum+1
          lent = lnblnk(txtmes) + 1
          CALL WAITYQ(txtmes(:lent+1))
          nchr = isltyq(.true.,idelim,tvar)
          if(nchr.le.0) goto 9000
*
          nnum = nnum + 1
          tnntp(nnum) = tvar(:nchr)
          goto 5000
      endif
C
 9000 CONTINUE
      END
