      SUBROUTINE MN_SPL(IDELIM)
C
C------------------------------------------------------------------------------
C     Spline fitting and histogram smoothing
C     Interfaced to HBOOK, IMSL, NAGLIB and Topdraw
C------------------------------------------------------------------------------
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mninf.inc"
#include "mnhpj.inc"
#include "mncmd.inc"
#include "mnlun.inc"
C
      INTEGER MPNTMX,MKNTMX
      PARAMETER (MPNTMX=1000,MKNTMX=100)
      REAL BUFX(MPNTMX),BUFY(MPNTMX),BUFDX(MPNTMX),BUFDY(MPNTMX)
     1 ,XKNOT(MKNTMX),BUFSPL(MPNTMX),BUFMAT(3*MPNTMX)
      DOUBLE PRECISION WX(MPNTMX),WY(MPNTMX),WGT(MPNTMX)
     + ,LAMDA(MKNTMX),C(MPNTMX),SS,WXX,WYY,WSM
      CHARACTER*10 TKNOT(MKNTMX)
      INTEGER IKNOT(MKNTMX),NEST
      REAL YKNOT(MKNTMX)
      CHARACTER*80 THEAD,THELP
      CHARACTER TFLAG*1,TTFLAG*4
#include "mnscr.inc"
      INTEGER IWORK(MPNTMX)
      REAL WORK(20*MPNTMX+41),BUFFX(MPNTMX),BUFFY(MPNTMX)
      EQUIVALENCE(SCRATCH(0*MPNTMX+1),BUFFX(1))
      EQUIVALENCE(SCRATCH(1*MPNTMX+1),BUFFY(1))
      EQUIVALENCE(SCRATCH(2*MPNTMX+1),IWORK(1))
      EQUIVALENCE(SCRATCH(3*MPNTMX+1),WORK(1))
C
      INTEGER MSPQUL
      PARAMETER (MSPQUL = 7)
      CHARACTER*10 SPLQUL(MSPQUL)
      INTEGER NQUAL,IQUAL(10)
C
      CHARACTER*80 TEXT,TITLE
      LOGICAL QERRL,QERRH,QERRLS,QERRHS,QNEW,QEXIT
      LOGICAL QSMOOTH,QSPLINE,QAKNOT
      INTEGER NMODE
      INTEGER IDSA,IDSB,NPNTU,NPNTC,NNUM
     + ,NKNOT,NK1,NK2,NKOLD,NKOLD1,NKOLD2,NCAP7,NKMIN,NKMAX,NMPLT
      INTEGER II,NFLAG
      REAL CHI2,HIF
C
      EXTERNAL HIF
C
      DATA SPLQUL/'HBOOK','IMSL','NAGLIB','TOPDRAW','AUTO','MANUAL',' '/
C
      IDSA = 0
      IDSB = 0
      QNEW = .TRUE.
C
      THEAD = 'Current Knot Positions:'
      THELP = COMND1
      DO II=1,MKNTMX
          WRITE(TKNOT(II),'(''Knot'',I3)') II
          IKNOT(II) = 1
      ENDDO
C
C     Find out what sort of smoothing and fitting to do
C     Smoothing:
C       NMODE= 1    HBOOK smoothing
C              2    IMSL smoothinig
C              3    Naglib smoothing
C              4    Topdrawer smoothing
C     Spline Fitting:
C       NMODE= 1    HBOOK spline fit
C              2    IMSL spline fit
C              3    Naglib spline fit
C
      QSMOOTH = .FALSE.
      QSPLINE = .FALSE.
      IF(COMND1.EQ.'SMOOTH') THEN
          QSMOOTH = .TRUE.
#if ( defined(IMSL) )
          NMODE = 2
#endif
#if ( defined(NAGLIB) )
          NMODE = 3
#endif
#if ( !defined(IMSL) ) && ( !defined(NAGLIB) )
          NMODE = 4
#endif

      ELSEIF(COMND1.EQ.'SPLINE') THEN
          QSPLINE = .TRUE.
#if ( defined(IMSL) )
          NMODE = 2
#endif
#if ( defined(NAGLIB) )
          NMODE = 3
#endif
#if ( !defined(IMSL) ) && ( !defined(NAGLIB) )
          NMODE = 1
#endif

      ENDIF
C
C     Check for qualifiers
C
      QAKNOT = .FALSE.
      CALL M_QUAL(IDELIM,SPLQUL,MSPQUL,IQUAL,NQUAL)
      IF(NQUAL.LT.0) GOTO 9000
      DO I=1,NQUAL
          IF(SPLQUL(IQUAL(I)).EQ.'HBOOK') THEN
              NMODE  = 1
              QAKNOT = .TRUE.
          ELSEIF(SPLQUL(IQUAL(I)).EQ.'IMSL') THEN
              NMODE = 2
          ELSEIF(SPLQUL(IQUAL(I)).EQ.'NAGLIB') THEN
              NMODE = 3
          ELSEIF(SPLQUL(IQUAL(I)).EQ.'TOPDRAW') THEN
              NMODE = 4
          ELSEIF(SPLQUL(IQUAL(I)).EQ.'AUTO') THEN
              QAKNOT = .TRUE.
          ELSEIF(SPLQUL(IQUAL(I)).EQ.'MANUAL') THEN
              QAKNOT = .FALSE.
          ENDIF
      ENDDO
C
C     Check that the option combination is valid
C
      IF(NMODE.EQ.1 .AND. .NOT.QAKNOT) THEN
          CALL MN_ERR('MN_SPL'
     +     ,'HBOOK only has automatic knot positioning')
          GOTO 9000
      ELSEIF((NMODE.EQ.2 .OR. NMODE.EQ.3) .AND. QAKNOT) THEN
          CALL MN_TXT(LUNTTO,'ME'
     +     ,'Automatic knot positioning is the same as smoothing')
          QSPLINE = .FALSE.
          QSMOOTH = .TRUE.
      ELSEIF(NMODE.EQ.4 .AND. QSPLINE) THEN
          CALL MN_ERR('MN_SPL'
     +     ,'I only have smoothing for Topdraw')
          GOTO 9000
      ENDIF
C
C     GET THE HISTOGRAM NUMBER
C
      CALL WAITYQ('Give histogram number: ')
      CALL MN_HNO(IDA,IDB,IDELIM,NNID)
      IF(NNID.EQ.0 .OR. IDA.LE.0) GOTO 9000
C
      QEXIT = IDELIM.EQ.0
C
      CALL MN_HGT(IDA,IDB,NH)
      IF(NH.LE.0) THEN
          WRITE(TXTERR,'(''Histogram'',I7,I4
     1     ,'' does not exist'')') IDA,IDB
          CALL MN_ERR('MN_SPL',TXTERR)
          GOTO 9000
      ENDIF
C
      IF(IABS(NDIM).NE.1) THEN
          CALL MN_ERR('MN_SPL'
     +     ,'I can only smooth 1-dimensional histograms')
          GOTO 9000
      ENDIF
      IF((NDIM.EQ.1 .AND. IDBIN(1).LE.0) .OR.
     +   ADHI(1).LE.ADLO(1)) THEN
          WRITE(TXTERR,'(''Error in bin specification for''
     +     ,'' histogram'',I7,I4)') IDA,IDB
          CALL M_EMSG('MN_SPL',TXTERR)
          WRITE(TXTERR,'(''Number of bins'',I4,''  Limits'',2G11.4)')
     +     IDBIN(1),ADLO(1),ADHI(1)
          CALL MN_ERR('MN_SPL',TXTERR)
          GOTO 9000
      ENDIF
      IF(NPNT.GT.MPNTMX) THEN
          WRITE(TXTERR,'(''I only have space to smooth the first''
     1     ,I5,'' points'')') MPNTMX
          CALL MN_ERR('MN_SPL',TXTERR)
          NPNT = MPNTMX
      ENDIF
C
C     UNPACK THE HISTOGRAM
C
      CALL AMNOFF(NDIM,NWPPT,NOFF,NOFFL,NOFFH,QERRL,QERRH)
C
      IF(NDIM.GT.0) DX = (ADHI(1) - ADLO(1)) / FLOAT(IDBIN(1))
      DY = 0.0
      NPNTU = 0
      DO 2000 II=1,NPNT
          NPTR = NPTRD + NWPPT*(II-1) - 1
          IF(NDIM.LT.0) THEN
              X = RDAT(NPTR+1)
          ELSE
              X = ADLO(1) + FLOAT(II-1)*DX + 0.5*DX
          ENDIF
          Y = RDAT(NPTR+NOFF)
          IF(QERRL) THEN
              IF(NDIM.LT.0) DX = RDAT(NPTR+NOFF+1)
              DY = RDAT(NPTR+NOFFL)
          ENDIF
C
C         Ignore this point if it has no error and
C         the spline fit includes errors
C
          IF(QERRL .AND.
     +       ((QSMOOTH .AND. NMODE.EQ.2) .OR.
     +        (QSPLINE .AND. NMODE.EQ.3)) .AND.
     +       DY.LE.0.0) GOTO 2000
          NPNTU = NPNTU + 1
          BUFX(NPNTU) = X
          BUFY(NPNTU) = Y
          BUFDX(NPNTU) = DX
          BUFDY(NPNTU) = DY
 2000 CONTINUE
C
C     Put the histogram into an HBOOK one for HSMOOF or HSPLIx
C
      IF(NMODE.EQ.1) THEN
          IDH = IDA
          CALL MN_HBN(IDA,IDB,IERR)
          IF(IERR.NE.0) THEN
              CALL MN_ERR('MN_SPL'
     +         ,'Error converting Mn_Fit histogram to HBOOK one')
              GOTO 9000
          ENDIF
      ENDIF
C
C     SMOOTH A HISTOGRAM
C
      IF(QSMOOTH .AND. NMODE.EQ.2) THEN
          SM = FLOAT(NPNTU)
      ELSEIF(QSMOOTH .AND. NMODE.EQ.3) THEN
          TFLAG  = 'C'
          TTFLAG = 'Cold'
      ELSEIF(QSMOOTH .AND. NMODE.EQ.4) THEN
          SM = 1.0
      ELSEIF(QSPLINE) THEN
          NKNOT = 0
          NKOLD = 0
          CALL VZERO_r(XKNOT,MKNTMX)
          IF(NMODE.EQ.3) THEN
              NKMIN = 0
          ELSE
              NKMIN = 2
          ENDIF
          NKMAX = MIN0(MKNTMX,NPNTU-4)
      ENDIF
C
C     Put the data in double precision and calculate the weight
C
      IF(NMODE.EQ.3) THEN
          DO II=1,NPNTU
              WX(II)  = DBLE(BUFX(II))
              WY(II)  = DBLE(BUFY(II))
              WGT(II) = 1.0D0
              IF(QERRL) THEN
                  WGT(II) = 0.0D0
                  IF(BUFDY(II).GT.0.0) WGT(II) = DBLE(1.0/BUFDY(II))
              ELSE
                  WGT(II) = 1.0D0
              ENDIF
          ENDDO
      ENDIF
 3000 CONTINUE
C
C     Get the smoothing parameter - if needed
C
      IF(QSMOOTH .AND.
     +   (NMODE.EQ.2 .OR. NMODE.EQ.3 .OR. NMODE.EQ.4)) THEN
          TEXT = 'Give smoothing parameter (<CR>=     ): '
          IF(NMODE.EQ.2 .OR. NMODE.EQ.3) THEN
              WRITE(TEXT(32:36),'(F5.1)',IOSTAT=IOERR) SM
          ELSEIF(NMODE.EQ.4) THEN
              WRITE(TEXT(32:36),'(I5)',IOSTAT=IOERR) NINT(SM)
          ENDIF
          CALL WAITYQ(TEXT(1:LNBLNK(TEXT)+1))
 3100     CONTINUE
          RVAL = VALTYQ(.TRUE.,IDELIM)
          CALL MN_RCK(RVAL,IDELIM,IERR)
          IF(IERR.EQ.2) GOTO 3200
          IF(IERR.GT.0) GOTO 3200
          SM = RVAL
 3200     CONTINUE
      ENDIF
C
C     For Naglib spline fitting with automatic knot positions
C     switch to a warm fit if the number of knots has not changed
C
      IF(QSMOOTH .AND. NMODE.EQ.3) THEN
          IF(.NOT.QNEW .AND. NKNOT.EQ.NKOLD) THEN
              TFLAG  = 'W'
              TTFLAG = 'Warm'
          ELSE
              TFLAG  = 'C'
              TTFLAG = 'Cold'
          ENDIF
      ENDIF
C
C     HSMOOF
C
      IF(QSMOOTH .AND. NMODE.EQ.1) THEN
          NCASE = 2
          SM = 0.0
          CALL HSMOOF(IDH,NCASE,CHI2)
          WRITE(TXTMES,'('' Chi**2 of smoothing = '',1PG11.4)') CHI2
          CALL MN_MES(LUNTTO,'ME',TXTMES)
C
C     Other Smoothing
C
      ELSEIF(QSMOOTH) THEN
C
C         Now do the smoothing
C
C         IMSL Smoothing
C
          IF(NMODE.EQ.2) THEN
              CALL ICSSCU(BUFX,BUFY,BUFDY,NPNTU,SM,BUFSPL,BUFMAT,NPNTU-1
     1         ,WORK,IER)
              IF(IER.NE.0) THEN
                  WRITE(TXTERR
     +             ,'(''Spline smoothing gave error'',I4)') IER
                  CALL MN_ERR('MN_SPL',TXTERR)
                  GOTO 9000
              ENDIF
              NKNOT = NPNTU - 1
              NK1  = 1
              NK2  = NKNOT
C
C         Naglib Smoothing
C
          ELSEIF(NMODE.EQ.3) THEN
              IER = -1
              WSM = DBLE(SM)
              NEST = MIN0(NPNTU+4,MPNTMX)
              LWRK = 4*NPNTU + 16*NEST + 41
              CALL E02BEF(TFLAG,NPNTU,WX,WY,WGT,WSM,NEST,NCAP7
     +         ,LAMDA,C,SS,WORK(1),LWRK,IWORK,IER)
              CHI2 = SNGL(SS)
              IF(IER.NE.0) THEN
                  WRITE(TXTERR
     +             ,'(''Spline fitting gave error'',I4)') IER
                  CALL MN_ERR('MN_SPL',TXTERR)
                  GOTO 9000
              ENDIF
              NKNOT = NCAP7 - 8
              NK1  = 5
              NK2  = NKNOT+4
              DO II=1,NCAP7
                  XKNOT(II) = SNGL(LAMDA(II))
              ENDDO
              NPNTC = NPNTU
C
C         Topdrawer Smoothing
C
          ELSEIF(NMODE.EQ.4) THEN
              NSM = NINT(SM)
              CALL SMCTRL(BUFSPL,BUFY,NPNTU,NSM
     +         ,WORK(1),WORK(MPNTMX+1))
          ENDIF
C
C         Calculate the chi**2 if necessary
C
          IF(NMODE.NE.3) THEN
              NPNTC = 0
              CHI2 = 0.0
              DO I=1,NPNTU
                  IF(BUFDY(I).GT.0.0) THEN
                      NPNTC = NPNTC + 1
                      CHI2 = CHI2 + ((BUFY(I)-BUFSPL(I))/BUFDY(I))**2
                  ENDIF
              ENDDO
          ENDIF
          WRITE(TXTMES,'('' Chi**2 of smoothing = '',1PG11.4
     +     ,'' for'',I4,'' points'')') CHI2,NPNTC
          CALL MN_MES(LUNTTO,'ME',TXTMES)
C
C     SPLINE FIT A HISTOGRAM
C
      ELSEIF(QSPLINE) THEN
 4000     CONTINUE
          IF(QNEW) THEN
              CALL WAITYQ('Give the number of knots: ')
          ELSE
              TEXT = 'Give number of knots (<CR>=  ): '
              WRITE(TEXT(28:29),'(I2)') NKNOT
              CALL WAITYQ(TEXT(1:32))
          ENDIF
          NVAL = IVLTYQ(.TRUE.,IDELIM)
          CALL MN_NCK(NVAL,IDELIM,IERR)
          IF(NKNOT.GT.0 .AND. IERR.EQ.2) GOTO 4100
          IF(IERR.GT.0) GOTO 9000
          IF(NVAL.LT.NKMIN .OR. NVAL.GT.NKMAX) THEN
              WRITE(TXTMES,'('' Error in the number of knots'',I6
     1         ,''. Number must be between'',I3,'' and'',I3)')
     1         NVAL,NKMIN,NKMAX
              CALL MN_MES(LUNTTO,'ME',TXTMES)
              CALL ZERTYQ('.FALSE.')
              GOTO 4000
          ENDIF
          NKNOT = NVAL
 4100     CONTINUE
C
C         Get the knot positions - if required
C
          IF(.NOT.QAKNOT) THEN
              DO II=1,NKNOT
                  IKNOT(II) = 1
              ENDDO
              IKNOT(NKNOT+1) = 0
C
              IF(NMODE.EQ.2) THEN
                  NNUM = 0
                  NK1  = 1
                  NK2  = NKNOT
              ELSE
                  NNUM = 0
                  NK1  = 5
                  NK2  = NKNOT+4
              ENDIF
 4150         CONTINUE
              CALL WAITYQ('Give knot positions: ')
              CALL MN_ENM(IDELIM,THELP,THEAD,NKNOT,TKNOT,IKNOT
     +         ,XKNOT(NK1),NNUM,YKNOT,IERR)
              IF(IERR.NE.0) GOTO 9000
              IF(NNUM.LE.0) GOTO 9000
              CALL UCOPY_r(YKNOT,XKNOT(NK1),NNUM)
C
              DO II=2,NKNOT
                  IF(XKNOT(NK1+II-1).LE.XKNOT(NK1+II-2)) THEN
                      WRITE(LUNTTO,'('' Error in knot'',I4
     +                   ,'' Value'',1PG11.4
     1                 ,/,'' Knots must monotonically increase.''
     2                   ,'' Knot will be ignored'')')
     2                 II,XKNOT(NK1+II-1)
                      GOTO 4150
                  ENDIF
              ENDDO
C
              IF(NMODE.EQ.2) THEN
                  IF(XKNOT(NK1).GT.BUFX(1) .OR.
     +               XKNOT(NK2).LT.BUFX(NPNTU)) THEN
                      WRITE(LUNTTO
     +                 ,'('' The first knot must be =< X(1) and''
     1                 ,'' the last knot must >= X(N)'')')
                      NNUM = 0
                      GOTO 4000
                  ENDIF
              ELSEIF(NMODE.EQ.3) THEN
                  IF(XKNOT(NK1).LE.BUFX(1) .OR.
     +               XKNOT(NK2).GE.BUFX(NPNTU)) THEN
                      WRITE(LUNTTO
     +                 ,'('' The first knot must be > X(1) and''
     1                 ,'' the last knot must < X(N)'')')
                      NNUM = 0
                      GOTO 4000
                  ENDIF
              ENDIF
          ENDIF
C
C         NOW DO THE SPLINE FIT
C
          IF(NMODE.EQ.1) THEN
              NCASE = 2
              CALL HSPLI1(IDH,NCASE,NKNOT,3,CHI2)
          ELSEIF(NMODE.EQ.2) THEN
              CALL ICSVKU(BUFX,BUFY,NPNTU,XKNOT,NKNOT
     1         ,BUFSPL,BUFMAT,NKNOT-1,CHI2,WORK,IER)
              IF(IER.NE.0) THEN
                  WRITE(TXTERR
     +             ,'(''Spline fitting gave error'',I4)') IER
                  CALL MN_ERR('MN_SPL',TXTERR)
                  GOTO 9000
              ENDIF
          ELSEIF(NMODE.EQ.3) THEN
              IER = -1
              NCAP7 = NKNOT + 1 + 7
              DO II=1,NCAP7
                  LAMDA(II) = DBLE(XKNOT(II))
              ENDDO
              CALL E02BAF(NPNTU,NCAP7,WX,WY,WGT,LAMDA
     +         ,WORK(1),WORK(MPNTMX+1),C,SS,IER)
              CHI2 = SNGL(SS)
              IF(IER.NE.0) THEN
                  WRITE(TXTERR
     +             ,'(''Spline fitting gave error'',I4)') IER
                  CALL MN_ERR('MN_SPL',TXTERR)
                  GOTO 9000
              ENDIF
          ENDIF
          NKOLD  = NKNOT
          NKOLD1 = NK1
          NKOLD2 = NK2
      ENDIF
C
      DO 4300 NN=1,2
          IF(NN.EQ.2 .AND. LUNDMP.EQ.LUNTTO) GOTO 4310
          IF(NN.EQ.2) THEN
              LUN = LUNTTO
          ELSE
              LUN = LUNDMP
              IF(QSMOOTH) THEN
                  IF(NMODE.EQ.3) THEN
                      WRITE(LUN,'(1X,A,'' Smoothing of histogram'',I7,I4
     +                 ,'', Parameter'',F6.2
     1                 ,/,1X,A,/)',IOSTAT=IOERR)
     1                 TTFLAG,IDA,IDB,SM,TDTIT(NH)(1:LNBLNK(TDTIT(NH)))
                  ELSE
                      WRITE(LUN,'('' Smoothing of histogram'',I7,I4
     +                 ,'', Parameter'',F6.2
     1                 ,/,1X,A,/)')
     1                 IDA,IDB,SM,TDTIT(NH)(1:LNBLNK(TDTIT(NH)))
                  ENDIF
              ELSE
                  WRITE(LUN,'('' Spline fit to histogram'',I7,I4
     1             ,/,1X,A,/)')
     1             IDA,IDB,TDTIT(NH)(1:LNBLNK(TDTIT(NH)))
              ENDIF
          ENDIF
          WRITE(LUN,14210,IOSTAT=IOERR) CHI2
14210     FORMAT(' Least squares error on cubic spline'
     1     ,' approximation',1PG11.4)
          IF(NMODE.EQ.2 .OR. NMODE.EQ.3) THEN
              WRITE(LUN,14220,IOSTAT=IOERR)
     1         NKNOT,(XKNOT(II),II=NK1,NK2)
14220         FORMAT(' Number of knots',I4
     1         ,/,' User knot positions:'
     +         ,/,(3X,5(1PG11.4,' ')))
              IF(NMODE.EQ.2) THEN
                  WRITE(LUN,14230,IOSTAT=IOERR)
     +             (BUFSPL(II),II=NK1,NK2-1)
14230             FORMAT(' Knot ordinates:'
     +             ,/,(3X,5(1PG11.4,' ')))
                  WRITE(LUN,14240)
14240             FORMAT(' Spline coefficients:')
                  DO 4250 IR=1,3
                      N1 = (NKNOT-1)*(IR-1) + 1
                      N2 = (NKNOT-1)*IR
                      WRITE(LUN,14250,IOSTAT=IOERR)
     +                 (BUFMAT(II),II=N1,N2)
14250                 FORMAT((3X,5(1PG11.4,' ')))
 4250             CONTINUE
              ELSE
                  WRITE(LUN,14260,IOSTAT=IOERR)
     +             (LAMDA(II),II=1,NCAP7)
14260             FORMAT(' Naglib knot positions:'
     +             ,/,(3X,5(1PG11.4,' ')))
                  WRITE(LUN,14270,IOSTAT=IOERR)
     +             (C(II),II=1,NKNOT+4)
14270             FORMAT(' Spline Coefficients:'
     +             ,/,(3X,5(1PG11.4,' ')))
              ENDIF
          ENDIF
 4300 CONTINUE
 4310 CONTINUE
C
C     PUT THE SPLINE RESULTS IN A HISTOGRAM
C
      IDSA = IDA
      IF(IDSB.EQ.0) IDSB = IDB + 1
      TEXT = 'Give secondary ID for smoothed histogram (<CR>=   ): '
      WRITE(TEXT(48:50),'(I3)') IDSB
      CALL WAITYQ(TEXT(1:53))
      CALL MN_SEC(IDSB,IDELIM,IERR)
      IF(IERR.NE.0) GOTO 9000
C
      IF(QSMOOTH .OR. (QSPLINE .AND. NMODE.EQ.1)) THEN
          NMPLT = 1
      ELSEIF(QSPLINE .AND. NMODE.NE.1) THEN
          NMPLT = 0
      ENDIF
C
      IF((QSMOOTH .AND. (NMODE.EQ.2 .OR. NMODE.EQ.3)) .OR.
     +   (QSPLINE .AND. (NMODE.EQ.2 .OR. NMODE.EQ.3))) THEN
          TEXT = 'Plot as a smooth curve (0) or a histogram (1)' //
     1     ' (<CR>= ): '
          WRITE(TEXT(53:53),'(I1)') NMPLT
 5300     CONTINUE
          CALL WAITYQ(TEXT(1:56))
          NVAL = INTTYQ(.TRUE.,IDELIM)
          CALL MN_NCK(NVAL,IDELIM,IERR)
          IF(IERR.EQ.2) GOTO 5400
          IF(IERR.NE.0) GOTO 5400
          IF(NVAL.LT.0 .OR. NVAL.GT.1) THEN
              WRITE(LUNTTO,'('' Invalid mode'',I4)') NVAL
              GOTO 5400
          ENDIF
          NMPLT = NVAL
 5400     CONTINUE
      ENDIF
C
      IF(NMPLT.EQ.0) THEN
          NPP = 10*(NPNTU-1)
          IF(NPP.GE.MPNTMX) NPP = MPNTMX - 1
          NPP = (NPP / (NPNTU-1))
          NPPTS = NPP * (NPNTU-1) + 1
          NDIMS  = -IABS(NDIM)
          NWPPTS = IABS(NDIMS) + 1
          DXS = (BUFX(NPNTU) - BUFX(1)) / FLOAT(NPPTS-1)
      ELSEIF(NMPLT.EQ.1) THEN
          NPP    = 1
          NPPTS  = NPNT
          NDIMS  = NDIM
          NWPPTS = NWPPT
      ENDIF
      NWRDS = NWPPTS * NPPTS
C
      NBPPTS = 0
      CALL MN_HNW(IDSA,IDSB,NDIMS,NWRDS,NHS,NPTRHS,NPTRDS,NWHS
     + ,NBPPTS,NTMODE)
      IF(QSMOOTH .AND. NMODE.EQ.1) THEN
          TITLE = 'Histogram             HSMOOFed'
      ELSEIF(QSMOOTH) THEN
          TITLE = 'Histogram             spline smoothed'
      ELSE
          TITLE = 'Histogram             spline fit'
      ENDIF
      WRITE(TITLE(11:22),'(I7,I4)') IDA,IDB
C
      IF(NDIMS.LT.0) THEN
          NOFFS  = IABS(NDIMS)+1
          NOFFLS = 2*(IABS(NDIMS)+1)
          NOFFHS = 3*(IABS(NDIMS)+1)
          QERRLS = NWPPTS.GT.1*(IABS(NDIMS)+1)
          QERRHS = NWPPTS.GT.2*(IABS(NDIMS)+1)
      ELSE
          NOFFS  = 1
          NOFFLS = 2
          NOFFHS = 3
          QERRLS = NWPPTS.GT.1
          QERRHS = NWPPTS.GT.2
      ENDIF
      EDENTS = 0.0
      EDLOS = 1.0E+30
      EDHIS = -1.0E+30
C
C     Fix the points to plot
C
      IF(NDIM.GT.0) THEN
          DX = (ADHI(1)-ADLO(1)) / FLOAT(IDBIN(1))
      ENDIF
      DY = 0.0
      DO 6100 II=1,NPPTS
          IF(NMPLT.EQ.0) THEN
              X = BUFX(1) + FLOAT(II-1)*DXS
          ELSE
              IF(NDIM.LT.0) THEN
                  NPTR  = NPTRD  + NWPPT*(II-1) - 1
                  X  = RDAT(NPTR+1)
              ELSE
                  X  = ADLO(1) + FLOAT(II-1)*DX + 0.5*DX
              ENDIF
          ENDIF
          BUFFX(II) = AMAX1(BUFX(1),AMIN1(BUFX(NPNTU),X))
 6100 CONTINUE
C
C     Fill in the y values
C
      IF(NMODE.EQ.1) THEN
          DO 6110 II=1,NPNTU
              BUFFY(II) = HIF(IDH,II)
 6110     CONTINUE
      ELSEIF(QSMOOTH .AND. NMODE.EQ.2) THEN
          CALL ICSEVU(BUFX,BUFSPL,NPNTU,BUFMAT,NPNTU-1
     1     ,BUFFX,BUFFY,NPPTS,IER)
      ELSEIF(QSPLINE .AND. NMODE.EQ.2) THEN
          CALL ICSEVU(XKNOT,BUFSPL,NKNOT,BUFMAT,NKNOT-1
     1     ,BUFFX,BUFFY,NPPTS,IER)
      ELSEIF(NMODE.EQ.3) THEN
          DO 6130 II=1,NPPTS
              IER = -1
              WXX = DBLE(BUFFX(II))
              CALL E02BBF(NCAP7,LAMDA,C,WXX,WYY,IER)
              BUFFY(II) = WYY
 6130     CONTINUE
      ELSEIF(QSMOOTH .AND. NMODE.EQ.4) THEN
          DO 6140 II=1,NPPTS
              BUFFY(II) = BUFSPL(II)
 6140     CONTINUE
      ENDIF
C
C     Put the data into the plot
C
      DO 6200 II=1,NPPTS
          NPTRS = NPTRDS + NWPPTS*(II-1) - 1
          X = BUFFX(II)
          Y = BUFFY(II)
          IF(NMPLT.EQ.0) THEN
              DX = 0.5*DXS
              DY = 0.0
          ELSE
              DX = BUFDX(II)
              DY = BUFDY(II)
          ENDIF
C
          NN = 0
          IF(NDIMS.LT.0) THEN
              NN = NN + 1
              RDAT(NPTRS+NN) = X
          ENDIF
          NN = NN + 1
          RDAT(NPTRS+NN) = Y
          IF(QERRL) THEN
              IF(NDIMS.LT.0) THEN
                  NN = NN + 1
                  RDAT(NPTRS+NN) = DX
              ENDIF
              NN = NN + 1
              RDAT(NPTRS+NN) = DY
          ENDIF
C
          EDENTS = EDENTS + Y
          EDLOS = AMIN1(EDLOS,Y-DY)
          EDHIS = AMAX1(EDHIS,Y+DY)
 6200 CONTINUE
C
      NWTOT = NWHS + NWRDS
      ACONT(2) = EDENTS
      CALL M_RTIM(NHDATS,NHTIMS)
      CALL MN_HDU(RDAT(NPTRHS),NWTOT,NWHS,NWRDS,IDSA,IDSB
     1 ,NDIMS,NWPPTS,NPPTS,NHDATS,NHTIMS,NSDATE,NSTIME,NTMODE
     + ,EDENTS,EDLOS,EDHIS,IDBIN,ADLO,ADHI,NBPPTS,ACONT)
      CALL MN_PTU(NHS,NWTOT,IDSA,IDSB,NPTRHS,NPTRDS,TITLE
     1 ,'Generated internally',' ',TDNAM(1,NH))
      CALL MN_MSU(IDSA,IDSB,NDIMS,NWHS,NHS)
C
C     NOW PLOT THE HISTOGRAM AND THE FIT
C
C
      IF(QDFIT) CALL MN_FRP
      QLEGO = .FALSE.
      QDFUN = .FALSE.
      NFLAG = 0
C
      NSYM = NSYMS
      IF(NSYM.EQ.0) NSYM = -32
C
C     Get the next plot number
C
      CALL M_NPLT(.FALSE.,.TRUE.,IERR)
      IF(IERR.NE.0) GOTO 9000
      IPLTIA(NHPLT) = IDA
      IPLTIB(NHPLT) = IDB
      IPLTSY(NHPLT) = NSYM
      IPLTHA(NHPLT) = NHATS
      IPLTPA(NHPLT) = NPATS
      IPLTCO(1,NHPLT) = ICOLS(7)
      IPLTCO(2,NHPLT) = ICOLS(8)
      IPLTCO(3,NHPLT) = ICOLS(9)
      IPLTFL(NHPLT) = 1
      IPLTCL(NHPLT) = 1
      IPLTLG(NHPLT) = 0
      CALL MN_ZER(NHPLT,IDELIM)
      IF(NHPLT.EQ.1) NDRWLN = 0
      CALL MN_DRW(NFLAG,NDERR)
C
      NHPLT = NHPLT + 1
      IPLTIA(NHPLT) = IDSA
      IPLTIB(NHPLT) = IDSB
      IF(NMPLT.EQ.0) THEN
          IPLTSY(NHPLT) = -1
      ELSE
          IF(NSYM.GT.0 .AND. NSYM.LT.9) THEN
              IPLTSY(NHPLT) = NSYM + 1
          ELSE
              IPLTSY(NHPLT) = 1
          ENDIF
      ENDIF
      IPLTHA(NHPLT) = 0
      IPLTPA(NHPLT) = 0
      IPLTCO(1,NHPLT) = ICOLS(12)
      IPLTCO(2,NHPLT) = icols(12)
      IPLTCO(3,NHPLT) = icols(12)
      IPLTFL(NHPLT) = 2
      IPLTCL(NHPLT) = 0
      IPLTLG(NHPLT) = 0
      NPLTCM(NHPLT) = 0
      NPLTKY(NHPLT) = 0
      CALL MN_DRW(NFLAG,NDERR)
C
      IF(.NOT.QEXIT) THEN
          CALL WAITYP('Are you happy with the fit [*Y/N]: ')
          JCMD = ICMTYP(.TRUE.,IDELIM,LOGNAM)
          IF(JCMD.GT.0 .AND. MOD(JCMD,2).EQ.0) THEN
              QNEW = .FALSE.
              GOTO 3000
          ENDIF
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
