      REAL FUNCTION AMNP(NBIN,NH,NC,NE,NERR)
C
C     GIVES THE POSITION OF COORDINATE NC, element NE
C     If necessary reads in the HBOOK Ntuple
C
      implicit none
*
#include "mnpar.inc"
#include "mndat.inc"
#include "mninf.inc"
#include "mnlst.inc"
#include "mntpl.inc"
#include "mncwn.inc"
*
      integer nbin,nh,nc,ne,nerr
C
      REAL ADAT(MDIMMX)
      INTEGER nnum,ida,idb,idh,ierr,nbmax,n1,n2,n3,nhf,nptr
      real rnum,dx
C
      AMNP = 0.0
      NERR = 0
C
      IF(NH.LE.0) THEN
          NERR = 1
          CALL AMNERR('AMNP',NERR,N1,N2,N3)
          RETURN
      ENDIF
C
C     Value when doing a projection - bin number is 0
C     Ntuple entry is already in memory
C
      IF(NBIN.EQ.0) THEN
          if(qcwntpl) then
              call m_ntpvar(nc,ne,nnum,rnum,ierr)
              if(ierr.ne.0) then
                  NERR = 5
                  CALL AMNERR('AMNP',NERR,N1,N2,N3)
                  RETURN
              endif
              amnp = rnum
          else
              AMNP = RVAL(NC)
          endif
          goto 9000
      ENDIF
C
      IF(NH.NE.NHALST) THEN
          IDAL = IDIDA(NH)
          IDBL = IDIDB(NH)
          CALL MN_HGT(IDAL,IDBL,NHF)
          NPTRHL = NPTRH
          NPTRDL = NPTRD
          NDIML  = NDIM
          NWPPTL = NWPPT
          NBPPTL = NBPPT
          NPNTL  = NPNT
          NWDATL = NWDAT
          EDENTL = EDENT
          EDLOL  = EDLO
          EDHIL  = EDHI
          CALL UCOPY_i(IDBIN,IDBINL,IABS(NDIM))
          CALL UCOPY_r(ADLO,ADLOL,IABS(NDIM))
          CALL UCOPY_r(ADHI,ADHIL,IABS(NDIM))
          if(nwdat.le.0) then
              nvcwn = 0
              ida = idal
              idb = idbl
              call m_ntppnt(ida,idb,0,ierr,adat)
              if(ierr.ne.0) then
                  NERR = 5
                  CALL AMNERR('AMNP',NERR,N1,N2,N3)
                  RETURN
              endif
          else
              qcwntpl = .false.
          endif
      ENDIF
      DX = 0.0
      IF(IDBINL(NC).GT.0) DX = (ADHIL(NC) - ADLOL(NC)) / IDBINL(NC)
C
      IF((NDIML.GT.0 .AND. (NBIN.LT.0 .OR. NBIN.GT.IDBINL(NC))) .OR.
     1   (NDIML.LT.0 .AND. (NBIN.LT.0 .OR. NBIN.GT.NPNTL))) THEN
          IF(NDIML.GT.0) THEN
              NERR = 2
              NBMAX = IDBINL(NC)
          ELSE
              NERR = 3
              NBMAX = NPNTL
          ENDIF
          CALL AMNERR('AMNP',NERR,NBIN,NBMAX,N3)
          RETURN
      ENDIF
C
      IF(NDIML.GT.0) THEN
          AMNP = ADLOL(NC) + FLOAT(NBIN-1)*DX + 0.5*DX
      ELSEIF(NWDAT.GT.0) THEN
          NPTR = NPTRDL + FLOAT(NBIN-1)*NWPPTL
          AMNP = RDAT(NPTR+NC-1)
      ELSE
          IDH = IDAL
          if(qcwntpl) then
              call m_ntppnt(idal,idbl,nbin,nerr,adat)
              if(nerr.eq.0) then
                  call m_ntpvar(nc,ne,nnum,rnum,nerr)
                  if(nerr.eq.0) amnp = rnum
              endif
          else
              CALL HGNF(IDH,NBIN,ADAT,NERR)
              IF(NERR.EQ.0) AMNP = ADAT(NC)
          endif
      ENDIF
C
      NHALST = NH
 9000 continue
C
      RETURN
      END
