      SUBROUTINE M_UTIS (IDATM, ISECS)
*
************************************************************************
*                                                                      *
*        SUBR. M_UTIS (IDATM, ISECS*)                                  *
*                                                                      *
*   Computes number of seconds passed since midnight of January 1,1980 *
*   from the packed date and time (ala M_PKTS)                         *
*                                                                      *
*   Arguments :                                                        *
*                                                                      *
*     IDATM    Packed date-time                                        *
*     IMINS*   Number of seconds passed from 00.00 on Jan 1, 1980      *
*                                                                      *
************************************************************************
*
      implicit none
*
#include "mntim.inc"
*
      integer idatm,isecs
*
      integer iii,isec,imin,ihou,iday,imon,iyea,iadd,ityp,idays
*
#include "mntimd.inc"
*
      if(idatm.eq.0) then
          isecs = 0
          return
      endif
*
      III  = IDATM
      ISEC = MOD (III, MXSEC)
      III  = (III-ISEC)/MXSEC
      IMIN = MOD (III, MXMIN)
      III  = (III-IMIN)/MXMIN
      IHOU = MOD (III, MXHOU)
      III  = (III-IHOU)/MXHOU
      IDAY = MOD (III, MXDAY)
      III  = (III-IDAY)/MXDAY
      IMON = MOD (III, MXMON)
      IYEA = (III-IMON)/MXMON
      IF (IYEA.LT.1) THEN
        IADD = 0
        ITYP = 2
      ELSE IF (IYEA.GT.mdayy) THEN
        IADD = IDAYY(mdayy)
        ITYP = 2
      ELSE
        IADD = IDAYY(IYEA)
        ITYP = MOD (IYEA, 4)
        IF (ITYP.EQ.0) THEN
          ITYP = 2
        ELSE
          ITYP = 1
        ENDIF
      ENDIF
*
      IDAYS = IDAY + IADD + IDAYM(IMON,ITYP)
      ISECS = ISEC + 60*(IMIN + 60*(IHOU + 24*IDAYS))
*                                                             END M_UTIS
      END
