/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "udm_config.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include "udm_common.h"
#include "udm_mutex.h"

/*#define DEBUG_LOCK*/

#ifdef DEBUG_LOCK
#include <assert.h>
#endif

static UDM_MUTEX MuMu[UDM_LOCK_MAX];
/*static udm_mutex_t internalMuMu;*/

#ifdef WIN32
__C_LINK udm_mutex_t ThreadProcLock;
#endif

__C_LINK void __UDMCALL UdmInitMutexes(void) {
	int i;
/*	InitMutex(&internalMuMu);*/
#ifdef WIN32
	InitMutex(&ThreadProcLock);
#endif
	for(i=0;i<UDM_LOCK_MAX;i++){
		InitMutex(&MuMu[i].mutex);
		MuMu[i].cnt = 0;
	}
}

__C_LINK  void __UDMCALL UdmDestroyMutexes(void) {
	int i;
	for(i=0;i<UDM_LOCK_MAX;i++){
		DestroyMutex(&MuMu[i].mutex);
	}
/*	DestroyMutex(&internalMuMu);*/
#ifdef WIN32
	DestroyMutex(&ThreadProcLock);
#endif
}

/* CALL-BACK Locking function */
__C_LINK void __UDMCALL UdmLockProc(UDM_AGENT *A,int command,int type,const char *fn,int ln){
  int u;

#ifdef DEBUG_LOCK
  if (type != UDM_LOCK_THREAD)
	fprintf(
#ifdef USE_TRACE
		A->TR
#else
		stderr
#endif
               , "[%d]{%02d} %2d Try %s\t%s\t%d\n", (int)getpid(), A ? A->handle : -1, type, (command==UDM_LOCK) ? "lock\t" : "unlock", fn, ln);
#endif
#ifdef USE_TRACE
  fflush(A->TR);
#endif
	switch(command){
		case UDM_LOCK:
		        if (A->Locked[type] == 0) {
			  UDM_MUTEX_LOCK(&MuMu[type].mutex);
			}
			A->Locked[type]++;
#ifdef DEBUG_LOCK
/*			assert(A->Locked[type] == 1);*/
#endif
			break;
		case UDM_UNLOCK:
			A->Locked[type]--;
			u = (A->Locked[type] == 0);
			if (u) UDM_MUTEX_UNLOCK(&MuMu[type].mutex);
			break;
	}
#ifdef DEBUG_LOCK
  if (type != UDM_LOCK_THREAD)
	fprintf(
#ifdef USE_TRACE
		A->TR
#else
		stderr
#endif
		, "[%d]{%02d} %2d %s\t%s\t%d\n", (int)getpid(),
		A ? A->handle : -1, type, (command==UDM_LOCK) ? "locked\t" : ((u) ? "unlocked\t" : "still locked"), fn, ln);
#ifdef USE_TRACE
  fflush(A->TR);
#endif
#endif

}

