#include <pgcheckbutton.h>

#include "PlayerConfiguration.h"

#include "PlayGroundMenu.h"
#include "GraphicsMenu.h"


#define GRAPHICS_FULLSCREEN_TXT_ON "Fullscreen is on"
#define GRAPHICS_FULLSCREEN_TXT_OFF "Fullscreen is off"

#define GRAPHICS_FULLFRAMERATE_TXT_ON "Full frame rate is on"
#define GRAPHICS_FULLFRAMERATE_TXT_OFF "Full frame rate is off"

MENU_SINGLETON_INIT(Graphics);

//----------------------------------------------------------------------
GraphicsMenu::GraphicsMenu()
{
    getWidget(ID_GRAPHICS_MENU_OK)->SetEventObject(
        MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&GraphicsMenu::onOk);
    getWidget(ID_GRAPHICS_MENU_CANCEL)->SetEventObject(
        MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&GraphicsMenu::onCancel);
    getWidget(ID_GRAPHICS_MENU_FULLSCREEN_ONOFF)->SetEventObject(
        MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&GraphicsMenu::onFullScreenCheck);
    getWidget(ID_GRAPHICS_MENU_FULLFRAMERATE_ONOFF)->SetEventObject(
        MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&GraphicsMenu::onFullFrameRateCheck);

    getWidget(ID_GRAPHICS_MENU_OK)->Show();
    getWidget(ID_GRAPHICS_MENU_CANCEL)->Show();
    getWidget(ID_GRAPHICS_MENU_FULLSCREEN_ONOFF)->Show();
    getWidget(ID_GRAPHICS_MENU_FULLFRAMERATE_ONOFF)->Show();

    m_autoPress = false;
}

//----------------------------------------------------------------------
GraphicsMenu::~GraphicsMenu()
{
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(GraphicsMenu::onOk)
{
    PlayerConfiguration *playerConfiguration =
        PlayerConfiguration::getInstance();

    playerConfiguration->getGraphics()->setFullScreen(m_fullScreenEnabled);
    playerConfiguration->getGraphics()->setFullFrameRate(m_fullFrameRateEnabled);
    playerConfiguration->writeConfiguration();

    PlayGroundMenu::getInstance()->initUpdateState();

    MenuManager::getInstance()->changeTo(getPrevious(), true, false);
    return true;
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(GraphicsMenu::onCancel)
{
    bool oldFullScreen = m_fullScreenEnabled;
    m_fullScreenEnabled =
        PlayerConfiguration::getInstance()->getGraphics()->isFullScreen();
    if (m_fullScreenEnabled != oldFullScreen)
    {
        MenuManager::initScreen(m_fullScreenEnabled);
    }

    MenuManager::getInstance()->changeTo(getPrevious(), true, false);
    return true;
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(GraphicsMenu::onFullScreenCheck)
{
    if (m_autoPress) return true;

    PG_CheckButton* check =
        (PG_CheckButton*)getWidget(ID_GRAPHICS_MENU_FULLSCREEN_ONOFF);
    m_fullScreenEnabled = check->GetPressed();

    check->SetText(m_fullScreenEnabled ?
                   GRAPHICS_FULLSCREEN_TXT_ON :
                   GRAPHICS_FULLSCREEN_TXT_OFF);
    check->Redraw();

    MenuManager::initScreen(m_fullScreenEnabled);

    return true;
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(GraphicsMenu::onFullFrameRateCheck)
{
    if (m_autoPress) return true;

    PG_CheckButton* check =
        (PG_CheckButton*)getWidget(ID_GRAPHICS_MENU_FULLFRAMERATE_ONOFF);
    m_fullFrameRateEnabled = check->GetPressed();

    check->SetText(m_fullFrameRateEnabled ?
                   GRAPHICS_FULLFRAMERATE_TXT_ON :
                   GRAPHICS_FULLFRAMERATE_TXT_OFF);
    check->Redraw();

    return true;
}

//----------------------------------------------------------------------
void GraphicsMenu::eventShow()
{
    getWidget(ID_GRAPHICS_MENU)->Show();

    PG_CheckButton *check = NULL;

    m_fullScreenEnabled =
        PlayerConfiguration::getInstance()->getGraphics()->isFullScreen();
    m_fullFrameRateEnabled =
        PlayerConfiguration::getInstance()->getGraphics()->isFullFrameRate();

    m_autoPress = true;

    check = (PG_CheckButton*)getWidget(ID_GRAPHICS_MENU_FULLSCREEN_ONOFF);
    if (m_fullScreenEnabled)
    {
        check->SetPressed();
    }
    else
    {
        check->SetUnpressed();
    }

    check = (PG_CheckButton*)getWidget(ID_GRAPHICS_MENU_FULLFRAMERATE_ONOFF);
    if (m_fullFrameRateEnabled)
    {
        check->SetPressed();
    }
    else
    {
        check->SetUnpressed();
    }

    m_autoPress = false;
}

//----------------------------------------------------------------------
void GraphicsMenu::eventHide()
{
    getWidget(ID_GRAPHICS_MENU)->Hide();
}
