///////////////////////////////////////////////////////////////////////////////
// $Id: resizedialog.cpp,v 1.1.1.1 2003/10/26 20:55:18 krake Exp $
//
// Package:   MOAGG Edit - Level Editor for MOAGG
// Copyright: Kevin Krammer, 2003
//
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
///////////////////////////////////////////////////////////////////////////////

/*! \file    resizedialog.cpp
    \author  Kevin Krammer, kevin.krammer@gmx.at
    \brief   Implementation of ResizeDialog class
*/

// Qt includes
#include <qradiobutton.h>
#include <qspinbox.h>

// local includes
#include "resizedialog.h"

///////////////////////////////////////////////////////////////////////////////

ResizeDialog::ResizeDialog(QWidget* parent, const char* name)
	: ResizeDialogBase(parent, name, true)
{
	m_rbScreen->setChecked(true);
	m_rbLevel->toggle();
}

///////////////////////////////////////////////////////////////////////////////

ResizeDialog::~ResizeDialog()
{
}

///////////////////////////////////////////////////////////////////////////////

void ResizeDialog::setNumRows(int rows)
{
	m_spRows->setValue(rows);
}

///////////////////////////////////////////////////////////////////////////////

void ResizeDialog::setNumCols(int cols)
{
	m_spColumns->setValue(cols);
}

///////////////////////////////////////////////////////////////////////////////

int ResizeDialog::numRows() const
{
	return m_spRows->value();
}

///////////////////////////////////////////////////////////////////////////////

int ResizeDialog::numCols() const
{
	return m_spColumns->value();
}

///////////////////////////////////////////////////////////////////////////////

void ResizeDialog::slotLevelSizeChanged()
{
	m_spWidth->blockSignals(true);
	m_spHeight->blockSignals(true);

	m_spWidth->setValue(m_spColumns->value() * 16);
	m_spHeight->setValue(m_spRows->value() * 16);
	
	m_spWidth->blockSignals(false);
	m_spHeight->blockSignals(false);
}

///////////////////////////////////////////////////////////////////////////////

void ResizeDialog::slotScreenSizeChanged()
{
	m_spColumns->blockSignals(true);
	m_spRows->blockSignals(true);

	m_spColumns->setValue(m_spWidth->value() / 16);
	m_spRows->setValue(m_spHeight->value() / 16);

	m_spColumns->blockSignals(false);
	m_spRows->blockSignals(false);
}

// End of file

