#ifndef LIBBTT_TRACKER_TRACKER_H
#define LIBBTT_TRACKER_TRACKER_H

/* other libs */
#include <apr.h>
#include <apr_pools.h>
/* local */
#include <libbttracker/types/btt_tracker.h>

/* bt_tracker_alloc.c */
extern btt_tracker* btt_tracker_alloc(apr_pool_t* p, const char* homedir, int master);
/* bt_tracker_free.c */
extern int btt_tracker_free(btt_tracker** tracker, int master);
extern void btt_free_tracker_pool(btt_tracker *t);

/* bt_tracker_connect.c */
extern int btt_tracker_connect_db(btt_tracker* tracker, int master);
extern int btt_tracker_connect_mem(btt_tracker* tracker, int master);
extern int btt_tracker_connect(btt_tracker* tracker, int master);
/* bt_tracker_disconnect.c */
extern int btt_tracker_disconnect_db(btt_tracker* tracker);
extern int btt_tracker_disconnect_mem(btt_tracker* tracker);
extern int btt_tracker_disconnect(btt_tracker* tracker);

/* bt_tracker_refresh_stats.c */
extern int btt_tracker_refresh_stats(btt_tracker* tracker);

#endif /* LIBBTT_TRACKER_TRACKER_H */
