/*
 *  mod_bt - Making Things Better For Seeders
 *  Copyright 2004, 2005, 2006 Tyler MacDonald <tyler@yi.org>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/* libc */
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
/* other libs */
#include <apr.h>
#include <apr_pools.h>
#include <apr_strings.h>
/* local */
#include <libbtutil.h>

char* bt_hash_str(apr_pool_t* p, char* data, apr_size_t data_len) {
    int i;
    char* rv = apr_palloc(p, data_len);
    char rrv[3] = "\0\0\0";
    long int riv;
 
    for(i=0;i<data_len;i++) {
        rrv[0] = data[i * 2];
        rrv[1] = data[(i * 2) + 1];
        riv = strtol(rrv, NULL, 16);
        rv[i] = riv;
    }
 
    return rv;
}

char* bt_str_hash(apr_pool_t* p, char* data, apr_size_t data_len) {
    int i;
    char* rv = apr_palloc(p, (data_len * 2) + 1);
 
    rv[data_len * 2] = 0;
 
    for(i=0;i<data_len;i++)
        sprintf(&(rv[i*2]), "%02hhx", data[i]);
 
    return rv;
}

char* bt_str_esc_hash(apr_pool_t* p, char* data, apr_size_t data_len) {
    char* rv = apr_pcalloc(p, (data_len * 3) + 2);
    int i;
 
    for(i=0;i<data_len;i++)
        sprintf(rv, "%s%%%02hhx", rv, (char)(data[i]));

    return rv;
}
