#!/bin/sh
# remodlogan.sh -- rerun modlogan for a directory of log files.
#
# Copyright 2003 Erich Schubert <erich@vitavonni.de>
#                written for Drinsama IT Services GmbH
#
if [ ! -d "$1" ]; then
	echo Please specify a directory >&2
	exit 1
fi
if [ ! -e "$1/modlogan.conf" ]; then
	echo No configuration file for modlogan found >&2
	exit 1
fi
rm -r "$1/modlogan/*" "$1/modlogan-state/*"
for dir in `ls -d $1/[0-9][0-9][0-9][0-9]/[0-9][0-9] | sort`; do
	for nam in `find $dir -name "resolved.log*gz" | sort`; do
		nice zcat $nam
	done \
	| nice sudo -u modlogan modlogan -c $1/modlogan.conf
done

