/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: datatype.c,v 1.15 2004/08/27 18:32:51 ostborn Exp $
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "config.h"
#include "mdatatypes.h"
#include "datatype.h"
#include "mconfig.h"

/* begin of Count */
extern size_t mem_mdata_type_count[M_DATA_TYPE_IPPLWATCH];

int mdata_Count_to_xml(gzFile *fd, mdata *data) {
#define WR(x,f) \
	gzprintf(fd, "<%s>%"#f"</%s>\n", #x, data->data.count.x, #x);

	WR(count, d);
	WR(grouped, d);
#undef WR


	return 0;
}

int mdata_Count_free(mdata *data) {
	if (!data) return -1;
	if (data->type != M_DATA_TYPE_COUNT) return -1;

	return 0;
}

int mdata_Count_setdata(mdata *data, const char *str, int count, int type) {

	data->key = str;
	assert(data->key);

	if (data->type == M_DATA_TYPE_UNSET)
		data->type		= M_DATA_TYPE_COUNT;


	data->data.count.count		= count;
	data->data.count.grouped	= type;
	
	mem_mdata_type_count[data->type]++;

	return 0;
}

int mdata_Count_from_xml(void *user_data, int tagtype, const xmlChar *value, const xmlChar **attrs) {
	int i;
	const mdata_values data_values[] = {
		{ "grouped", M_DATA_FIELDTYPE_LONG },
		{ "count", M_DATA_FIELDTYPE_LONG },

		{ NULL, M_DATA_FIELDTYPE_UNSET }
	};

	mstate_stack *m = user_data;

//	M_WP();

	switch(tagtype) {
	case M_TAG_BEGIN:
		for (i = 0; data_values[i].string != NULL && 0 != strcmp(data_values[i].string, value); i++)
			;

		if (data_values[i].string == NULL) {
			M_DEBUG1(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
				 "unknown tag '%s'\n",
				 value);
			return -1;
		}
#define SET_DATA(x) \
	m->st[m->st_depth].data = &(((mdata *)(m->st[m->st_depth-1].data))->x);
		switch(i) {
		case 0: SET_DATA(data.count.grouped); break;
		case 1: SET_DATA(data.count.count); break;
		default:
			return -1;
		}
#undef SET_DATA
		/* the same for all 4 values */
		m->st[m->st_depth].function = mdata_insert_value;
		m->st[m->st_depth].type = data_values[i].type;

		break;
	case M_TAG_END:
		((mdata *)(m->st[m->st_depth-1].data))->type = M_DATA_TYPE_COUNT;

		switch(m->st[m->st_depth-2].type) {
		case M_DATA_FIELDTYPE_HASH: {
			mhash *h = m->st[m->st_depth-2].data;
			mdata *data = m->st[m->st_depth-1].data;

			mhash_insert_sorted(h, data);
			break;
		}
		default:
			M_WP();
		}

		break;
	case M_TAG_TEXT:
		M_WP();
		break;
	default:
		M_DEBUG1(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
			 "can't handle tagtype '%d'\n",
			 tagtype);
		return -1;
	}

	return 0;
}



int mdata_Count_append(mdata *dst, mdata *src) {
	dst->data.count.count += src->data.count.count;

	return M_DATA_APPENDED;
}

mdata *mdata_Count_init() {
	mdata *data = mdata_init();
	assert(data);

	data->key		= NULL;
	data->type		= M_DATA_TYPE_COUNT;

#ifdef DEBUG_DATATYPES
	fprintf(stderr, "%s.%d: got %ld (%d)\n", __FILE__, __LINE__, data->id, data->type);
#endif
/* init specifics */
	data->data.count.count		= 0;
	data->data.count.grouped	= M_DATA_STATE_PLAIN;

	return data;
}

mdata *mdata_Count_copy(mdata *src) {
	mdata *data = mdata_Count_init();

	mdata_Count_setdata(data, src->key, src->data.count.count, src->data.count.grouped);

	return data;
}

mdata *mdata_Count_create(const char *str, int count, int type) {
	mdata *data = mdata_Count_init();

	mdata_Count_setdata(data, str, count, type);

	return data;
}

/* end of Count */
