/* 
 *   Creation Date: <2002/10/29 18:59:05 samuel>
 *   Time-stamp: <2002/12/08 04:15:18 samuel>
 *   
 *	<console.c>
 *	
 *	Simple text console
 *   
 *   Copyright (C) 2002 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#include "of.h"
#include "osi_calls.h"
#include "video_sh.h"

#include "font_8x8.c"

#define FONT_ADJ_HEIGHT	 (FONT_HEIGHT + 2)
#define NCOLS	80
#define NROWS	48

static struct {
	int	inited;
	int	physw, physh;
	int	w,h;

	int	x,y;
	char	*buf;
} cons;

static void
draw_char( char ch, int h, int v )
{
	char *c = fontdata;
	int x, y, xx, rskip, m;

	while( h >= cons.physw/FONT_WIDTH || v >= cons.physh/FONT_ADJ_HEIGHT )
		return;
	
	h *= FONT_WIDTH;
	v *= FONT_ADJ_HEIGHT;

	rskip = (FONT_WIDTH > 8)? 2 : 1;
	c += rskip * (unsigned int)(ch & 0xff) * FONT_HEIGHT;

	for( x=0; x<FONT_WIDTH; x++ ) {
		xx = x % 8;
		if( x && !xx )
			c++;
		m = (1<<(7-xx));
		for( y=0; y<FONT_HEIGHT; y++ ){
			int col = (c[rskip*y] & m) ? 0: 254;
			draw_pixel( h+x, v+y+1, col );
		}
		draw_pixel( h+x, v, 254 );
		draw_pixel( h+x, v+FONT_HEIGHT+1, 254 );
	}
}

static void
draw_line( int n )
{
	int i;

	if( n >= cons.h || n < 0 )
		return;
	for( i=0; i<cons.w; i++ )
		draw_char( cons.buf[n*cons.w+i], i, n );
}

#if 0
static void
refresh( void )
{
	int i;       
	for( i=0; i<cons.h; i++ )
		draw_line(i);
}
#endif

static int
console_init( void ) 
{
	if( video_get_res(&cons.physw,&cons.physh) < 0 )
		return -1;

	set_color( 0, 0 );
	
	cons.w = cons.physw/FONT_WIDTH;
	cons.h = cons.physh/FONT_ADJ_HEIGHT;
	cons.buf = malloc( cons.w * cons.h );
	cons.inited = 1;	
	cons.x = cons.y = 0;
	return 0;
}

void
console_close( void ) 
{
 	if( !cons.inited )
		return; 
	free( cons.buf );
	cons.inited = 0;	
}

static void
rec_char( char ch, int x, int y )
{
	if( x>=0 && y>=0 && x<cons.w && y<cons.h ) {
		cons.buf[y*cons.w + x] = ch;
		draw_char( ch, x, y );
	}
}

static void
scroll1( void )
{
	osi_fb_info_t fb;
	int offs,x;
	OSI_GetFBInfo( &fb );
	offs = fb.rb * FONT_ADJ_HEIGHT;

	memmove( (char*)fb.mphys, (char*)fb.mphys + offs, fb.h * fb.rb - offs );
	for( x=0; x<cons.w; x++ )
		cons.buf[(cons.h-1)*cons.w + x] = 0;
	draw_line(cons.h-1);
}

int
console_draw_str( const char *str )
{
	static char *ignore[] = { "[1;37m", "[2;40m", NULL };
	int ch, y, x, i;

	if( !cons.inited && console_init() )
		return -1;

	rec_char( 0, cons.x, cons.y );
	while( (ch=*str++) ) {
		if( ch == 12 )
			continue;
		if( ch == '\n' || cons.x >= cons.w ) {
			cons.x=0, cons.y++;
			continue;
		}
		if( cons.y >= cons.h ) {
			for( y=0; y<cons.h-1; y++ )
				for( x=0; x<cons.w; x++ )
					cons.buf[y*cons.w + x] = cons.buf[(y+1)*cons.w + x];
			cons.y = cons.h-1;
			cons.x = 0;
			scroll1();
		}
		if( ch == '\r' )
			continue;
		if( ch == '\e' ) {
			for( i=0; ignore[i] && strncmp(ignore[i], str, strlen(ignore[i])); i++ )
				;
			if( ignore[i] )
				str += strlen(ignore[i]);
			continue;
		}
		if( ch == '\b' )
			rec_char( ' ', cons.x--, cons.y );
		else
			rec_char( ch, cons.x++, cons.y );
	}
	rec_char( 1, cons.x, cons.y );
	return 0;
}
