/* 
 * Motion Eye video4linux application.
 *
 * Copyright (C) 2001-2002 Stelian Pop <stelian@popies.net>
 *
 * Copyright (C) 2001-2002 Alcve <www.alcove.com>
 *
 * Copyright (C) 2000 Andrew Tridgell <tridge@valinux.com>
 *
 * Earlier work by Werner Almesberger, Paul `Rusty' Russell and Paul Mackerras.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef WITH_X
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/shape.h>
#include <Imlib.h>
#endif

#include "motioneye.h"

/* convert a YUV set to a rgb set - thanks to MartinS and
   http://www.efg2.com/lab/Graphics/Colors/YUV.htm */
static void yuvtorgb(int Y, int U, int V, u8 *rgb) {
	int r, g, b;
	static short L1[256], L2[256], L3[256], L4[256], L5[256];
	static int initialised;

	if (!initialised) {
		int i;
		initialised=1;
		for (i=0;i<256;i++) {
			L1[i] = 1.164*(i-16);
			L2[i] = 1.596*(i-128);
			L3[i] = -0.813*(i-128);
			L4[i] = 2.018*(i-128);
			L5[i] = -0.391*(i-128);
		}
	}
#if 0
	r = 1.164*(Y-16) + 1.596*(V-128);
	g = 1.164*(Y-16) - 0.813*(U-128) - 0.391*(V-128);
	b = 1.164*(Y-16) + 2.018*(U-128);
#endif

	r = L1[Y] + L2[V];
	g = L1[Y] + L3[U] + L5[V];
	b = L1[Y] + L4[U];

	if (r < 0) r = 0;
	if (g < 0) g = 0;
	if (b < 0) b = 0;
	if (r > 255) r = 255;
	if (g > 255) g = 255;
	if (b > 255) b = 255;

	rgb[0] = r;
	rgb[1] = g;
	rgb[2] = b;
}

/* convert yuv to rgb */
void yuv_convert(u8 *buf, u8 *rgb, int xsize, int ysize) {
	int i;

	for (i=0;i<xsize*ysize;i+=2) {
		int Y1, Y2, U, V;

		Y1 = buf[2*i+0];
		Y2 = buf[2*i+2];
		U = buf[2*i+1];
		V = buf[2*i+3];

		yuvtorgb(Y1, U, V, &rgb[3*i]);
		yuvtorgb(Y2, U, V, &rgb[3*(i+1)]);
	}
}

#ifdef WITH_X
void display_rgb(u8 *rgb, int width, int height, char *name) {
	XSetWindowAttributes attr;
	static int initialised;
	static Display *disp;
	static ImlibData *id;
	static Window win;
	static ImlibImage *im;

	if (!initialised) {
		if (!rgb) return;

		initialised = 1;
		if (!disp) {
			disp=XOpenDisplay(NULL);
		}
		id=Imlib_init(disp);

		win=XCreateWindow(disp,DefaultRootWindow(disp),0,0,
				  width,height,0,id->x.depth,
				  InputOutput,id->x.visual,0,&attr);
		XMapWindow(disp,win);
		XSync(disp,False);
	}

	if (!rgb) {
		XDestroyWindow(disp, win);
		initialised=0;
		XSync(disp,False);
		return;
	}

	XStoreName(disp, win, name);
	im = Imlib_create_image_from_data(id, rgb, NULL, width,height);
	Imlib_paste_image(id,im,win,0,0,im->rgb_width,im->rgb_height);
	Imlib_kill_image(id, im);
	XSync(disp,False);
}
#endif
