/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Nezhevenko                               *
 *   dionua@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef FRMSEEMEDITOR_H
#define FRMSEEMEDITOR_H

#include "frmseemeditor_base.h"
#include <qtable.h>

/**
@author Dmitry Nezhevenko
*/
class PhoneMan;

class frmSeemEditor : public frmSeemEditor_base
{
	Q_OBJECT
public:
	frmSeemEditor(QWidget *parent, PhoneMan * ph, const char *name = 0);
	~frmSeemEditor();

public slots:
	void doSeemLoad();
	void doSeemSave();
	void doSeemRead();
	void doSeemWrite();
	void doBackup();
	void doCellChange(int, int);
	void doBitChanged();
private:
	int tmpLock;
	int seemSize;
	int tmpSize;
	unsigned char * curSeem;
	PhoneMan * phone;
	
	void showSeem(unsigned char *buf, int size);
	void seem2buf(unsigned char *buf, int size);
private slots:
	void onSeemReadComplete();
	void onSeemWriteComplete();
};

class MyTableItem : public QTableItem
{
public:
	MyTableItem( QTable * table, EditType et, const QString &text )
	:QTableItem(table,et, text) {; };
	
	virtual int alignment() const {return (Qt::AlignRight | Qt::AlignVCenter);};
	
};

#endif
