/* show some nice effect on actual window

   Written by Matthias Hensler
   Copyright WSPse 1999-2004
   eMail: matthias@wspse.de

Created: 1999/06/11
Updated: 2004/04/15, MH: portability changes
*/

/* Copying:
   This program is free software; you can redistribute it and/or modify it under
   the terms of the GNU Gerneral Public License as published by the Free Soft-
   ware Foundation; either version 2 of License, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILTY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 675 Mass
   Ave, Cambridge, MA 02139, USA.
   */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <ncurses.h>
#include "mp3creat.h"

/* Globals */
WINDOW *eff_win = NULL;
char eff_course = 0, eff_color = 0;
signed char eff_pos = 0;
#define EFF_MAX_COL 3
const short eff_color_tab[] = {1, 2, 6};
#define EFF_RESTORE (winch(win) & ((A_COLOR) ^ 0xffffff))

/* Parameter:
   WINDOW * : window which should get effect
   BOOL     : do a refresh, or leave this to caller-routine
   BOOL     : save old cursorcoordinates
 */
void win_effect(WINDOW *win, BOOL e_refresh, BOOL save_coor)
{
  chtype old_ch;
  int oldx=0, oldy=0;
  int maxy, maxx;
  int i;
  
  /* create new effect for actual win */
  if(eff_win != win) {
    eff_win    = win;
    eff_course = 1 - eff_course;
  }
  
  getmaxyx(eff_win, maxy, maxx);
  old_ch = getbkgd(eff_win);
  
  /* must save old cursor */
  if(save_coor) {
    getyx(eff_win, oldy, oldx);
  }
  
  wbkgdset(eff_win, COLOR_PAIR(eff_color_tab[(int) eff_color]));
  switch(eff_pos) {
    case 0:
      wmove(eff_win, 0, 0);
      for(i=0;i<(maxx>>1);i++) waddch(eff_win, EFF_RESTORE);
      break;
    case 1:
      wmove(eff_win, 0, maxx>>1);
      for(i=(maxx>>1);i<maxx;i++) waddch(eff_win, EFF_RESTORE);
      break;
    case 2:
      for(i=0;i<(maxy>>1);i++) {
	wmove(eff_win, i, maxx-1);
	waddch(eff_win, EFF_RESTORE);
      }
      break;
    case 3:
      for(i=(maxy>>1);i<maxy;i++) {
	wmove(eff_win, i, maxx-1);
	waddch(eff_win, EFF_RESTORE);
      }
      break;
    case 4:
      wmove(eff_win, maxy-1, maxx>>1);
      for(i=(maxx>>1);i<maxx;i++) waddch(eff_win, EFF_RESTORE);
      break;
    case 5:
      wmove(eff_win, maxy-1, 0);
      for(i=0;i<(maxx>>1);i++) waddch(eff_win, EFF_RESTORE);
      break;
    case 6:
      for(i=(maxy>>1);i<maxy-1;i++) {
	wmove(eff_win, i, 0);
	waddch(eff_win, EFF_RESTORE);
      }
      break;
    case 7:
      for(i=0;i<(maxy>>1);i++) {
	wmove(eff_win, i, 0);
	waddch(eff_win, EFF_RESTORE);
      }
      break;
  }
  wbkgdset(eff_win, old_ch);

  if(eff_course) eff_pos++;
  else           eff_pos--;

  if((eff_pos == -1) || (eff_pos == 8)) {
    eff_color = (eff_color + 1) % EFF_MAX_COL;
    if(eff_pos == -1) eff_pos = 7;
    else              eff_pos = 0;
  }

  if(save_coor) {
    wmove(eff_win, oldy, oldx);
  }

  if(e_refresh) wrefresh(eff_win);
}

