/* lockfile handling

   Written by Matthias Hensler
   Copyright WSPse 1999+2000
   eMail: wsp@gmx.de

Created: 1999/09/27
Updated: 2000/06/24
*/

/* Copying:
   This program is free software; you can redistribute it and/or modify it under
   the terms of the GNU Gerneral Public License as published by the Free Soft-
   ware Foundation; either version 2 of License, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILTY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 675 Mass
   Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>                                                              
#include "mp3creat.h"

#ifdef HAVE_ERRNO_H                                                             
#include <errno.h>                                                              
#endif
#ifdef HAVE_SYS_TYPES_H                                                         
#include <sys/types.h>                                                          
#endif
#ifdef HAVE_SIGNAL_H                                                            
#include <signal.h>                                                             
#endif

extern void popup_error_win(char *tx);
extern void wuuush(int);

char *lock_add_extension(char *lockfile)
{
  char *new;
  
  if(! lockfile) return NULL;

  new = (char *) malloc(sizeof(char) * strlen(lockfile) + 6);
  if(! new) {
    wuuush(1);
  }

  sprintf(new, "%s.lock", lockfile);

  return new;
}

/* return-codes:
   0 - lockfile created
   1 - error determining if process is running
   2 - error writing lockfile
   3 - locked process still running
 */
int lock_lock_file(char *lockfile, BOOL extension)
{
  FILE *lckdes;
  pid_t lckpid;
  char *file;

  if(! lockfile) return 1;

  if(extension) {
    file = lock_add_extension(lockfile);
  } else {
    file = lockfile;
  }

  lckdes = fopen(file, "r");
  if(lckdes) {     /* lockfile exists */
    if(fscanf(lckdes, "%d", &lckpid) == 1) {
      if(kill(lckpid, 0) == -1 && errno == ESRCH) {        /* process is not longer existing */
	/* remove stale lockfile */
	fclose(lckdes);
	unlink(file);
      } else {          /* process still running */
	fclose(lckdes);
	if(extension) {
	  free(file);
	  file = NULL;
	}
	return 3;
      }
    } else {
      popup_error_win(_("error while reading pid from existing lockfile"));
      fclose(lckdes);
      return 1;
    }
  } else if(errno != ENOENT) {
    popup_error_win(_("lockfile exists and is not readable"));
    return 1;
  }

  lckdes = fopen(file, "w");
  if(! lckdes) {
    if(extension) {
      free(file);
      file = NULL;
    }
    return 2;
  }

  fprintf(lckdes, "%d", getpid());
  fclose(lckdes);
  return 0;
}

int lock_unlock_file(char *lockfile, BOOL extension)
{
  char *file;
  
  if(! lockfile) return 0;

  if(extension) {
    file = lock_add_extension(lockfile);
  } else {
    file = lockfile;
  }

  if(unlink(file)) {
    if(extension) {
      free(file);
      file = NULL;
    }
    return 1;
  }
  
  if(extension) {
    free(file);
    file = NULL;
  }
  return 0;
}

