#include <gtk/gtk.h>
#include <gtk/gtktreeview.h>
#include <stdio.h>
#include <string.h>

#ifdef NLS
#include <libintl.h>
#include <locale.h>

#define _(String) gettext (String)
#endif

#ifndef NLS
#define _(String) String
#endif

#define gettext_noop(String) String
#define N_(String) gettext_noop (String)

#ifndef USE_OSX
#include <linux/limits.h>
#endif

#define MAX_PATH NAME_MAX + PATH_MAX



#include "dirdialog.h"
#include "open.xpm"
#include "closed.xpm"

static GtkWidget* dirsel_window = NULL;

static gchar dirsel_dirname[MAX_PATH];

static dirsel_callback dirsel_callback_func;

enum {
//     DIRSEL_COL1,
     DIRSEL_COL2,
     DIRSEL_NCOL

};

#ifdef NLS

// if not a valid utf-8 string try to convert from current locale charset to utf-8 
//  fallback to iso8859-1 charset  
gchar* dirsel_convert_if_needed(gchar* text) {
	gint bytes_read;
	gint bytes_written;
	gchar* conv_text;
	GError*	gerror = NULL;
	static gchar* free_text = NULL;
	
	if (g_utf8_validate(text,-1,NULL))
		return text;

	conv_text = g_locale_to_utf8(text,-1,&bytes_read,&bytes_written,NULL);
	if (conv_text != NULL)
		return conv_text;

	if (free_text) 
		g_free(free_text);

	free_text =  g_convert(text,strlen(text),"UTF-8","ISO-8859-1",&bytes_read,&bytes_written,&gerror);
	if (!free_text) {
		g_print("%s\bn",gerror->message);
		// if we still cant convert return original string, will likely produce an error message
		return text;
	}

	return free_text;
}

#endif

gchar* dirsel_get_path_from_tree(gchar* fullpath,
				 GtkTreeModel* model,
				 GtkTreeIter* iter) {
     GString* p;
     gchar* c;
     GtkTreeIter parent;
     GtkTreeIter child;
     gboolean flag = 0;
     child = *iter;
     p = g_string_new("");

     while (gtk_tree_model_iter_parent(model,&parent,&child)) {
	  gtk_tree_model_get(model,&child,DIRSEL_COL2,&c,-1);
	  g_string_prepend(p,c);
	  g_string_prepend(p,"/");
	  child = parent;
	  flag = 1;
     }
     if (!flag)
	  g_string_prepend(p,"/");

     strncpy(fullpath,p->str,MAX_PATH);
     g_string_free(p,TRUE);
     return fullpath;
}

gchar* dirsel_path_cat(gchar* ret,gchar* p1,char* p2) {
     if (strlen(p1) + strlen(p2) > MAX_PATH - 1)
	  return NULL;
     strncpy(ret,p1,MAX_PATH);
     if (p1[strlen(p1) -1] != '/')
	  strcat(ret,"/");
     strncat(ret,p2,MAX_PATH - (strlen(p1) +1));

     return ret;
}

int dirsel_check_for_sub_dir(gchar* path) {
     GDir* dptr;
     gchar* c;
     gchar fullpath[MAX_PATH];

     dptr = g_dir_open(path,0,NULL);
     if (dptr == NULL)
	  return 0;
     
     while( (c = (gchar*)g_dir_read_name(dptr)) != NULL) 
	  if (g_file_test(dirsel_path_cat(fullpath,path,c) ,G_FILE_TEST_IS_DIR)) {
	       g_dir_close(dptr);
	       return 1;
	  }
     
     g_dir_close(dptr);
     return 0;
}

gint dirsel_dircomp(GString* s1,GString* s2) {

     return strcmp(s1->str,s2->str);
}

int dirsel_load_dir(GtkTreeStore* model,GtkTreeIter* iter,gchar* path) {
     GDir* dptr;
     gchar* c;
     gchar fullpath[MAX_PATH];
     GList* dirlist = NULL;
     GtkTreeIter iter2;
     GtkTreeIter iter3;
     GString* gs;
     gint showhidden = 0;

     dptr = g_dir_open(path,0,NULL);
     if (dptr == NULL)
	  return 0;
     
     showhidden = (gint)g_object_get_data(G_OBJECT(dirsel_window),"show hidden");

     while( (c = (gchar*)g_dir_read_name(dptr)) != NULL) {
	  if ((*c == '.') && !showhidden) continue; 
	  if (g_file_test(dirsel_path_cat(fullpath,path,c),G_FILE_TEST_IS_DIR)) {
#ifdef NLS
	       gs = g_string_new(dirsel_convert_if_needed(c));
#else
			gs = g_string_new(c);
#endif
	       dirlist = g_list_insert_sorted(dirlist,gs,(GCompareFunc)dirsel_dircomp);
	  }
     }

     for (dirlist = g_list_first(dirlist);dirlist;dirlist = g_list_next(dirlist)) {
	       gtk_tree_store_append(model,&iter2,iter);     
	       gtk_tree_store_set(model,&iter2,DIRSEL_COL2,((GString*)dirlist->data)->str,-1);

	       if (dirsel_check_for_sub_dir(dirsel_path_cat(fullpath,path,((GString*)dirlist->data)->str)))
		    gtk_tree_store_append(model,&iter3,&iter2);

	       g_string_free((GString*)dirlist->data,0);
     }
 
     g_dir_close(dptr);
     g_list_free(dirlist);
     return 1;
}


void  dirsel_row_expanded  (GtkTreeView *treeview,
			    GtkTreeIter* arg1,
			    gint arg2,
			    gpointer user_data) 
{
     gchar fullpath[MAX_PATH];
     GtkTreeIter iter;
     gboolean ret;
     GtkTreeModel* model;

     model = gtk_tree_view_get_model(treeview);
     dirsel_get_path_from_tree(fullpath,model,arg1);
     ret = gtk_tree_model_iter_nth_child(model,&iter,arg1,0);
     dirsel_load_dir(GTK_TREE_STORE(model),arg1,fullpath);
     if (ret) gtk_tree_store_remove(GTK_TREE_STORE(model),&iter);
}

void  dirsel_row_collapsed  (GtkTreeView *treeview,
			    GtkTreeIter* arg1,
			    gint arg2,
			    gpointer user_data) 
{
     GtkTreeModel* model;
     GtkTreeIter iter;

     model = gtk_tree_view_get_model(treeview);
     
     gtk_tree_model_iter_nth_child(model,&iter,arg1,0);
     while(gtk_tree_model_iter_n_children(model,arg1) > 1)
	  gtk_tree_store_remove(GTK_TREE_STORE(model),&iter);	  
}

gboolean dirsel_DestroyWidget(GtkWidget *button,gpointer user_data) {
     gtk_widget_destroy(dirsel_window);
     return FALSE;
	  
}


void dirsel_button_clicked(GtkButton *button,gpointer user_data) {

//     gtk_timeout_add (1000,(GtkFunction)run_callback,user_data);
     gtk_timeout_add (200,(GtkFunction)dirsel_DestroyWidget,NULL);
     dirsel_callback_func(dirsel_dirname,(gint) user_data); 
}


void dirsel_destroy(GtkButton *button,gpointer user_data) {
     dirsel_window = NULL;
}

void dirsel_button_toggled(GtkToggleButton *button,gpointer user_data) {

     if (gtk_toggle_button_get_active(button)) 
	  g_object_set_data(G_OBJECT(user_data),"show hidden",(gpointer)1);
     else
	  g_object_set_data(G_OBJECT(user_data),"show hidden",(gpointer)0);
}


void dirsel_changed (GtkTreeView *treeview,gpointer user_data) {
    GtkTreeSelection* selection;
    GtkTreeIter iter;
    GtkTreeModel *model;

    selection = gtk_tree_view_get_selection(treeview);
    gtk_tree_selection_get_selected (selection, &model, &iter);
    dirsel_get_path_from_tree(dirsel_dirname,model,&iter);
}

gint dirsel_button_press(GtkWidget *widget,
			 GdkEventButton *event,
			 gpointer user_data) {
     GtkTreeSelection* selection;
     GtkTreePath* tp;
     GtkTreeModel *model;
     GtkTreeIter iter;

     if (event->type != GDK_2BUTTON_PRESS)
	  return FALSE;

     model = gtk_tree_view_get_model(GTK_TREE_VIEW(widget));
     selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(widget));
     gtk_tree_selection_get_selected (selection, &model, &iter);
     if (!gtk_tree_model_iter_has_child(model,&iter))     
	  return FALSE;

     tp = gtk_tree_model_get_path(model,&iter);
     
     if (!gtk_tree_view_row_expanded(GTK_TREE_VIEW(widget),tp))
	  gtk_tree_view_expand_row(GTK_TREE_VIEW(widget),tp,0);
     else
	  gtk_tree_view_collapse_row(GTK_TREE_VIEW(widget),tp);
     gtk_tree_path_free (tp);

     return FALSE;
}


int dirsel_treeview_scroll   (GtkTreeView* widget,
                                            GdkEventScroll *event,
			       gpointer user_data) {

     GtkAdjustment* adj;
     
     adj= gtk_tree_view_get_vadjustment(GTK_TREE_VIEW(widget));
     adj->page_increment = 80.0f;
     gtk_tree_view_set_vadjustment(GTK_TREE_VIEW(widget),adj);
     gtk_adjustment_changed(adj);    
     
     return FALSE;
} 

void dirsel_expand_to_path(GtkTreeView* tv,gchar* path) {
     GtkTreePath* tp;
     gchar* c;
     gchar temp[MAX_PATH];
     GtkTreeIter iter;
     GtkTreeIter iter2;
     GtkTreeModel* model;
     gchar* txt;
     gboolean ret;
     GtkTreeSelection *selection;

     if (!path)
	  return;

     model = gtk_tree_view_get_model(tv);

     strncpy(temp,path,MAX_PATH);
     c = temp;
     
     while(*c != '\0') {
	  if (*c == '/')
	       *c = '\0';
	  c++;
     }
     *++c = '\0';

     c = temp;
     if (*c == '\0')
	  c++;

     selection = gtk_tree_view_get_selection(tv);
     gtk_tree_model_get_iter_first(model,&iter);
     gtk_tree_selection_unselect_iter(selection,&iter);
     gtk_tree_model_iter_nth_child(model,&iter2,&iter,0);
     iter = iter2;
     while(*c != '\0') {
	  
	  do {
	       gtk_tree_model_get(model,&iter,DIRSEL_COL2,&txt,-1);

	       if (strncmp(txt,c,NAME_MAX) == 0) {
		    if (gtk_tree_model_iter_has_child(model,&iter)) {
			 tp = gtk_tree_model_get_path(model,&iter);
			 gtk_tree_view_set_cursor (tv,tp,NULL,0);
			 gtk_tree_view_scroll_to_cell(tv,tp,NULL,TRUE,0.5,0);
			 gtk_tree_view_expand_row(tv,tp,0);
			 gtk_tree_path_free (tp);
			 iter2 = iter;
			 gtk_tree_model_iter_nth_child(model,&iter,&iter2,0);
			 break;
		    }
		    else
		    {
			 tp = gtk_tree_model_get_path(model,&iter);
			 gtk_tree_view_set_cursor (tv,tp,NULL,0);
			 gtk_tree_view_scroll_to_cell(tv,tp,NULL,TRUE,0.5,0);
			 gtk_tree_path_free (tp);
			 ret = 0; 
			 break;
		    }
	       }
	  } while( (ret = gtk_tree_model_iter_next(model,&iter)) );
     
	  if (!ret)
	       return;
	  c = c + strlen(c) + 1;
     }
}



GtkWindow* dirsel_create_dialog(dirsel_callback userfunc,gchar* path) {
     GtkWidget* window = dirsel_window;
     GtkWidget* vbox;
     GtkWidget* hbox;
     GtkWidget* scroller;
     GtkWidget* bbox;
     GtkWidget* statusbar;
     GtkWidget* button;
     GtkWidget* treeview;
     GtkCellRenderer* renderer = gtk_cell_renderer_text_new();
     GtkCellRenderer* renderer2;
     GtkTreeViewColumn* column;
     GtkTreeStore* dir_tree;
     GtkTreeIter iter;
     GtkTreeIter iter2;
     GtkTreePath* tpath;

     if (window) 
	  return GTK_WINDOW(window);


     window = gtk_widget_new(gtk_window_get_type(),
			     "type",GTK_WINDOW_TOPLEVEL,
			     "title",_("Select directory"),
			     "allow_grow",TRUE,
			     "allow_shrink",FALSE,
			     "default-width",350,
			     "default-height",350,
			     NULL);

     dirsel_window = window;
     dirsel_callback_func = userfunc;

//     g_object_connect(window,"signal::destroy",gtk_widget_destroy,NULL,NULL);
     g_signal_connect(window,"destroy",G_CALLBACK(dirsel_destroy),0);
     vbox = gtk_vbox_new(FALSE,0);
     gtk_container_add(GTK_CONTAINER(window),vbox);
     scroller = gtk_scrolled_window_new(NULL, NULL);
     gtk_container_set_border_width(GTK_CONTAINER(scroller),5);
     gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroller),
				    GTK_POLICY_ALWAYS,
				    GTK_POLICY_ALWAYS);
     gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(scroller),GTK_SHADOW_IN);
     treeview = gtk_tree_view_new();
     gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(treeview),FALSE);
     gtk_container_add(GTK_CONTAINER(scroller),treeview);
     gtk_box_pack_start(GTK_BOX(vbox),scroller,TRUE,TRUE,0);
     hbox = gtk_hbox_new(FALSE,0);
     button = gtk_check_button_new_with_label(_("Show Hidden Directories"));
     gtk_box_pack_start(GTK_BOX(hbox),button,TRUE,FALSE,0);
     gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);


     g_object_set_data(G_OBJECT(treeview),"show hidden",(gpointer)0);
     g_signal_connect(button,"clicked",G_CALLBACK(dirsel_button_toggled),(gpointer)window);
     g_object_set_data(G_OBJECT(window),"show hidden",(gpointer)0);

     
     bbox = gtk_hbutton_box_new();
     gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox),GTK_BUTTONBOX_END);
     gtk_box_set_spacing (GTK_BOX (bbox), 10);
     gtk_container_set_border_width(GTK_CONTAINER(bbox),5);

     button = gtk_button_new_from_stock(GTK_STOCK_OK);
     gtk_container_add(GTK_CONTAINER(bbox),button);
     g_signal_connect(button,"clicked",G_CALLBACK(dirsel_button_clicked),(gpointer)1);

     button = gtk_button_new_from_stock(GTK_STOCK_CANCEL);
     gtk_container_add(GTK_CONTAINER(bbox),button);
     gtk_box_pack_start(GTK_BOX(hbox),bbox,FALSE,FALSE,0);
     g_signal_connect(button,"clicked",G_CALLBACK(dirsel_button_clicked),(gpointer)0);

     statusbar = gtk_statusbar_new();
     gtk_box_pack_start(GTK_BOX(vbox),statusbar,FALSE,FALSE,0);
     
     if (1) {
	  char font[] = "Sans 10";
	  gtk_cell_renderer_set_fixed_size(renderer,-1,20);
	  g_object_set(renderer,"font",font,NULL);
     }

     renderer2 = gtk_cell_renderer_pixbuf_new();
     column = gtk_tree_view_column_new();
     gtk_tree_view_column_set_title(column,"pic");
     gtk_tree_view_column_pack_start(column,renderer2,FALSE);

     if (1 ) {
	  GdkPixbuf* p;
	  p = gdk_pixbuf_new_from_xpm_data((const char**)&closed_xpm);
	  g_object_set(renderer2,"pixbuf",p,NULL);
	  p = gdk_pixbuf_new_from_xpm_data((const char**)&open_xpm); 
	  g_object_set(renderer2,"pixbuf-expander-open",p,NULL);
	  p = gdk_pixbuf_new_from_xpm_data((const char**)&closed_xpm);
	  g_object_set(renderer2,"pixbuf-expander-closed",p,NULL);
     }

     gtk_tree_view_column_pack_start(column,renderer,FALSE);
     gtk_tree_view_column_set_attributes(column,renderer,"text",DIRSEL_COL2,NULL);
     gtk_tree_view_append_column(GTK_TREE_VIEW(treeview),column);

     dir_tree = gtk_tree_store_new(DIRSEL_NCOL,G_TYPE_STRING);
     gtk_tree_view_set_model(GTK_TREE_VIEW(treeview),GTK_TREE_MODEL(dir_tree));

     g_signal_connect(treeview,"row-expanded",G_CALLBACK(dirsel_row_expanded),NULL);
     g_signal_connect(treeview,"row-collapsed",G_CALLBACK(dirsel_row_collapsed),NULL);
     g_signal_connect(treeview,"cursor_changed",G_CALLBACK(dirsel_changed),NULL);
     g_signal_connect(treeview,"button-press-event",G_CALLBACK(dirsel_button_press),NULL);
     g_signal_connect(treeview,"scroll-event",G_CALLBACK(dirsel_treeview_scroll),NULL);
     
     gtk_tree_store_append(dir_tree,&iter,NULL);     
     gtk_tree_store_set(dir_tree,&iter,DIRSEL_COL2,"/",-1);
     gtk_tree_store_append(dir_tree,&iter2,&iter);

     tpath = gtk_tree_path_new_from_string ("0");
     gtk_tree_view_expand_row(GTK_TREE_VIEW(treeview),tpath,0);
     gtk_tree_path_free (tpath);

     dirsel_expand_to_path(GTK_TREE_VIEW(treeview),path);

     return GTK_WINDOW(window);
}
