#include <glib/gtypes.h>
#include <MRI_Types.h>

#define	BALANCE_MODE_PRESET 0
#define	BALANCE_MODE_MANUAL 1

/* Persistent options structure. */
typedef struct
{
  gint     initialized;
  gdouble  gammaVal;
  guint	   newbal1;
  guint	   newbal2;
  gdouble  mix;
  gdouble  autolevel;
  guint	   balanceMode;
  gdouble  redBalance, greenBalance, blueBalance;
  MRI_balance userBalance;
  guint	   rotate;
  guint	   finalShrink;
  guint	   previewShrink;
  guint    histWidth, histHeight;
  guint    iMethodNum;
  guint    toneCurveNum;
  gdouble  vmedian_tolerance;
  guint	   useLab;
  guint	   applyVMF;
  guint	   applyMedianFilter;
  guint    radius;
  gdouble  blur;
  gdouble  iSharpen;
  gdouble  cSharpen;
  guint    filterColorOnly;
  gdouble  darkness;
  gdouble  contrast;
  gdouble  shadows;
  gdouble  saturation;
  guint    fixShortSide;
  gdouble  fixedSideLength;
} PersistentVals;

extern PersistentVals plvals;

extern void InitializePersistentVals (PersistentVals *pVals);
