/* Interpolation Method Table for Minolta Raw Photo Plugin
 *
 * Copyright (C) 2004 Bradley Broom
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>

#include "../../config.h"

#include <glib/gthread.h>
#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>

#include "lcms.h"

#include <MRI.h>
#include <MRW_Loader.h>
#include "../FindFile.h"
#include "../options.h"

#include "mrwplugin-intl.h"

struct intMethodTable_t {
	char	*baseName;
	char	*intlName;
	char	*shortName;
} intMethodTable[] = {
   { N_("Bilinear"), NULL, "bilinear", },
   { N_("Vector Median"), NULL, "vmedian", },
   { N_("Smoothed Vector Median"), NULL, "svmedian", },
   { N_("MedianG BilinearRB"), NULL, "mgbrb", },
   { N_("MedianG MedianRB"), NULL, "mgmrb", },
   { N_("Pseudo Expansion"), NULL, "pseudoexp", },
};

int
num_interpolation_methods()
{
    return sizeof(intMethodTable)/sizeof(intMethodTable[0]);
}

char *
get_interpolation_method_shortname (int index)
{
    if (index >= 0 && index < sizeof(intMethodTable)/sizeof(intMethodTable[0]))
	return intMethodTable[index].shortName;
    else
        return "internal error";
}

char *
get_interpolation_method_intlname (int index)
{
    if (index >= 0 && index < sizeof(intMethodTable)/sizeof(intMethodTable[0])) {
        if (intMethodTable[index].intlName == NULL)
            intMethodTable[index].intlName = _(intMethodTable[index].baseName);
	return intMethodTable[index].intlName;
    }
    else
        return "internal error";
}

int
find_interpolation_method (char *shortName)
{
    int i;

    for (i = 0; i < sizeof(intMethodTable)/sizeof(intMethodTable[0]); i++)
        if (strcmp (intMethodTable[i].shortName, shortName) == 0)
	    return i;
    return -1;
}

gpointer
get_interpolation_method_handle (int index)
{
    if (index >= 0 && index < sizeof(intMethodTable)/sizeof(intMethodTable[0]))
        return (gpointer)&intMethodTable[index];
    else
        return NULL;
}

int
get_interpolation_method_index (gpointer handle)
{
    return handle == NULL ? -1 : (struct intMethodTable_t *)handle - intMethodTable;
}
