/*
 *   Written by Bradley Broom (2002).
 *
 *   Copyright (c) 2002 Bradley Broom
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdlib.h>
#include <stdio.h>

#include "MRW_Private.h"

char *progname;

void
Usage ()
{
	fprintf (stderr, "Usage: %s < mrwfile > jpgfile\n", progname);
	exit (1);
}

/* Copies the embedded JPEG thumbnail from a Minolta Raw file to stdout.
 */

int
main (int argc, char *argv[])
{
	mrw_header	hdr;
	MinoltaJPG	jpg;
	char		*errmsg;

	progname = argv[0];
	if (LoadMRW (&hdr, stdin, &errmsg)) {
	    int		tmbOffset, tmbLength;
	    tmbOffset = IFD_GetUndefined (hdr.manu_ifd, MANUTAG_THUMBNAIL);
	    tmbLength = IFD_GetUndefinedLength (hdr.manu_ifd, MANUTAG_THUMBNAIL);
	    fprintf (stderr, "Thumbnail Offset: %d\n", tmbOffset);
	    fprintf (stderr, "Thumbnail Length: %d\n", tmbLength);
	    hdr.ttw.data[tmbOffset] = 0xFF;
	    write (1, hdr.ttw.data + tmbOffset, tmbLength);
	}
	else if (fseek (stdin, 0L, SEEK_SET), LoadMinoltaJPG (stdin, &jpg)) {
	    fprintf (stderr, "First byte is 0x%02x\n", jpg.thumbnail[0]);
	    jpg.thumbnail[0] = 0xFF;
	    write (1, jpg.thumbnail, jpg.thumbnail_length);
	}
	else {
	    fprintf (stderr, "%s: Unable to read MRW header:\n", progname);
	    fprintf (stderr, "    %s\n", errmsg);
	    Usage();
	}
	exit (0);
}
