using System;
using System.IO;

namespace Muine.Audioscrobbler
{
  public class Global 
  {
    public static StreamWriter LogStream = null;
    public static int DebugLevel = Int32.MaxValue;

    public enum DEBUG_LEVEL { VERBOSE = 0, INFO = 1, WARNING = 2 };

    public static void Log (int level, string location, string message)
    {
      if (LogStream != null && level > 0) {
        LogStream.WriteLine("{0} {1} {2}", DateTime.Now.ToString(), location, message);
        LogStream.Flush();
      }
      if (level >= DebugLevel) {
        switch (level) {
        case 0:
        case 1:
          Console.WriteLine("SCROB " + DateTime.Now.ToShortTimeString() + " " + location + ": " + message);
          break;
        case 2:
          Console.WriteLine("!! SCROB " + DateTime.Now.ToShortTimeString() + " " + location + ": " + message);
          break;
        }
      }
    }    
  }
}
