#ifndef GUI_H
#define GUI_H
#include <glib.h>
#include <gtk/gtk.h>
#include <multisync.h>
#include "evolution_sync.h"

typedef struct {
  char *name;
  char *path;
} evo_sync_file;

GtkWidget* open_option_window(sync_pair *pair, connection_type type);
void evo_window_closed(void);
void evo_window_ok(void);
void evo_window_cancel(void);
GList* read_filelist(GList *list, char *dirname, char *textname, 
		     char *filename, int depth);
void free_filelist(GList *list);
void calendar_selected(GtkMenuItem *menuitem, gpointer user_data);
void todo_selected(GtkMenuItem *menuitem, gpointer user_data);
void addressbook_selected(GtkMenuItem *menuitem, gpointer user_data);
void evo_display_error(char *msg);
gboolean evo_do_display_error(gpointer msg);
void evo_async_display_error(char *msg);

#endif
