
#include <stdio.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include "transpose.h"
#include "track.h"
#include "song.h"
#include "event.h"
#include "audio.h"

//---------------------------------------------------------
//   Transpose
//---------------------------------------------------------

Transpose::Transpose(QWidget* parent, const char* name)
   : TransposeDialogBase(parent, name)
      {
      if (song->lpos() != song->rpos()) {
            time_selected->setChecked(true);
            }
      else {
//            time_all->setChecked(true);
            ButtonGroup1->setEnabled(false);
            }
//      parts_all->setSelected(true);
      }

//---------------------------------------------------------
//   accept
//---------------------------------------------------------

void Transpose::accept()
      {
      int left = 0, right = 0;
      int dv = delta->value();

      TrackList *tracks = song->tracks();

      if (time_selected->isChecked()) {
            left  = song->lpos();
            right = song->rpos();
            }
      else {
            left  = 0;
            right = song->len();
            }

      song->startUndo();
      for (iTrack t = tracks->begin(); t != tracks->end(); ++t) {
//         if (((*t)->type() == Track::MIDI || (*t)->type() == Track::DRUM)
            if (((*t)->type() != Track::MIDI)
               || !(parts_all->isChecked() || (*t)->selected()))
                  continue;

            PartList *pl = (*t)->parts();
            for (iPart p = pl->begin(); p != pl->end(); ++p) {
                  MidiPart *mp = (MidiPart *) p->second;
                  EventList* el = mp->events();
                  for (iEvent i = el->begin(); i != el->end(); ++i) {
                        Event oe = i->second;
                        int tick = oe.tick();
                        if (tick > right)
                              break;
                        if (tick < left)
                              continue;
                        Event ne = oe.clone();
                        ne.setA(oe.dataA() + dv );
                        audio->msgChangeEvent(oe, ne, mp, false);
                        }
                  }
            }
      song->endUndo(SC_EVENT_MODIFIED);
      close(true);
      }

