/*
 * Header of the launcher-style button.
 *
 * Music Applet
 * Copyright (C) 2006 Paul Kuliniewicz <paul.kuliniewicz@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02111-1301, USA.
 *
 */

#ifndef MA_LAUNCHER_BUTTON_H
#define MA_LAUNCHER_BUTTON_H

#include <gtk/gtkbutton.h>
#include <panel-applet.h>


#define MA_TYPE_LAUNCHER_BUTTON			(ma_launcher_button_get_type ())
#define MA_LAUNCHER_BUTTON(o) 			(G_TYPE_CHECK_INSTANCE_CAST ((o), MA_TYPE_LAUNCHER_BUTTON, MaLauncherButton))
#define MA_LAUNCHER_BUTTON_CLASS(k) 		(G_TYPE_CHECK_CLASS_CAST ((k), MA_TYPE_LAUNCHER_BUTTON, MaLauncherButtonClass))
#define MA_IS_LAUNCHER_BUTTON(o) 		(G_TYPE_CHECK_INSTANCE_TYPE ((o), MA_TYPE_LAUNCHER_BUTTON))
#define MA_IS_LAUNCHER_BUTTON_CLASS(k) 		(G_TYPE_CHECK_CLASS_TYPE ((k), MA_TYPE_LAUNCHER_BUTTON))
#define MA_LAUNCHER_BUTTON_GET_CLASS(o) 	(G_TYPE_INSTANCE_GET_CLASS ((o), MA_TYPE_LAUNCHER_BUTTON, MaLauncherButtonClass))

typedef struct _MaLauncherButton	MaLauncherButton;
typedef struct _MaLauncherButtonClass	MaLauncherButtonClass;

struct _MaLauncherButton
{
	GtkButton parent;
};

struct _MaLauncherButtonClass
{
	GtkButtonClass parent_class;
};


GType ma_launcher_button_get_type (void);

GtkWidget *ma_launcher_button_new_from_stock (const gchar *stock_id);
GtkWidget *ma_launcher_button_new_from_icon (const gchar *icon_name);

const gchar *ma_launcher_button_get_stock_id (MaLauncherButton *lb);
void ma_launcher_button_set_stock_id (MaLauncherButton *lb, const gchar *stock_id);

const gchar *ma_launcher_button_get_icon_name (MaLauncherButton *lb);
void ma_launcher_button_set_icon_name (MaLauncherButton *lb, const gchar *icon_name);

PanelAppletOrient ma_launcher_button_get_orientation (MaLauncherButton *lb);
void ma_launcher_button_set_orientation (MaLauncherButton *lb, PanelAppletOrient orient);


#endif /* MA_LAUNCHER_BUTTON_H */
