/*
 * Header of the proxy around Muine's D-Bus interface.
 *
 * Music Applet
 * Copyright (C) 2006 Paul Kuliniewicz <paul.kuliniewicz@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02111-1301, USA.
 *
 */

#ifndef MA_MUINE_PROXY_H
#define MA_MUINE_PROXY_H

#include "ma-dbus-proxy.h"

#define MA_TYPE_MUINE_PROXY		(ma_muine_proxy_get_type ())
#define MA_MUINE_PROXY(o) 		(G_TYPE_CHECK_INSTANCE_CAST ((o), MA_TYPE_MUINE_PROXY, MaMuineProxy))
#define MA_MUINE_PROXY_CLASS(k) 	(G_TYPE_CHECK_CLASS_CAST ((k), MA_TYPE_MUINE_PROXY, MaMuineProxyClass))
#define MA_IS_MUINE_PROXY(o) 		(G_TYPE_CHECK_INSTANCE_TYPE ((o), MA_TYPE_MUINE_PROXY))
#define MA_IS_MUINE_PROXY_CLASS(k) 	(G_TYPE_CHECK_CLASS_TYPE ((k), MA_TYPE_MUINE_PROXY))
#define MA_MUINE_PROXY_GET_CLASS(o) 	(G_TYPE_INSTANCE_GET_CLASS ((o), MA_TYPE_MUINE_PROXY, MaMuineProxyClass))

typedef struct _MaMuineProxy		MaMuineProxy;
typedef struct _MaMuineProxyClass	MaMuineProxyClass;

struct _MaMuineProxy
{
	MaDBusProxy parent;
};

struct _MaMuineProxyClass
{
	MaDBusProxyClass parent_class;
};

GType		ma_muine_proxy_get_type (void);

MaProxy *	ma_muine_proxy_new (MaConf *conf);

#endif /* MA_MUINE_PROXY_H */

