/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 asyncsocket.h  -  Core asynchronous socket wrapper

    begin                : Sun May 27 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/
 
#ifndef __MASYCNSOCKET_H_INCLUDED__
#define __MASYCNSOCKET_H_INCLUDED__

typedef int             SOCKET;
typedef sockaddr        SOCKADDR;
typedef sockaddr_in     SOCKADDR_IN;
typedef hostent         HOSTENT;
typedef hostent*        LPHOSTENT;
typedef in_addr*        LPIN_ADDR;

#define FD_READ_BIT      0
#define FD_READ          (1 << FD_READ_BIT)

#define FD_WRITE_BIT     1
#define FD_WRITE         (1 << FD_WRITE_BIT)

#define FD_OOB_BIT       2
#define FD_OOB           (1 << FD_OOB_BIT)

#define FD_ACCEPT_BIT    3
#define FD_ACCEPT        (1 << FD_ACCEPT_BIT)

#define FD_CONNECT_BIT   4
#define FD_CONNECT       (1 << FD_CONNECT_BIT)

#define FD_CLOSE_BIT     5
#define FD_CLOSE         (1 << FD_CLOSE_BIT)

// Level number for (get/set)sockopt() to apply to socket itself.
//#define SOL_SOCKET      0xffff          // options for socket level
// Types
//#define SOCK_STREAM     1               // stream socket
//#define SOCK_DGRAM      2               // datagram socket
//#define SOCK_RAW        3               // raw-protocol interface
//#define SOCK_RDM        4               // reliably-delivered message
//#define SOCK_SEQPACKET  5               // sequenced packet stream

// TODO: correct value
#define INVALID_SOCKET  (SOCKET)(~0)
#define SOCKET_ERROR            (-1)

#ifndef INADDR_NONE
#define INADDR_NONE -1
#endif

/////////////////////////////////////////////////////////////////////////////
// MAsyncSocket

class MAsyncSocket
{
	friend class MAsyncConnectByName;
private:
	MAsyncSocket(const MAsyncSocket& rSrc);    // no implementation
	void operator=(const MAsyncSocket& rSrc);  // no implementation

// Construction
public:
	MAsyncSocket();
	BOOL Create(UINT nSocketPort = 0, int nSocketType=SOCK_STREAM,
		long lEvent = FD_READ | FD_WRITE | FD_OOB | FD_ACCEPT | FD_CONNECT | FD_CLOSE,
		LPCTSTR lpszSocketAddress = NULL);

// Attributes
public:
	SOCKET m_hSocket;
	bool m_bConnecting;
	bool m_bListening;
	bool m_bNewSocket;
protected:
	long m_nAsyncDnsReqID;

public:

	operator SOCKET() const {return m_hSocket;}
	BOOL Attach(SOCKET hSocket, long lEvent =
		FD_READ | FD_WRITE | FD_OOB | FD_ACCEPT | FD_CONNECT | FD_CLOSE);
	SOCKET Detach();

	BOOL GetPeerName(CString& rPeerAddress, UINT& rPeerPort);
	BOOL GetPeerName(SOCKADDR* lpSockAddr, socklen_t* lpSockAddrLen);

	BOOL GetSockName(CString& rSocketAddress, UINT& rSocketPort);
	BOOL GetSockName(SOCKADDR* lpSockAddr, socklen_t* lpSockAddrLen);

	//BOOL SetSockOpt(int nOptionName, const void* lpOptionValue,
	//	int nOptionLen, int nLevel = SOL_SOCKET);
	//BOOL GetSockOpt(int nOptionName, void* lpOptionValue,
	//	int* lpOptionLen, int nLevel = SOL_SOCKET);

    static MAsyncSocket* FromHandle(SOCKET hSocket);
    int GetLastError();
    void SetLastError(int nError);

// Operations
public:

	virtual BOOL Accept(MAsyncSocket& rConnectedSocket,
		SOCKADDR* lpSockAddr = NULL, socklen_t* lpSockAddrLen = NULL);

	BOOL Bind(UINT nSocketPort, LPCTSTR lpszSocketAddress = NULL);
	BOOL Bind (const SOCKADDR* lpSockAddr, socklen_t nSockAddrLen);

	virtual void Close();


	BOOL Connect(LPCTSTR lpszHostAddress, UINT nHostPort);
	BOOL Connect(const SOCKADDR* lpSockAddr, socklen_t nSockAddrLen);

	//BOOL IOCtl(long lCommand, DWORD* lpArgument);

	BOOL Listen(int nConnectionBacklog=5);

	virtual int Receive(void* lpBuf, int nBufLen, int nFlags = 0);

	//int ReceiveFrom(void* lpBuf, int nBufLen,
	//	CString& rSocketAddress, UINT& rSocketPort, int nFlags = 0);
	//int ReceiveFrom(void* lpBuf, int nBufLen,
	//	SOCKADDR* lpSockAddr, int* lpSockAddrLen, int nFlags = 0);

	enum { receives = 0, sends = 1, both = 2 };
	BOOL ShutDown(int nHow = sends);

	virtual int Send(const void* lpBuf, int nBufLen, int nFlags = 0);

	//int SendTo(const void* lpBuf, int nBufLen,
	//	UINT nHostPort, LPCTSTR lpszHostAddress = NULL, int nFlags = 0);
	//int SendTo(const void* lpBuf, int nBufLen,
	//	const SOCKADDR* lpSockAddr, int nSockAddrLen, int nFlags = 0);

	BOOL AsyncSelect(long lEvent =
		FD_READ | FD_WRITE | FD_OOB | FD_ACCEPT | FD_CONNECT | FD_CLOSE);
	BOOL ModifySelectFlags(long lEventAdd, long lEventRemove);
//private:
	long m_nSelectFlags;
	bool m_bSelectActive;
	int m_nLastError;
	unsigned long m_dwActivity;
// Overridable callbacks
protected:
	virtual void OnReceive(int nErrorCode);
	virtual void OnSend(int nErrorCode);
	virtual void OnOutOfBandData(int nErrorCode);
	virtual void OnAccept(int nErrorCode);
	virtual void OnConnect(int nErrorCode);
	virtual void OnClose(int nErrorCode);

// Implementation
public:
	virtual ~MAsyncSocket();

	static MAsyncSocket* LookupHandle(SOCKET hSocket);
	static void AttachHandle(SOCKET hSocket, MAsyncSocket* pSocket);
	static void DetachHandle(SOCKET hSocket);
	static void KillSocket(SOCKET hSocket, MAsyncSocket* pSocket);
	//static void DoCallBack(WPARAM wParam, LPARAM lParam);
	static void Heartbeat(int nSleep);
	//static bool AsyncSelect(SOCKET hSocket, long lEvent);
	static void SetDirty(); // sets the dirty flag that is socket list or
							// select flags have been updated

	BOOL Socket(int nSocketType=SOCK_STREAM, long lEvent =
		FD_READ | FD_WRITE | FD_OOB | FD_ACCEPT | FD_CONNECT | FD_CLOSE,
		int nProtocolType = 0, int nAddressFormat = PF_INET);

};


#endif //__MASYCNSOCKET_H_INCLUDED__
