<?
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
include("../inc/inc.Settings.php");
include("../inc/inc.AccessUtils.php");
include("../inc/inc.ClassAccess.php");
include("../inc/inc.ClassDocument.php");
include("../inc/inc.ClassFolder.php");
include("../inc/inc.ClassGroup.php");
include("../inc/inc.ClassUser.php");
include("../inc/inc.DBAccess.php");
include("../inc/inc.FileUtils.php");
include("../inc/inc.Language.php");
include("../inc/inc.OutUtils.php");
include("../inc/inc.Authentication.php");

$folder = getFolder($folderid);




printHTMLHead( getMLText("folder_title", array("foldername" => $folder->getName()) ) );
printTitleBar($folder);
printCenterStart();

printStartBox(getMLText("edit_folder_notify"));

print "<div class=\"standardText\">";


if ($folder->getAccessMode($user) < M_READWRITE)
{
	printMLText("operation_not_allowed");
	printGoBack();
}
else
{
	//Benachrichtigung lschen ------------------------------------------------------------------------
	if ($action == "delnotify")
	{
		printMLText("deleting_folder_notify");
		if (isset($userid)) {
			if (!is_numeric($userid))
				die ("invalid user id");
			$folder->removeNotify($userid, true);
		}
		else if (isset($groupid)) {
			if (!is_numeric($groupid))
				die ("invalid group id");
			$folder->removeNotify($groupid, false);
		}
	}

	//Benachrichtigung hinzufgen ---------------------------------------------------------------------
	else if ($action == "addnotify")
	{
		printMLText("adding_folder_notify");
		if ($userid != -1) {
			if (!is_numeric($userid))
				die ("invalid user id");
			$folder->addNotify($userid, true);
		}
		if ($groupid != -1) {
			if (!is_numeric($groupid))
				die ("invalid group id");
			$folder->addNotify($groupid, false);
		}
	}
	
	printMLText("op_finished");
	printGoto(array(array($folder->getName(), "../out/out.ViewFolder.php?folderid=".$folder->getID()), 
				array(getMLText("folder_notify_again"), "../out/out.FolderNotify.php?folderid=".$folder->getID())));
}



print "</div>";
printEndBox();
printCenterEnd();
printHTMLFoot();
?>
