dnl ---------------------------------------------------------
dnl
dnl Macro: 
dnl     AC_FIND_FILE
dnl 
dnl Arguments:
dnl
dnl Description:
dnl     Find file(s) in given directories.
dnl
dnl ---------------------------------------------------------

AC_DEFUN(AC_FIND_FILE,
[
$3=NO
for i in $2;
do
  for j in $1;
  do
    if test -r "$i/$j"; then
      $3=$i
      break 2
    fi
  done
done
])

dnl ---------------------------------------------------------
dnl
dnl Macro: 
dnl     AC_CHECK_ODBC_TYPE
dnl
dnl Arguments:
dnl
dnl Description:
dnl     Checks if $1 is a valid type in the ODBC environment,
dnl     and #defines it to $2 if not
dnl
dnl ---------------------------------------------------------

AC_DEFUN(AC_CHECK_ODBC_TYPE,
[

AC_MSG_CHECKING([for $1])
AC_CACHE_VAL(ac_cv_odbc_$1,
[
echo > conftest.c

for i in $odbc_headers
do
	echo "#include <$i>" >> conftest.c
done

echo "int main(void) { $1 x; return 0; }" >> conftest.c

if $CC -c $CFLAGS $CPPFLAGS conftest.c > /dev/null 2> /dev/null
then
	eval ac_cv_odbc_$1=yes
else
	eval ac_cv_odbc_$2=no
fi
rm -f conftest*
])

eval ac_odbc_check_res=$ac_cv_odbc_$1
if test "x$ac_odbc_check_res" = "xyes"
then
	AC_MSG_RESULT(yes)
else
	AC_MSG_RESULT([no ($2)])
	AC_DEFINE($1,$2,[Define if $1 is undefined])
fi
])


dnl ---------------------------------------------------------
dnl
dnl Macro: 
dnl     AC_CHECK_IODBC
dnl
dnl Arguments: 
dnl     $1=includedir
dnl     $2=libdir
dnl
dnl Description:
dnl     Checks for iODBC. If found configure for it.
dnl
dnl ---------------------------------------------------------

AC_DEFUN(AC_CHECK_IODBC,
[
CPPFLAGS="$CPPFLAGS $ODBC_FLAGS -I$1"
AC_CHECK_HEADERS([isql.h isqlext.h isqltypes.h],
[iodbc_ok=yes;odbc_headers="$odbc_headers $ac_hdr"],[iodbc_ok=no; break])

if test "x$iodbc_ok" != "xyes"
then
	AC_MSG_ERROR([Unable to find the iodbc headers in '$1'])
fi


# new autoconf tools doesn't detect through ac_hdr, so define
# odbc_headers manually to make AC_CHECK_ODBC_TYPE to work
if test "x$odbc_headers" = "x"
then
  odbc_headers="isql.h isqlext.h isqltypes.h"
fi

AC_CHECK_HEADERS(iodbcinst.h)

if test "x$ac_cv_header_iodbcinst_h" = "xyes"
then

  odbc_headers="$odbc_headers iodbcinst.h"
	save_LIBS="$LIBS"
	LIBS="-L$2 $LIBS"

	AC_CHECK_LIB(iodbcadm,_iodbcdm_admin_dialbox,
	[LIBS="$LIBS -liodbcadm"
	have_iodbcadm=yes],
	[LIBS="$save_LIBS"])

	AC_CHECK_LIB(iodbcinst,SQLGetPrivateProfileString,
	[AC_DEFINE(HAVE_SQLGETPRIVATEPROFILESTRING,1,[Define if SQLGetPrivateProfileString is defined])
	LIBS="$LIBS -liodbcinst"
	have_iodbcinst=yes],
	[LIBS="$save_LIBS"])
fi
])


dnl ---------------------------------------------------------
dnl
dnl Macro: 
dnl     AC_CHECK_UNIXODBC
dnl
dnl Arguments:
dnl	$1=includedir
dnl	$2=libdir
dnl
dnl Description:
dnl     Check for unixODBC. If found configure for it.
dnl
dnl ---------------------------------------------------------

AC_DEFUN(AC_CHECK_UNIXODBC,
[
CPPFLAGS="$CPPFLAGS $ODBC_FLAGS -I$1"
AC_CHECK_HEADERS([sql.h sqlext.h sqltypes.h],
[unixODBC_ok=yes;odbc_headers="$odbc_headers $ac_hdr"],[unixODBC_ok=no; break])

if test "x$unixODBC_ok" != "xyes"
then
	AC_MSG_ERROR([Unable to find the unixODBC headers in '$1'])
fi

# new autoconf tools doesn't detect through ac_hdr, so define
# odbc_headers manually to make AC_CHECK_ODBC_TYPE to work
if test "x$odbc_headers" = "x   "
then
  odbc_headers="sql.h sqlext.h sqltypes.h"
fi

AC_CHECK_HEADERS(odbcinst.h)

if test "x$ac_cv_header_odbcinst_h" = "xyes"
then

  odbc_headers="$odbc_headers odbcinst.h"
	save_LIBS="$LIBS"
	LIBS="-L$2 $LIBS"

  AC_CHECK_LIB(odbcinst,SQLGetPrivateProfileString,
  [AC_DEFINE(HAVE_SQLGETPRIVATEPROFILESTRING,1,[Define if SQLGetPrivateProfileString is defined])
  LIBS="$LIBS -lodbcinst"
  have_odbcinst=yes],
  [LIBS="$save_LIBS"])
fi   
])

dnl ---------------------------------------------------------
dnl
dnl Macro: 
dnl     AC_QT_TEXT
dnl
dnl Arguments:
dnl     none
dnl
dnl Description:
dnl     Allows user to tell us where qt is by providing
dnl     configure options.
dnl
dnl ---------------------------------------------------------

AC_DEFUN(AC_QT_TEXT,
[
ac_qt_includes=NO ac_qt_libraries=NO ac_qt_bindir=NO
qt_libraries=""
qt_includes=""
AC_ARG_WITH(qt-dir,
    [  --with-qt-dir=DIR       where the root of Qt is installed ],
    [  ac_qt_includes="$withval"/include
       ac_qt_libraries="$withval"/lib
       ac_qt_bindir="$withval"/bin
    ])

AC_ARG_WITH(qt-includes,
    [  --with-qt-includes=DIR  where the Qt includes are. ],
    [  ac_qt_includes="$withval" ]
    )

AC_ARG_WITH(qt-libraries,
    [  --with-qt-libraries=DIR where the Qt library is installed.],
    [  ac_qt_libraries="$withval"]
    )

AC_ARG_WITH(qt-bin,
    [  --with-qt-bin=DIR       where the Qt binaries are installed.],
    [  ac_qt_bindir="$withval"]
    )
])

dnl ---------------------------------------------------------
dnl
dnl Macro: 
dnl     QT_PROGRAM
dnl
dnl Arguments:
dnl     none
dnl
dnl Description:
dnl     Provides a small program to test qt config options.
dnl
dnl ---------------------------------------------------------

AC_DEFUN(QT_PROGRAM,
[
cat > conftest.$ac_ext <<EOF
#include <qapplication.h>
#include <qstringlist.h>

int main() 
{
    QStringList *t = new QStringList();
    return 0;
}
EOF
])

dnl ---------------------------------------------------------
dnl 
dnl Macro: 
dnl     AC_PATH_QT_WITHOUT_X
dnl
dnl Arguments:
dnl     none
dnl
dnl Description:
dnl     Check for qt. If found configure for it.
dnl
dnl ---------------------------------------------------------

AC_DEFUN(AC_PATH_QT_WITHOUT_X,
[
AC_REQUIRE([AC_QT_TEXT])
LIBQT=""
LIBQTEXACT="-lqt"
AC_MSG_CHECKING([for Qt])

AC_CACHE_VAL(ac_cv_have_qt, 
[#try to guess Qt locations

qt_incdirs="$QTINC /usr/lib/qt/include /usr/local/qt/include /usr/include/qt /usr/include $x_includes /usr/include/qt3"
test -n "$QTDIR" && qt_incdirs="$QTDIR/include $QTDIR $qt_incdirs"
qt_incdirs="$ac_qt_includes $qt_incdirs"
AC_FIND_FILE(qmovie.h, $qt_incdirs, qt_incdir)
ac_qt_includes="$qt_incdir"

qt_libdirs="$QTLIB /usr/lib/qt/lib /usr/lib /usr/local/qt/lib /usr/lib/qt $x_libraries"
test -n "$QTDIR" && qt_libdirs="$QTDIR/lib $QTDIR $qt_libdirs"
if test ! "$ac_qt_libraries" = "NO"; then
  qt_libdirs="$ac_qt_libraries $qt_libdirs"
fi

test=NONE
qt_libdir=NONE

dnl
dnl The static lib names are hard-coded because the "eval ls" thing
dnl was not working properly on OSX. Subsequently; qt built as shared
dnl will not work unless this is modified.
dnl
for dir in $qt_libdirs; do
  if [[ -e $dir/libqt-mt.a ]]; then
    qt_libdir=$dir;
    LIBQTEXACT="-lqt-mt"
    break;
  else
    if [[ -e $dir/libqt.a ]]; then
      qt_libdir=$dir;
      LIBQTEXACT="-lqt"
      break;
    else
      echo "tried $dir" ;
    fi
    echo "tried $dir" ;
  fi
done

dnl
dnl We toss in our alternative link dependencies assuming we are dealing with
dnl OSX and no X.
dnl
LIBQT="$LIBQTEXACT -framework Carbon -framework QuickTime -framework OpenGL -framework AGL"

ac_qt_libraries="$qt_libdir"

AC_LANG_SAVE
AC_LANG_CPLUSPLUS

ac_cxxflags_safe="$CXXFLAGS"
ac_ldflags_safe="$LDFLAGS"
ac_libs_safe="$LIBS"

CXXFLAGS="$CXXFLAGS -I$qt_incdir $all_includes"
dnl LDFLAGS="-L$qt_libdir $all_libraries"
LDFLAGS="-L$qt_libdir"
LIBS="$LIBS $LIBQT"

QT_PROGRAM

if AC_TRY_EVAL(ac_link) && test -s conftest; then
  rm -f conftest*
else
  echo "configure: failed program was:" >&AC_FD_CC
  cat conftest.$ac_ext >&AC_FD_CC
  ac_qt_libraries="NO"
fi
rm -f conftest*
CXXFLAGS="$ac_cxxflags_safe"
LDFLAGS="$ac_ldflags_safe"
LIBS="$ac_libs_safe"

AC_LANG_RESTORE
if test "$ac_qt_includes" = NO || test "$ac_qt_libraries" = NO; then
  ac_cv_have_qt="have_qt=no"
  ac_qt_notfound=""
  if test "$ac_qt_includes" = NO; then
    if test "$ac_qt_libraries" = NO; then
      ac_qt_notfound="(headers and libraries)";
    else
      ac_qt_notfound="(headers)";
    fi
  else
    ac_qt_notfound="(libraries)";
  fi
  have_qt="no"
else
  have_qt="yes"
fi
])

eval "$ac_cv_have_qt"

if test "$have_qt" != yes; then
  AC_MSG_RESULT([$have_qt]);
else
  ac_cv_have_qt="have_qt=yes \
    ac_qt_includes=$ac_qt_includes ac_qt_libraries=$ac_qt_libraries"
  AC_MSG_RESULT([libraries $ac_qt_libraries, headers $ac_qt_includes])

  qt_libraries="$ac_qt_libraries"
  qt_includes="$ac_qt_includes"
fi

AC_SUBST(qt_libraries)
AC_SUBST(qt_includes)

if test "$qt_includes" = "$x_includes" || test -z "$qt_includes"; then
 QT_INCLUDES="";
else
 QT_INCLUDES="-I$qt_includes"
 all_includes="$QT_INCLUDES $all_includes"
fi

if test "$qt_libraries" = "$x_libraries" || test -z "$qt_libraries"; then
 QT_LDFLAGS=""
else
 QT_LDFLAGS="-L$qt_libraries -framework Carbon -framework QuickTime -framework OpenGL -framework AGL"
 all_libraries="$QT_LDFLAGS $all_libraries"
fi

AC_SUBST(QT_INCLUDES)
AC_SUBST(QT_LDFLAGS)
AC_PATH_QT_MOC

LIB_QT='$(LIBPNG)'
LIB_QT="$LIBQTEXACT $LIB_QT"
AC_SUBST(LIB_QT)

])

dnl ---------------------------------------------------------
dnl
dnl Macro: 
dnl     AC_PATH_QT_WITH_X
dnl
dnl Arguments:
dnl     none
dnl
dnl Description:
dnl     Check for qt. If found configure for it.
dnl
dnl ---------------------------------------------------------

AC_DEFUN(AC_PATH_QT_WITH_X,
[
AC_REQUIRE([AC_QT_TEXT])
LIBQT=""
LIBQTEXACT="-lqt"
AC_MSG_CHECKING([for Qt])

LIBQT="$LIBQT $EXTRA_XLIBS -lXext -lX11 $LIBSOCKET"

AC_CACHE_VAL(ac_cv_have_qt,
[#try to guess Qt locations

qt_incdirs="$QTINC /usr/lib/qt/include /usr/local/qt/include /usr/include/qt /usr/include /usr/X11R6/include/X11/qt $x_includes /usr/include/qt3"
test -n "$QTDIR" && qt_incdirs="$QTDIR/include $QTDIR $qt_incdirs"
qt_incdirs="$ac_qt_includes $qt_incdirs"
AC_FIND_FILE(qmovie.h, $qt_incdirs, qt_incdir)
ac_qt_includes="$qt_incdir"

qt_libdirs="$QTLIB /usr/lib/qt/lib /usr/X11R6/lib /usr/lib /usr/local/qt/lib /usr/lib/qt $x_libraries"
test -n "$QTDIR" && qt_libdirs="$QTDIR/lib $QTDIR $qt_libdirs"
if test ! "$ac_qt_libraries" = "NO"; then
  qt_libdirs="$ac_qt_libraries $qt_libdirs"
fi

test=NONE
qt_libdir=NONE
for dir in $qt_libdirs; do
  try="ls -1 $dir/libqt-mt*"
  if test=`eval $try 2> /dev/null`; then
    qt_libdir=$dir;
    LIBQTEXACT="-lqt-mt"
    break;
  else
    try="ls -1 $dir/libqt*"
    if test=`eval $try 2> /dev/null`; then
      qt_libdir=$dir;
      break;
    else
      echo "tried $dir" >&AC_FD_CC ; fi
    echo "tried $dir" >&AC_FD_CC ; fi
done

LIBQT="$LIBQTEXACT $EXTRA_XLIBS -lXext -lX11 $LIBSOCKET"

ac_qt_libraries="$qt_libdir"

AC_LANG_SAVE
AC_LANG_CPLUSPLUS

ac_cxxflags_safe="$CXXFLAGS"
ac_ldflags_safe="$LDFLAGS"
ac_libs_safe="$LIBS"

CXXFLAGS="$CXXFLAGS -I$qt_incdir $all_includes"
LDFLAGS="-L$qt_libdir $all_libraries"
LIBS="$LIBS $LIBQT"

QT_PROGRAM

if AC_TRY_EVAL(ac_link) && test -s conftest; then
  rm -f conftest*
else
  echo "configure: failed program was:" >&AC_FD_CC
  cat conftest.$ac_ext >&AC_FD_CC
  ac_qt_libraries="NO"
fi
rm -f conftest*
CXXFLAGS="$ac_cxxflags_safe"
LDFLAGS="$ac_ldflags_safe"
LIBS="$ac_libs_safe"

AC_LANG_RESTORE
if test "$ac_qt_includes" = NO || test "$ac_qt_libraries" = NO; then
  ac_cv_have_qt="have_qt=no"
  ac_qt_notfound=""
  if test "$ac_qt_includes" = NO; then
    if test "$ac_qt_libraries" = NO; then
      ac_qt_notfound="(headers and libraries)";
    else
      ac_qt_notfound="(headers)";
    fi
  else
    ac_qt_notfound="(libraries)";
  fi
  have_qt="no"
else
  have_qt="yes"
fi
])

eval "$ac_cv_have_qt"

if test "$have_qt" != yes; then
  AC_MSG_RESULT([$have_qt]);
else
  ac_cv_have_qt="have_qt=yes \
    ac_qt_includes=$ac_qt_includes ac_qt_libraries=$ac_qt_libraries"
  AC_MSG_RESULT([libraries $ac_qt_libraries, headers $ac_qt_includes])

  qt_libraries="$ac_qt_libraries"
  qt_includes="$ac_qt_includes"
fi

AC_SUBST(qt_libraries)
AC_SUBST(qt_includes)

if test "$qt_includes" = "$x_includes" || test -z "$qt_includes"; then
 QT_INCLUDES="";
else
 QT_INCLUDES="-I$qt_includes"
 all_includes="$QT_INCLUDES $all_includes"
fi

if test "$qt_libraries" = "$x_libraries" || test -z "$qt_libraries"; then
 QT_LDFLAGS=""
else
 QT_LDFLAGS="-L$qt_libraries"
 all_libraries="$QT_LDFLAGS $all_libraries"
fi

AC_SUBST(QT_INCLUDES)
AC_SUBST(QT_LDFLAGS)
AC_PATH_QT_MOC

LIB_QT='$(LIBPNG) -lXext $(LIB_X11)'
LIB_QT="$LIBQTEXACT $LIB_QT"
AC_SUBST(LIB_QT)

])

dnl ---------------------------------------------------------
dnl
dnl Macro:
dnl     AC_PATH_QT_MOC
dnl
dnl Arguments:
dnl     none
dnl
dnl Description:
dnl     Determine the complete path to the qt moc precompiler.
dnl
dnl ---------------------------------------------------------

AC_DEFUN(AC_PATH_QT_MOC,
[
   AC_FIND_FILE(moc, [$ac_qt_bindir $QTDIR/bin $QTDIR/src/moc /usr/bin /usr/X11R6/bin /usr/lib/qt/bin /usr/local/qt/bin], MOC)

   if test -z "$MOC"; then
      MOC="$MOC/moc"
   else
      MOC="moc"
   fi

   AC_SUBST(MOC)
])

