/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbcext;

import com.sap.dbtech.jdbcext.ConnectionPoolDataSourceSapDB;
import com.sap.dbtech.jdbcext.DataSourceSapDB;
import com.sap.dbtech.jdbcext.XADataSourceSapDB;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;

public class DataSourceSapDBFactory
implements ObjectFactory {
    static HashSet forbiddenproperties = new HashSet();

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) {
        if (object instanceof Reference) {
            Reference reference = (Reference)object;
            if ("com.sap.dbtech.jdbcext.XADataSourceSapDB".equals(reference.getClassName())) {
                Properties properties = this.propertiesFromRef(reference);
                XADataSourceSapDB xADataSourceSapDB = new XADataSourceSapDB();
                xADataSourceSapDB.setProperties(properties);
                return xADataSourceSapDB;
            }
            if ("com.sap.dbtech.jdbcext.ConnectionPoolDataSourceSapDB".equals(reference.getClassName())) {
                Properties properties = this.propertiesFromRef(reference);
                ConnectionPoolDataSourceSapDB connectionPoolDataSourceSapDB = new ConnectionPoolDataSourceSapDB();
                connectionPoolDataSourceSapDB.setProperties(properties);
                return connectionPoolDataSourceSapDB;
            }
            if ("com.sap.dbtech.jdbcext.DataSourceSapDB".equals(reference.getClassName())) {
                Properties properties = this.propertiesFromRef(reference);
                DataSourceSapDB dataSourceSapDB = new DataSourceSapDB();
                dataSourceSapDB.setProperties(properties);
                return dataSourceSapDB;
            }
            return null;
        }
        return null;
    }

    private Properties propertiesFromRef(Reference reference) {
        Enumeration<RefAddr> enumeration = reference.getAll();
        Properties properties = new Properties();
        while (enumeration.hasMoreElements()) {
            RefAddr refAddr = enumeration.nextElement();
            try {
                StringRefAddr stringRefAddr = (StringRefAddr)refAddr;
                if (forbiddenproperties.contains(stringRefAddr.getType())) continue;
                if (!stringRefAddr.getType().equals("isolation")) {
                    properties.setProperty(stringRefAddr.getType(), (String)stringRefAddr.getContent());
                    continue;
                }
                String string = (String)stringRefAddr.getContent();
                if (string.equals("none")) continue;
                if (string.equals("ruc")) {
                    string = "TRANSACTION_READ_UNCOMMITTED";
                } else if (string.equals("rc")) {
                    string = "TRANSACTION_READ_COMMITTED";
                } else if (string.equals("rr")) {
                    string = "TRANSACTION_REPEATABLE_READ";
                } else if (string.equals("s")) {
                    string = "TRANSACTION_SERIALIZABLE";
                }
                properties.setProperty("isolation", string);
            }
            catch (ClassCastException classCastException) {}
        }
        return properties;
    }

    static {
        forbiddenproperties.add("autocommit");
    }
}

