-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.1.11-beta


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema sakila
--

CREATE DATABASE IF NOT EXISTS sakila;
USE sakila;

--
-- Temporary table structure for view `sakila`.`film_list`
--
DROP TABLE IF EXISTS `sakila`.`film_list`;
DROP VIEW IF EXISTS `sakila`.`film_list`;
CREATE TABLE `sakila`.`film_list` (
  `FID` smallint(5) unsigned,
  `title` varchar(255),
  `description` text,
  `category` varchar(25),
  `price` decimal(4,2),
  `length` smallint(5) unsigned,
  `rating` enum('G','PG','PG-13','R','NC-17'),
  `actors` varchar(341)
);

--
-- Temporary table structure for view `sakila`.`actor_info`
--
DROP TABLE IF EXISTS `sakila`.`actor_info`;
DROP VIEW IF EXISTS `sakila`.`actor_info`;
CREATE TABLE `sakila`.`actor_info` (
  `actor_id` smallint(5) unsigned,
  `first_name` varchar(45),
  `last_name` varchar(45),
  `film_info` varchar(341)
);

--
-- Temporary table structure for view `sakila`.`sales_by_store`
--
DROP TABLE IF EXISTS `sakila`.`sales_by_store`;
DROP VIEW IF EXISTS `sakila`.`sales_by_store`;
CREATE TABLE `sakila`.`sales_by_store` (
  `store` varchar(101),
  `manager` varchar(91),
  `total_sales` decimal(27,2)
);

--
-- Definition of table `sakila`.`actor`
--

DROP TABLE IF EXISTS `sakila`.`actor`;
CREATE TABLE  `sakila`.`actor` (
  `actor_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(45) NOT NULL,
  `last_name` varchar(45) NOT NULL,
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`actor_id`),
  KEY `idx_actor_last_name` (`last_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sakila`.`actor`
--

/*!40000 ALTER TABLE `actor` DISABLE KEYS */;
LOCK TABLES `actor` WRITE;
INSERT INTO `sakila`.`actor` VALUES  (1,'PENELOPE','GUINESS','2006-02-15 04:34:33'),
 (2,'NICK','WAHLBERG','2006-02-15 04:34:33'),
 (3,'ED','CHASE','2006-02-15 04:34:33'),
 (4,'JENNIFER','DAVIS','2006-02-15 04:34:33'),
 (5,'JOHNNY','LOLLOBRIGIDA','2006-02-15 04:34:33'),
 (6,'BETTE','NICHOLSON','2006-02-15 04:34:33'),
 (7,'GRACE','MOSTEL','2006-02-15 04:34:33'),
 (8,'MATTHEW','JOHANSSON','2006-02-15 04:34:33'),
 (9,'JOE','SWANK','2006-02-15 04:34:33'),
 (10,'CHRISTIAN','GABLE','2006-02-15 04:34:33'),
 (11,'ZERO','CAGE','2006-02-15 04:34:33'),
 (12,'KARL','BERRY','2006-02-15 04:34:33'),
 (13,'UMA','WOOD','2006-02-15 04:34:33'),
 (14,'VIVIEN','BERGEN','2006-02-15 04:34:33'),
 (15,'CUBA','OLIVIER','2006-02-15 04:34:33'),
 (16,'FRED','COSTNER','2006-02-15 04:34:33'),
 (17,'HELEN','VOIGHT','2006-02-15 04:34:33'),
 (18,'DAN','TORN','2006-02-15 04:34:33'),
 (19,'BOB','FAWCETT','2006-02-15 04:34:33'),
 (20,'LUCILLE','TRACY','2006-02-15 04:34:33'),
 (21,'KIRSTEN','PALTROW','2006-02-15 04:34:33'),
 (22,'ELVIS','MARX','2006-02-15 04:34:33');
INSERT INTO `sakila`.`actor` VALUES  (23,'SANDRA','KILMER','2006-02-15 04:34:33'),
 (24,'CAMERON','STREEP','2006-02-15 04:34:33'),
 (25,'KEVIN','BLOOM','2006-02-15 04:34:33'),
 (26,'RIP','CRAWFORD','2006-02-15 04:34:33'),
 (27,'JULIA','MCQUEEN','2006-02-15 04:34:33'),
 (28,'WOODY','HOFFMAN','2006-02-15 04:34:33'),
 (29,'ALEC','WAYNE','2006-02-15 04:34:33'),
 (30,'SANDRA','PECK','2006-02-15 04:34:33'),
 (31,'SISSY','SOBIESKI','2006-02-15 04:34:33'),
 (32,'TIM','HACKMAN','2006-02-15 04:34:33'),
 (33,'MILLA','PECK','2006-02-15 04:34:33'),
 (34,'AUDREY','OLIVIER','2006-02-15 04:34:33'),
 (35,'JUDY','DEAN','2006-02-15 04:34:33'),
 (36,'BURT','DUKAKIS','2006-02-15 04:34:33'),
 (37,'VAL','BOLGER','2006-02-15 04:34:33'),
 (38,'TOM','MCKELLEN','2006-02-15 04:34:33'),
 (39,'GOLDIE','BRODY','2006-02-15 04:34:33'),
 (40,'JOHNNY','CAGE','2006-02-15 04:34:33'),
 (41,'JODIE','DEGENERES','2006-02-15 04:34:33'),
 (42,'TOM','MIRANDA','2006-02-15 04:34:33'),
 (43,'KIRK','JOVOVICH','2006-02-15 04:34:33'),
 (44,'NICK','STALLONE','2006-02-15 04:34:33');
INSERT INTO `sakila`.`actor` VALUES  (45,'REESE','KILMER','2006-02-15 04:34:33'),
 (46,'PARKER','GOLDBERG','2006-02-15 04:34:33'),
 (47,'JULIA','BARRYMORE','2006-02-15 04:34:33'),
 (48,'FRANCES','DAY-LEWIS','2006-02-15 04:34:33'),
 (49,'ANNE','CRONYN','2006-02-15 04:34:33'),
 (50,'NATALIE','HOPKINS','2006-02-15 04:34:33'),
 (51,'GARY','PHOENIX','2006-02-15 04:34:33'),
 (52,'CARMEN','HUNT','2006-02-15 04:34:33'),
 (53,'MENA','TEMPLE','2006-02-15 04:34:33'),
 (54,'PENELOPE','PINKETT','2006-02-15 04:34:33'),
 (55,'FAY','KILMER','2006-02-15 04:34:33'),
 (56,'DAN','HARRIS','2006-02-15 04:34:33'),
 (57,'JUDE','CRUISE','2006-02-15 04:34:33'),
 (58,'CHRISTIAN','AKROYD','2006-02-15 04:34:33'),
 (59,'DUSTIN','TAUTOU','2006-02-15 04:34:33'),
 (60,'HENRY','BERRY','2006-02-15 04:34:33'),
 (61,'CHRISTIAN','NEESON','2006-02-15 04:34:33'),
 (62,'JAYNE','NEESON','2006-02-15 04:34:33'),
 (63,'CAMERON','WRAY','2006-02-15 04:34:33'),
 (64,'RAY','JOHANSSON','2006-02-15 04:34:33'),
 (65,'ANGELA','HUDSON','2006-02-15 04:34:33'),
 (66,'MARY','TANDY','2006-02-15 04:34:33');
INSERT INTO `sakila`.`actor` VALUES  (67,'JESSICA','BAILEY','2006-02-15 04:34:33'),
 (68,'RIP','WINSLET','2006-02-15 04:34:33'),
 (69,'KENNETH','PALTROW','2006-02-15 04:34:33'),
 (70,'MICHELLE','MCCONAUGHEY','2006-02-15 04:34:33'),
 (71,'ADAM','GRANT','2006-02-15 04:34:33'),
 (72,'SEAN','WILLIAMS','2006-02-15 04:34:33'),
 (73,'GARY','PENN','2006-02-15 04:34:33'),
 (74,'MILLA','KEITEL','2006-02-15 04:34:33'),
 (75,'BURT','POSEY','2006-02-15 04:34:33'),
 (76,'ANGELINA','ASTAIRE','2006-02-15 04:34:33'),
 (77,'CARY','MCCONAUGHEY','2006-02-15 04:34:33'),
 (78,'GROUCHO','SINATRA','2006-02-15 04:34:33'),
 (79,'MAE','HOFFMAN','2006-02-15 04:34:33'),
 (80,'RALPH','CRUZ','2006-02-15 04:34:33'),
 (81,'SCARLETT','DAMON','2006-02-15 04:34:33'),
 (82,'WOODY','JOLIE','2006-02-15 04:34:33'),
 (83,'BEN','WILLIS','2006-02-15 04:34:33'),
 (84,'JAMES','PITT','2006-02-15 04:34:33'),
 (85,'MINNIE','ZELLWEGER','2006-02-15 04:34:33'),
 (86,'GREG','CHAPLIN','2006-02-15 04:34:33'),
 (87,'SPENCER','PECK','2006-02-15 04:34:33'),
 (88,'KENNETH','PESCI','2006-02-15 04:34:33');
INSERT INTO `sakila`.`actor` VALUES  (89,'CHARLIZE','DENCH','2006-02-15 04:34:33'),
 (90,'SEAN','GUINESS','2006-02-15 04:34:33'),
 (91,'CHRISTOPHER','BERRY','2006-02-15 04:34:33'),
 (92,'KIRSTEN','AKROYD','2006-02-15 04:34:33'),
 (93,'ELLEN','PRESLEY','2006-02-15 04:34:33'),
 (94,'KENNETH','TORN','2006-02-15 04:34:33'),
 (95,'DARYL','WAHLBERG','2006-02-15 04:34:33'),
 (96,'GENE','WILLIS','2006-02-15 04:34:33'),
 (97,'MEG','HAWKE','2006-02-15 04:34:33'),
 (98,'CHRIS','BRIDGES','2006-02-15 04:34:33'),
 (99,'JIM','MOSTEL','2006-02-15 04:34:33'),
 (100,'SPENCER','DEPP','2006-02-15 04:34:33'),
 (101,'SUSAN','DAVIS','2006-02-15 04:34:33'),
 (102,'WALTER','TORN','2006-02-15 04:34:33'),
 (103,'MATTHEW','LEIGH','2006-02-15 04:34:33'),
 (104,'PENELOPE','CRONYN','2006-02-15 04:34:33'),
 (105,'SIDNEY','CROWE','2006-02-15 04:34:33'),
 (106,'GROUCHO','DUNST','2006-02-15 04:34:33'),
 (107,'GINA','DEGENERES','2006-02-15 04:34:33'),
 (108,'WARREN','NOLTE','2006-02-15 04:34:33'),
 (109,'SYLVESTER','DERN','2006-02-15 04:34:33'),
 (110,'SUSAN','DAVIS','2006-02-15 04:34:33');
INSERT INTO `sakila`.`actor` VALUES  (111,'CAMERON','ZELLWEGER','2006-02-15 04:34:33'),
 (112,'RUSSELL','BACALL','2006-02-15 04:34:33'),
 (113,'MORGAN','HOPKINS','2006-02-15 04:34:33'),
 (114,'MORGAN','MCDORMAND','2006-02-15 04:34:33'),
 (115,'HARRISON','BALE','2006-02-15 04:34:33'),
 (116,'DAN','STREEP','2006-02-15 04:34:33'),
 (117,'RENEE','TRACY','2006-02-15 04:34:33'),
 (118,'CUBA','ALLEN','2006-02-15 04:34:33'),
 (119,'WARREN','JACKMAN','2006-02-15 04:34:33'),
 (120,'PENELOPE','MONROE','2006-02-15 04:34:33'),
 (121,'LIZA','BERGMAN','2006-02-15 04:34:33'),
 (122,'SALMA','NOLTE','2006-02-15 04:34:33'),
 (123,'JULIANNE','DENCH','2006-02-15 04:34:33'),
 (124,'SCARLETT','BENING','2006-02-15 04:34:33'),
 (125,'ALBERT','NOLTE','2006-02-15 04:34:33'),
 (126,'FRANCES','TOMEI','2006-02-15 04:34:33'),
 (127,'KEVIN','GARLAND','2006-02-15 04:34:33'),
 (128,'CATE','MCQUEEN','2006-02-15 04:34:33'),
 (129,'DARYL','CRAWFORD','2006-02-15 04:34:33'),
 (130,'GRETA','KEITEL','2006-02-15 04:34:33'),
 (131,'JANE','JACKMAN','2006-02-15 04:34:33'),
 (132,'ADAM','HOPPER','2006-02-15 04:34:33');
INSERT INTO `sakila`.`actor` VALUES  (133,'RICHARD','PENN','2006-02-15 04:34:33'),
 (134,'GENE','HOPKINS','2006-02-15 04:34:33'),
 (135,'RITA','REYNOLDS','2006-02-15 04:34:33'),
 (136,'ED','MANSFIELD','2006-02-15 04:34:33'),
 (137,'MORGAN','WILLIAMS','2006-02-15 04:34:33'),
 (138,'LUCILLE','DEE','2006-02-15 04:34:33'),
 (139,'EWAN','GOODING','2006-02-15 04:34:33'),
 (140,'WHOOPI','HURT','2006-02-15 04:34:33'),
 (141,'CATE','HARRIS','2006-02-15 04:34:33'),
 (142,'JADA','RYDER','2006-02-15 04:34:33'),
 (143,'RIVER','DEAN','2006-02-15 04:34:33'),
 (144,'ANGELA','WITHERSPOON','2006-02-15 04:34:33'),
 (145,'KIM','ALLEN','2006-02-15 04:34:33'),
 (146,'ALBERT','JOHANSSON','2006-02-15 04:34:33'),
 (147,'FAY','WINSLET','2006-02-15 04:34:33'),
 (148,'EMILY','DEE','2006-02-15 04:34:33'),
 (149,'RUSSELL','TEMPLE','2006-02-15 04:34:33'),
 (150,'JAYNE','NOLTE','2006-02-15 04:34:33'),
 (151,'GEOFFREY','HESTON','2006-02-15 04:34:33'),
 (152,'BEN','HARRIS','2006-02-15 04:34:33'),
 (153,'MINNIE','KILMER','2006-02-15 04:34:33'),
 (154,'MERYL','GIBSON','2006-02-15 04:34:33');
INSERT INTO `sakila`.`actor` VALUES  (155,'IAN','TANDY','2006-02-15 04:34:33'),
 (156,'FAY','WOOD','2006-02-15 04:34:33'),
 (157,'GRETA','MALDEN','2006-02-15 04:34:33'),
 (158,'VIVIEN','BASINGER','2006-02-15 04:34:33'),
 (159,'LAURA','BRODY','2006-02-15 04:34:33'),
 (160,'CHRIS','DEPP','2006-02-15 04:34:33'),
 (161,'HARVEY','HOPE','2006-02-15 04:34:33'),
 (162,'OPRAH','KILMER','2006-02-15 04:34:33'),
 (163,'CHRISTOPHER','WEST','2006-02-15 04:34:33'),
 (164,'HUMPHREY','WILLIS','2006-02-15 04:34:33'),
 (165,'AL','GARLAND','2006-02-15 04:34:33'),
 (166,'NICK','DEGENERES','2006-02-15 04:34:33'),
 (167,'LAURENCE','BULLOCK','2006-02-15 04:34:33'),
 (168,'WILL','WILSON','2006-02-15 04:34:33'),
 (169,'KENNETH','HOFFMAN','2006-02-15 04:34:33'),
 (170,'MENA','HOPPER','2006-02-15 04:34:33'),
 (171,'OLYMPIA','PFEIFFER','2006-02-15 04:34:33'),
 (172,'GROUCHO','WILLIAMS','2006-02-15 04:34:33'),
 (173,'ALAN','DREYFUSS','2006-02-15 04:34:33'),
 (174,'MICHAEL','BENING','2006-02-15 04:34:33'),
 (175,'WILLIAM','HACKMAN','2006-02-15 04:34:33'),
 (176,'JON','CHASE','2006-02-15 04:34:33');
INSERT INTO `sakila`.`actor` VALUES  (177,'GENE','MCKELLEN','2006-02-15 04:34:33'),
 (178,'LISA','MONROE','2006-02-15 04:34:33'),
 (179,'ED','GUINESS','2006-02-15 04:34:33'),
 (180,'JEFF','SILVERSTONE','2006-02-15 04:34:33'),
 (181,'MATTHEW','CARREY','2006-02-15 04:34:33'),
 (182,'DEBBIE','AKROYD','2006-02-15 04:34:33'),
 (183,'RUSSELL','CLOSE','2006-02-15 04:34:33'),
 (184,'HUMPHREY','GARLAND','2006-02-15 04:34:33'),
 (185,'MICHAEL','BOLGER','2006-02-15 04:34:33'),
 (186,'JULIA','ZELLWEGER','2006-02-15 04:34:33'),
 (187,'RENEE','BALL','2006-02-15 04:34:33'),
 (188,'ROCK','DUKAKIS','2006-02-15 04:34:33'),
 (189,'CUBA','BIRCH','2006-02-15 04:34:33'),
 (190,'AUDREY','BAILEY','2006-02-15 04:34:33'),
 (191,'GREGORY','GOODING','2006-02-15 04:34:33'),
 (192,'JOHN','SUVARI','2006-02-15 04:34:33'),
 (193,'BURT','TEMPLE','2006-02-15 04:34:33'),
 (194,'MERYL','ALLEN','2006-02-15 04:34:33'),
 (195,'JAYNE','SILVERSTONE','2006-02-15 04:34:33'),
 (196,'BELA','WALKEN','2006-02-15 04:34:33'),
 (197,'REESE','WEST','2006-02-15 04:34:33'),
 (198,'MARY','KEITEL','2006-02-15 04:34:33');
INSERT INTO `sakila`.`actor` VALUES  (199,'JULIA','FAWCETT','2006-02-15 04:34:33'),
 (200,'THORA','TEMPLE','2006-02-15 04:34:33');
UNLOCK TABLES;
/*!40000 ALTER TABLE `actor` ENABLE KEYS */;


--
-- Definition of table `sakila`.`film`
--

DROP TABLE IF EXISTS `sakila`.`film`;
CREATE TABLE  `sakila`.`film` (
  `film_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` text,
  `release_year` year(4) DEFAULT NULL,
  `language_id` tinyint(3) unsigned NOT NULL,
  `original_language_id` tinyint(3) unsigned DEFAULT NULL,
  `rental_duration` tinyint(3) unsigned NOT NULL DEFAULT '3',
  `rental_rate` decimal(4,2) NOT NULL DEFAULT '4.99',
  `length` smallint(5) unsigned DEFAULT NULL,
  `replacement_cost` decimal(5,2) NOT NULL DEFAULT '19.99',
  `rating` enum('G','PG','PG-13','R','NC-17') DEFAULT 'G',
  `special_features` set('Trailers','Commentaries','Deleted Scenes','Behind the Scenes') DEFAULT NULL,
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`film_id`),
  KEY `idx_title` (`title`),
  KEY `idx_fk_language_id` (`language_id`),
  KEY `idx_fk_original_language_id` (`original_language_id`),
  CONSTRAINT `fk_film_language` FOREIGN KEY (`language_id`) REFERENCES `language` (`language_id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_film_language_original` FOREIGN KEY (`original_language_id`) REFERENCES `language` (`language_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sakila`.`film`
--

/*!40000 ALTER TABLE `film` DISABLE KEYS */;
LOCK TABLES `film` WRITE;
INSERT INTO `sakila`.`film` VALUES  (1,'ACADEMY DINOSAUR','A Epic Drama of a Feminist And a Mad Scientist who must Battle a Teacher in The Canadian Rockies',2006,1,NULL,6,'0.99',86,'20.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (2,'ACE GOLDFINGER','A Astounding Epistle of a Database Administrator And a Explorer who must Find a Car in Ancient China',2006,1,NULL,3,'4.99',48,'12.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (3,'ADAPTATION HOLES','A Astounding Reflection of a Lumberjack And a Car who must Sink a Lumberjack in A Baloon Factory',2006,1,NULL,7,'2.99',50,'18.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (4,'AFFAIR PREJUDICE','A Fanciful Documentary of a Frisbee And a Lumberjack who must Chase a Monkey in A Shark Tank',2006,1,NULL,5,'2.99',117,'26.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (5,'AFRICAN EGG','A Fast-Paced Documentary of a Pastry Chef And a Dentist who must Pursue a Forensic Psychologist in The Gulf of Mexico',2006,1,NULL,6,'2.99',130,'22.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (6,'AGENT TRUMAN','A Intrepid Panorama of a Robot And a Boy who must Escape a Sumo Wrestler in Ancient China',2006,1,NULL,3,'2.99',169,'17.99','PG','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (7,'AIRPLANE SIERRA','A Touching Saga of a Hunter And a Butler who must Discover a Butler in A Jet Boat',2006,1,NULL,6,'4.99',62,'28.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (8,'AIRPORT POLLOCK','A Epic Tale of a Moose And a Girl who must Confront a Monkey in Ancient India',2006,1,NULL,6,'4.99',54,'15.99','R','Trailers','2006-02-15 05:03:42'),
 (9,'ALABAMA DEVIL','A Thoughtful Panorama of a Database Administrator And a Mad Scientist who must Outgun a Mad Scientist in A Jet Boat',2006,1,NULL,3,'2.99',114,'21.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (10,'ALADDIN CALENDAR','A Action-Packed Tale of a Man And a Lumberjack who must Reach a Feminist in Ancient China',2006,1,NULL,6,'4.99',63,'24.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (11,'ALAMO VIDEOTAPE','A Boring Epistle of a Butler And a Cat who must Fight a Pastry Chef in A MySQL Convention',2006,1,NULL,6,'0.99',126,'16.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (12,'ALASKA PHANTOM','A Fanciful Saga of a Hunter And a Pastry Chef who must Vanquish a Boy in Australia',2006,1,NULL,6,'0.99',136,'22.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (13,'ALI FOREVER','A Action-Packed Drama of a Dentist And a Crocodile who must Battle a Feminist in The Canadian Rockies',2006,1,NULL,4,'4.99',150,'21.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (14,'ALICE FANTASIA','A Emotional Drama of a A Shark And a Database Administrator who must Vanquish a Pioneer in Soviet Georgia',2006,1,NULL,6,'0.99',94,'23.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (15,'ALIEN CENTER','A Brilliant Drama of a Cat And a Mad Scientist who must Battle a Feminist in A MySQL Convention',2006,1,NULL,5,'2.99',46,'10.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (16,'ALLEY EVOLUTION','A Fast-Paced Drama of a Robot And a Composer who must Battle a Astronaut in New Orleans',2006,1,NULL,6,'2.99',180,'23.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42'),
 (17,'ALONE TRIP','A Fast-Paced Character Study of a Composer And a Dog who must Outgun a Boat in An Abandoned Fun House',2006,1,NULL,3,'0.99',82,'14.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (18,'ALTER VICTORY','A Thoughtful Drama of a Composer And a Feminist who must Meet a Secret Agent in The Canadian Rockies',2006,1,NULL,6,'0.99',57,'27.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (19,'AMADEUS HOLY','A Emotional Display of a Pioneer And a Technical Writer who must Battle a Man in A Baloon',2006,1,NULL,6,'0.99',113,'20.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (20,'AMELIE HELLFIGHTERS','A Boring Drama of a Woman And a Squirrel who must Conquer a Student in A Baloon',2006,1,NULL,4,'4.99',79,'23.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (21,'AMERICAN CIRCUS','A Insightful Drama of a Girl And a Astronaut who must Face a Database Administrator in A Shark Tank',2006,1,NULL,3,'4.99',129,'17.99','R','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (22,'AMISTAD MIDSUMMER','A Emotional Character Study of a Dentist And a Crocodile who must Meet a Sumo Wrestler in California',2006,1,NULL,6,'2.99',85,'10.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (23,'ANACONDA CONFESSIONS','A Lacklusture Display of a Dentist And a Dentist who must Fight a Girl in Australia',2006,1,NULL,3,'0.99',92,'9.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (24,'ANALYZE HOOSIERS','A Thoughtful Display of a Explorer And a Pastry Chef who must Overcome a Feminist in The Sahara Desert',2006,1,NULL,6,'2.99',181,'19.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (25,'ANGELS LIFE','A Thoughtful Display of a Woman And a Astronaut who must Battle a Robot in Berlin',2006,1,NULL,3,'2.99',74,'15.99','G','Trailers','2006-02-15 05:03:42'),
 (26,'ANNIE IDENTITY','A Amazing Panorama of a Pastry Chef And a Boat who must Escape a Woman in An Abandoned Amusement Park',2006,1,NULL,3,'0.99',86,'15.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (27,'ANONYMOUS HUMAN','A Amazing Reflection of a Database Administrator And a Astronaut who must Outrace a Database Administrator in A Shark Tank',2006,1,NULL,7,'0.99',179,'12.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (28,'ANTHEM LUKE','A Touching Panorama of a Waitress And a Woman who must Outrace a Dog in An Abandoned Amusement Park',2006,1,NULL,5,'4.99',91,'16.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (29,'ANTITRUST TOMATOES','A Fateful Yarn of a Womanizer And a Feminist who must Succumb a Database Administrator in Ancient India',2006,1,NULL,5,'2.99',168,'11.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (30,'ANYTHING SAVANNAH','A Epic Story of a Pastry Chef And a Woman who must Chase a Feminist in An Abandoned Fun House',2006,1,NULL,4,'2.99',82,'27.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (31,'APACHE DIVINE','A Awe-Inspiring Reflection of a Pastry Chef And a Teacher who must Overcome a Sumo Wrestler in A U-Boat',2006,1,NULL,5,'4.99',92,'16.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (32,'APOCALYPSE FLAMINGOS','A Astounding Story of a Dog And a Squirrel who must Defeat a Woman in An Abandoned Amusement Park',2006,1,NULL,6,'4.99',119,'11.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (33,'APOLLO TEEN','A Action-Packed Reflection of a Crocodile And a Explorer who must Find a Sumo Wrestler in An Abandoned Mine Shaft',2006,1,NULL,5,'2.99',153,'15.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (34,'ARABIA DOGMA','A Touching Epistle of a Madman And a Mad Cow who must Defeat a Student in Nigeria',2006,1,NULL,6,'0.99',62,'29.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (35,'ARACHNOPHOBIA ROLLERCOASTER','A Action-Packed Reflection of a Pastry Chef And a Composer who must Discover a Mad Scientist in The First Manned Space Station',2006,1,NULL,4,'2.99',147,'24.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (36,'ARGONAUTS TOWN','A Emotional Epistle of a Forensic Psychologist And a Butler who must Challenge a Waitress in An Abandoned Mine Shaft',2006,1,NULL,7,'0.99',127,'12.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (37,'ARIZONA BANG','A Brilliant Panorama of a Mad Scientist And a Mad Cow who must Meet a Pioneer in A Monastery',2006,1,NULL,3,'2.99',121,'28.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (38,'ARK RIDGEMONT','A Beautiful Yarn of a Pioneer And a Monkey who must Pursue a Explorer in The Sahara Desert',2006,1,NULL,6,'0.99',68,'25.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (39,'ARMAGEDDON LOST','A Fast-Paced Tale of a Boat And a Teacher who must Succumb a Composer in An Abandoned Mine Shaft',2006,1,NULL,5,'0.99',99,'10.99','G','Trailers','2006-02-15 05:03:42'),
 (40,'ARMY FLINTSTONES','A Boring Saga of a Database Administrator And a Womanizer who must Battle a Waitress in Nigeria',2006,1,NULL,4,'0.99',148,'22.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (41,'ARSENIC INDEPENDENCE','A Fanciful Documentary of a Mad Cow And a Womanizer who must Find a Dentist in Berlin',2006,1,NULL,4,'0.99',137,'17.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (42,'ARTIST COLDBLOODED','A Stunning Reflection of a Robot And a Moose who must Challenge a Woman in California',2006,1,NULL,5,'2.99',170,'10.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (43,'ATLANTIS CAUSE','A Thrilling Yarn of a Feminist And a Hunter who must Fight a Technical Writer in A Shark Tank',2006,1,NULL,6,'2.99',170,'15.99','G','Behind the Scenes','2006-02-15 05:03:42'),
 (44,'ATTACKS HATE','A Fast-Paced Panorama of a Technical Writer And a Mad Scientist who must Find a Feminist in An Abandoned Mine Shaft',2006,1,NULL,5,'4.99',113,'21.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (45,'ATTRACTION NEWTON','A Astounding Panorama of a Composer And a Frisbee who must Reach a Husband in Ancient Japan',2006,1,NULL,5,'4.99',83,'14.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (46,'AUTUMN CROW','A Beautiful Tale of a Dentist And a Mad Cow who must Battle a Moose in The Sahara Desert',2006,1,NULL,3,'4.99',108,'13.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (47,'BABY HALL','A Boring Character Study of a A Shark And a Girl who must Outrace a Feminist in An Abandoned Mine Shaft',2006,1,NULL,5,'4.99',153,'23.99','NC-17','Commentaries','2006-02-15 05:03:42'),
 (48,'BACKLASH UNDEFEATED','A Stunning Character Study of a Mad Scientist And a Mad Cow who must Kill a Car in A Monastery',2006,1,NULL,3,'4.99',118,'24.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (49,'BADMAN DAWN','A Emotional Panorama of a Pioneer And a Composer who must Escape a Mad Scientist in A Jet Boat',2006,1,NULL,6,'2.99',162,'22.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (50,'BAKED CLEOPATRA','A Stunning Drama of a Forensic Psychologist And a Husband who must Overcome a Waitress in A Monastery',2006,1,NULL,3,'2.99',182,'20.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (51,'BALLOON HOMEWARD','A Insightful Panorama of a Forensic Psychologist And a Mad Cow who must Build a Mad Scientist in The First Manned Space Station',2006,1,NULL,5,'2.99',75,'10.99','NC-17','Deleted Scenes','2006-02-15 05:03:42'),
 (52,'BALLROOM MOCKINGBIRD','A Thrilling Documentary of a Composer And a Monkey who must Find a Feminist in California',2006,1,NULL,6,'0.99',173,'29.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (53,'BANG KWAI','A Epic Drama of a Madman And a Cat who must Face a A Shark in An Abandoned Amusement Park',2006,1,NULL,5,'2.99',87,'25.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (54,'BANGER PINOCCHIO','A Awe-Inspiring Drama of a Car And a Pastry Chef who must Chase a Crocodile in The First Manned Space Station',2006,1,NULL,5,'0.99',113,'15.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (55,'BARBARELLA STREETCAR','A Awe-Inspiring Story of a Feminist And a Cat who must Conquer a Dog in A Monastery',2006,1,NULL,6,'2.99',65,'27.99','G','Behind the Scenes','2006-02-15 05:03:42'),
 (56,'BAREFOOT MANCHURIAN','A Intrepid Story of a Cat And a Student who must Vanquish a Girl in An Abandoned Amusement Park',2006,1,NULL,6,'2.99',129,'15.99','G','Trailers,Commentaries','2006-02-15 05:03:42'),
 (57,'BASIC EASY','A Stunning Epistle of a Man And a Husband who must Reach a Mad Scientist in A Jet Boat',2006,1,NULL,4,'2.99',90,'18.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (58,'BEACH HEARTBREAKERS','A Fateful Display of a Womanizer And a Mad Scientist who must Outgun a A Shark in Soviet Georgia',2006,1,NULL,6,'2.99',122,'16.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (59,'BEAR GRACELAND','A Astounding Saga of a Dog And a Boy who must Kill a Teacher in The First Manned Space Station',2006,1,NULL,4,'2.99',160,'20.99','R','Deleted Scenes','2006-02-15 05:03:42'),
 (60,'BEAST HUNCHBACK','A Awe-Inspiring Epistle of a Student And a Squirrel who must Defeat a Boy in Ancient China',2006,1,NULL,3,'4.99',89,'22.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (61,'BEAUTY GREASE','A Fast-Paced Display of a Composer And a Moose who must Sink a Robot in An Abandoned Mine Shaft',2006,1,NULL,5,'4.99',175,'28.99','G','Trailers,Commentaries','2006-02-15 05:03:42'),
 (62,'BED HIGHBALL','A Astounding Panorama of a Lumberjack And a Dog who must Redeem a Woman in An Abandoned Fun House',2006,1,NULL,5,'2.99',106,'23.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (63,'BEDAZZLED MARRIED','A Astounding Character Study of a Madman And a Robot who must Meet a Mad Scientist in An Abandoned Fun House',2006,1,NULL,6,'0.99',73,'21.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (64,'BEETHOVEN EXORCIST','A Epic Display of a Pioneer And a Student who must Challenge a Butler in The Gulf of Mexico',2006,1,NULL,6,'0.99',151,'26.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (65,'BEHAVIOR RUNAWAY','A Unbelieveable Drama of a Student And a Husband who must Outrace a Sumo Wrestler in Berlin',2006,1,NULL,3,'4.99',100,'20.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (66,'BENEATH RUSH','A Astounding Panorama of a Man And a Monkey who must Discover a Man in The First Manned Space Station',2006,1,NULL,6,'0.99',53,'27.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (67,'BERETS AGENT','A Taut Saga of a Crocodile And a Boy who must Overcome a Technical Writer in Ancient China',2006,1,NULL,5,'2.99',77,'24.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (68,'BETRAYED REAR','A Emotional Character Study of a Boat And a Pioneer who must Find a Explorer in A Shark Tank',2006,1,NULL,5,'4.99',122,'26.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (69,'BEVERLY OUTLAW','A Fanciful Documentary of a Womanizer And a Boat who must Defeat a Madman in The First Manned Space Station',2006,1,NULL,3,'2.99',85,'21.99','R','Trailers','2006-02-15 05:03:42'),
 (70,'BIKINI BORROWERS','A Astounding Drama of a Astronaut And a Cat who must Discover a Woman in The First Manned Space Station',2006,1,NULL,7,'4.99',142,'26.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (71,'BILKO ANONYMOUS','A Emotional Reflection of a Teacher And a Man who must Meet a Cat in The First Manned Space Station',2006,1,NULL,3,'4.99',100,'25.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (72,'BILL OTHERS','A Stunning Saga of a Mad Scientist And a Forensic Psychologist who must Challenge a Squirrel in A MySQL Convention',2006,1,NULL,6,'2.99',93,'12.99','PG','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (73,'BINGO TALENTED','A Touching Tale of a Girl And a Crocodile who must Discover a Waitress in Nigeria',2006,1,NULL,5,'2.99',150,'22.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42'),
 (74,'BIRCH ANTITRUST','A Fanciful Panorama of a Husband And a Pioneer who must Outgun a Dog in A Baloon',2006,1,NULL,4,'4.99',162,'18.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (75,'BIRD INDEPENDENCE','A Thrilling Documentary of a Car And a Student who must Sink a Hunter in The Canadian Rockies',2006,1,NULL,6,'4.99',163,'14.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (76,'BIRDCAGE CASPER','A Fast-Paced Saga of a Frisbee And a Astronaut who must Overcome a Feminist in Ancient India',2006,1,NULL,4,'0.99',103,'23.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (77,'BIRDS PERDITION','A Boring Story of a Womanizer And a Pioneer who must Face a Dog in California',2006,1,NULL,5,'4.99',61,'15.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (78,'BLACKOUT PRIVATE','A Intrepid Yarn of a Pastry Chef And a Mad Scientist who must Challenge a Secret Agent in Ancient Japan',2006,1,NULL,7,'2.99',85,'12.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (79,'BLADE POLISH','A Thoughtful Character Study of a Frisbee And a Pastry Chef who must Fight a Dentist in The First Manned Space Station',2006,1,NULL,5,'0.99',114,'10.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (80,'BLANKET BEVERLY','A Emotional Documentary of a Student And a Girl who must Build a Boat in Nigeria',2006,1,NULL,7,'2.99',148,'21.99','G','Trailers','2006-02-15 05:03:42'),
 (81,'BLINDNESS GUN','A Touching Drama of a Robot And a Dentist who must Meet a Hunter in A Jet Boat',2006,1,NULL,6,'4.99',103,'29.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (82,'BLOOD ARGONAUTS','A Boring Drama of a Explorer And a Man who must Kill a Lumberjack in A Manhattan Penthouse',2006,1,NULL,3,'0.99',71,'13.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (83,'BLUES INSTINCT','A Insightful Documentary of a Boat And a Composer who must Meet a Forensic Psychologist in An Abandoned Fun House',2006,1,NULL,5,'2.99',50,'18.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (84,'BOILED DARES','A Awe-Inspiring Story of a Waitress And a Dog who must Discover a Dentist in Ancient Japan',2006,1,NULL,7,'4.99',102,'13.99','PG','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (85,'BONNIE HOLOCAUST','A Fast-Paced Story of a Crocodile And a Robot who must Find a Moose in Ancient Japan',2006,1,NULL,4,'0.99',63,'29.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (86,'BOOGIE AMELIE','A Lacklusture Character Study of a Husband And a Sumo Wrestler who must Succumb a Technical Writer in The Gulf of Mexico',2006,1,NULL,6,'4.99',121,'11.99','R','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (87,'BOONDOCK BALLROOM','A Fateful Panorama of a Crocodile And a Boy who must Defeat a Monkey in The Gulf of Mexico',2006,1,NULL,7,'0.99',76,'14.99','NC-17','Behind the Scenes','2006-02-15 05:03:42'),
 (88,'BORN SPINAL','A Touching Epistle of a Frisbee And a Husband who must Pursue a Student in Nigeria',2006,1,NULL,7,'4.99',179,'17.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (89,'BORROWERS BEDAZZLED','A Brilliant Epistle of a Teacher And a Sumo Wrestler who must Defeat a Man in An Abandoned Fun House',2006,1,NULL,7,'0.99',63,'22.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (90,'BOULEVARD MOB','A Fateful Epistle of a Moose And a Monkey who must Confront a Lumberjack in Ancient China',2006,1,NULL,3,'0.99',63,'11.99','R','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (91,'BOUND CHEAPER','A Thrilling Panorama of a Database Administrator And a Astronaut who must Challenge a Lumberjack in A Baloon',2006,1,NULL,5,'0.99',98,'17.99','PG','Behind the Scenes','2006-02-15 05:03:42'),
 (92,'BOWFINGER GABLES','A Fast-Paced Yarn of a Waitress And a Composer who must Outgun a Dentist in California',2006,1,NULL,7,'4.99',72,'19.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (93,'BRANNIGAN SUNRISE','A Amazing Epistle of a Moose And a Crocodile who must Outrace a Dog in Berlin',2006,1,NULL,4,'4.99',121,'27.99','PG','Trailers','2006-02-15 05:03:42'),
 (94,'BRAVEHEART HUMAN','A Insightful Story of a Dog And a Pastry Chef who must Battle a Girl in Berlin',2006,1,NULL,7,'2.99',176,'14.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (95,'BREAKFAST GOLDFINGER','A Beautiful Reflection of a Student And a Student who must Fight a Moose in Berlin',2006,1,NULL,5,'4.99',123,'18.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (96,'BREAKING HOME','A Beautiful Display of a Secret Agent And a Monkey who must Battle a Sumo Wrestler in An Abandoned Mine Shaft',2006,1,NULL,4,'2.99',169,'21.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (97,'BRIDE INTRIGUE','A Epic Tale of a Robot And a Monkey who must Vanquish a Man in New Orleans',2006,1,NULL,7,'0.99',56,'24.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (98,'BRIGHT ENCOUNTERS','A Fateful Yarn of a Lumberjack And a Feminist who must Conquer a Student in A Jet Boat',2006,1,NULL,4,'4.99',73,'12.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (99,'BRINGING HYSTERICAL','A Fateful Saga of a A Shark And a Technical Writer who must Find a Woman in A Jet Boat',2006,1,NULL,7,'2.99',136,'14.99','PG','Trailers','2006-02-15 05:03:42'),
 (100,'BROOKLYN DESERT','A Beautiful Drama of a Dentist And a Composer who must Battle a Sumo Wrestler in The First Manned Space Station',2006,1,NULL,7,'4.99',161,'21.99','R','Commentaries','2006-02-15 05:03:42'),
 (101,'BROTHERHOOD BLANKET','A Fateful Character Study of a Butler And a Technical Writer who must Sink a Astronaut in Ancient Japan',2006,1,NULL,3,'0.99',73,'26.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (102,'BUBBLE GROSSE','A Awe-Inspiring Panorama of a Crocodile And a Moose who must Confront a Girl in A Baloon',2006,1,NULL,4,'4.99',60,'20.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (103,'BUCKET BROTHERHOOD','A Amazing Display of a Girl And a Womanizer who must Succumb a Lumberjack in A Baloon Factory',2006,1,NULL,7,'4.99',133,'27.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (104,'BUGSY SONG','A Awe-Inspiring Character Study of a Secret Agent And a Boat who must Find a Squirrel in The First Manned Space Station',2006,1,NULL,4,'2.99',119,'17.99','G','Commentaries','2006-02-15 05:03:42'),
 (105,'BULL SHAWSHANK','A Fanciful Drama of a Moose And a Squirrel who must Conquer a Pioneer in The Canadian Rockies',2006,1,NULL,6,'0.99',125,'21.99','NC-17','Deleted Scenes','2006-02-15 05:03:42'),
 (106,'BULWORTH COMMANDMENTS','A Amazing Display of a Mad Cow And a Pioneer who must Redeem a Sumo Wrestler in The Outback',2006,1,NULL,4,'2.99',61,'14.99','G','Trailers','2006-02-15 05:03:42'),
 (107,'BUNCH MINDS','A Emotional Story of a Feminist And a Feminist who must Escape a Pastry Chef in A MySQL Convention',2006,1,NULL,4,'2.99',63,'13.99','G','Behind the Scenes','2006-02-15 05:03:42'),
 (108,'BUTCH PANTHER','A Lacklusture Yarn of a Feminist And a Database Administrator who must Face a Hunter in New Orleans',2006,1,NULL,6,'0.99',67,'19.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (109,'BUTTERFLY CHOCOLAT','A Fateful Story of a Girl And a Composer who must Conquer a Husband in A Shark Tank',2006,1,NULL,3,'0.99',89,'17.99','G','Behind the Scenes','2006-02-15 05:03:42'),
 (110,'CABIN FLASH','A Stunning Epistle of a Boat And a Man who must Challenge a A Shark in A Baloon Factory',2006,1,NULL,4,'0.99',53,'25.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (111,'CADDYSHACK JEDI','A Awe-Inspiring Epistle of a Woman And a Madman who must Fight a Robot in Soviet Georgia',2006,1,NULL,3,'0.99',52,'17.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (112,'CALENDAR GUNFIGHT','A Thrilling Drama of a Frisbee And a Lumberjack who must Sink a Man in Nigeria',2006,1,NULL,4,'4.99',120,'22.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (113,'CALIFORNIA BIRDS','A Thrilling Yarn of a Database Administrator And a Robot who must Battle a Database Administrator in Ancient India',2006,1,NULL,4,'4.99',75,'19.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (114,'CAMELOT VACATION','A Touching Character Study of a Woman And a Waitress who must Battle a Pastry Chef in A MySQL Convention',2006,1,NULL,3,'0.99',61,'26.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (115,'CAMPUS REMEMBER','A Astounding Drama of a Crocodile And a Mad Cow who must Build a Robot in A Jet Boat',2006,1,NULL,5,'2.99',167,'27.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (116,'CANDIDATE PERDITION','A Brilliant Epistle of a Composer And a Database Administrator who must Vanquish a Mad Scientist in The First Manned Space Station',2006,1,NULL,4,'2.99',70,'10.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (117,'CANDLES GRAPES','A Fanciful Character Study of a Monkey And a Explorer who must Build a Astronaut in An Abandoned Fun House',2006,1,NULL,6,'4.99',135,'15.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (118,'CANYON STOCK','A Thoughtful Reflection of a Waitress And a Feminist who must Escape a Squirrel in A Manhattan Penthouse',2006,1,NULL,7,'0.99',85,'26.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (119,'CAPER MOTIONS','A Fateful Saga of a Moose And a Car who must Pursue a Woman in A MySQL Convention',2006,1,NULL,6,'0.99',176,'22.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (120,'CARIBBEAN LIBERTY','A Fanciful Tale of a Pioneer And a Technical Writer who must Outgun a Pioneer in A Shark Tank',2006,1,NULL,3,'4.99',92,'16.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (121,'CAROL TEXAS','A Astounding Character Study of a Composer And a Student who must Overcome a Composer in A Monastery',2006,1,NULL,4,'2.99',151,'15.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (122,'CARRIE BUNCH','A Amazing Epistle of a Student And a Astronaut who must Discover a Frisbee in The Canadian Rockies',2006,1,NULL,7,'0.99',114,'11.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (123,'CASABLANCA SUPER','A Amazing Panorama of a Crocodile And a Forensic Psychologist who must Pursue a Secret Agent in The First Manned Space Station',2006,1,NULL,6,'4.99',85,'22.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (124,'CASPER DRAGONFLY','A Intrepid Documentary of a Boat And a Crocodile who must Chase a Robot in The Sahara Desert',2006,1,NULL,3,'4.99',163,'16.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (125,'CASSIDY WYOMING','A Intrepid Drama of a Frisbee And a Hunter who must Kill a Secret Agent in New Orleans',2006,1,NULL,5,'2.99',61,'19.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (126,'CASUALTIES ENCINO','A Insightful Yarn of a A Shark And a Pastry Chef who must Face a Boy in A Monastery',2006,1,NULL,3,'4.99',179,'16.99','G','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (127,'CAT CONEHEADS','A Fast-Paced Panorama of a Girl And a A Shark who must Confront a Boy in Ancient India',2006,1,NULL,5,'4.99',112,'14.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (128,'CATCH AMISTAD','A Boring Reflection of a Lumberjack And a Feminist who must Discover a Woman in Nigeria',2006,1,NULL,7,'0.99',183,'10.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (129,'CAUSE DATE','A Taut Tale of a Explorer And a Pastry Chef who must Conquer a Hunter in A MySQL Convention',2006,1,NULL,3,'2.99',179,'16.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (130,'CELEBRITY HORN','A Amazing Documentary of a Secret Agent And a Astronaut who must Vanquish a Hunter in A Shark Tank',2006,1,NULL,7,'0.99',110,'24.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (131,'CENTER DINOSAUR','A Beautiful Character Study of a Sumo Wrestler And a Dentist who must Find a Dog in California',2006,1,NULL,5,'4.99',152,'12.99','PG','Deleted Scenes','2006-02-15 05:03:42'),
 (132,'CHAINSAW UPTOWN','A Beautiful Documentary of a Boy And a Robot who must Discover a Squirrel in Australia',2006,1,NULL,6,'0.99',114,'25.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (133,'CHAMBER ITALIAN','A Fateful Reflection of a Moose And a Husband who must Overcome a Monkey in Nigeria',2006,1,NULL,7,'4.99',117,'14.99','NC-17','Trailers','2006-02-15 05:03:42'),
 (134,'CHAMPION FLATLINERS','A Amazing Story of a Mad Cow And a Dog who must Kill a Husband in A Monastery',2006,1,NULL,4,'4.99',51,'21.99','PG','Trailers','2006-02-15 05:03:42'),
 (135,'CHANCE RESURRECTION','A Astounding Story of a Forensic Psychologist And a Forensic Psychologist who must Overcome a Moose in Ancient China',2006,1,NULL,3,'2.99',70,'22.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (136,'CHAPLIN LICENSE','A Boring Drama of a Dog And a Forensic Psychologist who must Outrace a Explorer in Ancient India',2006,1,NULL,7,'2.99',146,'26.99','NC-17','Behind the Scenes','2006-02-15 05:03:42'),
 (137,'CHARADE DUFFEL','A Action-Packed Display of a Man And a Waitress who must Build a Dog in A MySQL Convention',2006,1,NULL,3,'2.99',66,'21.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (138,'CHARIOTS CONSPIRACY','A Unbelieveable Epistle of a Robot And a Husband who must Chase a Robot in The First Manned Space Station',2006,1,NULL,5,'2.99',71,'29.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (139,'CHASING FIGHT','A Astounding Saga of a Technical Writer And a Butler who must Battle a Butler in A Shark Tank',2006,1,NULL,7,'4.99',114,'21.99','PG','Trailers,Commentaries','2006-02-15 05:03:42'),
 (140,'CHEAPER CLYDE','A Emotional Character Study of a Pioneer And a Girl who must Discover a Dog in Ancient Japan',2006,1,NULL,6,'0.99',87,'23.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (141,'CHICAGO NORTH','A Fateful Yarn of a Mad Cow And a Waitress who must Battle a Student in California',2006,1,NULL,6,'4.99',185,'11.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (142,'CHICKEN HELLFIGHTERS','A Emotional Drama of a Dog And a Explorer who must Outrace a Technical Writer in Australia',2006,1,NULL,3,'0.99',122,'24.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (143,'CHILL LUCK','A Lacklusture Epistle of a Boat And a Technical Writer who must Fight a A Shark in The Canadian Rockies',2006,1,NULL,6,'0.99',142,'17.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (144,'CHINATOWN GLADIATOR','A Brilliant Panorama of a Technical Writer And a Lumberjack who must Escape a Butler in Ancient India',2006,1,NULL,7,'4.99',61,'24.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (145,'CHISUM BEHAVIOR','A Epic Documentary of a Sumo Wrestler And a Butler who must Kill a Car in Ancient India',2006,1,NULL,5,'4.99',124,'25.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (146,'CHITTY LOCK','A Boring Epistle of a Boat And a Database Administrator who must Kill a Sumo Wrestler in The First Manned Space Station',2006,1,NULL,6,'2.99',107,'24.99','G','Commentaries','2006-02-15 05:03:42'),
 (147,'CHOCOLAT HARRY','A Action-Packed Epistle of a Dentist And a Moose who must Meet a Mad Cow in Ancient Japan',2006,1,NULL,5,'0.99',101,'16.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (148,'CHOCOLATE DUCK','A Unbelieveable Story of a Mad Scientist And a Technical Writer who must Discover a Composer in Ancient China',2006,1,NULL,3,'2.99',132,'13.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (149,'CHRISTMAS MOONSHINE','A Action-Packed Epistle of a Feminist And a Astronaut who must Conquer a Boat in A Manhattan Penthouse',2006,1,NULL,7,'0.99',150,'21.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (150,'CIDER DESIRE','A Stunning Character Study of a Composer And a Mad Cow who must Succumb a Cat in Soviet Georgia',2006,1,NULL,7,'2.99',101,'9.99','PG','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (151,'CINCINATTI WHISPERER','A Brilliant Saga of a Pastry Chef And a Hunter who must Confront a Butler in Berlin',2006,1,NULL,5,'4.99',143,'26.99','NC-17','Deleted Scenes','2006-02-15 05:03:42'),
 (152,'CIRCUS YOUTH','A Thoughtful Drama of a Pastry Chef And a Dentist who must Pursue a Girl in A Baloon',2006,1,NULL,5,'2.99',90,'13.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (153,'CITIZEN SHREK','A Fanciful Character Study of a Technical Writer And a Husband who must Redeem a Robot in The Outback',2006,1,NULL,7,'0.99',165,'18.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (154,'CLASH FREDDY','A Amazing Yarn of a Composer And a Squirrel who must Escape a Astronaut in Australia',2006,1,NULL,6,'2.99',81,'12.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (155,'CLEOPATRA DEVIL','A Fanciful Documentary of a Crocodile And a Technical Writer who must Fight a A Shark in A Baloon',2006,1,NULL,6,'0.99',150,'26.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (156,'CLERKS ANGELS','A Thrilling Display of a Sumo Wrestler And a Girl who must Confront a Man in A Baloon',2006,1,NULL,3,'4.99',164,'15.99','G','Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (157,'CLOCKWORK PARADISE','A Insightful Documentary of a Technical Writer And a Feminist who must Challenge a Cat in A Baloon',2006,1,NULL,7,'0.99',143,'29.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (158,'CLONES PINOCCHIO','A Amazing Drama of a Car And a Robot who must Pursue a Dentist in New Orleans',2006,1,NULL,6,'2.99',124,'16.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (159,'CLOSER BANG','A Unbelieveable Panorama of a Frisbee And a Hunter who must Vanquish a Monkey in Ancient India',2006,1,NULL,5,'4.99',58,'12.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (160,'CLUB GRAFFITI','A Epic Tale of a Pioneer And a Hunter who must Escape a Girl in A U-Boat',2006,1,NULL,4,'0.99',65,'12.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (161,'CLUE GRAIL','A Taut Tale of a Butler And a Mad Scientist who must Build a Crocodile in Ancient China',2006,1,NULL,6,'4.99',70,'27.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (162,'CLUELESS BUCKET','A Taut Tale of a Car And a Pioneer who must Conquer a Sumo Wrestler in An Abandoned Fun House',2006,1,NULL,4,'2.99',95,'13.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (163,'CLYDE THEORY','A Beautiful Yarn of a Astronaut And a Frisbee who must Overcome a Explorer in A Jet Boat',2006,1,NULL,4,'0.99',139,'29.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (164,'COAST RAINBOW','A Astounding Documentary of a Mad Cow And a Pioneer who must Challenge a Butler in The Sahara Desert',2006,1,NULL,4,'0.99',55,'20.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (165,'COLDBLOODED DARLING','A Brilliant Panorama of a Dentist And a Moose who must Find a Student in The Gulf of Mexico',2006,1,NULL,7,'4.99',70,'27.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (166,'COLOR PHILADELPHIA','A Thoughtful Panorama of a Car And a Crocodile who must Sink a Monkey in The Sahara Desert',2006,1,NULL,6,'2.99',149,'19.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (167,'COMA HEAD','A Awe-Inspiring Drama of a Boy And a Frisbee who must Escape a Pastry Chef in California',2006,1,NULL,6,'4.99',109,'10.99','NC-17','Commentaries','2006-02-15 05:03:42'),
 (168,'COMANCHEROS ENEMY','A Boring Saga of a Lumberjack And a Monkey who must Find a Monkey in The Gulf of Mexico',2006,1,NULL,5,'0.99',67,'23.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (169,'COMFORTS RUSH','A Unbelieveable Panorama of a Pioneer And a Husband who must Meet a Mad Cow in An Abandoned Mine Shaft',2006,1,NULL,3,'2.99',76,'19.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (170,'COMMAND DARLING','A Awe-Inspiring Tale of a Forensic Psychologist And a Woman who must Challenge a Database Administrator in Ancient Japan',2006,1,NULL,5,'4.99',120,'28.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (171,'COMMANDMENTS EXPRESS','A Fanciful Saga of a Student And a Mad Scientist who must Battle a Hunter in An Abandoned Mine Shaft',2006,1,NULL,6,'4.99',59,'13.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (172,'CONEHEADS SMOOCHY','A Touching Story of a Womanizer And a Composer who must Pursue a Husband in Nigeria',2006,1,NULL,7,'4.99',112,'12.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (173,'CONFESSIONS MAGUIRE','A Insightful Story of a Car And a Boy who must Battle a Technical Writer in A Baloon',2006,1,NULL,7,'4.99',65,'25.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (174,'CONFIDENTIAL INTERVIEW','A Stunning Reflection of a Cat And a Woman who must Find a Astronaut in Ancient Japan',2006,1,NULL,6,'4.99',180,'13.99','NC-17','Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (175,'CONFUSED CANDLES','A Stunning Epistle of a Cat And a Forensic Psychologist who must Confront a Pioneer in A Baloon',2006,1,NULL,3,'2.99',122,'27.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (176,'CONGENIALITY QUEST','A Touching Documentary of a Cat And a Pastry Chef who must Find a Lumberjack in A Baloon',2006,1,NULL,6,'0.99',87,'21.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (177,'CONNECTICUT TRAMP','A Unbelieveable Drama of a Crocodile And a Mad Cow who must Reach a Dentist in A Shark Tank',2006,1,NULL,4,'4.99',172,'20.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (178,'CONNECTION MICROCOSMOS','A Fateful Documentary of a Crocodile And a Husband who must Face a Husband in The First Manned Space Station',2006,1,NULL,6,'0.99',115,'25.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (179,'CONQUERER NUTS','A Taut Drama of a Mad Scientist And a Man who must Escape a Pioneer in An Abandoned Mine Shaft',2006,1,NULL,4,'4.99',173,'14.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (180,'CONSPIRACY SPIRIT','A Awe-Inspiring Story of a Student And a Frisbee who must Conquer a Crocodile in An Abandoned Mine Shaft',2006,1,NULL,4,'2.99',184,'27.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (181,'CONTACT ANONYMOUS','A Insightful Display of a A Shark And a Monkey who must Face a Database Administrator in Ancient India',2006,1,NULL,7,'2.99',166,'10.99','PG-13','Commentaries','2006-02-15 05:03:42'),
 (182,'CONTROL ANTHEM','A Fateful Documentary of a Robot And a Student who must Battle a Cat in A Monastery',2006,1,NULL,7,'4.99',185,'9.99','G','Commentaries','2006-02-15 05:03:42'),
 (183,'CONVERSATION DOWNHILL','A Taut Character Study of a Husband And a Waitress who must Sink a Squirrel in A MySQL Convention',2006,1,NULL,4,'4.99',112,'14.99','R','Commentaries','2006-02-15 05:03:42'),
 (184,'CORE SUIT','A Unbelieveable Tale of a Car And a Explorer who must Confront a Boat in A Manhattan Penthouse',2006,1,NULL,3,'2.99',92,'24.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (185,'COWBOY DOOM','A Astounding Drama of a Boy And a Lumberjack who must Fight a Butler in A Baloon',2006,1,NULL,3,'2.99',146,'10.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (186,'CRAFT OUTFIELD','A Lacklusture Display of a Explorer And a Hunter who must Succumb a Database Administrator in A Baloon Factory',2006,1,NULL,6,'0.99',64,'17.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (187,'CRANES RESERVOIR','A Fanciful Documentary of a Teacher And a Dog who must Outgun a Forensic Psychologist in A Baloon Factory',2006,1,NULL,5,'2.99',57,'12.99','NC-17','Commentaries','2006-02-15 05:03:42'),
 (188,'CRAZY HOME','A Fanciful Panorama of a Boy And a Woman who must Vanquish a Database Administrator in The Outback',2006,1,NULL,7,'2.99',136,'24.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (189,'CREATURES SHAKESPEARE','A Emotional Drama of a Womanizer And a Squirrel who must Vanquish a Crocodile in Ancient India',2006,1,NULL,3,'0.99',139,'23.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (190,'CREEPERS KANE','A Awe-Inspiring Reflection of a Squirrel And a Boat who must Outrace a Car in A Jet Boat',2006,1,NULL,5,'4.99',172,'23.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (191,'CROOKED FROGMEN','A Unbelieveable Drama of a Hunter And a Database Administrator who must Battle a Crocodile in An Abandoned Amusement Park',2006,1,NULL,6,'0.99',143,'27.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (192,'CROSSING DIVORCE','A Beautiful Documentary of a Dog And a Robot who must Redeem a Womanizer in Berlin',2006,1,NULL,4,'4.99',50,'19.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (193,'CROSSROADS CASUALTIES','A Intrepid Documentary of a Sumo Wrestler And a Astronaut who must Battle a Composer in The Outback',2006,1,NULL,5,'2.99',153,'20.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (194,'CROW GREASE','A Awe-Inspiring Documentary of a Woman And a Husband who must Sink a Database Administrator in The First Manned Space Station',2006,1,NULL,6,'0.99',104,'22.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (195,'CROWDS TELEMARK','A Intrepid Documentary of a Astronaut And a Forensic Psychologist who must Find a Frisbee in An Abandoned Fun House',2006,1,NULL,3,'4.99',112,'16.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (196,'CRUELTY UNFORGIVEN','A Brilliant Tale of a Car And a Moose who must Battle a Dentist in Nigeria',2006,1,NULL,7,'0.99',69,'29.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (197,'CRUSADE HONEY','A Fast-Paced Reflection of a Explorer And a Butler who must Battle a Madman in An Abandoned Amusement Park',2006,1,NULL,4,'2.99',112,'27.99','R','Commentaries','2006-02-15 05:03:42'),
 (198,'CRYSTAL BREAKING','A Fast-Paced Character Study of a Feminist And a Explorer who must Face a Pastry Chef in Ancient Japan',2006,1,NULL,6,'2.99',184,'22.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (199,'CUPBOARD SINNERS','A Emotional Reflection of a Frisbee And a Boat who must Reach a Pastry Chef in An Abandoned Amusement Park',2006,1,NULL,4,'2.99',56,'29.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (200,'CURTAIN VIDEOTAPE','A Boring Reflection of a Dentist And a Mad Cow who must Chase a Secret Agent in A Shark Tank',2006,1,NULL,7,'0.99',133,'27.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (201,'CYCLONE FAMILY','A Lacklusture Drama of a Student And a Monkey who must Sink a Womanizer in A MySQL Convention',2006,1,NULL,7,'2.99',176,'18.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (202,'DADDY PITTSBURGH','A Epic Story of a A Shark And a Student who must Confront a Explorer in The Gulf of Mexico',2006,1,NULL,5,'4.99',161,'26.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (203,'DAISY MENAGERIE','A Fast-Paced Saga of a Pastry Chef And a Monkey who must Sink a Composer in Ancient India',2006,1,NULL,5,'4.99',84,'9.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (204,'DALMATIONS SWEDEN','A Emotional Epistle of a Moose And a Hunter who must Overcome a Robot in A Manhattan Penthouse',2006,1,NULL,4,'0.99',106,'25.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (205,'DANCES NONE','A Insightful Reflection of a A Shark And a Dog who must Kill a Butler in An Abandoned Amusement Park',2006,1,NULL,3,'0.99',58,'22.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (206,'DANCING FEVER','A Stunning Story of a Explorer And a Forensic Psychologist who must Face a Crocodile in A Shark Tank',2006,1,NULL,6,'0.99',144,'25.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (207,'DANGEROUS UPTOWN','A Unbelieveable Story of a Mad Scientist And a Woman who must Overcome a Dog in California',2006,1,NULL,7,'4.99',121,'26.99','PG','Commentaries','2006-02-15 05:03:42'),
 (208,'DARES PLUTO','A Fateful Story of a Robot And a Dentist who must Defeat a Astronaut in New Orleans',2006,1,NULL,7,'2.99',89,'16.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (209,'DARKNESS WAR','A Touching Documentary of a Husband And a Hunter who must Escape a Boy in The Sahara Desert',2006,1,NULL,6,'2.99',99,'24.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (210,'DARKO DORADO','A Stunning Reflection of a Frisbee And a Husband who must Redeem a Dog in New Orleans',2006,1,NULL,3,'4.99',130,'13.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (211,'DARLING BREAKING','A Brilliant Documentary of a Astronaut And a Squirrel who must Succumb a Student in The Gulf of Mexico',2006,1,NULL,7,'4.99',165,'20.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (212,'DARN FORRESTER','A Fateful Story of a A Shark And a Explorer who must Succumb a Technical Writer in A Jet Boat',2006,1,NULL,7,'4.99',185,'14.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (213,'DATE SPEED','A Touching Saga of a Composer And a Moose who must Discover a Dentist in A MySQL Convention',2006,1,NULL,4,'0.99',104,'19.99','R','Commentaries','2006-02-15 05:03:42'),
 (214,'DAUGHTER MADIGAN','A Beautiful Tale of a Hunter And a Mad Scientist who must Confront a Squirrel in The First Manned Space Station',2006,1,NULL,3,'4.99',59,'13.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (215,'DAWN POND','A Thoughtful Documentary of a Dentist And a Forensic Psychologist who must Defeat a Waitress in Berlin',2006,1,NULL,4,'4.99',57,'27.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (216,'DAY UNFAITHFUL','A Stunning Documentary of a Composer And a Mad Scientist who must Find a Technical Writer in A U-Boat',2006,1,NULL,3,'4.99',113,'16.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (217,'DAZED PUNK','A Action-Packed Story of a Pioneer And a Technical Writer who must Discover a Forensic Psychologist in An Abandoned Amusement Park',2006,1,NULL,6,'4.99',120,'20.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (218,'DECEIVER BETRAYED','A Taut Story of a Moose And a Squirrel who must Build a Husband in Ancient India',2006,1,NULL,7,'0.99',122,'22.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (219,'DEEP CRUSADE','A Amazing Tale of a Crocodile And a Squirrel who must Discover a Composer in Australia',2006,1,NULL,6,'4.99',51,'20.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (220,'DEER VIRGINIAN','A Thoughtful Story of a Mad Cow And a Womanizer who must Overcome a Mad Scientist in Soviet Georgia',2006,1,NULL,7,'2.99',106,'13.99','NC-17','Deleted Scenes','2006-02-15 05:03:42'),
 (221,'DELIVERANCE MULHOLLAND','A Astounding Saga of a Monkey And a Moose who must Conquer a Butler in A Shark Tank',2006,1,NULL,4,'0.99',100,'9.99','R','Deleted Scenes','2006-02-15 05:03:42'),
 (222,'DESERT POSEIDON','A Brilliant Documentary of a Butler And a Frisbee who must Build a Astronaut in New Orleans',2006,1,NULL,4,'4.99',64,'27.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (223,'DESIRE ALIEN','A Fast-Paced Tale of a Dog And a Forensic Psychologist who must Meet a Astronaut in The First Manned Space Station',2006,1,NULL,7,'2.99',76,'24.99','NC-17','Deleted Scenes','2006-02-15 05:03:42'),
 (224,'DESPERATE TRAINSPOTTING','A Epic Yarn of a Forensic Psychologist And a Teacher who must Face a Lumberjack in California',2006,1,NULL,7,'4.99',81,'29.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (225,'DESTINATION JERK','A Beautiful Yarn of a Teacher And a Cat who must Build a Car in A U-Boat',2006,1,NULL,3,'0.99',76,'19.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (226,'DESTINY SATURDAY','A Touching Drama of a Crocodile And a Crocodile who must Conquer a Explorer in Soviet Georgia',2006,1,NULL,4,'4.99',56,'20.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (227,'DETAILS PACKER','A Epic Saga of a Waitress And a Composer who must Face a Boat in A U-Boat',2006,1,NULL,4,'4.99',88,'17.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (228,'DETECTIVE VISION','A Fanciful Documentary of a Pioneer And a Woman who must Redeem a Hunter in Ancient Japan',2006,1,NULL,4,'0.99',143,'16.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (229,'DEVIL DESIRE','A Beautiful Reflection of a Monkey And a Dentist who must Face a Database Administrator in Ancient Japan',2006,1,NULL,6,'4.99',87,'12.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (230,'DIARY PANIC','A Thoughtful Character Study of a Frisbee And a Mad Cow who must Outgun a Man in Ancient India',2006,1,NULL,7,'2.99',107,'20.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (231,'DINOSAUR SECRETARY','A Action-Packed Drama of a Feminist And a Girl who must Reach a Robot in The Canadian Rockies',2006,1,NULL,7,'2.99',63,'27.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (232,'DIRTY ACE','A Action-Packed Character Study of a Forensic Psychologist And a Girl who must Build a Dentist in The Outback',2006,1,NULL,7,'2.99',147,'29.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (233,'DISCIPLE MOTHER','A Touching Reflection of a Mad Scientist And a Boat who must Face a Moose in A Shark Tank',2006,1,NULL,3,'0.99',141,'17.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (234,'DISTURBING SCARFACE','A Lacklusture Display of a Crocodile And a Butler who must Overcome a Monkey in A U-Boat',2006,1,NULL,6,'2.99',94,'27.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (235,'DIVIDE MONSTER','A Intrepid Saga of a Man And a Forensic Psychologist who must Reach a Squirrel in A Monastery',2006,1,NULL,6,'2.99',68,'13.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42'),
 (236,'DIVINE RESURRECTION','A Boring Character Study of a Man And a Womanizer who must Succumb a Teacher in An Abandoned Amusement Park',2006,1,NULL,4,'2.99',100,'19.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (237,'DIVORCE SHINING','A Unbelieveable Saga of a Crocodile And a Student who must Discover a Cat in Ancient India',2006,1,NULL,3,'2.99',47,'21.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (238,'DOCTOR GRAIL','A Insightful Drama of a Womanizer And a Waitress who must Reach a Forensic Psychologist in The Outback',2006,1,NULL,4,'2.99',57,'29.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (239,'DOGMA FAMILY','A Brilliant Character Study of a Database Administrator And a Monkey who must Succumb a Astronaut in New Orleans',2006,1,NULL,5,'4.99',122,'16.99','G','Commentaries','2006-02-15 05:03:42'),
 (240,'DOLLS RAGE','A Thrilling Display of a Pioneer And a Frisbee who must Escape a Teacher in The Outback',2006,1,NULL,7,'2.99',120,'10.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (241,'DONNIE ALLEY','A Awe-Inspiring Tale of a Butler And a Frisbee who must Vanquish a Teacher in Ancient Japan',2006,1,NULL,4,'0.99',125,'20.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (242,'DOOM DANCING','A Astounding Panorama of a Car And a Mad Scientist who must Battle a Lumberjack in A MySQL Convention',2006,1,NULL,4,'0.99',68,'13.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (243,'DOORS PRESIDENT','A Awe-Inspiring Display of a Squirrel And a Woman who must Overcome a Boy in The Gulf of Mexico',2006,1,NULL,3,'4.99',49,'22.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (244,'DORADO NOTTING','A Action-Packed Tale of a Sumo Wrestler And a A Shark who must Meet a Frisbee in California',2006,1,NULL,5,'4.99',139,'26.99','NC-17','Commentaries','2006-02-15 05:03:42'),
 (245,'DOUBLE WRATH','A Thoughtful Yarn of a Womanizer And a Dog who must Challenge a Madman in The Gulf of Mexico',2006,1,NULL,4,'0.99',177,'28.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (246,'DOUBTFIRE LABYRINTH','A Intrepid Panorama of a Butler And a Composer who must Meet a Mad Cow in The Sahara Desert',2006,1,NULL,5,'4.99',154,'16.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (247,'DOWNHILL ENOUGH','A Emotional Tale of a Pastry Chef And a Forensic Psychologist who must Succumb a Monkey in The Sahara Desert',2006,1,NULL,3,'0.99',47,'19.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (248,'DOZEN LION','A Taut Drama of a Cat And a Girl who must Defeat a Frisbee in The Canadian Rockies',2006,1,NULL,6,'4.99',177,'20.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (249,'DRACULA CRYSTAL','A Thrilling Reflection of a Feminist And a Cat who must Find a Frisbee in An Abandoned Fun House',2006,1,NULL,7,'0.99',176,'26.99','G','Commentaries','2006-02-15 05:03:42'),
 (250,'DRAGON SQUAD','A Taut Reflection of a Boy And a Waitress who must Outgun a Teacher in Ancient China',2006,1,NULL,4,'0.99',170,'26.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (251,'DRAGONFLY STRANGERS','A Boring Documentary of a Pioneer And a Man who must Vanquish a Man in Nigeria',2006,1,NULL,6,'4.99',133,'19.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (252,'DREAM PICKUP','A Epic Display of a Car And a Composer who must Overcome a Forensic Psychologist in The Gulf of Mexico',2006,1,NULL,6,'2.99',135,'18.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (253,'DRIFTER COMMANDMENTS','A Epic Reflection of a Womanizer And a Squirrel who must Discover a Husband in A Jet Boat',2006,1,NULL,5,'4.99',61,'18.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (254,'DRIVER ANNIE','A Lacklusture Character Study of a Butler And a Car who must Redeem a Boat in An Abandoned Fun House',2006,1,NULL,4,'2.99',159,'11.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (255,'DRIVING POLISH','A Action-Packed Yarn of a Feminist And a Technical Writer who must Sink a Boat in An Abandoned Mine Shaft',2006,1,NULL,6,'4.99',175,'21.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (256,'DROP WATERFRONT','A Fanciful Documentary of a Husband And a Explorer who must Reach a Madman in Ancient China',2006,1,NULL,6,'4.99',178,'20.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (257,'DRUMLINE CYCLONE','A Insightful Panorama of a Monkey And a Sumo Wrestler who must Outrace a Mad Scientist in The Canadian Rockies',2006,1,NULL,3,'0.99',110,'14.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (258,'DRUMS DYNAMITE','A Epic Display of a Crocodile And a Crocodile who must Confront a Dog in An Abandoned Amusement Park',2006,1,NULL,6,'0.99',96,'11.99','PG','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (259,'DUCK RACER','A Lacklusture Yarn of a Teacher And a Squirrel who must Overcome a Dog in A Shark Tank',2006,1,NULL,4,'2.99',116,'15.99','NC-17','Behind the Scenes','2006-02-15 05:03:42'),
 (260,'DUDE BLINDNESS','A Stunning Reflection of a Husband And a Lumberjack who must Face a Frisbee in An Abandoned Fun House',2006,1,NULL,3,'4.99',132,'9.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (261,'DUFFEL APOCALYPSE','A Emotional Display of a Boat And a Explorer who must Challenge a Madman in A MySQL Convention',2006,1,NULL,5,'0.99',171,'13.99','G','Commentaries','2006-02-15 05:03:42'),
 (262,'DUMBO LUST','A Touching Display of a Feminist And a Dentist who must Conquer a Husband in The Gulf of Mexico',2006,1,NULL,5,'0.99',119,'17.99','NC-17','Behind the Scenes','2006-02-15 05:03:42'),
 (263,'DURHAM PANKY','A Brilliant Panorama of a Girl And a Boy who must Face a Mad Scientist in An Abandoned Mine Shaft',2006,1,NULL,6,'4.99',154,'14.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (264,'DWARFS ALTER','A Emotional Yarn of a Girl And a Dog who must Challenge a Composer in Ancient Japan',2006,1,NULL,6,'2.99',101,'13.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (265,'DYING MAKER','A Intrepid Tale of a Boat And a Monkey who must Kill a Cat in California',2006,1,NULL,5,'4.99',168,'28.99','PG','Behind the Scenes','2006-02-15 05:03:42'),
 (266,'DYNAMITE TARZAN','A Intrepid Documentary of a Forensic Psychologist And a Mad Scientist who must Face a Explorer in A U-Boat',2006,1,NULL,4,'0.99',141,'27.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (267,'EAGLES PANKY','A Thoughtful Story of a Car And a Boy who must Find a A Shark in The Sahara Desert',2006,1,NULL,4,'4.99',140,'14.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (268,'EARLY HOME','A Amazing Panorama of a Mad Scientist And a Husband who must Meet a Woman in The Outback',2006,1,NULL,6,'4.99',96,'27.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (269,'EARRING INSTINCT','A Stunning Character Study of a Dentist And a Mad Cow who must Find a Teacher in Nigeria',2006,1,NULL,3,'0.99',98,'22.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (270,'EARTH VISION','A Stunning Drama of a Butler And a Madman who must Outrace a Womanizer in Ancient India',2006,1,NULL,7,'0.99',85,'29.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (271,'EASY GLADIATOR','A Fateful Story of a Monkey And a Girl who must Overcome a Pastry Chef in Ancient India',2006,1,NULL,5,'4.99',148,'12.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (272,'EDGE KISSING','A Beautiful Yarn of a Composer And a Mad Cow who must Redeem a Mad Scientist in A Jet Boat',2006,1,NULL,5,'4.99',153,'9.99','NC-17','Deleted Scenes','2006-02-15 05:03:42'),
 (273,'EFFECT GLADIATOR','A Beautiful Display of a Pastry Chef And a Pastry Chef who must Outgun a Forensic Psychologist in A Manhattan Penthouse',2006,1,NULL,6,'0.99',107,'14.99','PG','Commentaries','2006-02-15 05:03:42'),
 (274,'EGG IGBY','A Beautiful Documentary of a Boat And a Sumo Wrestler who must Succumb a Database Administrator in The First Manned Space Station',2006,1,NULL,4,'2.99',67,'20.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (275,'EGYPT TENENBAUMS','A Intrepid Story of a Madman And a Secret Agent who must Outrace a Astronaut in An Abandoned Amusement Park',2006,1,NULL,3,'0.99',85,'11.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (276,'ELEMENT FREDDY','A Awe-Inspiring Reflection of a Waitress And a Squirrel who must Kill a Mad Cow in A Jet Boat',2006,1,NULL,6,'4.99',115,'28.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (277,'ELEPHANT TROJAN','A Beautiful Panorama of a Lumberjack And a Forensic Psychologist who must Overcome a Frisbee in A Baloon',2006,1,NULL,4,'4.99',126,'24.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (278,'ELF MURDER','A Action-Packed Story of a Frisbee And a Woman who must Reach a Girl in An Abandoned Mine Shaft',2006,1,NULL,4,'4.99',155,'19.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (279,'ELIZABETH SHANE','A Lacklusture Display of a Womanizer And a Dog who must Face a Sumo Wrestler in Ancient Japan',2006,1,NULL,7,'4.99',152,'11.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (280,'EMPIRE MALKOVICH','A Amazing Story of a Feminist And a Cat who must Face a Car in An Abandoned Fun House',2006,1,NULL,7,'0.99',177,'26.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (281,'ENCINO ELF','A Astounding Drama of a Feminist And a Teacher who must Confront a Husband in A Baloon',2006,1,NULL,6,'0.99',143,'9.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (282,'ENCOUNTERS CURTAIN','A Insightful Epistle of a Pastry Chef And a Womanizer who must Build a Boat in New Orleans',2006,1,NULL,5,'0.99',92,'20.99','NC-17','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (283,'ENDING CROWDS','A Unbelieveable Display of a Dentist And a Madman who must Vanquish a Squirrel in Berlin',2006,1,NULL,6,'0.99',85,'10.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (284,'ENEMY ODDS','A Fanciful Panorama of a Mad Scientist And a Woman who must Pursue a Astronaut in Ancient India',2006,1,NULL,5,'4.99',77,'23.99','NC-17','Trailers','2006-02-15 05:03:42'),
 (285,'ENGLISH BULWORTH','A Intrepid Epistle of a Pastry Chef And a Pastry Chef who must Pursue a Crocodile in Ancient China',2006,1,NULL,3,'0.99',51,'18.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (286,'ENOUGH RAGING','A Astounding Character Study of a Boat And a Secret Agent who must Find a Mad Cow in The Sahara Desert',2006,1,NULL,7,'2.99',158,'16.99','NC-17','Commentaries','2006-02-15 05:03:42'),
 (287,'ENTRAPMENT SATISFACTION','A Thoughtful Panorama of a Hunter And a Teacher who must Reach a Mad Cow in A U-Boat',2006,1,NULL,5,'0.99',176,'19.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (288,'ESCAPE METROPOLIS','A Taut Yarn of a Astronaut And a Technical Writer who must Outgun a Boat in New Orleans',2006,1,NULL,7,'2.99',167,'20.99','R','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (289,'EVE RESURRECTION','A Awe-Inspiring Yarn of a Pastry Chef And a Database Administrator who must Challenge a Teacher in A Baloon',2006,1,NULL,5,'4.99',66,'25.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (290,'EVERYONE CRAFT','A Fateful Display of a Waitress And a Dentist who must Reach a Butler in Nigeria',2006,1,NULL,4,'0.99',163,'29.99','PG','Trailers,Commentaries','2006-02-15 05:03:42'),
 (291,'EVOLUTION ALTER','A Fanciful Character Study of a Feminist And a Madman who must Find a Explorer in A Baloon Factory',2006,1,NULL,5,'0.99',174,'10.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (292,'EXCITEMENT EVE','A Brilliant Documentary of a Monkey And a Car who must Conquer a Crocodile in A Shark Tank',2006,1,NULL,3,'0.99',51,'20.99','G','Commentaries','2006-02-15 05:03:42'),
 (293,'EXORCIST STING','A Touching Drama of a Dog And a Sumo Wrestler who must Conquer a Mad Scientist in Berlin',2006,1,NULL,6,'2.99',167,'17.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (294,'EXPECATIONS NATURAL','A Amazing Drama of a Butler And a Husband who must Reach a A Shark in A U-Boat',2006,1,NULL,5,'4.99',138,'26.99','PG-13','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (295,'EXPENDABLE STALLION','A Amazing Character Study of a Mad Cow And a Squirrel who must Discover a Hunter in A U-Boat',2006,1,NULL,3,'0.99',97,'14.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (296,'EXPRESS LONELY','A Boring Drama of a Astronaut And a Boat who must Face a Boat in California',2006,1,NULL,5,'2.99',178,'23.99','R','Trailers','2006-02-15 05:03:42'),
 (297,'EXTRAORDINARY CONQUERER','A Stunning Story of a Dog And a Feminist who must Face a Forensic Psychologist in Berlin',2006,1,NULL,6,'2.99',122,'29.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (298,'EYES DRIVING','A Thrilling Story of a Cat And a Waitress who must Fight a Explorer in The Outback',2006,1,NULL,4,'2.99',172,'13.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42'),
 (299,'FACTORY DRAGON','A Action-Packed Saga of a Teacher And a Frisbee who must Escape a Lumberjack in The Sahara Desert',2006,1,NULL,4,'0.99',144,'9.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (300,'FALCON VOLUME','A Fateful Saga of a Sumo Wrestler And a Hunter who must Redeem a A Shark in New Orleans',2006,1,NULL,5,'4.99',102,'21.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (301,'FAMILY SWEET','A Epic Documentary of a Teacher And a Boy who must Escape a Woman in Berlin',2006,1,NULL,4,'0.99',155,'24.99','R','Trailers','2006-02-15 05:03:42'),
 (302,'FANTASIA PARK','A Thoughtful Documentary of a Mad Scientist And a A Shark who must Outrace a Feminist in Australia',2006,1,NULL,5,'2.99',131,'29.99','G','Commentaries','2006-02-15 05:03:42'),
 (303,'FANTASY TROOPERS','A Touching Saga of a Teacher And a Monkey who must Overcome a Secret Agent in A MySQL Convention',2006,1,NULL,6,'0.99',58,'27.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (304,'FARGO GANDHI','A Thrilling Reflection of a Pastry Chef And a Crocodile who must Reach a Teacher in The Outback',2006,1,NULL,3,'2.99',130,'28.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (305,'FATAL HAUNTED','A Beautiful Drama of a Student And a Secret Agent who must Confront a Dentist in Ancient Japan',2006,1,NULL,6,'2.99',91,'24.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (306,'FEATHERS METAL','A Thoughtful Yarn of a Monkey And a Teacher who must Find a Dog in Australia',2006,1,NULL,3,'0.99',104,'12.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (307,'FELLOWSHIP AUTUMN','A Lacklusture Reflection of a Dentist And a Hunter who must Meet a Teacher in A Baloon',2006,1,NULL,6,'4.99',77,'9.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (308,'FERRIS MOTHER','A Touching Display of a Frisbee And a Frisbee who must Kill a Girl in The Gulf of Mexico',2006,1,NULL,3,'2.99',142,'13.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (309,'FEUD FROGMEN','A Brilliant Reflection of a Database Administrator And a Mad Cow who must Chase a Woman in The Canadian Rockies',2006,1,NULL,6,'0.99',98,'29.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (310,'FEVER EMPIRE','A Insightful Panorama of a Cat And a Boat who must Defeat a Boat in The Gulf of Mexico',2006,1,NULL,5,'4.99',158,'20.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (311,'FICTION CHRISTMAS','A Emotional Yarn of a A Shark And a Student who must Battle a Robot in An Abandoned Mine Shaft',2006,1,NULL,4,'0.99',72,'14.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (312,'FIDDLER LOST','A Boring Tale of a Squirrel And a Dog who must Challenge a Madman in The Gulf of Mexico',2006,1,NULL,4,'4.99',75,'20.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (313,'FIDELITY DEVIL','A Awe-Inspiring Drama of a Technical Writer And a Composer who must Reach a Pastry Chef in A U-Boat',2006,1,NULL,5,'4.99',118,'11.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (314,'FIGHT JAWBREAKER','A Intrepid Panorama of a Womanizer And a Girl who must Escape a Girl in A Manhattan Penthouse',2006,1,NULL,3,'0.99',91,'13.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (315,'FINDING ANACONDA','A Fateful Tale of a Database Administrator And a Girl who must Battle a Squirrel in New Orleans',2006,1,NULL,4,'0.99',156,'10.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (316,'FIRE WOLVES','A Intrepid Documentary of a Frisbee And a Dog who must Outrace a Lumberjack in Nigeria',2006,1,NULL,5,'4.99',173,'18.99','R','Trailers','2006-02-15 05:03:42'),
 (317,'FIREBALL PHILADELPHIA','A Amazing Yarn of a Dentist And a A Shark who must Vanquish a Madman in An Abandoned Mine Shaft',2006,1,NULL,4,'0.99',148,'25.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (318,'FIREHOUSE VIETNAM','A Awe-Inspiring Character Study of a Boat And a Boy who must Kill a Pastry Chef in The Sahara Desert',2006,1,NULL,7,'0.99',103,'14.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (319,'FISH OPUS','A Touching Display of a Feminist And a Girl who must Confront a Astronaut in Australia',2006,1,NULL,4,'2.99',125,'22.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (320,'FLAMINGOS CONNECTICUT','A Fast-Paced Reflection of a Composer And a Composer who must Meet a Cat in The Sahara Desert',2006,1,NULL,4,'4.99',80,'28.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (321,'FLASH WARS','A Astounding Saga of a Moose And a Pastry Chef who must Chase a Student in The Gulf of Mexico',2006,1,NULL,3,'4.99',123,'21.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (322,'FLATLINERS KILLER','A Taut Display of a Secret Agent And a Waitress who must Sink a Robot in An Abandoned Mine Shaft',2006,1,NULL,5,'2.99',100,'29.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (323,'FLIGHT LIES','A Stunning Character Study of a Crocodile And a Pioneer who must Pursue a Teacher in New Orleans',2006,1,NULL,7,'4.99',179,'22.99','R','Trailers','2006-02-15 05:03:42'),
 (324,'FLINTSTONES HAPPINESS','A Fateful Story of a Husband And a Moose who must Vanquish a Boy in California',2006,1,NULL,3,'4.99',148,'11.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (325,'FLOATS GARDEN','A Action-Packed Epistle of a Robot And a Car who must Chase a Boat in Ancient Japan',2006,1,NULL,6,'2.99',145,'29.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (326,'FLYING HOOK','A Thrilling Display of a Mad Cow And a Dog who must Challenge a Frisbee in Nigeria',2006,1,NULL,6,'2.99',69,'18.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (327,'FOOL MOCKINGBIRD','A Lacklusture Tale of a Crocodile And a Composer who must Defeat a Madman in A U-Boat',2006,1,NULL,3,'4.99',158,'24.99','PG','Trailers,Commentaries','2006-02-15 05:03:42'),
 (328,'FOREVER CANDIDATE','A Unbelieveable Panorama of a Technical Writer And a Man who must Pursue a Frisbee in A U-Boat',2006,1,NULL,7,'2.99',131,'28.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (329,'FORREST SONS','A Thrilling Documentary of a Forensic Psychologist And a Butler who must Defeat a Explorer in A Jet Boat',2006,1,NULL,4,'2.99',63,'15.99','R','Commentaries','2006-02-15 05:03:42'),
 (330,'FORRESTER COMANCHEROS','A Fateful Tale of a Squirrel And a Forensic Psychologist who must Redeem a Man in Nigeria',2006,1,NULL,7,'4.99',112,'22.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (331,'FORWARD TEMPLE','A Astounding Display of a Forensic Psychologist And a Mad Scientist who must Challenge a Girl in New Orleans',2006,1,NULL,6,'2.99',90,'25.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (332,'FRANKENSTEIN STRANGER','A Insightful Character Study of a Feminist And a Pioneer who must Pursue a Pastry Chef in Nigeria',2006,1,NULL,7,'0.99',159,'16.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (333,'FREAKY POCUS','A Fast-Paced Documentary of a Pastry Chef And a Crocodile who must Chase a Squirrel in The Gulf of Mexico',2006,1,NULL,7,'2.99',126,'16.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (334,'FREDDY STORM','A Intrepid Saga of a Man And a Lumberjack who must Vanquish a Husband in The Outback',2006,1,NULL,6,'4.99',65,'21.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (335,'FREEDOM CLEOPATRA','A Emotional Reflection of a Dentist And a Mad Cow who must Face a Squirrel in A Baloon',2006,1,NULL,5,'0.99',133,'23.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (336,'FRENCH HOLIDAY','A Thrilling Epistle of a Dog And a Feminist who must Kill a Madman in Berlin',2006,1,NULL,5,'4.99',99,'22.99','PG','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (337,'FRIDA SLIPPER','A Fateful Story of a Lumberjack And a Car who must Escape a Boat in An Abandoned Mine Shaft',2006,1,NULL,6,'2.99',73,'11.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (338,'FRISCO FORREST','A Beautiful Documentary of a Woman And a Pioneer who must Pursue a Mad Scientist in A Shark Tank',2006,1,NULL,6,'4.99',51,'23.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (339,'FROGMEN BREAKING','A Unbelieveable Yarn of a Mad Scientist And a Cat who must Chase a Lumberjack in Australia',2006,1,NULL,5,'0.99',111,'17.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (340,'FRONTIER CABIN','A Emotional Story of a Madman And a Waitress who must Battle a Teacher in An Abandoned Fun House',2006,1,NULL,6,'4.99',183,'14.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (341,'FROST HEAD','A Amazing Reflection of a Lumberjack And a Cat who must Discover a Husband in A MySQL Convention',2006,1,NULL,5,'0.99',82,'13.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (342,'FUGITIVE MAGUIRE','A Taut Epistle of a Feminist And a Sumo Wrestler who must Battle a Crocodile in Australia',2006,1,NULL,7,'4.99',83,'28.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (343,'FULL FLATLINERS','A Beautiful Documentary of a Astronaut And a Moose who must Pursue a Monkey in A Shark Tank',2006,1,NULL,6,'2.99',94,'14.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (344,'FURY MURDER','A Lacklusture Reflection of a Boat And a Forensic Psychologist who must Fight a Waitress in A Monastery',2006,1,NULL,3,'0.99',178,'28.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (345,'GABLES METROPOLIS','A Fateful Display of a Cat And a Pioneer who must Challenge a Pastry Chef in A Baloon Factory',2006,1,NULL,3,'0.99',161,'17.99','PG','Trailers,Commentaries','2006-02-15 05:03:42'),
 (346,'GALAXY SWEETHEARTS','A Emotional Reflection of a Womanizer And a Pioneer who must Face a Squirrel in Berlin',2006,1,NULL,4,'4.99',128,'13.99','R','Deleted Scenes','2006-02-15 05:03:42'),
 (347,'GAMES BOWFINGER','A Astounding Documentary of a Butler And a Explorer who must Challenge a Butler in A Monastery',2006,1,NULL,7,'4.99',119,'17.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (348,'GANDHI KWAI','A Thoughtful Display of a Mad Scientist And a Secret Agent who must Chase a Boat in Berlin',2006,1,NULL,7,'0.99',86,'9.99','PG-13','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (349,'GANGS PRIDE','A Taut Character Study of a Woman And a A Shark who must Confront a Frisbee in Berlin',2006,1,NULL,4,'2.99',185,'27.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (350,'GARDEN ISLAND','A Unbelieveable Character Study of a Womanizer And a Madman who must Reach a Man in The Outback',2006,1,NULL,3,'4.99',80,'21.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (351,'GASLIGHT CRUSADE','A Amazing Epistle of a Boy And a Astronaut who must Redeem a Man in The Gulf of Mexico',2006,1,NULL,4,'2.99',106,'10.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (352,'GATHERING CALENDAR','A Intrepid Tale of a Pioneer And a Moose who must Conquer a Frisbee in A MySQL Convention',2006,1,NULL,4,'0.99',176,'22.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (353,'GENTLEMEN STAGE','A Awe-Inspiring Reflection of a Monkey And a Student who must Overcome a Dentist in The First Manned Space Station',2006,1,NULL,6,'2.99',125,'22.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (354,'GHOST GROUNDHOG','A Brilliant Panorama of a Madman And a Composer who must Succumb a Car in Ancient India',2006,1,NULL,6,'4.99',85,'18.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (355,'GHOSTBUSTERS ELF','A Thoughtful Epistle of a Dog And a Feminist who must Chase a Composer in Berlin',2006,1,NULL,7,'0.99',101,'18.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (356,'GIANT TROOPERS','A Fateful Display of a Feminist And a Monkey who must Vanquish a Monkey in The Canadian Rockies',2006,1,NULL,5,'2.99',102,'10.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (357,'GILBERT PELICAN','A Fateful Tale of a Man And a Feminist who must Conquer a Crocodile in A Manhattan Penthouse',2006,1,NULL,7,'0.99',114,'13.99','G','Trailers,Commentaries','2006-02-15 05:03:42'),
 (358,'GILMORE BOILED','A Unbelieveable Documentary of a Boat And a Husband who must Succumb a Student in A U-Boat',2006,1,NULL,5,'0.99',163,'29.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (359,'GLADIATOR WESTWARD','A Astounding Reflection of a Squirrel And a Sumo Wrestler who must Sink a Dentist in Ancient Japan',2006,1,NULL,6,'4.99',173,'20.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (360,'GLASS DYING','A Astounding Drama of a Frisbee And a Astronaut who must Fight a Dog in Ancient Japan',2006,1,NULL,4,'0.99',103,'24.99','G','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (361,'GLEAMING JAWBREAKER','A Amazing Display of a Composer And a Forensic Psychologist who must Discover a Car in The Canadian Rockies',2006,1,NULL,5,'2.99',89,'25.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42'),
 (362,'GLORY TRACY','A Amazing Saga of a Woman And a Womanizer who must Discover a Cat in The First Manned Space Station',2006,1,NULL,7,'2.99',115,'13.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (363,'GO PURPLE','A Fast-Paced Display of a Car And a Database Administrator who must Battle a Woman in A Baloon',2006,1,NULL,3,'0.99',54,'12.99','R','Trailers','2006-02-15 05:03:42'),
 (364,'GODFATHER DIARY','A Stunning Saga of a Lumberjack And a Squirrel who must Chase a Car in The Outback',2006,1,NULL,3,'2.99',73,'14.99','NC-17','Trailers','2006-02-15 05:03:42'),
 (365,'GOLD RIVER','A Taut Documentary of a Database Administrator And a Waitress who must Reach a Mad Scientist in A Baloon Factory',2006,1,NULL,4,'4.99',154,'21.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (366,'GOLDFINGER SENSIBILITY','A Insightful Drama of a Mad Scientist And a Hunter who must Defeat a Pastry Chef in New Orleans',2006,1,NULL,3,'0.99',93,'29.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (367,'GOLDMINE TYCOON','A Brilliant Epistle of a Composer And a Frisbee who must Conquer a Husband in The Outback',2006,1,NULL,6,'0.99',153,'20.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (368,'GONE TROUBLE','A Insightful Character Study of a Mad Cow And a Forensic Psychologist who must Conquer a A Shark in A Manhattan Penthouse',2006,1,NULL,7,'2.99',84,'20.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (369,'GOODFELLAS SALUTE','A Unbelieveable Tale of a Dog And a Explorer who must Sink a Mad Cow in A Baloon Factory',2006,1,NULL,4,'4.99',56,'22.99','PG','Deleted Scenes','2006-02-15 05:03:42'),
 (370,'GORGEOUS BINGO','A Action-Packed Display of a Sumo Wrestler And a Car who must Overcome a Waitress in A Baloon Factory',2006,1,NULL,4,'2.99',108,'26.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (371,'GOSFORD DONNIE','A Epic Panorama of a Mad Scientist And a Monkey who must Redeem a Secret Agent in Berlin',2006,1,NULL,5,'4.99',129,'17.99','G','Commentaries','2006-02-15 05:03:42'),
 (372,'GRACELAND DYNAMITE','A Taut Display of a Cat And a Girl who must Overcome a Database Administrator in New Orleans',2006,1,NULL,5,'4.99',140,'26.99','R','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (373,'GRADUATE LORD','A Lacklusture Epistle of a Girl And a A Shark who must Meet a Mad Scientist in Ancient China',2006,1,NULL,7,'2.99',156,'14.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (374,'GRAFFITI LOVE','A Unbelieveable Epistle of a Sumo Wrestler And a Hunter who must Build a Composer in Berlin',2006,1,NULL,3,'0.99',117,'29.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (375,'GRAIL FRANKENSTEIN','A Unbelieveable Saga of a Teacher And a Monkey who must Fight a Girl in An Abandoned Mine Shaft',2006,1,NULL,4,'2.99',85,'17.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (376,'GRAPES FURY','A Boring Yarn of a Mad Cow And a Sumo Wrestler who must Meet a Robot in Australia',2006,1,NULL,4,'0.99',155,'20.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (377,'GREASE YOUTH','A Emotional Panorama of a Secret Agent And a Waitress who must Escape a Composer in Soviet Georgia',2006,1,NULL,7,'0.99',135,'20.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (378,'GREATEST NORTH','A Astounding Character Study of a Secret Agent And a Robot who must Build a A Shark in Berlin',2006,1,NULL,5,'2.99',93,'24.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (379,'GREEDY ROOTS','A Amazing Reflection of a A Shark And a Butler who must Chase a Hunter in The Canadian Rockies',2006,1,NULL,7,'0.99',166,'14.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (380,'GREEK EVERYONE','A Stunning Display of a Butler And a Teacher who must Confront a A Shark in The First Manned Space Station',2006,1,NULL,7,'2.99',176,'11.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (381,'GRINCH MASSAGE','A Intrepid Display of a Madman And a Feminist who must Pursue a Pioneer in The First Manned Space Station',2006,1,NULL,7,'4.99',150,'25.99','R','Trailers','2006-02-15 05:03:42'),
 (382,'GRIT CLOCKWORK','A Thoughtful Display of a Dentist And a Squirrel who must Confront a Lumberjack in A Shark Tank',2006,1,NULL,3,'0.99',137,'21.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (383,'GROOVE FICTION','A Unbelieveable Reflection of a Moose And a A Shark who must Defeat a Lumberjack in An Abandoned Mine Shaft',2006,1,NULL,6,'0.99',111,'13.99','NC-17','Behind the Scenes','2006-02-15 05:03:42'),
 (384,'GROSSE WONDERFUL','A Epic Drama of a Cat And a Explorer who must Redeem a Moose in Australia',2006,1,NULL,5,'4.99',49,'19.99','R','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (385,'GROUNDHOG UNCUT','A Brilliant Panorama of a Astronaut And a Technical Writer who must Discover a Butler in A Manhattan Penthouse',2006,1,NULL,6,'4.99',139,'26.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (386,'GUMP DATE','A Intrepid Yarn of a Explorer And a Student who must Kill a Husband in An Abandoned Mine Shaft',2006,1,NULL,3,'4.99',53,'12.99','NC-17','Deleted Scenes','2006-02-15 05:03:42'),
 (387,'GUN BONNIE','A Boring Display of a Sumo Wrestler And a Husband who must Build a Waitress in The Gulf of Mexico',2006,1,NULL,7,'0.99',100,'27.99','G','Behind the Scenes','2006-02-15 05:03:42'),
 (388,'GUNFIGHT MOON','A Epic Reflection of a Pastry Chef And a Explorer who must Reach a Dentist in The Sahara Desert',2006,1,NULL,5,'0.99',70,'16.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (389,'GUNFIGHTER MUSSOLINI','A Touching Saga of a Robot And a Boy who must Kill a Man in Ancient Japan',2006,1,NULL,3,'2.99',127,'9.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42'),
 (390,'GUYS FALCON','A Boring Story of a Woman And a Feminist who must Redeem a Squirrel in A U-Boat',2006,1,NULL,4,'4.99',84,'20.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (391,'HALF OUTFIELD','A Epic Epistle of a Database Administrator And a Crocodile who must Face a Madman in A Jet Boat',2006,1,NULL,6,'2.99',146,'25.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (392,'HALL CASSIDY','A Beautiful Panorama of a Pastry Chef And a A Shark who must Battle a Pioneer in Soviet Georgia',2006,1,NULL,5,'4.99',51,'13.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (393,'HALLOWEEN NUTS','A Amazing Panorama of a Forensic Psychologist And a Technical Writer who must Fight a Dentist in A U-Boat',2006,1,NULL,6,'2.99',47,'19.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (394,'HAMLET WISDOM','A Touching Reflection of a Man And a Man who must Sink a Robot in The Outback',2006,1,NULL,7,'2.99',146,'21.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (395,'HANDICAP BOONDOCK','A Beautiful Display of a Pioneer And a Squirrel who must Vanquish a Sumo Wrestler in Soviet Georgia',2006,1,NULL,4,'0.99',108,'28.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (396,'HANGING DEEP','A Action-Packed Yarn of a Boat And a Crocodile who must Build a Monkey in Berlin',2006,1,NULL,5,'4.99',62,'18.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (397,'HANKY OCTOBER','A Boring Epistle of a Database Administrator And a Explorer who must Pursue a Madman in Soviet Georgia',2006,1,NULL,5,'2.99',107,'26.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (398,'HANOVER GALAXY','A Stunning Reflection of a Girl And a Secret Agent who must Succumb a Boy in A MySQL Convention',2006,1,NULL,5,'4.99',47,'21.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (399,'HAPPINESS UNITED','A Action-Packed Panorama of a Husband And a Feminist who must Meet a Forensic Psychologist in Ancient Japan',2006,1,NULL,6,'2.99',100,'23.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (400,'HARDLY ROBBERS','A Emotional Character Study of a Hunter And a Car who must Kill a Woman in Berlin',2006,1,NULL,7,'2.99',72,'15.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (401,'HAROLD FRENCH','A Stunning Saga of a Sumo Wrestler And a Student who must Outrace a Moose in The Sahara Desert',2006,1,NULL,6,'0.99',168,'10.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (402,'HARPER DYING','A Awe-Inspiring Reflection of a Woman And a Cat who must Confront a Feminist in The Sahara Desert',2006,1,NULL,3,'0.99',52,'15.99','G','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (403,'HARRY IDAHO','A Taut Yarn of a Technical Writer And a Feminist who must Outrace a Dog in California',2006,1,NULL,5,'4.99',121,'18.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (404,'HATE HANDICAP','A Intrepid Reflection of a Mad Scientist And a Pioneer who must Overcome a Hunter in The First Manned Space Station',2006,1,NULL,4,'0.99',107,'26.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (405,'HAUNTED ANTITRUST','A Amazing Saga of a Man And a Dentist who must Reach a Technical Writer in Ancient India',2006,1,NULL,6,'4.99',76,'13.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (406,'HAUNTING PIANIST','A Fast-Paced Story of a Database Administrator And a Composer who must Defeat a Squirrel in An Abandoned Amusement Park',2006,1,NULL,5,'0.99',181,'22.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (407,'HAWK CHILL','A Action-Packed Drama of a Mad Scientist And a Composer who must Outgun a Car in Australia',2006,1,NULL,5,'0.99',47,'12.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (408,'HEAD STRANGER','A Thoughtful Saga of a Hunter And a Crocodile who must Confront a Dog in The Gulf of Mexico',2006,1,NULL,4,'4.99',69,'28.99','R','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (409,'HEARTBREAKERS BRIGHT','A Awe-Inspiring Documentary of a A Shark And a Dentist who must Outrace a Pastry Chef in The Canadian Rockies',2006,1,NULL,3,'4.99',59,'9.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (410,'HEAVEN FREEDOM','A Intrepid Story of a Butler And a Car who must Vanquish a Man in New Orleans',2006,1,NULL,7,'2.99',48,'19.99','PG','Commentaries','2006-02-15 05:03:42'),
 (411,'HEAVENLY GUN','A Beautiful Yarn of a Forensic Psychologist And a Frisbee who must Battle a Moose in A Jet Boat',2006,1,NULL,5,'4.99',49,'13.99','NC-17','Behind the Scenes','2006-02-15 05:03:42'),
 (412,'HEAVYWEIGHTS BEAST','A Unbelieveable Story of a Composer And a Dog who must Overcome a Womanizer in An Abandoned Amusement Park',2006,1,NULL,6,'4.99',102,'25.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (413,'HEDWIG ALTER','A Action-Packed Yarn of a Womanizer And a Lumberjack who must Chase a Sumo Wrestler in A Monastery',2006,1,NULL,7,'2.99',169,'16.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (414,'HELLFIGHTERS SIERRA','A Taut Reflection of a A Shark And a Dentist who must Battle a Boat in Soviet Georgia',2006,1,NULL,3,'2.99',75,'23.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (415,'HIGH ENCINO','A Fateful Saga of a Waitress And a Hunter who must Outrace a Sumo Wrestler in Australia',2006,1,NULL,3,'2.99',84,'23.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (416,'HIGHBALL POTTER','A Action-Packed Saga of a Husband And a Dog who must Redeem a Database Administrator in The Sahara Desert',2006,1,NULL,6,'0.99',110,'10.99','R','Deleted Scenes','2006-02-15 05:03:42'),
 (417,'HILLS NEIGHBORS','A Epic Display of a Hunter And a Feminist who must Sink a Car in A U-Boat',2006,1,NULL,5,'0.99',93,'29.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (418,'HOBBIT ALIEN','A Emotional Drama of a Husband And a Girl who must Outgun a Composer in The First Manned Space Station',2006,1,NULL,5,'0.99',157,'27.99','PG-13','Commentaries','2006-02-15 05:03:42'),
 (419,'HOCUS FRIDA','A Awe-Inspiring Tale of a Girl And a Madman who must Outgun a Student in A Shark Tank',2006,1,NULL,4,'2.99',141,'19.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (420,'HOLES BRANNIGAN','A Fast-Paced Reflection of a Technical Writer And a Student who must Fight a Boy in The Canadian Rockies',2006,1,NULL,7,'4.99',128,'27.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (421,'HOLIDAY GAMES','A Insightful Reflection of a Waitress And a Madman who must Pursue a Boy in Ancient Japan',2006,1,NULL,7,'4.99',78,'10.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (422,'HOLLOW JEOPARDY','A Beautiful Character Study of a Robot And a Astronaut who must Overcome a Boat in A Monastery',2006,1,NULL,7,'4.99',136,'25.99','NC-17','Behind the Scenes','2006-02-15 05:03:42'),
 (423,'HOLLYWOOD ANONYMOUS','A Fast-Paced Epistle of a Boy And a Explorer who must Escape a Dog in A U-Boat',2006,1,NULL,7,'0.99',69,'29.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (424,'HOLOCAUST HIGHBALL','A Awe-Inspiring Yarn of a Composer And a Man who must Find a Robot in Soviet Georgia',2006,1,NULL,6,'0.99',149,'12.99','R','Deleted Scenes','2006-02-15 05:03:42'),
 (425,'HOLY TADPOLE','A Action-Packed Display of a Feminist And a Pioneer who must Pursue a Dog in A Baloon Factory',2006,1,NULL,6,'0.99',88,'20.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (426,'HOME PITY','A Touching Panorama of a Man And a Secret Agent who must Challenge a Teacher in A MySQL Convention',2006,1,NULL,7,'4.99',185,'15.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (427,'HOMEWARD CIDER','A Taut Reflection of a Astronaut And a Squirrel who must Fight a Squirrel in A Manhattan Penthouse',2006,1,NULL,5,'0.99',103,'19.99','R','Trailers','2006-02-15 05:03:42'),
 (428,'HOMICIDE PEACH','A Astounding Documentary of a Hunter And a Boy who must Confront a Boy in A MySQL Convention',2006,1,NULL,6,'2.99',141,'21.99','PG-13','Commentaries','2006-02-15 05:03:42'),
 (429,'HONEY TIES','A Taut Story of a Waitress And a Crocodile who must Outrace a Lumberjack in A Shark Tank',2006,1,NULL,3,'0.99',84,'29.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (430,'HOOK CHARIOTS','A Insightful Story of a Boy And a Dog who must Redeem a Boy in Australia',2006,1,NULL,7,'0.99',49,'23.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (431,'HOOSIERS BIRDCAGE','A Astounding Display of a Explorer And a Boat who must Vanquish a Car in The First Manned Space Station',2006,1,NULL,3,'2.99',176,'12.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (432,'HOPE TOOTSIE','A Amazing Documentary of a Student And a Sumo Wrestler who must Outgun a A Shark in A Shark Tank',2006,1,NULL,4,'2.99',139,'22.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (433,'HORN WORKING','A Stunning Display of a Mad Scientist And a Technical Writer who must Succumb a Monkey in A Shark Tank',2006,1,NULL,4,'2.99',95,'23.99','PG','Trailers','2006-02-15 05:03:42'),
 (434,'HORROR REIGN','A Touching Documentary of a A Shark And a Car who must Build a Husband in Nigeria',2006,1,NULL,3,'0.99',139,'25.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (435,'HOTEL HAPPINESS','A Thrilling Yarn of a Pastry Chef And a A Shark who must Challenge a Mad Scientist in The Outback',2006,1,NULL,6,'4.99',181,'28.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (436,'HOURS RAGE','A Fateful Story of a Explorer And a Feminist who must Meet a Technical Writer in Soviet Georgia',2006,1,NULL,4,'0.99',122,'14.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (437,'HOUSE DYNAMITE','A Taut Story of a Pioneer And a Squirrel who must Battle a Student in Soviet Georgia',2006,1,NULL,7,'2.99',109,'13.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (438,'HUMAN GRAFFITI','A Beautiful Reflection of a Womanizer And a Sumo Wrestler who must Chase a Database Administrator in The Gulf of Mexico',2006,1,NULL,3,'2.99',68,'22.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (439,'HUNCHBACK IMPOSSIBLE','A Touching Yarn of a Frisbee And a Dentist who must Fight a Composer in Ancient Japan',2006,1,NULL,4,'4.99',151,'28.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (440,'HUNGER ROOF','A Unbelieveable Yarn of a Student And a Database Administrator who must Outgun a Husband in An Abandoned Mine Shaft',2006,1,NULL,6,'0.99',105,'21.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (441,'HUNTER ALTER','A Emotional Drama of a Mad Cow And a Boat who must Redeem a Secret Agent in A Shark Tank',2006,1,NULL,5,'2.99',125,'21.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (442,'HUNTING MUSKETEERS','A Thrilling Reflection of a Pioneer And a Dentist who must Outrace a Womanizer in An Abandoned Mine Shaft',2006,1,NULL,6,'2.99',65,'24.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (443,'HURRICANE AFFAIR','A Lacklusture Epistle of a Database Administrator And a Woman who must Meet a Hunter in An Abandoned Mine Shaft',2006,1,NULL,6,'2.99',49,'11.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (444,'HUSTLER PARTY','A Emotional Reflection of a Sumo Wrestler And a Monkey who must Conquer a Robot in The Sahara Desert',2006,1,NULL,3,'4.99',83,'22.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (445,'HYDE DOCTOR','A Fanciful Documentary of a Boy And a Woman who must Redeem a Womanizer in A Jet Boat',2006,1,NULL,5,'2.99',100,'11.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (446,'HYSTERICAL GRAIL','A Amazing Saga of a Madman And a Dentist who must Build a Car in A Manhattan Penthouse',2006,1,NULL,5,'4.99',150,'19.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (447,'ICE CROSSING','A Fast-Paced Tale of a Butler And a Moose who must Overcome a Pioneer in A Manhattan Penthouse',2006,1,NULL,5,'2.99',131,'28.99','R','Deleted Scenes','2006-02-15 05:03:42'),
 (448,'IDAHO LOVE','A Fast-Paced Drama of a Student And a Crocodile who must Meet a Database Administrator in The Outback',2006,1,NULL,3,'2.99',172,'25.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (449,'IDENTITY LOVER','A Boring Tale of a Composer And a Mad Cow who must Defeat a Car in The Outback',2006,1,NULL,4,'2.99',119,'12.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (450,'IDOLS SNATCHERS','A Insightful Drama of a Car And a Composer who must Fight a Man in A Monastery',2006,1,NULL,5,'2.99',84,'29.99','NC-17','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (451,'IGBY MAKER','A Epic Documentary of a Hunter And a Dog who must Outgun a Dog in A Baloon Factory',2006,1,NULL,7,'4.99',160,'12.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (452,'ILLUSION AMELIE','A Emotional Epistle of a Boat And a Mad Scientist who must Outrace a Robot in An Abandoned Mine Shaft',2006,1,NULL,4,'0.99',122,'15.99','R','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (453,'IMAGE PRINCESS','A Lacklusture Panorama of a Secret Agent And a Crocodile who must Discover a Madman in The Canadian Rockies',2006,1,NULL,3,'2.99',178,'17.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (454,'IMPACT ALADDIN','A Epic Character Study of a Frisbee And a Moose who must Outgun a Technical Writer in A Shark Tank',2006,1,NULL,6,'0.99',180,'20.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (455,'IMPOSSIBLE PREJUDICE','A Awe-Inspiring Yarn of a Monkey And a Hunter who must Chase a Teacher in Ancient China',2006,1,NULL,7,'4.99',103,'11.99','NC-17','Deleted Scenes','2006-02-15 05:03:42'),
 (456,'INCH JET','A Fateful Saga of a Womanizer And a Student who must Defeat a Butler in A Monastery',2006,1,NULL,6,'4.99',167,'18.99','NC-17','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (457,'INDEPENDENCE HOTEL','A Thrilling Tale of a Technical Writer And a Boy who must Face a Pioneer in A Monastery',2006,1,NULL,5,'0.99',157,'21.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (458,'INDIAN LOVE','A Insightful Saga of a Mad Scientist And a Mad Scientist who must Kill a Astronaut in An Abandoned Fun House',2006,1,NULL,4,'0.99',135,'26.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (459,'INFORMER DOUBLE','A Action-Packed Display of a Woman And a Dentist who must Redeem a Forensic Psychologist in The Canadian Rockies',2006,1,NULL,4,'4.99',74,'23.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42'),
 (460,'INNOCENT USUAL','A Beautiful Drama of a Pioneer And a Crocodile who must Challenge a Student in The Outback',2006,1,NULL,3,'4.99',178,'26.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (461,'INSECTS STONE','A Epic Display of a Butler And a Dog who must Vanquish a Crocodile in A Manhattan Penthouse',2006,1,NULL,3,'0.99',123,'14.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (462,'INSIDER ARIZONA','A Astounding Saga of a Mad Scientist And a Hunter who must Pursue a Robot in A Baloon Factory',2006,1,NULL,5,'2.99',78,'17.99','NC-17','Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (463,'INSTINCT AIRPORT','A Touching Documentary of a Mad Cow And a Explorer who must Confront a Butler in A Manhattan Penthouse',2006,1,NULL,4,'2.99',116,'21.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (464,'INTENTIONS EMPIRE','A Astounding Epistle of a Cat And a Cat who must Conquer a Mad Cow in A U-Boat',2006,1,NULL,3,'2.99',107,'13.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (465,'INTERVIEW LIAISONS','A Action-Packed Reflection of a Student And a Butler who must Discover a Database Administrator in A Manhattan Penthouse',2006,1,NULL,4,'4.99',59,'17.99','R','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (466,'INTOLERABLE INTENTIONS','A Awe-Inspiring Story of a Monkey And a Pastry Chef who must Succumb a Womanizer in A MySQL Convention',2006,1,NULL,6,'4.99',63,'20.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (467,'INTRIGUE WORST','A Fanciful Character Study of a Explorer And a Mad Scientist who must Vanquish a Squirrel in A Jet Boat',2006,1,NULL,6,'0.99',181,'10.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (468,'INVASION CYCLONE','A Lacklusture Character Study of a Mad Scientist And a Womanizer who must Outrace a Explorer in A Monastery',2006,1,NULL,5,'2.99',97,'12.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (469,'IRON MOON','A Fast-Paced Documentary of a Mad Cow And a Boy who must Pursue a Dentist in A Baloon',2006,1,NULL,7,'4.99',46,'27.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (470,'ISHTAR ROCKETEER','A Astounding Saga of a Dog And a Squirrel who must Conquer a Dog in An Abandoned Fun House',2006,1,NULL,4,'4.99',79,'24.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (471,'ISLAND EXORCIST','A Fanciful Panorama of a Technical Writer And a Boy who must Find a Dentist in An Abandoned Fun House',2006,1,NULL,7,'2.99',84,'23.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42'),
 (472,'ITALIAN AFRICAN','A Astounding Character Study of a Monkey And a Moose who must Outgun a Cat in A U-Boat',2006,1,NULL,3,'4.99',174,'24.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (473,'JACKET FRISCO','A Insightful Reflection of a Womanizer And a Husband who must Conquer a Pastry Chef in A Baloon',2006,1,NULL,5,'2.99',181,'16.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (474,'JADE BUNCH','A Insightful Panorama of a Squirrel And a Mad Cow who must Confront a Student in The First Manned Space Station',2006,1,NULL,6,'2.99',174,'21.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (475,'JAPANESE RUN','A Awe-Inspiring Epistle of a Feminist And a Girl who must Sink a Girl in The Outback',2006,1,NULL,6,'0.99',135,'29.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (476,'JASON TRAP','A Thoughtful Tale of a Woman And a A Shark who must Conquer a Dog in A Monastery',2006,1,NULL,5,'2.99',130,'9.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (477,'JAWBREAKER BROOKLYN','A Stunning Reflection of a Boat And a Pastry Chef who must Succumb a A Shark in A Jet Boat',2006,1,NULL,5,'0.99',118,'15.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (478,'JAWS HARRY','A Thrilling Display of a Database Administrator And a Monkey who must Overcome a Dog in An Abandoned Fun House',2006,1,NULL,4,'2.99',112,'10.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (479,'JEDI BENEATH','A Astounding Reflection of a Explorer And a Dentist who must Pursue a Student in Nigeria',2006,1,NULL,7,'0.99',128,'12.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (480,'JEEPERS WEDDING','A Astounding Display of a Composer And a Dog who must Kill a Pastry Chef in Soviet Georgia',2006,1,NULL,3,'2.99',84,'29.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (481,'JEKYLL FROGMEN','A Fanciful Epistle of a Student And a Astronaut who must Kill a Waitress in A Shark Tank',2006,1,NULL,4,'2.99',58,'22.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (482,'JEOPARDY ENCINO','A Boring Panorama of a Man And a Mad Cow who must Face a Explorer in Ancient India',2006,1,NULL,3,'0.99',102,'12.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (483,'JERICHO MULAN','A Amazing Yarn of a Hunter And a Butler who must Defeat a Boy in A Jet Boat',2006,1,NULL,3,'2.99',171,'29.99','NC-17','Commentaries','2006-02-15 05:03:42'),
 (484,'JERK PAYCHECK','A Touching Character Study of a Pastry Chef And a Database Administrator who must Reach a A Shark in Ancient Japan',2006,1,NULL,3,'2.99',172,'13.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (485,'JERSEY SASSY','A Lacklusture Documentary of a Madman And a Mad Cow who must Find a Feminist in Ancient Japan',2006,1,NULL,6,'4.99',60,'16.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (486,'JET NEIGHBORS','A Amazing Display of a Lumberjack And a Teacher who must Outrace a Woman in A U-Boat',2006,1,NULL,7,'4.99',59,'14.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (487,'JINGLE SAGEBRUSH','A Epic Character Study of a Feminist And a Student who must Meet a Woman in A Baloon',2006,1,NULL,6,'4.99',124,'29.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42'),
 (488,'JOON NORTHWEST','A Thrilling Panorama of a Technical Writer And a Car who must Discover a Forensic Psychologist in A Shark Tank',2006,1,NULL,3,'0.99',105,'23.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (489,'JUGGLER HARDLY','A Epic Story of a Mad Cow And a Astronaut who must Challenge a Car in California',2006,1,NULL,4,'0.99',54,'14.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42'),
 (490,'JUMANJI BLADE','A Intrepid Yarn of a Husband And a Womanizer who must Pursue a Mad Scientist in New Orleans',2006,1,NULL,4,'2.99',121,'13.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (491,'JUMPING WRATH','A Touching Epistle of a Monkey And a Feminist who must Discover a Boat in Berlin',2006,1,NULL,4,'0.99',74,'18.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (492,'JUNGLE CLOSER','A Boring Character Study of a Boy And a Woman who must Battle a Astronaut in Australia',2006,1,NULL,6,'0.99',134,'11.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (493,'KANE EXORCIST','A Epic Documentary of a Composer And a Robot who must Overcome a Car in Berlin',2006,1,NULL,5,'0.99',92,'18.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (494,'KARATE MOON','A Astounding Yarn of a Womanizer And a Dog who must Reach a Waitress in A MySQL Convention',2006,1,NULL,4,'0.99',120,'21.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (495,'KENTUCKIAN GIANT','A Stunning Yarn of a Woman And a Frisbee who must Escape a Waitress in A U-Boat',2006,1,NULL,5,'2.99',169,'10.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (496,'KICK SAVANNAH','A Emotional Drama of a Monkey And a Robot who must Defeat a Monkey in New Orleans',2006,1,NULL,3,'0.99',179,'10.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (497,'KILL BROTHERHOOD','A Touching Display of a Hunter And a Secret Agent who must Redeem a Husband in The Outback',2006,1,NULL,4,'0.99',54,'15.99','G','Trailers,Commentaries','2006-02-15 05:03:42'),
 (498,'KILLER INNOCENT','A Fanciful Character Study of a Student And a Explorer who must Succumb a Composer in An Abandoned Mine Shaft',2006,1,NULL,7,'2.99',161,'11.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (499,'KING EVOLUTION','A Action-Packed Tale of a Boy And a Lumberjack who must Chase a Madman in A Baloon',2006,1,NULL,3,'4.99',184,'24.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (500,'KISS GLORY','A Lacklusture Reflection of a Girl And a Husband who must Find a Robot in The Canadian Rockies',2006,1,NULL,5,'4.99',163,'11.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (501,'KISSING DOLLS','A Insightful Reflection of a Pioneer And a Teacher who must Build a Composer in The First Manned Space Station',2006,1,NULL,3,'4.99',141,'9.99','R','Trailers','2006-02-15 05:03:42'),
 (502,'KNOCK WARLOCK','A Unbelieveable Story of a Teacher And a Boat who must Confront a Moose in A Baloon',2006,1,NULL,4,'2.99',71,'21.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (503,'KRAMER CHOCOLATE','A Amazing Yarn of a Robot And a Pastry Chef who must Redeem a Mad Scientist in The Outback',2006,1,NULL,3,'2.99',171,'24.99','R','Trailers','2006-02-15 05:03:42'),
 (504,'KWAI HOMEWARD','A Amazing Drama of a Car And a Squirrel who must Pursue a Car in Soviet Georgia',2006,1,NULL,5,'0.99',46,'25.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (505,'LABYRINTH LEAGUE','A Awe-Inspiring Saga of a Composer And a Frisbee who must Succumb a Pioneer in The Sahara Desert',2006,1,NULL,6,'2.99',46,'24.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (506,'LADY STAGE','A Beautiful Character Study of a Woman And a Man who must Pursue a Explorer in A U-Boat',2006,1,NULL,4,'4.99',67,'14.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (507,'LADYBUGS ARMAGEDDON','A Fateful Reflection of a Dog And a Mad Scientist who must Meet a Mad Scientist in New Orleans',2006,1,NULL,4,'0.99',113,'13.99','NC-17','Deleted Scenes','2006-02-15 05:03:42'),
 (508,'LAMBS CINCINATTI','A Insightful Story of a Man And a Feminist who must Fight a Composer in Australia',2006,1,NULL,6,'4.99',144,'18.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (509,'LANGUAGE COWBOY','A Epic Yarn of a Cat And a Madman who must Vanquish a Dentist in An Abandoned Amusement Park',2006,1,NULL,5,'0.99',78,'26.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (510,'LAWLESS VISION','A Insightful Yarn of a Boy And a Sumo Wrestler who must Outgun a Car in The Outback',2006,1,NULL,6,'4.99',181,'29.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (511,'LAWRENCE LOVE','A Fanciful Yarn of a Database Administrator And a Mad Cow who must Pursue a Womanizer in Berlin',2006,1,NULL,7,'0.99',175,'23.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (512,'LEAGUE HELLFIGHTERS','A Thoughtful Saga of a A Shark And a Monkey who must Outgun a Student in Ancient China',2006,1,NULL,5,'4.99',110,'25.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (513,'LEATHERNECKS DWARFS','A Fateful Reflection of a Dog And a Mad Cow who must Outrace a Teacher in An Abandoned Mine Shaft',2006,1,NULL,6,'2.99',153,'21.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (514,'LEBOWSKI SOLDIERS','A Beautiful Epistle of a Secret Agent And a Pioneer who must Chase a Astronaut in Ancient China',2006,1,NULL,6,'2.99',69,'17.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (515,'LEGALLY SECRETARY','A Astounding Tale of a A Shark And a Moose who must Meet a Womanizer in The Sahara Desert',2006,1,NULL,7,'4.99',113,'14.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (516,'LEGEND JEDI','A Awe-Inspiring Epistle of a Pioneer And a Student who must Outgun a Crocodile in The Outback',2006,1,NULL,7,'0.99',59,'18.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (517,'LESSON CLEOPATRA','A Emotional Display of a Man And a Explorer who must Build a Boy in A Manhattan Penthouse',2006,1,NULL,3,'0.99',167,'28.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (518,'LIAISONS SWEET','A Boring Drama of a A Shark And a Explorer who must Redeem a Waitress in The Canadian Rockies',2006,1,NULL,5,'4.99',140,'15.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (519,'LIBERTY MAGNIFICENT','A Boring Drama of a Student And a Cat who must Sink a Technical Writer in A Baloon',2006,1,NULL,3,'2.99',138,'27.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (520,'LICENSE WEEKEND','A Insightful Story of a Man And a Husband who must Overcome a Madman in A Monastery',2006,1,NULL,7,'2.99',91,'28.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (521,'LIES TREATMENT','A Fast-Paced Character Study of a Dentist And a Moose who must Defeat a Composer in The First Manned Space Station',2006,1,NULL,7,'4.99',147,'28.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (522,'LIFE TWISTED','A Thrilling Reflection of a Teacher And a Composer who must Find a Man in The First Manned Space Station',2006,1,NULL,4,'2.99',137,'9.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (523,'LIGHTS DEER','A Unbelieveable Epistle of a Dog And a Woman who must Confront a Moose in The Gulf of Mexico',2006,1,NULL,7,'0.99',174,'21.99','R','Commentaries','2006-02-15 05:03:42'),
 (524,'LION UNCUT','A Intrepid Display of a Pastry Chef And a Cat who must Kill a A Shark in Ancient China',2006,1,NULL,6,'0.99',50,'13.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (525,'LOATHING LEGALLY','A Boring Epistle of a Pioneer And a Mad Scientist who must Escape a Frisbee in The Gulf of Mexico',2006,1,NULL,4,'0.99',140,'29.99','R','Deleted Scenes','2006-02-15 05:03:42'),
 (526,'LOCK REAR','A Thoughtful Character Study of a Squirrel And a Technical Writer who must Outrace a Student in Ancient Japan',2006,1,NULL,7,'2.99',120,'10.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (527,'LOLA AGENT','A Astounding Tale of a Mad Scientist And a Husband who must Redeem a Database Administrator in Ancient Japan',2006,1,NULL,4,'4.99',85,'24.99','PG','Trailers,Commentaries','2006-02-15 05:03:42'),
 (528,'LOLITA WORLD','A Thrilling Drama of a Girl And a Robot who must Redeem a Waitress in An Abandoned Mine Shaft',2006,1,NULL,4,'2.99',155,'25.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (529,'LONELY ELEPHANT','A Intrepid Story of a Student And a Dog who must Challenge a Explorer in Soviet Georgia',2006,1,NULL,3,'2.99',67,'12.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (530,'LORD ARIZONA','A Action-Packed Display of a Frisbee And a Pastry Chef who must Pursue a Crocodile in A Jet Boat',2006,1,NULL,5,'2.99',108,'27.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (531,'LOSE INCH','A Stunning Reflection of a Student And a Technical Writer who must Battle a Butler in The First Manned Space Station',2006,1,NULL,3,'0.99',137,'18.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (532,'LOSER HUSTLER','A Stunning Drama of a Robot And a Feminist who must Outgun a Butler in Nigeria',2006,1,NULL,5,'4.99',80,'28.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (533,'LOST BIRD','A Emotional Character Study of a Robot And a A Shark who must Defeat a Technical Writer in A Manhattan Penthouse',2006,1,NULL,4,'2.99',98,'21.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (534,'LOUISIANA HARRY','A Lacklusture Drama of a Girl And a Technical Writer who must Redeem a Monkey in A Shark Tank',2006,1,NULL,5,'0.99',70,'18.99','PG-13','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (535,'LOVE SUICIDES','A Brilliant Panorama of a Hunter And a Explorer who must Pursue a Dentist in An Abandoned Fun House',2006,1,NULL,6,'0.99',181,'21.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (536,'LOVELY JINGLE','A Fanciful Yarn of a Crocodile And a Forensic Psychologist who must Discover a Crocodile in The Outback',2006,1,NULL,3,'2.99',65,'18.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (537,'LOVER TRUMAN','A Emotional Yarn of a Robot And a Boy who must Outgun a Technical Writer in A U-Boat',2006,1,NULL,3,'2.99',75,'29.99','G','Trailers','2006-02-15 05:03:42'),
 (538,'LOVERBOY ATTACKS','A Boring Story of a Car And a Butler who must Build a Girl in Soviet Georgia',2006,1,NULL,7,'0.99',162,'19.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (539,'LUCK OPUS','A Boring Display of a Moose And a Squirrel who must Outrace a Teacher in A Shark Tank',2006,1,NULL,7,'2.99',152,'21.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (540,'LUCKY FLYING','A Lacklusture Character Study of a A Shark And a Man who must Find a Forensic Psychologist in A U-Boat',2006,1,NULL,7,'2.99',97,'10.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (541,'LUKE MUMMY','A Taut Character Study of a Boy And a Robot who must Redeem a Mad Scientist in Ancient India',2006,1,NULL,5,'2.99',74,'21.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (542,'LUST LOCK','A Fanciful Panorama of a Hunter And a Dentist who must Meet a Secret Agent in The Sahara Desert',2006,1,NULL,3,'2.99',52,'28.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (543,'MADIGAN DORADO','A Astounding Character Study of a A Shark And a A Shark who must Discover a Crocodile in The Outback',2006,1,NULL,5,'4.99',116,'20.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (544,'MADISON TRAP','A Awe-Inspiring Reflection of a Monkey And a Dentist who must Overcome a Pioneer in A U-Boat',2006,1,NULL,4,'2.99',147,'11.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (545,'MADNESS ATTACKS','A Fanciful Tale of a Squirrel And a Boat who must Defeat a Crocodile in The Gulf of Mexico',2006,1,NULL,4,'0.99',178,'14.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (546,'MADRE GABLES','A Intrepid Panorama of a Sumo Wrestler And a Forensic Psychologist who must Discover a Moose in The First Manned Space Station',2006,1,NULL,7,'2.99',98,'27.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (547,'MAGIC MALLRATS','A Touching Documentary of a Pastry Chef And a Pastry Chef who must Build a Mad Scientist in California',2006,1,NULL,3,'0.99',117,'19.99','PG','Trailers,Commentaries','2006-02-15 05:03:42'),
 (548,'MAGNIFICENT CHITTY','A Insightful Story of a Teacher And a Hunter who must Face a Mad Cow in California',2006,1,NULL,3,'2.99',53,'27.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (549,'MAGNOLIA FORRESTER','A Thoughtful Documentary of a Composer And a Explorer who must Conquer a Dentist in New Orleans',2006,1,NULL,4,'0.99',171,'28.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (550,'MAGUIRE APACHE','A Fast-Paced Reflection of a Waitress And a Hunter who must Defeat a Forensic Psychologist in A Baloon',2006,1,NULL,6,'2.99',74,'22.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42'),
 (551,'MAIDEN HOME','A Lacklusture Saga of a Moose And a Teacher who must Kill a Forensic Psychologist in A MySQL Convention',2006,1,NULL,3,'4.99',138,'9.99','PG','Behind the Scenes','2006-02-15 05:03:42'),
 (552,'MAJESTIC FLOATS','A Thrilling Character Study of a Moose And a Student who must Escape a Butler in The First Manned Space Station',2006,1,NULL,5,'0.99',130,'15.99','PG','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (553,'MAKER GABLES','A Stunning Display of a Moose And a Database Administrator who must Pursue a Composer in A Jet Boat',2006,1,NULL,4,'0.99',136,'12.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (554,'MALKOVICH PET','A Intrepid Reflection of a Waitress And a A Shark who must Kill a Squirrel in The Outback',2006,1,NULL,6,'2.99',159,'22.99','G','Behind the Scenes','2006-02-15 05:03:42'),
 (555,'MALLRATS UNITED','A Thrilling Yarn of a Waitress And a Dentist who must Find a Hunter in A Monastery',2006,1,NULL,4,'0.99',133,'25.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (556,'MALTESE HOPE','A Fast-Paced Documentary of a Crocodile And a Sumo Wrestler who must Conquer a Explorer in California',2006,1,NULL,6,'4.99',127,'26.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (557,'MANCHURIAN CURTAIN','A Stunning Tale of a Mad Cow And a Boy who must Battle a Boy in Berlin',2006,1,NULL,5,'2.99',177,'27.99','PG','Trailers,Commentaries','2006-02-15 05:03:42'),
 (558,'MANNEQUIN WORST','A Astounding Saga of a Mad Cow And a Pastry Chef who must Discover a Husband in Ancient India',2006,1,NULL,3,'2.99',71,'18.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (559,'MARRIED GO','A Fanciful Story of a Womanizer And a Dog who must Face a Forensic Psychologist in The Sahara Desert',2006,1,NULL,7,'2.99',114,'22.99','G','Behind the Scenes','2006-02-15 05:03:42'),
 (560,'MARS ROMAN','A Boring Drama of a Car And a Dog who must Succumb a Madman in Soviet Georgia',2006,1,NULL,6,'0.99',62,'21.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (561,'MASK PEACH','A Boring Character Study of a Student And a Robot who must Meet a Woman in California',2006,1,NULL,6,'2.99',123,'26.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (562,'MASKED BUBBLE','A Fanciful Documentary of a Pioneer And a Boat who must Pursue a Pioneer in An Abandoned Mine Shaft',2006,1,NULL,6,'0.99',151,'12.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (563,'MASSACRE USUAL','A Fateful Reflection of a Waitress And a Crocodile who must Challenge a Forensic Psychologist in California',2006,1,NULL,6,'4.99',165,'16.99','R','Commentaries','2006-02-15 05:03:42'),
 (564,'MASSAGE IMAGE','A Fateful Drama of a Frisbee And a Crocodile who must Vanquish a Dog in The First Manned Space Station',2006,1,NULL,4,'2.99',161,'11.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (565,'MATRIX SNOWMAN','A Action-Packed Saga of a Womanizer And a Woman who must Overcome a Student in California',2006,1,NULL,6,'4.99',56,'9.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (566,'MAUDE MOD','A Beautiful Documentary of a Forensic Psychologist And a Cat who must Reach a Astronaut in Nigeria',2006,1,NULL,6,'0.99',72,'20.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (567,'MEET CHOCOLATE','A Boring Documentary of a Dentist And a Butler who must Confront a Monkey in A MySQL Convention',2006,1,NULL,3,'2.99',80,'26.99','G','Trailers','2006-02-15 05:03:42'),
 (568,'MEMENTO ZOOLANDER','A Touching Epistle of a Squirrel And a Explorer who must Redeem a Pastry Chef in The Sahara Desert',2006,1,NULL,4,'4.99',77,'11.99','NC-17','Behind the Scenes','2006-02-15 05:03:42'),
 (569,'MENAGERIE RUSHMORE','A Unbelieveable Panorama of a Composer And a Butler who must Overcome a Database Administrator in The First Manned Space Station',2006,1,NULL,7,'2.99',147,'18.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (570,'MERMAID INSECTS','A Lacklusture Drama of a Waitress And a Husband who must Fight a Husband in California',2006,1,NULL,5,'4.99',104,'20.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (571,'METAL ARMAGEDDON','A Thrilling Display of a Lumberjack And a Crocodile who must Meet a Monkey in A Baloon Factory',2006,1,NULL,6,'2.99',161,'26.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (572,'METROPOLIS COMA','A Emotional Saga of a Database Administrator And a Pastry Chef who must Confront a Teacher in A Baloon Factory',2006,1,NULL,4,'2.99',64,'9.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (573,'MICROCOSMOS PARADISE','A Touching Character Study of a Boat And a Student who must Sink a A Shark in Nigeria',2006,1,NULL,6,'2.99',105,'22.99','PG-13','Commentaries','2006-02-15 05:03:42'),
 (574,'MIDNIGHT WESTWARD','A Taut Reflection of a Husband And a A Shark who must Redeem a Pastry Chef in A Monastery',2006,1,NULL,3,'0.99',86,'19.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (575,'MIDSUMMER GROUNDHOG','A Fateful Panorama of a Moose And a Dog who must Chase a Crocodile in Ancient Japan',2006,1,NULL,3,'4.99',48,'27.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (576,'MIGHTY LUCK','A Astounding Epistle of a Mad Scientist And a Pioneer who must Escape a Database Administrator in A MySQL Convention',2006,1,NULL,7,'2.99',122,'13.99','PG','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (577,'MILE MULAN','A Lacklusture Epistle of a Cat And a Husband who must Confront a Boy in A MySQL Convention',2006,1,NULL,4,'0.99',64,'10.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (578,'MILLION ACE','A Brilliant Documentary of a Womanizer And a Squirrel who must Find a Technical Writer in The Sahara Desert',2006,1,NULL,4,'4.99',142,'16.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (579,'MINDS TRUMAN','A Taut Yarn of a Mad Scientist And a Crocodile who must Outgun a Database Administrator in A Monastery',2006,1,NULL,3,'4.99',149,'22.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (580,'MINE TITANS','A Amazing Yarn of a Robot And a Womanizer who must Discover a Forensic Psychologist in Berlin',2006,1,NULL,3,'4.99',166,'12.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (581,'MINORITY KISS','A Insightful Display of a Lumberjack And a Sumo Wrestler who must Meet a Man in The Outback',2006,1,NULL,4,'0.99',59,'16.99','G','Trailers','2006-02-15 05:03:42'),
 (582,'MIRACLE VIRTUAL','A Touching Epistle of a Butler And a Boy who must Find a Mad Scientist in The Sahara Desert',2006,1,NULL,3,'2.99',162,'19.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (583,'MISSION ZOOLANDER','A Intrepid Story of a Sumo Wrestler And a Teacher who must Meet a A Shark in An Abandoned Fun House',2006,1,NULL,3,'4.99',164,'26.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (584,'MIXED DOORS','A Taut Drama of a Womanizer And a Lumberjack who must Succumb a Pioneer in Ancient India',2006,1,NULL,6,'2.99',180,'26.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (585,'MOB DUFFEL','A Unbelieveable Documentary of a Frisbee And a Boat who must Meet a Boy in The Canadian Rockies',2006,1,NULL,4,'0.99',105,'25.99','G','Trailers','2006-02-15 05:03:42'),
 (586,'MOCKINGBIRD HOLLYWOOD','A Thoughtful Panorama of a Man And a Car who must Sink a Composer in Berlin',2006,1,NULL,4,'0.99',60,'27.99','PG','Behind the Scenes','2006-02-15 05:03:42'),
 (587,'MOD SECRETARY','A Boring Documentary of a Mad Cow And a Cat who must Build a Lumberjack in New Orleans',2006,1,NULL,6,'4.99',77,'20.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (588,'MODEL FISH','A Beautiful Panorama of a Boat And a Crocodile who must Outrace a Dog in Australia',2006,1,NULL,4,'4.99',175,'11.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (589,'MODERN DORADO','A Awe-Inspiring Story of a Butler And a Sumo Wrestler who must Redeem a Boy in New Orleans',2006,1,NULL,3,'0.99',74,'20.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (590,'MONEY HAROLD','A Touching Tale of a Explorer And a Boat who must Defeat a Robot in Australia',2006,1,NULL,3,'2.99',135,'17.99','PG','Trailers,Commentaries','2006-02-15 05:03:42'),
 (591,'MONSOON CAUSE','A Astounding Tale of a Crocodile And a Car who must Outrace a Squirrel in A U-Boat',2006,1,NULL,6,'4.99',182,'20.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (592,'MONSTER SPARTACUS','A Fast-Paced Story of a Waitress And a Cat who must Fight a Girl in Australia',2006,1,NULL,6,'2.99',107,'28.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (593,'MONTEREY LABYRINTH','A Awe-Inspiring Drama of a Monkey And a Composer who must Escape a Feminist in A U-Boat',2006,1,NULL,6,'0.99',158,'13.99','G','Trailers,Commentaries','2006-02-15 05:03:42'),
 (594,'MONTEZUMA COMMAND','A Thrilling Reflection of a Waitress And a Butler who must Battle a Butler in A Jet Boat',2006,1,NULL,6,'0.99',126,'22.99','NC-17','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (595,'MOON BUNCH','A Beautiful Tale of a Astronaut And a Mad Cow who must Challenge a Cat in A Baloon Factory',2006,1,NULL,7,'0.99',83,'20.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (596,'MOONSHINE CABIN','A Thoughtful Display of a Astronaut And a Feminist who must Chase a Frisbee in A Jet Boat',2006,1,NULL,4,'4.99',171,'25.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (597,'MOONWALKER FOOL','A Epic Drama of a Feminist And a Pioneer who must Sink a Composer in New Orleans',2006,1,NULL,5,'4.99',184,'12.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (598,'MOSQUITO ARMAGEDDON','A Thoughtful Character Study of a Waitress And a Feminist who must Build a Teacher in Ancient Japan',2006,1,NULL,6,'0.99',57,'22.99','G','Trailers','2006-02-15 05:03:42'),
 (599,'MOTHER OLEANDER','A Boring Tale of a Husband And a Boy who must Fight a Squirrel in Ancient China',2006,1,NULL,3,'0.99',103,'20.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (600,'MOTIONS DETAILS','A Awe-Inspiring Reflection of a Dog And a Student who must Kill a Car in An Abandoned Fun House',2006,1,NULL,5,'0.99',166,'16.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (601,'MOULIN WAKE','A Astounding Story of a Forensic Psychologist And a Cat who must Battle a Teacher in An Abandoned Mine Shaft',2006,1,NULL,4,'0.99',79,'20.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (602,'MOURNING PURPLE','A Lacklusture Display of a Waitress And a Lumberjack who must Chase a Pioneer in New Orleans',2006,1,NULL,5,'0.99',146,'14.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (603,'MOVIE SHAKESPEARE','A Insightful Display of a Database Administrator And a Student who must Build a Hunter in Berlin',2006,1,NULL,6,'4.99',53,'27.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (604,'MULAN MOON','A Emotional Saga of a Womanizer And a Pioneer who must Overcome a Dentist in A Baloon',2006,1,NULL,4,'0.99',160,'10.99','G','Behind the Scenes','2006-02-15 05:03:42'),
 (605,'MULHOLLAND BEAST','A Awe-Inspiring Display of a Husband And a Squirrel who must Battle a Sumo Wrestler in A Jet Boat',2006,1,NULL,7,'2.99',157,'13.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (606,'MUMMY CREATURES','A Fateful Character Study of a Crocodile And a Monkey who must Meet a Dentist in Australia',2006,1,NULL,3,'0.99',160,'15.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (607,'MUPPET MILE','A Lacklusture Story of a Madman And a Teacher who must Kill a Frisbee in The Gulf of Mexico',2006,1,NULL,5,'4.99',50,'18.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (608,'MURDER ANTITRUST','A Brilliant Yarn of a Car And a Database Administrator who must Escape a Boy in A MySQL Convention',2006,1,NULL,6,'2.99',166,'11.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (609,'MUSCLE BRIGHT','A Stunning Panorama of a Sumo Wrestler And a Husband who must Redeem a Madman in Ancient India',2006,1,NULL,7,'2.99',185,'23.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (610,'MUSIC BOONDOCK','A Thrilling Tale of a Butler And a Astronaut who must Battle a Explorer in The First Manned Space Station',2006,1,NULL,7,'0.99',129,'17.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (611,'MUSKETEERS WAIT','A Touching Yarn of a Student And a Moose who must Fight a Mad Cow in Australia',2006,1,NULL,7,'4.99',73,'17.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (612,'MUSSOLINI SPOILERS','A Thrilling Display of a Boat And a Monkey who must Meet a Composer in Ancient China',2006,1,NULL,6,'2.99',180,'10.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (613,'MYSTIC TRUMAN','A Epic Yarn of a Teacher And a Hunter who must Outgun a Explorer in Soviet Georgia',2006,1,NULL,5,'0.99',92,'19.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (614,'NAME DETECTIVE','A Touching Saga of a Sumo Wrestler And a Cat who must Pursue a Mad Scientist in Nigeria',2006,1,NULL,5,'4.99',178,'11.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (615,'NASH CHOCOLAT','A Epic Reflection of a Monkey And a Mad Cow who must Kill a Forensic Psychologist in An Abandoned Mine Shaft',2006,1,NULL,6,'2.99',180,'21.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (616,'NATIONAL STORY','A Taut Epistle of a Mad Scientist And a Girl who must Escape a Monkey in California',2006,1,NULL,4,'2.99',92,'19.99','NC-17','Trailers','2006-02-15 05:03:42'),
 (617,'NATURAL STOCK','A Fast-Paced Story of a Sumo Wrestler And a Girl who must Defeat a Car in A Baloon Factory',2006,1,NULL,4,'0.99',50,'24.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (618,'NECKLACE OUTBREAK','A Astounding Epistle of a Database Administrator And a Mad Scientist who must Pursue a Cat in California',2006,1,NULL,3,'0.99',132,'21.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (619,'NEIGHBORS CHARADE','A Fanciful Reflection of a Crocodile And a Astronaut who must Outrace a Feminist in An Abandoned Amusement Park',2006,1,NULL,3,'0.99',161,'20.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (620,'NEMO CAMPUS','A Lacklusture Reflection of a Monkey And a Squirrel who must Outrace a Womanizer in A Manhattan Penthouse',2006,1,NULL,5,'2.99',131,'23.99','NC-17','Trailers','2006-02-15 05:03:42'),
 (621,'NETWORK PEAK','A Unbelieveable Reflection of a Butler And a Boat who must Outgun a Mad Scientist in California',2006,1,NULL,5,'2.99',75,'23.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (622,'NEWSIES STORY','A Action-Packed Character Study of a Dog And a Lumberjack who must Outrace a Moose in The Gulf of Mexico',2006,1,NULL,4,'0.99',159,'25.99','G','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (623,'NEWTON LABYRINTH','A Intrepid Character Study of a Moose And a Waitress who must Find a A Shark in Ancient India',2006,1,NULL,4,'0.99',75,'9.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (624,'NIGHTMARE CHILL','A Brilliant Display of a Robot And a Butler who must Fight a Waitress in An Abandoned Mine Shaft',2006,1,NULL,3,'4.99',149,'25.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (625,'NONE SPIKING','A Boring Reflection of a Secret Agent And a Astronaut who must Face a Composer in A Manhattan Penthouse',2006,1,NULL,3,'0.99',83,'18.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42'),
 (626,'NOON PAPI','A Unbelieveable Character Study of a Mad Scientist And a Astronaut who must Find a Pioneer in A Manhattan Penthouse',2006,1,NULL,5,'2.99',57,'12.99','G','Behind the Scenes','2006-02-15 05:03:42'),
 (627,'NORTH TEQUILA','A Beautiful Character Study of a Mad Cow And a Robot who must Reach a Womanizer in New Orleans',2006,1,NULL,4,'4.99',67,'9.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (628,'NORTHWEST POLISH','A Boring Character Study of a Boy And a A Shark who must Outrace a Womanizer in The Outback',2006,1,NULL,5,'2.99',172,'24.99','PG','Trailers','2006-02-15 05:03:42'),
 (629,'NOTORIOUS REUNION','A Amazing Epistle of a Woman And a Squirrel who must Fight a Hunter in A Baloon',2006,1,NULL,7,'0.99',128,'9.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (630,'NOTTING SPEAKEASY','A Thoughtful Display of a Butler And a Womanizer who must Find a Waitress in The Canadian Rockies',2006,1,NULL,7,'0.99',48,'19.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (631,'NOVOCAINE FLIGHT','A Fanciful Display of a Student And a Teacher who must Outgun a Crocodile in Nigeria',2006,1,NULL,4,'0.99',64,'11.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (632,'NUTS TIES','A Thoughtful Drama of a Explorer And a Womanizer who must Meet a Teacher in California',2006,1,NULL,5,'4.99',145,'10.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (633,'OCTOBER SUBMARINE','A Taut Epistle of a Monkey And a Boy who must Confront a Husband in A Jet Boat',2006,1,NULL,6,'4.99',54,'10.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (634,'ODDS BOOGIE','A Thrilling Yarn of a Feminist And a Madman who must Battle a Hunter in Berlin',2006,1,NULL,6,'0.99',48,'14.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (635,'OKLAHOMA JUMANJI','A Thoughtful Drama of a Dentist And a Womanizer who must Meet a Husband in The Sahara Desert',2006,1,NULL,7,'0.99',58,'15.99','PG','Behind the Scenes','2006-02-15 05:03:42'),
 (636,'OLEANDER CLUE','A Boring Story of a Teacher And a Monkey who must Succumb a Forensic Psychologist in A Jet Boat',2006,1,NULL,5,'0.99',161,'12.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (637,'OPEN AFRICAN','A Lacklusture Drama of a Secret Agent And a Explorer who must Discover a Car in A U-Boat',2006,1,NULL,7,'4.99',131,'16.99','PG','Trailers,Commentaries','2006-02-15 05:03:42'),
 (638,'OPERATION OPERATION','A Intrepid Character Study of a Man And a Frisbee who must Overcome a Madman in Ancient China',2006,1,NULL,7,'2.99',156,'23.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (639,'OPPOSITE NECKLACE','A Fateful Epistle of a Crocodile And a Moose who must Kill a Explorer in Nigeria',2006,1,NULL,7,'4.99',92,'9.99','PG','Deleted Scenes','2006-02-15 05:03:42'),
 (640,'OPUS ICE','A Fast-Paced Drama of a Hunter And a Boy who must Discover a Feminist in The Sahara Desert',2006,1,NULL,5,'4.99',102,'21.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (641,'ORANGE GRAPES','A Astounding Documentary of a Butler And a Womanizer who must Face a Dog in A U-Boat',2006,1,NULL,4,'0.99',76,'21.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42'),
 (642,'ORDER BETRAYED','A Amazing Saga of a Dog And a A Shark who must Challenge a Cat in The Sahara Desert',2006,1,NULL,7,'2.99',120,'13.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (643,'ORIENT CLOSER','A Astounding Epistle of a Technical Writer And a Teacher who must Fight a Squirrel in The Sahara Desert',2006,1,NULL,3,'2.99',118,'22.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (644,'OSCAR GOLD','A Insightful Tale of a Database Administrator And a Dog who must Face a Madman in Soviet Georgia',2006,1,NULL,7,'2.99',115,'29.99','PG','Behind the Scenes','2006-02-15 05:03:42'),
 (645,'OTHERS SOUP','A Lacklusture Documentary of a Mad Cow And a Madman who must Sink a Moose in The Gulf of Mexico',2006,1,NULL,7,'2.99',118,'18.99','PG','Deleted Scenes','2006-02-15 05:03:42'),
 (646,'OUTBREAK DIVINE','A Unbelieveable Yarn of a Database Administrator And a Woman who must Succumb a A Shark in A U-Boat',2006,1,NULL,6,'0.99',169,'12.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (647,'OUTFIELD MASSACRE','A Thoughtful Drama of a Husband And a Secret Agent who must Pursue a Database Administrator in Ancient India',2006,1,NULL,4,'0.99',129,'18.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (648,'OUTLAW HANKY','A Thoughtful Story of a Astronaut And a Composer who must Conquer a Dog in The Sahara Desert',2006,1,NULL,7,'4.99',148,'17.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (649,'OZ LIAISONS','A Epic Yarn of a Mad Scientist And a Cat who must Confront a Womanizer in A Baloon Factory',2006,1,NULL,4,'2.99',85,'14.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (650,'PACIFIC AMISTAD','A Thrilling Yarn of a Dog And a Moose who must Kill a Pastry Chef in A Manhattan Penthouse',2006,1,NULL,3,'0.99',144,'27.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (651,'PACKER MADIGAN','A Epic Display of a Sumo Wrestler And a Forensic Psychologist who must Build a Woman in An Abandoned Amusement Park',2006,1,NULL,3,'0.99',84,'20.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (652,'PAJAMA JAWBREAKER','A Emotional Drama of a Boy And a Technical Writer who must Redeem a Sumo Wrestler in California',2006,1,NULL,3,'0.99',126,'14.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (653,'PANIC CLUB','A Fanciful Display of a Teacher And a Crocodile who must Succumb a Girl in A Baloon',2006,1,NULL,3,'4.99',102,'15.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (654,'PANKY SUBMARINE','A Touching Documentary of a Dentist And a Sumo Wrestler who must Overcome a Boy in The Gulf of Mexico',2006,1,NULL,4,'4.99',93,'19.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (655,'PANTHER REDS','A Brilliant Panorama of a Moose And a Man who must Reach a Teacher in The Gulf of Mexico',2006,1,NULL,5,'4.99',109,'22.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (656,'PAPI NECKLACE','A Fanciful Display of a Car And a Monkey who must Escape a Squirrel in Ancient Japan',2006,1,NULL,3,'0.99',128,'9.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (657,'PARADISE SABRINA','A Intrepid Yarn of a Car And a Moose who must Outrace a Crocodile in A Manhattan Penthouse',2006,1,NULL,5,'2.99',48,'12.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (658,'PARIS WEEKEND','A Intrepid Story of a Squirrel And a Crocodile who must Defeat a Monkey in The Outback',2006,1,NULL,7,'2.99',121,'19.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (659,'PARK CITIZEN','A Taut Epistle of a Sumo Wrestler And a Girl who must Face a Husband in Ancient Japan',2006,1,NULL,3,'4.99',109,'14.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (660,'PARTY KNOCK','A Fateful Display of a Technical Writer And a Butler who must Battle a Sumo Wrestler in An Abandoned Mine Shaft',2006,1,NULL,7,'2.99',107,'11.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (661,'PAST SUICIDES','A Intrepid Tale of a Madman And a Astronaut who must Challenge a Hunter in A Monastery',2006,1,NULL,5,'4.99',157,'17.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (662,'PATHS CONTROL','A Astounding Documentary of a Butler And a Cat who must Find a Frisbee in Ancient China',2006,1,NULL,3,'4.99',118,'9.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (663,'PATIENT SISTER','A Emotional Epistle of a Squirrel And a Robot who must Confront a Lumberjack in Soviet Georgia',2006,1,NULL,7,'0.99',99,'29.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42'),
 (664,'PATRIOT ROMAN','A Taut Saga of a Robot And a Database Administrator who must Challenge a Astronaut in California',2006,1,NULL,6,'2.99',65,'12.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (665,'PATTON INTERVIEW','A Thrilling Documentary of a Composer And a Secret Agent who must Succumb a Cat in Berlin',2006,1,NULL,4,'2.99',175,'22.99','PG','Commentaries','2006-02-15 05:03:42'),
 (666,'PAYCHECK WAIT','A Awe-Inspiring Reflection of a Boy And a Man who must Discover a Moose in The Sahara Desert',2006,1,NULL,4,'4.99',145,'27.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (667,'PEACH INNOCENT','A Action-Packed Drama of a Monkey And a Dentist who must Chase a Butler in Berlin',2006,1,NULL,3,'2.99',160,'20.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (668,'PEAK FOREVER','A Insightful Reflection of a Boat And a Secret Agent who must Vanquish a Astronaut in An Abandoned Mine Shaft',2006,1,NULL,7,'4.99',80,'25.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (669,'PEARL DESTINY','A Lacklusture Yarn of a Astronaut And a Pastry Chef who must Sink a Dog in A U-Boat',2006,1,NULL,3,'2.99',74,'10.99','NC-17','Trailers','2006-02-15 05:03:42'),
 (670,'PELICAN COMFORTS','A Epic Documentary of a Boy And a Monkey who must Pursue a Astronaut in Berlin',2006,1,NULL,4,'4.99',48,'17.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (671,'PERDITION FARGO','A Fast-Paced Story of a Car And a Cat who must Outgun a Hunter in Berlin',2006,1,NULL,7,'4.99',99,'27.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (672,'PERFECT GROOVE','A Thrilling Yarn of a Dog And a Dog who must Build a Husband in A Baloon',2006,1,NULL,7,'2.99',82,'17.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (673,'PERSONAL LADYBUGS','A Epic Saga of a Hunter And a Technical Writer who must Conquer a Cat in Ancient Japan',2006,1,NULL,3,'0.99',118,'19.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (674,'PET HAUNTING','A Unbelieveable Reflection of a Explorer And a Boat who must Conquer a Woman in California',2006,1,NULL,3,'0.99',99,'11.99','PG','Trailers,Commentaries','2006-02-15 05:03:42'),
 (675,'PHANTOM GLORY','A Beautiful Documentary of a Astronaut And a Crocodile who must Discover a Madman in A Monastery',2006,1,NULL,6,'2.99',60,'17.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (676,'PHILADELPHIA WIFE','A Taut Yarn of a Hunter And a Astronaut who must Conquer a Database Administrator in The Sahara Desert',2006,1,NULL,7,'4.99',137,'16.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (677,'PIANIST OUTFIELD','A Intrepid Story of a Boy And a Technical Writer who must Pursue a Lumberjack in A Monastery',2006,1,NULL,6,'0.99',136,'25.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (678,'PICKUP DRIVING','A Touching Documentary of a Husband And a Boat who must Meet a Pastry Chef in A Baloon Factory',2006,1,NULL,3,'2.99',77,'23.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (679,'PILOT HOOSIERS','A Awe-Inspiring Reflection of a Crocodile And a Sumo Wrestler who must Meet a Forensic Psychologist in An Abandoned Mine Shaft',2006,1,NULL,6,'2.99',50,'17.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (680,'PINOCCHIO SIMON','A Action-Packed Reflection of a Mad Scientist And a A Shark who must Find a Feminist in California',2006,1,NULL,4,'4.99',103,'21.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (681,'PIRATES ROXANNE','A Stunning Drama of a Woman And a Lumberjack who must Overcome a A Shark in The Canadian Rockies',2006,1,NULL,4,'0.99',100,'20.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (682,'PITTSBURGH HUNCHBACK','A Thrilling Epistle of a Boy And a Boat who must Find a Student in Soviet Georgia',2006,1,NULL,4,'4.99',134,'17.99','PG-13','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (683,'PITY BOUND','A Boring Panorama of a Feminist And a Moose who must Defeat a Database Administrator in Nigeria',2006,1,NULL,5,'4.99',60,'19.99','NC-17','Commentaries','2006-02-15 05:03:42'),
 (684,'PIZZA JUMANJI','A Epic Saga of a Cat And a Squirrel who must Outgun a Robot in A U-Boat',2006,1,NULL,4,'2.99',173,'11.99','NC-17','Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (685,'PLATOON INSTINCT','A Thrilling Panorama of a Man And a Woman who must Reach a Woman in Australia',2006,1,NULL,6,'4.99',132,'10.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42'),
 (686,'PLUTO OLEANDER','A Action-Packed Reflection of a Car And a Moose who must Outgun a Car in A Shark Tank',2006,1,NULL,5,'4.99',84,'9.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (687,'POCUS PULP','A Intrepid Yarn of a Frisbee And a Dog who must Build a Astronaut in A Baloon Factory',2006,1,NULL,6,'0.99',138,'15.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (688,'POLISH BROOKLYN','A Boring Character Study of a Database Administrator And a Lumberjack who must Reach a Madman in The Outback',2006,1,NULL,6,'0.99',61,'12.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (689,'POLLOCK DELIVERANCE','A Intrepid Story of a Madman And a Frisbee who must Outgun a Boat in The Sahara Desert',2006,1,NULL,5,'2.99',137,'14.99','PG','Commentaries','2006-02-15 05:03:42'),
 (690,'POND SEATTLE','A Stunning Drama of a Teacher And a Boat who must Battle a Feminist in Ancient China',2006,1,NULL,7,'2.99',185,'25.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (691,'POSEIDON FOREVER','A Thoughtful Epistle of a Womanizer And a Monkey who must Vanquish a Dentist in A Monastery',2006,1,NULL,6,'4.99',159,'29.99','PG-13','Commentaries','2006-02-15 05:03:42'),
 (692,'POTLUCK MIXED','A Beautiful Story of a Dog And a Technical Writer who must Outgun a Student in A Baloon',2006,1,NULL,3,'2.99',179,'10.99','G','Behind the Scenes','2006-02-15 05:03:42'),
 (693,'POTTER CONNECTICUT','A Thrilling Epistle of a Frisbee And a Cat who must Fight a Technical Writer in Berlin',2006,1,NULL,5,'2.99',115,'16.99','PG','Trailers,Commentaries','2006-02-15 05:03:42'),
 (694,'PREJUDICE OLEANDER','A Epic Saga of a Boy And a Dentist who must Outrace a Madman in A U-Boat',2006,1,NULL,6,'4.99',98,'15.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (695,'PRESIDENT BANG','A Fateful Panorama of a Technical Writer And a Moose who must Battle a Robot in Soviet Georgia',2006,1,NULL,6,'4.99',144,'12.99','PG','Behind the Scenes','2006-02-15 05:03:42'),
 (696,'PRIDE ALAMO','A Thoughtful Drama of a A Shark And a Forensic Psychologist who must Vanquish a Student in Ancient India',2006,1,NULL,6,'0.99',114,'20.99','NC-17','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (697,'PRIMARY GLASS','A Fateful Documentary of a Pastry Chef And a Butler who must Build a Dog in The Canadian Rockies',2006,1,NULL,7,'0.99',53,'16.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (698,'PRINCESS GIANT','A Thrilling Yarn of a Pastry Chef And a Monkey who must Battle a Monkey in A Shark Tank',2006,1,NULL,3,'2.99',71,'29.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (699,'PRIVATE DROP','A Stunning Story of a Technical Writer And a Hunter who must Succumb a Secret Agent in A Baloon',2006,1,NULL,7,'4.99',106,'26.99','PG','Trailers','2006-02-15 05:03:42'),
 (700,'PRIX UNDEFEATED','A Stunning Saga of a Mad Scientist And a Boat who must Overcome a Dentist in Ancient China',2006,1,NULL,4,'2.99',115,'13.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (701,'PSYCHO SHRUNK','A Amazing Panorama of a Crocodile And a Explorer who must Fight a Husband in Nigeria',2006,1,NULL,5,'2.99',155,'11.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (702,'PULP BEVERLY','A Unbelieveable Display of a Dog And a Crocodile who must Outrace a Man in Nigeria',2006,1,NULL,4,'2.99',89,'12.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (703,'PUNK DIVORCE','A Fast-Paced Tale of a Pastry Chef And a Boat who must Face a Frisbee in The Canadian Rockies',2006,1,NULL,6,'4.99',100,'18.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (704,'PURE RUNNER','A Thoughtful Documentary of a Student And a Madman who must Challenge a Squirrel in A Manhattan Penthouse',2006,1,NULL,3,'2.99',121,'25.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (705,'PURPLE MOVIE','A Boring Display of a Pastry Chef And a Sumo Wrestler who must Discover a Frisbee in An Abandoned Amusement Park',2006,1,NULL,4,'2.99',88,'9.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (706,'QUEEN LUKE','A Astounding Story of a Girl And a Boy who must Challenge a Composer in New Orleans',2006,1,NULL,5,'4.99',163,'22.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (707,'QUEST MUSSOLINI','A Fateful Drama of a Husband And a Sumo Wrestler who must Battle a Pastry Chef in A Baloon Factory',2006,1,NULL,5,'2.99',177,'29.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (708,'QUILLS BULL','A Thoughtful Story of a Pioneer And a Woman who must Reach a Moose in Australia',2006,1,NULL,4,'4.99',112,'19.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (709,'RACER EGG','A Emotional Display of a Monkey And a Waitress who must Reach a Secret Agent in California',2006,1,NULL,7,'2.99',147,'19.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (710,'RAGE GAMES','A Fast-Paced Saga of a Astronaut And a Secret Agent who must Escape a Hunter in An Abandoned Amusement Park',2006,1,NULL,4,'4.99',120,'18.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (711,'RAGING AIRPLANE','A Astounding Display of a Secret Agent And a Technical Writer who must Escape a Mad Scientist in A Jet Boat',2006,1,NULL,4,'4.99',154,'18.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (712,'RAIDERS ANTITRUST','A Amazing Drama of a Teacher And a Feminist who must Meet a Woman in The First Manned Space Station',2006,1,NULL,4,'0.99',82,'11.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (713,'RAINBOW SHOCK','A Action-Packed Story of a Hunter And a Boy who must Discover a Lumberjack in Ancient India',2006,1,NULL,3,'4.99',74,'14.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (714,'RANDOM GO','A Fateful Drama of a Frisbee And a Student who must Confront a Cat in A Shark Tank',2006,1,NULL,6,'2.99',73,'29.99','NC-17','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (715,'RANGE MOONWALKER','A Insightful Documentary of a Hunter And a Dentist who must Confront a Crocodile in A Baloon',2006,1,NULL,3,'4.99',147,'25.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (716,'REAP UNFAITHFUL','A Thrilling Epistle of a Composer And a Sumo Wrestler who must Challenge a Mad Cow in A MySQL Convention',2006,1,NULL,6,'2.99',136,'26.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42'),
 (717,'REAR TRADING','A Awe-Inspiring Reflection of a Forensic Psychologist And a Secret Agent who must Succumb a Pastry Chef in Soviet Georgia',2006,1,NULL,6,'0.99',97,'23.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (718,'REBEL AIRPORT','A Intrepid Yarn of a Database Administrator And a Boat who must Outrace a Husband in Ancient India',2006,1,NULL,7,'0.99',73,'24.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (719,'RECORDS ZORRO','A Amazing Drama of a Mad Scientist And a Composer who must Build a Husband in The Outback',2006,1,NULL,7,'4.99',182,'11.99','PG','Behind the Scenes','2006-02-15 05:03:42'),
 (720,'REDEMPTION COMFORTS','A Emotional Documentary of a Dentist And a Woman who must Battle a Mad Scientist in Ancient China',2006,1,NULL,3,'2.99',179,'20.99','NC-17','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (721,'REDS POCUS','A Lacklusture Yarn of a Sumo Wrestler And a Squirrel who must Redeem a Monkey in Soviet Georgia',2006,1,NULL,7,'4.99',182,'23.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (722,'REEF SALUTE','A Action-Packed Saga of a Teacher And a Lumberjack who must Battle a Dentist in A Baloon',2006,1,NULL,5,'0.99',123,'26.99','NC-17','Behind the Scenes','2006-02-15 05:03:42'),
 (723,'REIGN GENTLEMEN','A Emotional Yarn of a Composer And a Man who must Escape a Butler in The Gulf of Mexico',2006,1,NULL,3,'2.99',82,'29.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (724,'REMEMBER DIARY','A Insightful Tale of a Technical Writer And a Waitress who must Conquer a Monkey in Ancient India',2006,1,NULL,5,'2.99',110,'15.99','R','Trailers,Commentaries','2006-02-15 05:03:42'),
 (725,'REQUIEM TYCOON','A Unbelieveable Character Study of a Cat And a Database Administrator who must Pursue a Teacher in A Monastery',2006,1,NULL,6,'4.99',167,'25.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (726,'RESERVOIR ADAPTATION','A Intrepid Drama of a Teacher And a Moose who must Kill a Car in California',2006,1,NULL,7,'2.99',61,'29.99','PG-13','Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (727,'RESURRECTION SILVERADO','A Epic Yarn of a Robot And a Explorer who must Challenge a Girl in A MySQL Convention',2006,1,NULL,6,'0.99',117,'12.99','PG','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (728,'REUNION WITCHES','A Unbelieveable Documentary of a Database Administrator And a Frisbee who must Redeem a Mad Scientist in A Baloon Factory',2006,1,NULL,3,'0.99',63,'26.99','R','Commentaries','2006-02-15 05:03:42'),
 (729,'RIDER CADDYSHACK','A Taut Reflection of a Monkey And a Womanizer who must Chase a Moose in Nigeria',2006,1,NULL,5,'2.99',177,'28.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (730,'RIDGEMONT SUBMARINE','A Unbelieveable Drama of a Waitress And a Composer who must Sink a Mad Cow in Ancient Japan',2006,1,NULL,3,'0.99',46,'28.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (731,'RIGHT CRANES','A Fateful Character Study of a Boat And a Cat who must Find a Database Administrator in A Jet Boat',2006,1,NULL,7,'4.99',153,'29.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (732,'RINGS HEARTBREAKERS','A Amazing Yarn of a Sumo Wrestler And a Boat who must Conquer a Waitress in New Orleans',2006,1,NULL,5,'0.99',58,'17.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (733,'RIVER OUTLAW','A Thrilling Character Study of a Squirrel And a Lumberjack who must Face a Hunter in A MySQL Convention',2006,1,NULL,4,'0.99',149,'29.99','PG-13','Commentaries','2006-02-15 05:03:42'),
 (734,'ROAD ROXANNE','A Boring Character Study of a Waitress And a Astronaut who must Fight a Crocodile in Ancient Japan',2006,1,NULL,4,'4.99',158,'12.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (735,'ROBBERS JOON','A Thoughtful Story of a Mad Scientist And a Waitress who must Confront a Forensic Psychologist in Soviet Georgia',2006,1,NULL,7,'2.99',102,'26.99','PG-13','Commentaries','2006-02-15 05:03:42'),
 (736,'ROBBERY BRIGHT','A Taut Reflection of a Robot And a Squirrel who must Fight a Boat in Ancient Japan',2006,1,NULL,4,'0.99',134,'21.99','R','Trailers','2006-02-15 05:03:42'),
 (737,'ROCK INSTINCT','A Astounding Character Study of a Robot And a Moose who must Overcome a Astronaut in Ancient India',2006,1,NULL,4,'0.99',102,'28.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (738,'ROCKETEER MOTHER','A Awe-Inspiring Character Study of a Robot And a Sumo Wrestler who must Discover a Womanizer in A Shark Tank',2006,1,NULL,3,'0.99',178,'27.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (739,'ROCKY WAR','A Fast-Paced Display of a Squirrel And a Explorer who must Outgun a Mad Scientist in Nigeria',2006,1,NULL,4,'4.99',145,'17.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (740,'ROLLERCOASTER BRINGING','A Beautiful Drama of a Robot And a Lumberjack who must Discover a Technical Writer in A Shark Tank',2006,1,NULL,5,'2.99',153,'13.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (741,'ROMAN PUNK','A Thoughtful Panorama of a Mad Cow And a Student who must Battle a Forensic Psychologist in Berlin',2006,1,NULL,7,'0.99',81,'28.99','NC-17','Trailers','2006-02-15 05:03:42'),
 (742,'ROOF CHAMPION','A Lacklusture Reflection of a Car And a Explorer who must Find a Monkey in A Baloon',2006,1,NULL,7,'0.99',101,'25.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (743,'ROOM ROMAN','A Awe-Inspiring Panorama of a Composer And a Secret Agent who must Sink a Composer in A Shark Tank',2006,1,NULL,7,'0.99',60,'27.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (744,'ROOTS REMEMBER','A Brilliant Drama of a Mad Cow And a Hunter who must Escape a Hunter in Berlin',2006,1,NULL,4,'0.99',89,'23.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (745,'ROSES TREASURE','A Astounding Panorama of a Monkey And a Secret Agent who must Defeat a Woman in The First Manned Space Station',2006,1,NULL,5,'4.99',162,'23.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (746,'ROUGE SQUAD','A Awe-Inspiring Drama of a Astronaut And a Frisbee who must Conquer a Mad Scientist in Australia',2006,1,NULL,3,'0.99',118,'10.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (747,'ROXANNE REBEL','A Astounding Story of a Pastry Chef And a Database Administrator who must Fight a Man in The Outback',2006,1,NULL,5,'0.99',171,'9.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (748,'RUGRATS SHAKESPEARE','A Touching Saga of a Crocodile And a Crocodile who must Discover a Technical Writer in Nigeria',2006,1,NULL,4,'0.99',109,'16.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (749,'RULES HUMAN','A Beautiful Epistle of a Astronaut And a Student who must Confront a Monkey in An Abandoned Fun House',2006,1,NULL,6,'4.99',153,'19.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (750,'RUN PACIFIC','A Touching Tale of a Cat And a Pastry Chef who must Conquer a Pastry Chef in A MySQL Convention',2006,1,NULL,3,'0.99',145,'25.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (751,'RUNAWAY TENENBAUMS','A Thoughtful Documentary of a Boat And a Man who must Meet a Boat in An Abandoned Fun House',2006,1,NULL,6,'0.99',181,'17.99','NC-17','Commentaries','2006-02-15 05:03:42'),
 (752,'RUNNER MADIGAN','A Thoughtful Documentary of a Crocodile And a Robot who must Outrace a Womanizer in The Outback',2006,1,NULL,6,'0.99',101,'27.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (753,'RUSH GOODFELLAS','A Emotional Display of a Man And a Dentist who must Challenge a Squirrel in Australia',2006,1,NULL,3,'0.99',48,'20.99','PG','Deleted Scenes','2006-02-15 05:03:42'),
 (754,'RUSHMORE MERMAID','A Boring Story of a Woman And a Moose who must Reach a Husband in A Shark Tank',2006,1,NULL,6,'2.99',150,'17.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (755,'SABRINA MIDNIGHT','A Emotional Story of a Squirrel And a Crocodile who must Succumb a Husband in The Sahara Desert',2006,1,NULL,5,'4.99',99,'11.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (756,'SADDLE ANTITRUST','A Stunning Epistle of a Feminist And a A Shark who must Battle a Woman in An Abandoned Fun House',2006,1,NULL,7,'2.99',80,'10.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (757,'SAGEBRUSH CLUELESS','A Insightful Story of a Lumberjack And a Hunter who must Kill a Boy in Ancient Japan',2006,1,NULL,4,'2.99',106,'28.99','G','Trailers','2006-02-15 05:03:42'),
 (758,'SAINTS BRIDE','A Fateful Tale of a Technical Writer And a Composer who must Pursue a Explorer in The Gulf of Mexico',2006,1,NULL,5,'2.99',125,'11.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (759,'SALUTE APOLLO','A Awe-Inspiring Character Study of a Boy And a Feminist who must Sink a Crocodile in Ancient China',2006,1,NULL,4,'2.99',73,'29.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (760,'SAMURAI LION','A Fast-Paced Story of a Pioneer And a Astronaut who must Reach a Boat in A Baloon',2006,1,NULL,5,'2.99',110,'21.99','G','Commentaries','2006-02-15 05:03:42'),
 (761,'SANTA PARIS','A Emotional Documentary of a Moose And a Car who must Redeem a Mad Cow in A Baloon Factory',2006,1,NULL,7,'2.99',154,'23.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (762,'SASSY PACKER','A Fast-Paced Documentary of a Dog And a Teacher who must Find a Moose in A Manhattan Penthouse',2006,1,NULL,6,'0.99',154,'29.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (763,'SATISFACTION CONFIDENTIAL','A Lacklusture Yarn of a Dentist And a Butler who must Meet a Secret Agent in Ancient China',2006,1,NULL,3,'4.99',75,'26.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (764,'SATURDAY LAMBS','A Thoughtful Reflection of a Mad Scientist And a Moose who must Kill a Husband in A Baloon',2006,1,NULL,3,'4.99',150,'28.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (765,'SATURN NAME','A Fateful Epistle of a Butler And a Boy who must Redeem a Teacher in Berlin',2006,1,NULL,7,'4.99',182,'18.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (766,'SAVANNAH TOWN','A Awe-Inspiring Tale of a Astronaut And a Database Administrator who must Chase a Secret Agent in The Gulf of Mexico',2006,1,NULL,5,'0.99',84,'25.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (767,'SCALAWAG DUCK','A Fateful Reflection of a Car And a Teacher who must Confront a Waitress in A Monastery',2006,1,NULL,6,'4.99',183,'13.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (768,'SCARFACE BANG','A Emotional Yarn of a Teacher And a Girl who must Find a Teacher in A Baloon Factory',2006,1,NULL,3,'4.99',102,'11.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (769,'SCHOOL JACKET','A Intrepid Yarn of a Monkey And a Boy who must Fight a Composer in A Manhattan Penthouse',2006,1,NULL,5,'4.99',151,'21.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (770,'SCISSORHANDS SLUMS','A Awe-Inspiring Drama of a Girl And a Technical Writer who must Meet a Feminist in The Canadian Rockies',2006,1,NULL,5,'2.99',147,'13.99','G','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (771,'SCORPION APOLLO','A Awe-Inspiring Documentary of a Technical Writer And a Husband who must Meet a Monkey in An Abandoned Fun House',2006,1,NULL,3,'4.99',137,'23.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (772,'SEA VIRGIN','A Fast-Paced Documentary of a Technical Writer And a Pastry Chef who must Escape a Moose in A U-Boat',2006,1,NULL,4,'2.99',80,'24.99','PG','Deleted Scenes','2006-02-15 05:03:42'),
 (773,'SEABISCUIT PUNK','A Insightful Saga of a Man And a Forensic Psychologist who must Discover a Mad Cow in A MySQL Convention',2006,1,NULL,6,'2.99',112,'28.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (774,'SEARCHERS WAIT','A Fast-Paced Tale of a Car And a Mad Scientist who must Kill a Womanizer in Ancient Japan',2006,1,NULL,3,'2.99',182,'22.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (775,'SEATTLE EXPECATIONS','A Insightful Reflection of a Crocodile And a Sumo Wrestler who must Meet a Technical Writer in The Sahara Desert',2006,1,NULL,4,'4.99',110,'18.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (776,'SECRET GROUNDHOG','A Astounding Story of a Cat And a Database Administrator who must Build a Technical Writer in New Orleans',2006,1,NULL,6,'4.99',90,'11.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (777,'SECRETARY ROUGE','A Action-Packed Panorama of a Mad Cow And a Composer who must Discover a Robot in A Baloon Factory',2006,1,NULL,5,'4.99',158,'10.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (778,'SECRETS PARADISE','A Fateful Saga of a Cat And a Frisbee who must Kill a Girl in A Manhattan Penthouse',2006,1,NULL,3,'4.99',109,'24.99','G','Trailers,Commentaries','2006-02-15 05:03:42'),
 (779,'SENSE GREEK','A Taut Saga of a Lumberjack And a Pastry Chef who must Escape a Sumo Wrestler in An Abandoned Fun House',2006,1,NULL,4,'4.99',54,'23.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (780,'SENSIBILITY REAR','A Emotional Tale of a Robot And a Sumo Wrestler who must Redeem a Pastry Chef in A Baloon Factory',2006,1,NULL,7,'4.99',98,'15.99','PG','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (781,'SEVEN SWARM','A Unbelieveable Character Study of a Dog And a Mad Cow who must Kill a Monkey in Berlin',2006,1,NULL,4,'4.99',127,'15.99','R','Deleted Scenes','2006-02-15 05:03:42'),
 (782,'SHAKESPEARE SADDLE','A Fast-Paced Panorama of a Lumberjack And a Database Administrator who must Defeat a Madman in A MySQL Convention',2006,1,NULL,6,'2.99',60,'26.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (783,'SHANE DARKNESS','A Action-Packed Saga of a Moose And a Lumberjack who must Find a Woman in Berlin',2006,1,NULL,5,'2.99',93,'22.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (784,'SHANGHAI TYCOON','A Fast-Paced Character Study of a Crocodile And a Lumberjack who must Build a Husband in An Abandoned Fun House',2006,1,NULL,7,'2.99',47,'20.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (785,'SHAWSHANK BUBBLE','A Lacklusture Story of a Moose And a Monkey who must Confront a Butler in An Abandoned Amusement Park',2006,1,NULL,6,'4.99',80,'20.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (786,'SHEPHERD MIDSUMMER','A Thoughtful Drama of a Robot And a Womanizer who must Kill a Lumberjack in A Baloon',2006,1,NULL,7,'0.99',113,'14.99','R','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (787,'SHINING ROSES','A Awe-Inspiring Character Study of a Astronaut And a Forensic Psychologist who must Challenge a Madman in Ancient India',2006,1,NULL,4,'0.99',125,'12.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (788,'SHIP WONDERLAND','A Thrilling Saga of a Monkey And a Frisbee who must Escape a Explorer in The Outback',2006,1,NULL,5,'2.99',104,'15.99','R','Commentaries','2006-02-15 05:03:42'),
 (789,'SHOCK CABIN','A Fateful Tale of a Mad Cow And a Crocodile who must Meet a Husband in New Orleans',2006,1,NULL,7,'2.99',79,'15.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (790,'SHOOTIST SUPERFLY','A Fast-Paced Story of a Crocodile And a A Shark who must Sink a Pioneer in Berlin',2006,1,NULL,6,'0.99',67,'22.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (791,'SHOW LORD','A Fanciful Saga of a Student And a Girl who must Find a Butler in Ancient Japan',2006,1,NULL,3,'4.99',167,'24.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (792,'SHREK LICENSE','A Fateful Yarn of a Secret Agent And a Feminist who must Find a Feminist in A Jet Boat',2006,1,NULL,7,'2.99',154,'15.99','PG-13','Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (793,'SHRUNK DIVINE','A Fateful Character Study of a Waitress And a Technical Writer who must Battle a Hunter in A Baloon',2006,1,NULL,6,'2.99',139,'14.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (794,'SIDE ARK','A Stunning Panorama of a Crocodile And a Womanizer who must Meet a Feminist in The Canadian Rockies',2006,1,NULL,5,'0.99',52,'28.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (795,'SIEGE MADRE','A Boring Tale of a Frisbee And a Crocodile who must Vanquish a Moose in An Abandoned Mine Shaft',2006,1,NULL,7,'0.99',111,'23.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (796,'SIERRA DIVIDE','A Emotional Character Study of a Frisbee And a Mad Scientist who must Build a Madman in California',2006,1,NULL,3,'0.99',135,'12.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (797,'SILENCE KANE','A Emotional Drama of a Sumo Wrestler And a Dentist who must Confront a Sumo Wrestler in A Baloon',2006,1,NULL,7,'0.99',67,'23.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (798,'SILVERADO GOLDFINGER','A Stunning Epistle of a Sumo Wrestler And a Man who must Challenge a Waitress in Ancient India',2006,1,NULL,4,'4.99',74,'11.99','PG','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (799,'SIMON NORTH','A Thrilling Documentary of a Technical Writer And a A Shark who must Face a Pioneer in A Shark Tank',2006,1,NULL,3,'0.99',51,'26.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42'),
 (800,'SINNERS ATLANTIS','A Epic Display of a Dog And a Boat who must Succumb a Mad Scientist in An Abandoned Mine Shaft',2006,1,NULL,7,'2.99',126,'19.99','PG-13','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (801,'SISTER FREDDY','A Stunning Saga of a Butler And a Woman who must Pursue a Explorer in Australia',2006,1,NULL,5,'4.99',152,'19.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (802,'SKY MIRACLE','A Epic Drama of a Mad Scientist And a Explorer who must Succumb a Waitress in An Abandoned Fun House',2006,1,NULL,7,'2.99',132,'15.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (803,'SLACKER LIAISONS','A Fast-Paced Tale of a A Shark And a Student who must Meet a Crocodile in Ancient China',2006,1,NULL,7,'4.99',179,'29.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (804,'SLEEPING SUSPECTS','A Stunning Reflection of a Sumo Wrestler And a Explorer who must Sink a Frisbee in A MySQL Convention',2006,1,NULL,7,'4.99',129,'13.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (805,'SLEEPLESS MONSOON','A Amazing Saga of a Moose And a Pastry Chef who must Escape a Butler in Australia',2006,1,NULL,5,'4.99',64,'12.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (806,'SLEEPY JAPANESE','A Emotional Epistle of a Moose And a Composer who must Fight a Technical Writer in The Outback',2006,1,NULL,4,'2.99',137,'25.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (807,'SLEUTH ORIENT','A Fateful Character Study of a Husband And a Dog who must Find a Feminist in Ancient India',2006,1,NULL,4,'0.99',87,'25.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (808,'SLING LUKE','A Intrepid Character Study of a Robot And a Monkey who must Reach a Secret Agent in An Abandoned Amusement Park',2006,1,NULL,5,'0.99',84,'10.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (809,'SLIPPER FIDELITY','A Taut Reflection of a Secret Agent And a Man who must Redeem a Explorer in A MySQL Convention',2006,1,NULL,5,'0.99',156,'14.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (810,'SLUMS DUCK','A Amazing Character Study of a Teacher And a Database Administrator who must Defeat a Waitress in A Jet Boat',2006,1,NULL,5,'0.99',147,'21.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (811,'SMILE EARRING','A Intrepid Drama of a Teacher And a Butler who must Build a Pastry Chef in Berlin',2006,1,NULL,4,'2.99',60,'29.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (812,'SMOKING BARBARELLA','A Lacklusture Saga of a Mad Cow And a Mad Scientist who must Sink a Cat in A MySQL Convention',2006,1,NULL,7,'0.99',50,'13.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (813,'SMOOCHY CONTROL','A Thrilling Documentary of a Husband And a Feminist who must Face a Mad Scientist in Ancient China',2006,1,NULL,7,'0.99',184,'18.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (814,'SNATCH SLIPPER','A Insightful Panorama of a Woman And a Feminist who must Defeat a Forensic Psychologist in Berlin',2006,1,NULL,6,'4.99',110,'15.99','PG','Commentaries','2006-02-15 05:03:42'),
 (815,'SNATCHERS MONTEZUMA','A Boring Epistle of a Sumo Wrestler And a Woman who must Escape a Man in The Canadian Rockies',2006,1,NULL,4,'2.99',74,'14.99','PG-13','Commentaries','2006-02-15 05:03:42'),
 (816,'SNOWMAN ROLLERCOASTER','A Fateful Display of a Lumberjack And a Girl who must Succumb a Mad Cow in A Manhattan Penthouse',2006,1,NULL,3,'0.99',62,'27.99','G','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (817,'SOLDIERS EVOLUTION','A Lacklusture Panorama of a A Shark And a Pioneer who must Confront a Student in The First Manned Space Station',2006,1,NULL,7,'4.99',185,'27.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (818,'SOMETHING DUCK','A Boring Character Study of a Car And a Husband who must Outgun a Frisbee in The First Manned Space Station',2006,1,NULL,4,'4.99',180,'17.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (819,'SONG HEDWIG','A Amazing Documentary of a Man And a Husband who must Confront a Squirrel in A MySQL Convention',2006,1,NULL,3,'0.99',165,'29.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (820,'SONS INTERVIEW','A Taut Character Study of a Explorer And a Mad Cow who must Battle a Hunter in Ancient China',2006,1,NULL,3,'2.99',184,'11.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (821,'SORORITY QUEEN','A Fast-Paced Display of a Squirrel And a Composer who must Fight a Forensic Psychologist in A Jet Boat',2006,1,NULL,6,'0.99',184,'17.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (822,'SOUP WISDOM','A Fast-Paced Display of a Robot And a Butler who must Defeat a Butler in A MySQL Convention',2006,1,NULL,6,'0.99',169,'12.99','R','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (823,'SOUTH WAIT','A Amazing Documentary of a Car And a Robot who must Escape a Lumberjack in An Abandoned Amusement Park',2006,1,NULL,4,'2.99',143,'21.99','R','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (824,'SPARTACUS CHEAPER','A Thrilling Panorama of a Pastry Chef And a Secret Agent who must Overcome a Student in A Manhattan Penthouse',2006,1,NULL,4,'4.99',52,'19.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (825,'SPEAKEASY DATE','A Lacklusture Drama of a Forensic Psychologist And a Car who must Redeem a Man in A Manhattan Penthouse',2006,1,NULL,6,'2.99',165,'22.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (826,'SPEED SUIT','A Brilliant Display of a Frisbee And a Mad Scientist who must Succumb a Robot in Ancient China',2006,1,NULL,7,'4.99',124,'19.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (827,'SPICE SORORITY','A Fateful Display of a Pioneer And a Hunter who must Defeat a Husband in An Abandoned Mine Shaft',2006,1,NULL,5,'4.99',141,'22.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (828,'SPIKING ELEMENT','A Lacklusture Epistle of a Dentist And a Technical Writer who must Find a Dog in A Monastery',2006,1,NULL,7,'2.99',79,'12.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (829,'SPINAL ROCKY','A Lacklusture Epistle of a Sumo Wrestler And a Squirrel who must Defeat a Explorer in California',2006,1,NULL,7,'2.99',138,'12.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (830,'SPIRIT FLINTSTONES','A Brilliant Yarn of a Cat And a Car who must Confront a Explorer in Ancient Japan',2006,1,NULL,7,'0.99',149,'23.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (831,'SPIRITED CASUALTIES','A Taut Story of a Waitress And a Man who must Face a Car in A Baloon Factory',2006,1,NULL,5,'0.99',138,'20.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (832,'SPLASH GUMP','A Taut Saga of a Crocodile And a Boat who must Conquer a Hunter in A Shark Tank',2006,1,NULL,5,'0.99',175,'16.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (833,'SPLENDOR PATTON','A Taut Story of a Dog And a Explorer who must Find a Astronaut in Berlin',2006,1,NULL,5,'0.99',134,'20.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (834,'SPOILERS HELLFIGHTERS','A Fanciful Story of a Technical Writer And a Squirrel who must Defeat a Dog in The Gulf of Mexico',2006,1,NULL,4,'0.99',151,'26.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (835,'SPY MILE','A Thrilling Documentary of a Feminist And a Feminist who must Confront a Feminist in A Baloon',2006,1,NULL,6,'2.99',112,'13.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (836,'SQUAD FISH','A Fast-Paced Display of a Pastry Chef And a Dog who must Kill a Teacher in Berlin',2006,1,NULL,3,'2.99',136,'14.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (837,'STAGE WORLD','A Lacklusture Panorama of a Woman And a Frisbee who must Chase a Crocodile in A Jet Boat',2006,1,NULL,4,'2.99',85,'19.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (838,'STAGECOACH ARMAGEDDON','A Touching Display of a Pioneer And a Butler who must Chase a Car in California',2006,1,NULL,5,'4.99',112,'25.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (839,'STALLION SUNDANCE','A Fast-Paced Tale of a Car And a Dog who must Outgun a A Shark in Australia',2006,1,NULL,5,'0.99',130,'23.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (840,'STAMPEDE DISTURBING','A Unbelieveable Tale of a Woman And a Lumberjack who must Fight a Frisbee in A U-Boat',2006,1,NULL,5,'0.99',75,'26.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (841,'STAR OPERATION','A Insightful Character Study of a Girl And a Car who must Pursue a Mad Cow in A Shark Tank',2006,1,NULL,5,'2.99',181,'9.99','PG','Commentaries','2006-02-15 05:03:42'),
 (842,'STATE WASTELAND','A Beautiful Display of a Cat And a Pastry Chef who must Outrace a Mad Cow in A Jet Boat',2006,1,NULL,4,'2.99',113,'13.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (843,'STEEL SANTA','A Fast-Paced Yarn of a Composer And a Frisbee who must Face a Moose in Nigeria',2006,1,NULL,4,'4.99',143,'15.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (844,'STEERS ARMAGEDDON','A Stunning Character Study of a Car And a Girl who must Succumb a Car in A MySQL Convention',2006,1,NULL,6,'4.99',140,'16.99','PG','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (845,'STEPMOM DREAM','A Touching Epistle of a Crocodile And a Teacher who must Build a Forensic Psychologist in A MySQL Convention',2006,1,NULL,7,'4.99',48,'9.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (846,'STING PERSONAL','A Fanciful Drama of a Frisbee And a Dog who must Fight a Madman in A Jet Boat',2006,1,NULL,3,'4.99',93,'9.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (847,'STOCK GLASS','A Boring Epistle of a Crocodile And a Lumberjack who must Outgun a Moose in Ancient China',2006,1,NULL,7,'2.99',160,'10.99','PG','Commentaries','2006-02-15 05:03:42'),
 (848,'STONE FIRE','A Intrepid Drama of a Astronaut And a Crocodile who must Find a Boat in Soviet Georgia',2006,1,NULL,3,'0.99',94,'19.99','G','Trailers','2006-02-15 05:03:42'),
 (849,'STORM HAPPINESS','A Insightful Drama of a Feminist And a A Shark who must Vanquish a Boat in A Shark Tank',2006,1,NULL,6,'0.99',57,'28.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (850,'STORY SIDE','A Lacklusture Saga of a Boy And a Cat who must Sink a Dentist in An Abandoned Mine Shaft',2006,1,NULL,7,'0.99',163,'27.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (851,'STRAIGHT HOURS','A Boring Panorama of a Secret Agent And a Girl who must Sink a Waitress in The Outback',2006,1,NULL,3,'0.99',151,'19.99','R','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (852,'STRANGELOVE DESIRE','A Awe-Inspiring Panorama of a Lumberjack And a Waitress who must Defeat a Crocodile in An Abandoned Amusement Park',2006,1,NULL,4,'0.99',103,'27.99','NC-17','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (853,'STRANGER STRANGERS','A Awe-Inspiring Yarn of a Womanizer And a Explorer who must Fight a Woman in The First Manned Space Station',2006,1,NULL,3,'4.99',139,'12.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (854,'STRANGERS GRAFFITI','A Brilliant Character Study of a Secret Agent And a Man who must Find a Cat in The Gulf of Mexico',2006,1,NULL,4,'4.99',119,'22.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (855,'STREAK RIDGEMONT','A Astounding Character Study of a Hunter And a Waitress who must Sink a Man in New Orleans',2006,1,NULL,7,'0.99',132,'28.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (856,'STREETCAR INTENTIONS','A Insightful Character Study of a Waitress And a Crocodile who must Sink a Waitress in The Gulf of Mexico',2006,1,NULL,5,'4.99',73,'11.99','R','Commentaries','2006-02-15 05:03:42'),
 (857,'STRICTLY SCARFACE','A Touching Reflection of a Crocodile And a Dog who must Chase a Hunter in An Abandoned Fun House',2006,1,NULL,3,'2.99',144,'24.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (858,'SUBMARINE BED','A Amazing Display of a Car And a Monkey who must Fight a Teacher in Soviet Georgia',2006,1,NULL,5,'4.99',127,'21.99','R','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (859,'SUGAR WONKA','A Touching Story of a Dentist And a Database Administrator who must Conquer a Astronaut in An Abandoned Amusement Park',2006,1,NULL,3,'4.99',114,'20.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (860,'SUICIDES SILENCE','A Emotional Character Study of a Car And a Girl who must Face a Composer in A U-Boat',2006,1,NULL,4,'4.99',93,'13.99','G','Deleted Scenes','2006-02-15 05:03:42'),
 (861,'SUIT WALLS','A Touching Panorama of a Lumberjack And a Frisbee who must Build a Dog in Australia',2006,1,NULL,3,'4.99',111,'12.99','R','Commentaries','2006-02-15 05:03:42'),
 (862,'SUMMER SCARFACE','A Emotional Panorama of a Lumberjack And a Hunter who must Meet a Girl in A Shark Tank',2006,1,NULL,5,'0.99',53,'25.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (863,'SUN CONFESSIONS','A Beautiful Display of a Mad Cow And a Dog who must Redeem a Waitress in An Abandoned Amusement Park',2006,1,NULL,5,'0.99',141,'9.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (864,'SUNDANCE INVASION','A Epic Drama of a Lumberjack And a Explorer who must Confront a Hunter in A Baloon Factory',2006,1,NULL,5,'0.99',92,'21.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (865,'SUNRISE LEAGUE','A Beautiful Epistle of a Madman And a Butler who must Face a Crocodile in A Manhattan Penthouse',2006,1,NULL,3,'4.99',135,'19.99','PG-13','Behind the Scenes','2006-02-15 05:03:42'),
 (866,'SUNSET RACER','A Awe-Inspiring Reflection of a Astronaut And a A Shark who must Defeat a Forensic Psychologist in California',2006,1,NULL,6,'0.99',48,'28.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (867,'SUPER WYOMING','A Action-Packed Saga of a Pastry Chef And a Explorer who must Discover a A Shark in The Outback',2006,1,NULL,5,'4.99',58,'10.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (868,'SUPERFLY TRIP','A Beautiful Saga of a Lumberjack And a Teacher who must Build a Technical Writer in An Abandoned Fun House',2006,1,NULL,5,'0.99',114,'27.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (869,'SUSPECTS QUILLS','A Emotional Epistle of a Pioneer And a Crocodile who must Battle a Man in A Manhattan Penthouse',2006,1,NULL,4,'2.99',47,'22.99','PG','Trailers','2006-02-15 05:03:42'),
 (870,'SWARM GOLD','A Insightful Panorama of a Crocodile And a Boat who must Conquer a Sumo Wrestler in A MySQL Convention',2006,1,NULL,4,'0.99',123,'12.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (871,'SWEDEN SHINING','A Taut Documentary of a Car And a Robot who must Conquer a Boy in The Canadian Rockies',2006,1,NULL,6,'4.99',176,'19.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (872,'SWEET BROTHERHOOD','A Unbelieveable Epistle of a Sumo Wrestler And a Hunter who must Chase a Forensic Psychologist in A Baloon',2006,1,NULL,3,'2.99',185,'27.99','R','Deleted Scenes','2006-02-15 05:03:42'),
 (873,'SWEETHEARTS SUSPECTS','A Brilliant Character Study of a Frisbee And a Sumo Wrestler who must Confront a Woman in The Gulf of Mexico',2006,1,NULL,3,'0.99',108,'13.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (874,'TADPOLE PARK','A Beautiful Tale of a Frisbee And a Moose who must Vanquish a Dog in An Abandoned Amusement Park',2006,1,NULL,6,'2.99',155,'13.99','PG','Trailers,Commentaries','2006-02-15 05:03:42'),
 (875,'TALENTED HOMICIDE','A Lacklusture Panorama of a Dentist And a Forensic Psychologist who must Outrace a Pioneer in A U-Boat',2006,1,NULL,6,'0.99',173,'9.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (876,'TARZAN VIDEOTAPE','A Fast-Paced Display of a Lumberjack And a Mad Scientist who must Succumb a Sumo Wrestler in The Sahara Desert',2006,1,NULL,3,'2.99',91,'11.99','PG-13','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (877,'TAXI KICK','A Amazing Epistle of a Girl And a Woman who must Outrace a Waitress in Soviet Georgia',2006,1,NULL,4,'0.99',64,'23.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (878,'TEEN APOLLO','A Awe-Inspiring Drama of a Dog And a Man who must Escape a Robot in A Shark Tank',2006,1,NULL,3,'4.99',74,'25.99','G','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (879,'TELEGRAPH VOYAGE','A Fateful Yarn of a Husband And a Dog who must Battle a Waitress in A Jet Boat',2006,1,NULL,3,'4.99',148,'20.99','PG','Commentaries','2006-02-15 05:03:42'),
 (880,'TELEMARK HEARTBREAKERS','A Action-Packed Panorama of a Technical Writer And a Man who must Build a Forensic Psychologist in A Manhattan Penthouse',2006,1,NULL,6,'2.99',152,'9.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (881,'TEMPLE ATTRACTION','A Action-Packed Saga of a Forensic Psychologist And a Woman who must Battle a Womanizer in Soviet Georgia',2006,1,NULL,5,'4.99',71,'13.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (882,'TENENBAUMS COMMAND','A Taut Display of a Pioneer And a Man who must Reach a Girl in The Gulf of Mexico',2006,1,NULL,4,'0.99',99,'24.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (883,'TEQUILA PAST','A Action-Packed Panorama of a Mad Scientist And a Robot who must Challenge a Student in Nigeria',2006,1,NULL,6,'4.99',53,'17.99','PG','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (884,'TERMINATOR CLUB','A Touching Story of a Crocodile And a Girl who must Sink a Man in The Gulf of Mexico',2006,1,NULL,5,'4.99',88,'11.99','R','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (885,'TEXAS WATCH','A Awe-Inspiring Yarn of a Student And a Teacher who must Fight a Teacher in An Abandoned Amusement Park',2006,1,NULL,7,'0.99',179,'22.99','NC-17','Trailers','2006-02-15 05:03:42'),
 (886,'THEORY MERMAID','A Fateful Yarn of a Composer And a Monkey who must Vanquish a Womanizer in The First Manned Space Station',2006,1,NULL,5,'0.99',184,'9.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (887,'THIEF PELICAN','A Touching Documentary of a Madman And a Mad Scientist who must Outrace a Feminist in An Abandoned Mine Shaft',2006,1,NULL,5,'4.99',135,'28.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (888,'THIN SAGEBRUSH','A Emotional Drama of a Husband And a Lumberjack who must Build a Cat in Ancient India',2006,1,NULL,5,'4.99',53,'9.99','PG-13','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (889,'TIES HUNGER','A Insightful Saga of a Astronaut And a Explorer who must Pursue a Mad Scientist in A U-Boat',2006,1,NULL,3,'4.99',111,'28.99','R','Deleted Scenes','2006-02-15 05:03:42'),
 (890,'TIGHTS DAWN','A Thrilling Epistle of a Boat And a Secret Agent who must Face a Boy in A Baloon',2006,1,NULL,5,'0.99',172,'14.99','R','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (891,'TIMBERLAND SKY','A Boring Display of a Man And a Dog who must Redeem a Girl in A U-Boat',2006,1,NULL,3,'0.99',69,'13.99','G','Commentaries','2006-02-15 05:03:42'),
 (892,'TITANIC BOONDOCK','A Brilliant Reflection of a Feminist And a Dog who must Fight a Boy in A Baloon Factory',2006,1,NULL,3,'4.99',104,'18.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (893,'TITANS JERK','A Unbelieveable Panorama of a Feminist And a Sumo Wrestler who must Challenge a Technical Writer in Ancient China',2006,1,NULL,4,'4.99',91,'11.99','PG','Behind the Scenes','2006-02-15 05:03:42'),
 (894,'TOMATOES HELLFIGHTERS','A Thoughtful Epistle of a Madman And a Astronaut who must Overcome a Monkey in A Shark Tank',2006,1,NULL,6,'0.99',68,'23.99','PG','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (895,'TOMORROW HUSTLER','A Thoughtful Story of a Moose And a Husband who must Face a Secret Agent in The Sahara Desert',2006,1,NULL,3,'2.99',142,'21.99','R','Commentaries','2006-02-15 05:03:42'),
 (896,'TOOTSIE PILOT','A Awe-Inspiring Documentary of a Womanizer And a Pastry Chef who must Kill a Lumberjack in Berlin',2006,1,NULL,3,'0.99',157,'10.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (897,'TORQUE BOUND','A Emotional Display of a Crocodile And a Husband who must Reach a Man in Ancient Japan',2006,1,NULL,3,'4.99',179,'27.99','G','Trailers,Commentaries','2006-02-15 05:03:42'),
 (898,'TOURIST PELICAN','A Boring Story of a Butler And a Astronaut who must Outrace a Pioneer in Australia',2006,1,NULL,4,'4.99',152,'18.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (899,'TOWERS HURRICANE','A Fateful Display of a Monkey And a Car who must Sink a Husband in A MySQL Convention',2006,1,NULL,7,'0.99',144,'14.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (900,'TOWN ARK','A Awe-Inspiring Documentary of a Moose And a Madman who must Meet a Dog in An Abandoned Mine Shaft',2006,1,NULL,6,'2.99',136,'17.99','R','Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (901,'TRACY CIDER','A Touching Reflection of a Database Administrator And a Madman who must Build a Lumberjack in Nigeria',2006,1,NULL,3,'0.99',142,'29.99','G','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (902,'TRADING PINOCCHIO','A Emotional Character Study of a Student And a Explorer who must Discover a Frisbee in The First Manned Space Station',2006,1,NULL,6,'4.99',170,'22.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (903,'TRAFFIC HOBBIT','A Amazing Epistle of a Squirrel And a Lumberjack who must Succumb a Database Administrator in A U-Boat',2006,1,NULL,5,'4.99',139,'13.99','G','Trailers,Commentaries','2006-02-15 05:03:42'),
 (904,'TRAIN BUNCH','A Thrilling Character Study of a Robot And a Squirrel who must Face a Dog in Ancient India',2006,1,NULL,3,'4.99',71,'26.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (905,'TRAINSPOTTING STRANGERS','A Fast-Paced Drama of a Pioneer And a Mad Cow who must Challenge a Madman in Ancient Japan',2006,1,NULL,7,'4.99',132,'10.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (906,'TRAMP OTHERS','A Brilliant Display of a Composer And a Cat who must Succumb a A Shark in Ancient India',2006,1,NULL,4,'0.99',171,'27.99','PG','Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (907,'TRANSLATION SUMMER','A Touching Reflection of a Man And a Monkey who must Pursue a Womanizer in A MySQL Convention',2006,1,NULL,4,'0.99',168,'10.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (908,'TRAP GUYS','A Unbelieveable Story of a Boy And a Mad Cow who must Challenge a Database Administrator in The Sahara Desert',2006,1,NULL,3,'4.99',110,'11.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (909,'TREASURE COMMAND','A Emotional Saga of a Car And a Madman who must Discover a Pioneer in California',2006,1,NULL,3,'0.99',102,'28.99','PG-13','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (910,'TREATMENT JEKYLL','A Boring Story of a Teacher And a Student who must Outgun a Cat in An Abandoned Mine Shaft',2006,1,NULL,3,'0.99',87,'19.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (911,'TRIP NEWTON','A Fanciful Character Study of a Lumberjack And a Car who must Discover a Cat in An Abandoned Amusement Park',2006,1,NULL,7,'4.99',64,'14.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (912,'TROJAN TOMORROW','A Astounding Panorama of a Husband And a Sumo Wrestler who must Pursue a Boat in Ancient India',2006,1,NULL,3,'2.99',52,'9.99','PG','Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (913,'TROOPERS METAL','A Fanciful Drama of a Monkey And a Feminist who must Sink a Man in Berlin',2006,1,NULL,3,'0.99',115,'20.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (914,'TROUBLE DATE','A Lacklusture Panorama of a Forensic Psychologist And a Woman who must Kill a Explorer in Ancient Japan',2006,1,NULL,6,'2.99',61,'13.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (915,'TRUMAN CRAZY','A Thrilling Epistle of a Moose And a Boy who must Meet a Database Administrator in A Monastery',2006,1,NULL,7,'4.99',92,'9.99','G','Trailers,Commentaries','2006-02-15 05:03:42'),
 (916,'TURN STAR','A Stunning Tale of a Man And a Monkey who must Chase a Student in New Orleans',2006,1,NULL,3,'2.99',80,'10.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (917,'TUXEDO MILE','A Boring Drama of a Man And a Forensic Psychologist who must Face a Frisbee in Ancient India',2006,1,NULL,3,'2.99',152,'24.99','R','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (918,'TWISTED PIRATES','A Touching Display of a Frisbee And a Boat who must Kill a Girl in A MySQL Convention',2006,1,NULL,4,'4.99',152,'23.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (919,'TYCOON GATHERING','A Emotional Display of a Husband And a A Shark who must Succumb a Madman in A Manhattan Penthouse',2006,1,NULL,3,'4.99',82,'17.99','G','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (920,'UNBREAKABLE KARATE','A Amazing Character Study of a Robot And a Student who must Chase a Robot in Australia',2006,1,NULL,3,'0.99',62,'16.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (921,'UNCUT SUICIDES','A Intrepid Yarn of a Explorer And a Pastry Chef who must Pursue a Mad Cow in A U-Boat',2006,1,NULL,7,'2.99',172,'29.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (922,'UNDEFEATED DALMATIONS','A Unbelieveable Display of a Crocodile And a Feminist who must Overcome a Moose in An Abandoned Amusement Park',2006,1,NULL,7,'4.99',107,'22.99','PG-13','Commentaries','2006-02-15 05:03:42'),
 (923,'UNFAITHFUL KILL','A Taut Documentary of a Waitress And a Mad Scientist who must Battle a Technical Writer in New Orleans',2006,1,NULL,7,'2.99',78,'12.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (924,'UNFORGIVEN ZOOLANDER','A Taut Epistle of a Monkey And a Sumo Wrestler who must Vanquish a A Shark in A Baloon Factory',2006,1,NULL,7,'0.99',129,'15.99','PG','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (925,'UNITED PILOT','A Fast-Paced Reflection of a Cat And a Mad Cow who must Fight a Car in The Sahara Desert',2006,1,NULL,3,'0.99',164,'27.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (926,'UNTOUCHABLES SUNRISE','A Amazing Documentary of a Woman And a Astronaut who must Outrace a Teacher in An Abandoned Fun House',2006,1,NULL,5,'2.99',120,'11.99','NC-17','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (927,'UPRISING UPTOWN','A Fanciful Reflection of a Boy And a Butler who must Pursue a Woman in Berlin',2006,1,NULL,6,'2.99',174,'16.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (928,'UPTOWN YOUNG','A Fateful Documentary of a Dog And a Hunter who must Pursue a Teacher in An Abandoned Amusement Park',2006,1,NULL,5,'2.99',84,'16.99','PG','Commentaries','2006-02-15 05:03:42'),
 (929,'USUAL UNTOUCHABLES','A Touching Display of a Explorer And a Lumberjack who must Fight a Forensic Psychologist in A Shark Tank',2006,1,NULL,5,'4.99',128,'21.99','PG-13','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (930,'VACATION BOONDOCK','A Fanciful Character Study of a Secret Agent And a Mad Scientist who must Reach a Teacher in Australia',2006,1,NULL,4,'2.99',145,'23.99','R','Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (931,'VALENTINE VANISHING','A Thrilling Display of a Husband And a Butler who must Reach a Pastry Chef in California',2006,1,NULL,7,'0.99',48,'9.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (932,'VALLEY PACKER','A Astounding Documentary of a Astronaut And a Boy who must Outrace a Sumo Wrestler in Berlin',2006,1,NULL,3,'0.99',73,'21.99','G','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (933,'VAMPIRE WHALE','A Epic Story of a Lumberjack And a Monkey who must Confront a Pioneer in A MySQL Convention',2006,1,NULL,4,'4.99',126,'11.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42'),
 (934,'VANILLA DAY','A Fast-Paced Saga of a Girl And a Forensic Psychologist who must Redeem a Girl in Nigeria',2006,1,NULL,7,'4.99',122,'20.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (935,'VANISHED GARDEN','A Intrepid Character Study of a Squirrel And a A Shark who must Kill a Lumberjack in California',2006,1,NULL,5,'0.99',142,'17.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (936,'VANISHING ROCKY','A Brilliant Reflection of a Man And a Woman who must Conquer a Pioneer in A MySQL Convention',2006,1,NULL,3,'2.99',123,'21.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (937,'VARSITY TRIP','A Action-Packed Character Study of a Astronaut And a Explorer who must Reach a Monkey in A MySQL Convention',2006,1,NULL,7,'2.99',85,'14.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (938,'VELVET TERMINATOR','A Lacklusture Tale of a Pastry Chef And a Technical Writer who must Confront a Crocodile in An Abandoned Amusement Park',2006,1,NULL,3,'4.99',173,'14.99','R','Behind the Scenes','2006-02-15 05:03:42'),
 (939,'VERTIGO NORTHWEST','A Unbelieveable Display of a Mad Scientist And a Mad Scientist who must Outgun a Mad Cow in Ancient Japan',2006,1,NULL,4,'2.99',90,'17.99','R','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (940,'VICTORY ACADEMY','A Insightful Epistle of a Mad Scientist And a Explorer who must Challenge a Cat in The Sahara Desert',2006,1,NULL,6,'0.99',64,'19.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (941,'VIDEOTAPE ARSENIC','A Lacklusture Display of a Girl And a Astronaut who must Succumb a Student in Australia',2006,1,NULL,4,'4.99',145,'10.99','NC-17','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (942,'VIETNAM SMOOCHY','A Lacklusture Display of a Butler And a Man who must Sink a Explorer in Soviet Georgia',2006,1,NULL,7,'0.99',174,'27.99','PG-13','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (943,'VILLAIN DESPERATE','A Boring Yarn of a Pioneer And a Feminist who must Redeem a Cat in An Abandoned Amusement Park',2006,1,NULL,4,'4.99',76,'27.99','PG-13','Trailers,Commentaries','2006-02-15 05:03:42'),
 (944,'VIRGIN DAISY','A Awe-Inspiring Documentary of a Robot And a Mad Scientist who must Reach a Database Administrator in A Shark Tank',2006,1,NULL,6,'4.99',179,'29.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (945,'VIRGINIAN PLUTO','A Emotional Panorama of a Dentist And a Crocodile who must Meet a Boy in Berlin',2006,1,NULL,5,'0.99',164,'22.99','R','Deleted Scenes','2006-02-15 05:03:42'),
 (946,'VIRTUAL SPOILERS','A Fateful Tale of a Database Administrator And a Squirrel who must Discover a Student in Soviet Georgia',2006,1,NULL,3,'4.99',144,'14.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (947,'VISION TORQUE','A Thoughtful Documentary of a Dog And a Man who must Sink a Man in A Shark Tank',2006,1,NULL,5,'0.99',59,'16.99','PG-13','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (948,'VOICE PEACH','A Amazing Panorama of a Pioneer And a Student who must Overcome a Mad Scientist in A Manhattan Penthouse',2006,1,NULL,6,'0.99',139,'22.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (949,'VOLCANO TEXAS','A Awe-Inspiring Yarn of a Hunter And a Feminist who must Challenge a Dentist in The Outback',2006,1,NULL,6,'0.99',157,'27.99','NC-17','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (950,'VOLUME HOUSE','A Boring Tale of a Dog And a Woman who must Meet a Dentist in California',2006,1,NULL,7,'4.99',132,'12.99','PG','Commentaries','2006-02-15 05:03:42'),
 (951,'VOYAGE LEGALLY','A Epic Tale of a Squirrel And a Hunter who must Conquer a Boy in An Abandoned Mine Shaft',2006,1,NULL,6,'0.99',78,'28.99','PG-13','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (952,'WAGON JAWS','A Intrepid Drama of a Moose And a Boat who must Kill a Explorer in A Manhattan Penthouse',2006,1,NULL,7,'2.99',152,'17.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (953,'WAIT CIDER','A Intrepid Epistle of a Woman And a Forensic Psychologist who must Succumb a Astronaut in A Manhattan Penthouse',2006,1,NULL,3,'0.99',112,'9.99','PG-13','Trailers','2006-02-15 05:03:42'),
 (954,'WAKE JAWS','A Beautiful Saga of a Feminist And a Composer who must Challenge a Moose in Berlin',2006,1,NULL,7,'4.99',73,'18.99','G','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (955,'WALLS ARTIST','A Insightful Panorama of a Teacher And a Teacher who must Overcome a Mad Cow in An Abandoned Fun House',2006,1,NULL,7,'4.99',135,'19.99','PG','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (956,'WANDA CHAMBER','A Insightful Drama of a A Shark And a Pioneer who must Find a Womanizer in The Outback',2006,1,NULL,7,'4.99',107,'23.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (957,'WAR NOTTING','A Boring Drama of a Teacher And a Sumo Wrestler who must Challenge a Secret Agent in The Canadian Rockies',2006,1,NULL,7,'4.99',80,'26.99','G','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (958,'WARDROBE PHANTOM','A Action-Packed Display of a Mad Cow And a Astronaut who must Kill a Car in Ancient India',2006,1,NULL,6,'2.99',178,'19.99','G','Trailers,Commentaries','2006-02-15 05:03:42'),
 (959,'WARLOCK WEREWOLF','A Astounding Yarn of a Pioneer And a Crocodile who must Defeat a A Shark in The Outback',2006,1,NULL,6,'2.99',83,'10.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (960,'WARS PLUTO','A Taut Reflection of a Teacher And a Database Administrator who must Chase a Madman in The Sahara Desert',2006,1,NULL,5,'2.99',128,'15.99','G','Commentaries,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (961,'WASH HEAVENLY','A Awe-Inspiring Reflection of a Cat And a Pioneer who must Escape a Hunter in Ancient China',2006,1,NULL,7,'4.99',161,'22.99','R','Commentaries','2006-02-15 05:03:42'),
 (962,'WASTELAND DIVINE','A Fanciful Story of a Database Administrator And a Womanizer who must Fight a Database Administrator in Ancient China',2006,1,NULL,7,'2.99',85,'18.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (963,'WATCH TRACY','A Fast-Paced Yarn of a Dog And a Frisbee who must Conquer a Hunter in Nigeria',2006,1,NULL,5,'0.99',78,'12.99','PG','Trailers,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (964,'WATERFRONT DELIVERANCE','A Unbelieveable Documentary of a Dentist And a Technical Writer who must Build a Womanizer in Nigeria',2006,1,NULL,4,'4.99',61,'17.99','G','Behind the Scenes','2006-02-15 05:03:42'),
 (965,'WATERSHIP FRONTIER','A Emotional Yarn of a Boat And a Crocodile who must Meet a Moose in Soviet Georgia',2006,1,NULL,6,'0.99',112,'28.99','G','Commentaries','2006-02-15 05:03:42'),
 (966,'WEDDING APOLLO','A Action-Packed Tale of a Student And a Waitress who must Conquer a Lumberjack in An Abandoned Mine Shaft',2006,1,NULL,3,'0.99',70,'14.99','PG','Trailers','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (967,'WEEKEND PERSONAL','A Fast-Paced Documentary of a Car And a Butler who must Find a Frisbee in A Jet Boat',2006,1,NULL,5,'2.99',134,'26.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (968,'WEREWOLF LOLA','A Fanciful Story of a Man And a Sumo Wrestler who must Outrace a Student in A Monastery',2006,1,NULL,6,'4.99',79,'19.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (969,'WEST LION','A Intrepid Drama of a Butler And a Lumberjack who must Challenge a Database Administrator in A Manhattan Penthouse',2006,1,NULL,4,'4.99',159,'29.99','G','Trailers','2006-02-15 05:03:42'),
 (970,'WESTWARD SEABISCUIT','A Lacklusture Tale of a Butler And a Husband who must Face a Boy in Ancient China',2006,1,NULL,7,'0.99',52,'11.99','NC-17','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (971,'WHALE BIKINI','A Intrepid Story of a Pastry Chef And a Database Administrator who must Kill a Feminist in A MySQL Convention',2006,1,NULL,4,'4.99',109,'11.99','PG-13','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (972,'WHISPERER GIANT','A Intrepid Story of a Dentist And a Hunter who must Confront a Monkey in Ancient Japan',2006,1,NULL,4,'4.99',59,'24.99','PG-13','Trailers,Deleted Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (973,'WIFE TURN','A Awe-Inspiring Epistle of a Teacher And a Feminist who must Confront a Pioneer in Ancient Japan',2006,1,NULL,3,'4.99',183,'27.99','NC-17','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (974,'WILD APOLLO','A Beautiful Story of a Monkey And a Sumo Wrestler who must Conquer a A Shark in A MySQL Convention',2006,1,NULL,4,'0.99',181,'24.99','R','Trailers,Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (975,'WILLOW TRACY','A Brilliant Panorama of a Boat And a Astronaut who must Challenge a Teacher in A Manhattan Penthouse',2006,1,NULL,6,'2.99',137,'22.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (976,'WIND PHANTOM','A Touching Saga of a Madman And a Forensic Psychologist who must Build a Sumo Wrestler in An Abandoned Mine Shaft',2006,1,NULL,6,'0.99',111,'12.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (977,'WINDOW SIDE','A Astounding Character Study of a Womanizer And a Hunter who must Escape a Robot in A Monastery',2006,1,NULL,3,'2.99',85,'25.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (978,'WISDOM WORKER','A Unbelieveable Saga of a Forensic Psychologist And a Student who must Face a Squirrel in The First Manned Space Station',2006,1,NULL,3,'0.99',98,'12.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (979,'WITCHES PANIC','A Awe-Inspiring Drama of a Secret Agent And a Hunter who must Fight a Moose in Nigeria',2006,1,NULL,6,'4.99',100,'10.99','NC-17','Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (980,'WIZARD COLDBLOODED','A Lacklusture Display of a Robot And a Girl who must Defeat a Sumo Wrestler in A MySQL Convention',2006,1,NULL,4,'4.99',75,'12.99','PG','Commentaries,Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (981,'WOLVES DESIRE','A Fast-Paced Drama of a Squirrel And a Robot who must Succumb a Technical Writer in A Manhattan Penthouse',2006,1,NULL,7,'0.99',55,'13.99','NC-17','Behind the Scenes','2006-02-15 05:03:42'),
 (982,'WOMEN DORADO','A Insightful Documentary of a Waitress And a Butler who must Vanquish a Composer in Australia',2006,1,NULL,4,'0.99',126,'23.99','R','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (983,'WON DARES','A Unbelieveable Documentary of a Teacher And a Monkey who must Defeat a Explorer in A U-Boat',2006,1,NULL,7,'2.99',105,'18.99','PG','Behind the Scenes','2006-02-15 05:03:42'),
 (984,'WONDERFUL DROP','A Boring Panorama of a Woman And a Madman who must Overcome a Butler in A U-Boat',2006,1,NULL,3,'2.99',126,'20.99','NC-17','Commentaries','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (985,'WONDERLAND CHRISTMAS','A Awe-Inspiring Character Study of a Waitress And a Car who must Pursue a Mad Scientist in The First Manned Space Station',2006,1,NULL,4,'4.99',111,'19.99','PG','Commentaries','2006-02-15 05:03:42'),
 (986,'WONKA SEA','A Brilliant Saga of a Boat And a Mad Scientist who must Meet a Moose in Ancient India',2006,1,NULL,6,'2.99',85,'24.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42'),
 (987,'WORDS HUNTER','A Action-Packed Reflection of a Composer And a Mad Scientist who must Face a Pioneer in A MySQL Convention',2006,1,NULL,3,'2.99',116,'13.99','PG','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (988,'WORKER TARZAN','A Action-Packed Yarn of a Secret Agent And a Technical Writer who must Battle a Sumo Wrestler in The First Manned Space Station',2006,1,NULL,7,'2.99',139,'26.99','R','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42'),
 (989,'WORKING MICROCOSMOS','A Stunning Epistle of a Dentist And a Dog who must Kill a Madman in Ancient China',2006,1,NULL,4,'4.99',74,'22.99','R','Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (990,'WORLD LEATHERNECKS','A Unbelieveable Tale of a Pioneer And a Astronaut who must Overcome a Robot in An Abandoned Amusement Park',2006,1,NULL,3,'0.99',171,'13.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (991,'WORST BANGER','A Thrilling Drama of a Madman And a Dentist who must Conquer a Boy in The Outback',2006,1,NULL,4,'2.99',185,'26.99','PG','Deleted Scenes,Behind the Scenes','2006-02-15 05:03:42'),
 (992,'WRATH MILE','A Intrepid Reflection of a Technical Writer And a Hunter who must Defeat a Sumo Wrestler in A Monastery',2006,1,NULL,5,'0.99',176,'17.99','NC-17','Trailers,Commentaries','2006-02-15 05:03:42'),
 (993,'WRONG BEHAVIOR','A Emotional Saga of a Crocodile And a Sumo Wrestler who must Discover a Mad Cow in New Orleans',2006,1,NULL,6,'2.99',178,'10.99','PG-13','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (994,'WYOMING STORM','A Awe-Inspiring Panorama of a Robot And a Boat who must Overcome a Feminist in A U-Boat',2006,1,NULL,6,'4.99',100,'29.99','PG-13','Deleted Scenes','2006-02-15 05:03:42'),
 (995,'YENTL IDAHO','A Amazing Display of a Robot And a Astronaut who must Fight a Womanizer in Berlin',2006,1,NULL,5,'4.99',86,'11.99','R','Trailers,Commentaries,Deleted Scenes','2006-02-15 05:03:42'),
 (996,'YOUNG LANGUAGE','A Unbelieveable Yarn of a Boat And a Database Administrator who must Meet a Boy in The First Manned Space Station',2006,1,NULL,6,'0.99',183,'9.99','G','Trailers,Behind the Scenes','2006-02-15 05:03:42');
INSERT INTO `sakila`.`film` VALUES  (997,'YOUTH KICK','A Touching Drama of a Teacher And a Cat who must Challenge a Technical Writer in A U-Boat',2006,1,NULL,4,'0.99',179,'14.99','NC-17','Trailers,Behind the Scenes','2006-02-15 05:03:42'),
 (998,'ZHIVAGO CORE','A Fateful Yarn of a Composer And a Man who must Face a Boy in The Canadian Rockies',2006,1,NULL,6,'0.99',105,'10.99','NC-17','Deleted Scenes','2006-02-15 05:03:42'),
 (999,'ZOOLANDER FICTION','A Fateful Reflection of a Waitress And a Boat who must Discover a Sumo Wrestler in Ancient China',2006,1,NULL,5,'2.99',101,'28.99','R','Trailers,Deleted Scenes','2006-02-15 05:03:42'),
 (1000,'ZORRO ARK','A Intrepid Panorama of a Mad Scientist And a Boy who must Redeem a Boy in A Monastery',2006,1,NULL,3,'4.99',50,'18.99','NC-17','Trailers,Commentaries,Behind the Scenes','2006-02-15 05:03:42');
UNLOCK TABLES;
/*!40000 ALTER TABLE `film` ENABLE KEYS */;


--
-- Definition of trigger `sakila`.`film`
--

DROP TRIGGER IF EXISTS `sakila`.`film`;

DELIMITER $$

CREATE DEFINER = `root`@`%` TRIGGER  `sakila`.`ins_film` AFTER INSERT ON `film` FOR EACH ROW BEGIN
    INSERT INTO film_text (film_id, title, description)
        VALUES (new.film_id, new.title, new.description);
  END $$

DELIMITER ;

--
-- Definition of trigger `sakila`.`film`
--

DROP TRIGGER IF EXISTS `sakila`.`film`;

DELIMITER $$

CREATE DEFINER = `root`@`%` TRIGGER  `sakila`.`upd_film` AFTER UPDATE ON `film` FOR EACH ROW BEGIN
    IF (old.title != new.title) or (old.description != new.description)
    THEN
        UPDATE film_text
            SET title=new.title,
                description=new.description,
                film_id=new.film_id
        WHERE film_id=old.film_id;
    END IF;
  END $$

DELIMITER ;

--
-- Definition of trigger `sakila`.`film`
--

DROP TRIGGER IF EXISTS `sakila`.`film`;

DELIMITER $$

CREATE DEFINER = `root`@`%` TRIGGER  `sakila`.`del_film` AFTER DELETE ON `film` FOR EACH ROW BEGIN
    DELETE FROM film_text WHERE film_id = old.film_id;
  END $$

DELIMITER ;

--
-- Definition of table `sakila`.`city`
--

DROP TABLE IF EXISTS `sakila`.`city`;
CREATE TABLE  `sakila`.`city` (
  `city_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `city` varchar(50) NOT NULL,
  `country_id` smallint(5) unsigned NOT NULL,
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`city_id`),
  KEY `idx_fk_country_id` (`country_id`),
  CONSTRAINT `fk_city_country` FOREIGN KEY (`country_id`) REFERENCES `country` (`country_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sakila`.`city`
--

/*!40000 ALTER TABLE `city` DISABLE KEYS */;
LOCK TABLES `city` WRITE;
INSERT INTO `sakila`.`city` VALUES  (1,'A Corua (La Corua)',87,'2006-02-15 04:45:25'),
 (2,'Abha',82,'2006-02-15 04:45:25'),
 (3,'Abu Dhabi',101,'2006-02-15 04:45:25'),
 (4,'Acua',60,'2006-02-15 04:45:25'),
 (5,'Adana',97,'2006-02-15 04:45:25'),
 (6,'Addis Abeba',31,'2006-02-15 04:45:25'),
 (7,'Aden',107,'2006-02-15 04:45:25'),
 (8,'Adoni',44,'2006-02-15 04:45:25'),
 (9,'Ahmadnagar',44,'2006-02-15 04:45:25'),
 (10,'Akishima',50,'2006-02-15 04:45:25'),
 (11,'Akron',103,'2006-02-15 04:45:25'),
 (12,'al-Ayn',101,'2006-02-15 04:45:25'),
 (13,'al-Hawiya',82,'2006-02-15 04:45:25'),
 (14,'al-Manama',11,'2006-02-15 04:45:25'),
 (15,'al-Qadarif',89,'2006-02-15 04:45:25'),
 (16,'al-Qatif',82,'2006-02-15 04:45:25'),
 (17,'Alessandria',49,'2006-02-15 04:45:25'),
 (18,'Allappuzha (Alleppey)',44,'2006-02-15 04:45:25'),
 (19,'Allende',60,'2006-02-15 04:45:25'),
 (20,'Almirante Brown',6,'2006-02-15 04:45:25'),
 (21,'Alvorada',15,'2006-02-15 04:45:25'),
 (22,'Ambattur',44,'2006-02-15 04:45:25'),
 (23,'Amersfoort',67,'2006-02-15 04:45:25'),
 (24,'Amroha',44,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (25,'Angra dos Reis',15,'2006-02-15 04:45:25'),
 (26,'Anpolis',15,'2006-02-15 04:45:25'),
 (27,'Antofagasta',22,'2006-02-15 04:45:25'),
 (28,'Aparecida de Goinia',15,'2006-02-15 04:45:25'),
 (29,'Apeldoorn',67,'2006-02-15 04:45:25'),
 (30,'Araatuba',15,'2006-02-15 04:45:25'),
 (31,'Arak',46,'2006-02-15 04:45:25'),
 (32,'Arecibo',77,'2006-02-15 04:45:25'),
 (33,'Arlington',103,'2006-02-15 04:45:25'),
 (34,'Ashdod',48,'2006-02-15 04:45:25'),
 (35,'Ashgabat',98,'2006-02-15 04:45:25'),
 (36,'Ashqelon',48,'2006-02-15 04:45:25'),
 (37,'Asuncin',73,'2006-02-15 04:45:25'),
 (38,'Athenai',39,'2006-02-15 04:45:25'),
 (39,'Atinsk',80,'2006-02-15 04:45:25'),
 (40,'Atlixco',60,'2006-02-15 04:45:25'),
 (41,'Augusta-Richmond County',103,'2006-02-15 04:45:25'),
 (42,'Aurora',103,'2006-02-15 04:45:25'),
 (43,'Avellaneda',6,'2006-02-15 04:45:25'),
 (44,'Bag',15,'2006-02-15 04:45:25'),
 (45,'Baha Blanca',6,'2006-02-15 04:45:25'),
 (46,'Baicheng',23,'2006-02-15 04:45:25'),
 (47,'Baiyin',23,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (48,'Baku',10,'2006-02-15 04:45:25'),
 (49,'Balaiha',80,'2006-02-15 04:45:25'),
 (50,'Balikesir',97,'2006-02-15 04:45:25'),
 (51,'Balurghat',44,'2006-02-15 04:45:25'),
 (52,'Bamenda',19,'2006-02-15 04:45:25'),
 (53,'Bandar Seri Begawan',16,'2006-02-15 04:45:25'),
 (54,'Banjul',37,'2006-02-15 04:45:25'),
 (55,'Barcelona',104,'2006-02-15 04:45:25'),
 (56,'Basel',91,'2006-02-15 04:45:25'),
 (57,'Bat Yam',48,'2006-02-15 04:45:25'),
 (58,'Batman',97,'2006-02-15 04:45:25'),
 (59,'Batna',2,'2006-02-15 04:45:25'),
 (60,'Battambang',18,'2006-02-15 04:45:25'),
 (61,'Baybay',75,'2006-02-15 04:45:25'),
 (62,'Bayugan',75,'2006-02-15 04:45:25'),
 (63,'Bchar',2,'2006-02-15 04:45:25'),
 (64,'Beira',63,'2006-02-15 04:45:25'),
 (65,'Bellevue',103,'2006-02-15 04:45:25'),
 (66,'Belm',15,'2006-02-15 04:45:25'),
 (67,'Benguela',4,'2006-02-15 04:45:25'),
 (68,'Beni-Mellal',62,'2006-02-15 04:45:25'),
 (69,'Benin City',69,'2006-02-15 04:45:25'),
 (70,'Bergamo',49,'2006-02-15 04:45:25'),
 (71,'Berhampore (Baharampur)',44,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (72,'Bern',91,'2006-02-15 04:45:25'),
 (73,'Bhavnagar',44,'2006-02-15 04:45:25'),
 (74,'Bhilwara',44,'2006-02-15 04:45:25'),
 (75,'Bhimavaram',44,'2006-02-15 04:45:25'),
 (76,'Bhopal',44,'2006-02-15 04:45:25'),
 (77,'Bhusawal',44,'2006-02-15 04:45:25'),
 (78,'Bijapur',44,'2006-02-15 04:45:25'),
 (79,'Bilbays',29,'2006-02-15 04:45:25'),
 (80,'Binzhou',23,'2006-02-15 04:45:25'),
 (81,'Birgunj',66,'2006-02-15 04:45:25'),
 (82,'Bislig',75,'2006-02-15 04:45:25'),
 (83,'Blumenau',15,'2006-02-15 04:45:25'),
 (84,'Boa Vista',15,'2006-02-15 04:45:25'),
 (85,'Boksburg',85,'2006-02-15 04:45:25'),
 (86,'Botosani',78,'2006-02-15 04:45:25'),
 (87,'Botshabelo',85,'2006-02-15 04:45:25'),
 (88,'Bradford',102,'2006-02-15 04:45:25'),
 (89,'Braslia',15,'2006-02-15 04:45:25'),
 (90,'Bratislava',84,'2006-02-15 04:45:25'),
 (91,'Brescia',49,'2006-02-15 04:45:25'),
 (92,'Brest',34,'2006-02-15 04:45:25'),
 (93,'Brindisi',49,'2006-02-15 04:45:25'),
 (94,'Brockton',103,'2006-02-15 04:45:25'),
 (95,'Bucuresti',78,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (96,'Buenaventura',24,'2006-02-15 04:45:25'),
 (97,'Bydgoszcz',76,'2006-02-15 04:45:25'),
 (98,'Cabuyao',75,'2006-02-15 04:45:25'),
 (99,'Callao',74,'2006-02-15 04:45:25'),
 (100,'Cam Ranh',105,'2006-02-15 04:45:25'),
 (101,'Cape Coral',103,'2006-02-15 04:45:25'),
 (102,'Caracas',104,'2006-02-15 04:45:25'),
 (103,'Carmen',60,'2006-02-15 04:45:25'),
 (104,'Cavite',75,'2006-02-15 04:45:25'),
 (105,'Cayenne',35,'2006-02-15 04:45:25'),
 (106,'Celaya',60,'2006-02-15 04:45:25'),
 (107,'Chandrapur',44,'2006-02-15 04:45:25'),
 (108,'Changhwa',92,'2006-02-15 04:45:25'),
 (109,'Changzhou',23,'2006-02-15 04:45:25'),
 (110,'Chapra',44,'2006-02-15 04:45:25'),
 (111,'Charlotte Amalie',106,'2006-02-15 04:45:25'),
 (112,'Chatsworth',85,'2006-02-15 04:45:25'),
 (113,'Cheju',86,'2006-02-15 04:45:25'),
 (114,'Chiayi',92,'2006-02-15 04:45:25'),
 (115,'Chisinau',61,'2006-02-15 04:45:25'),
 (116,'Chungho',92,'2006-02-15 04:45:25'),
 (117,'Cianjur',45,'2006-02-15 04:45:25'),
 (118,'Ciomas',45,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (119,'Ciparay',45,'2006-02-15 04:45:25'),
 (120,'Citrus Heights',103,'2006-02-15 04:45:25'),
 (121,'Citt del Vaticano',41,'2006-02-15 04:45:25'),
 (122,'Ciudad del Este',73,'2006-02-15 04:45:25'),
 (123,'Clarksville',103,'2006-02-15 04:45:25'),
 (124,'Coacalco de Berriozbal',60,'2006-02-15 04:45:25'),
 (125,'Coatzacoalcos',60,'2006-02-15 04:45:25'),
 (126,'Compton',103,'2006-02-15 04:45:25'),
 (127,'Coquimbo',22,'2006-02-15 04:45:25'),
 (128,'Crdoba',6,'2006-02-15 04:45:25'),
 (129,'Cuauhtmoc',60,'2006-02-15 04:45:25'),
 (130,'Cuautla',60,'2006-02-15 04:45:25'),
 (131,'Cuernavaca',60,'2006-02-15 04:45:25'),
 (132,'Cuman',104,'2006-02-15 04:45:25'),
 (133,'Czestochowa',76,'2006-02-15 04:45:25'),
 (134,'Dadu',72,'2006-02-15 04:45:25'),
 (135,'Dallas',103,'2006-02-15 04:45:25'),
 (136,'Datong',23,'2006-02-15 04:45:25'),
 (137,'Daugavpils',54,'2006-02-15 04:45:25'),
 (138,'Davao',75,'2006-02-15 04:45:25'),
 (139,'Daxian',23,'2006-02-15 04:45:25'),
 (140,'Dayton',103,'2006-02-15 04:45:25'),
 (141,'Deba Habe',69,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (142,'Denizli',97,'2006-02-15 04:45:25'),
 (143,'Dhaka',12,'2006-02-15 04:45:25'),
 (144,'Dhule (Dhulia)',44,'2006-02-15 04:45:25'),
 (145,'Dongying',23,'2006-02-15 04:45:25'),
 (146,'Donostia-San Sebastin',87,'2006-02-15 04:45:25'),
 (147,'Dos Quebradas',24,'2006-02-15 04:45:25'),
 (148,'Duisburg',38,'2006-02-15 04:45:25'),
 (149,'Dundee',102,'2006-02-15 04:45:25'),
 (150,'Dzerzinsk',80,'2006-02-15 04:45:25'),
 (151,'Ede',67,'2006-02-15 04:45:25'),
 (152,'Effon-Alaiye',69,'2006-02-15 04:45:25'),
 (153,'El Alto',14,'2006-02-15 04:45:25'),
 (154,'El Fuerte',60,'2006-02-15 04:45:25'),
 (155,'El Monte',103,'2006-02-15 04:45:25'),
 (156,'Elista',80,'2006-02-15 04:45:25'),
 (157,'Emeishan',23,'2006-02-15 04:45:25'),
 (158,'Emmen',67,'2006-02-15 04:45:25'),
 (159,'Enshi',23,'2006-02-15 04:45:25'),
 (160,'Erlangen',38,'2006-02-15 04:45:25'),
 (161,'Escobar',6,'2006-02-15 04:45:25'),
 (162,'Esfahan',46,'2006-02-15 04:45:25'),
 (163,'Eskisehir',97,'2006-02-15 04:45:25'),
 (164,'Etawah',44,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (165,'Ezeiza',6,'2006-02-15 04:45:25'),
 (166,'Ezhou',23,'2006-02-15 04:45:25'),
 (167,'Faaa',36,'2006-02-15 04:45:25'),
 (168,'Fengshan',92,'2006-02-15 04:45:25'),
 (169,'Firozabad',44,'2006-02-15 04:45:25'),
 (170,'Florencia',24,'2006-02-15 04:45:25'),
 (171,'Fontana',103,'2006-02-15 04:45:25'),
 (172,'Fukuyama',50,'2006-02-15 04:45:25'),
 (173,'Funafuti',99,'2006-02-15 04:45:25'),
 (174,'Fuyu',23,'2006-02-15 04:45:25'),
 (175,'Fuzhou',23,'2006-02-15 04:45:25'),
 (176,'Gandhinagar',44,'2006-02-15 04:45:25'),
 (177,'Garden Grove',103,'2006-02-15 04:45:25'),
 (178,'Garland',103,'2006-02-15 04:45:25'),
 (179,'Gatineau',20,'2006-02-15 04:45:25'),
 (180,'Gaziantep',97,'2006-02-15 04:45:25'),
 (181,'Gijn',87,'2006-02-15 04:45:25'),
 (182,'Gingoog',75,'2006-02-15 04:45:25'),
 (183,'Goinia',15,'2006-02-15 04:45:25'),
 (184,'Gorontalo',45,'2006-02-15 04:45:25'),
 (185,'Grand Prairie',103,'2006-02-15 04:45:25'),
 (186,'Graz',9,'2006-02-15 04:45:25'),
 (187,'Greensboro',103,'2006-02-15 04:45:25'),
 (188,'Guadalajara',60,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (189,'Guaruj',15,'2006-02-15 04:45:25'),
 (190,'guas Lindas de Gois',15,'2006-02-15 04:45:25'),
 (191,'Gulbarga',44,'2006-02-15 04:45:25'),
 (192,'Hagonoy',75,'2006-02-15 04:45:25'),
 (193,'Haining',23,'2006-02-15 04:45:25'),
 (194,'Haiphong',105,'2006-02-15 04:45:25'),
 (195,'Haldia',44,'2006-02-15 04:45:25'),
 (196,'Halifax',20,'2006-02-15 04:45:25'),
 (197,'Halisahar',44,'2006-02-15 04:45:25'),
 (198,'Halle/Saale',38,'2006-02-15 04:45:25'),
 (199,'Hami',23,'2006-02-15 04:45:25'),
 (200,'Hamilton',68,'2006-02-15 04:45:25'),
 (201,'Hanoi',105,'2006-02-15 04:45:25'),
 (202,'Hidalgo',60,'2006-02-15 04:45:25'),
 (203,'Higashiosaka',50,'2006-02-15 04:45:25'),
 (204,'Hino',50,'2006-02-15 04:45:25'),
 (205,'Hiroshima',50,'2006-02-15 04:45:25'),
 (206,'Hodeida',107,'2006-02-15 04:45:25'),
 (207,'Hohhot',23,'2006-02-15 04:45:25'),
 (208,'Hoshiarpur',44,'2006-02-15 04:45:25'),
 (209,'Hsichuh',92,'2006-02-15 04:45:25'),
 (210,'Huaian',23,'2006-02-15 04:45:25'),
 (211,'Hubli-Dharwad',44,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (212,'Huejutla de Reyes',60,'2006-02-15 04:45:25'),
 (213,'Huixquilucan',60,'2006-02-15 04:45:25'),
 (214,'Hunuco',74,'2006-02-15 04:45:25'),
 (215,'Ibirit',15,'2006-02-15 04:45:25'),
 (216,'Idfu',29,'2006-02-15 04:45:25'),
 (217,'Ife',69,'2006-02-15 04:45:25'),
 (218,'Ikerre',69,'2006-02-15 04:45:25'),
 (219,'Iligan',75,'2006-02-15 04:45:25'),
 (220,'Ilorin',69,'2006-02-15 04:45:25'),
 (221,'Imus',75,'2006-02-15 04:45:25'),
 (222,'Inegl',97,'2006-02-15 04:45:25'),
 (223,'Ipoh',59,'2006-02-15 04:45:25'),
 (224,'Isesaki',50,'2006-02-15 04:45:25'),
 (225,'Ivanovo',80,'2006-02-15 04:45:25'),
 (226,'Iwaki',50,'2006-02-15 04:45:25'),
 (227,'Iwakuni',50,'2006-02-15 04:45:25'),
 (228,'Iwatsuki',50,'2006-02-15 04:45:25'),
 (229,'Izumisano',50,'2006-02-15 04:45:25'),
 (230,'Jaffna',88,'2006-02-15 04:45:25'),
 (231,'Jaipur',44,'2006-02-15 04:45:25'),
 (232,'Jakarta',45,'2006-02-15 04:45:25'),
 (233,'Jalib al-Shuyukh',53,'2006-02-15 04:45:25'),
 (234,'Jamalpur',12,'2006-02-15 04:45:25'),
 (235,'Jaroslavl',80,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (236,'Jastrzebie-Zdrj',76,'2006-02-15 04:45:25'),
 (237,'Jedda',82,'2006-02-15 04:45:25'),
 (238,'Jelets',80,'2006-02-15 04:45:25'),
 (239,'Jhansi',44,'2006-02-15 04:45:25'),
 (240,'Jinchang',23,'2006-02-15 04:45:25'),
 (241,'Jining',23,'2006-02-15 04:45:25'),
 (242,'Jinzhou',23,'2006-02-15 04:45:25'),
 (243,'Jodhpur',44,'2006-02-15 04:45:25'),
 (244,'Johannesburg',85,'2006-02-15 04:45:25'),
 (245,'Joliet',103,'2006-02-15 04:45:25'),
 (246,'Jos Azueta',60,'2006-02-15 04:45:25'),
 (247,'Juazeiro do Norte',15,'2006-02-15 04:45:25'),
 (248,'Juiz de Fora',15,'2006-02-15 04:45:25'),
 (249,'Junan',23,'2006-02-15 04:45:25'),
 (250,'Jurez',60,'2006-02-15 04:45:25'),
 (251,'Kabul',1,'2006-02-15 04:45:25'),
 (252,'Kaduna',69,'2006-02-15 04:45:25'),
 (253,'Kakamigahara',50,'2006-02-15 04:45:25'),
 (254,'Kaliningrad',80,'2006-02-15 04:45:25'),
 (255,'Kalisz',76,'2006-02-15 04:45:25'),
 (256,'Kamakura',50,'2006-02-15 04:45:25'),
 (257,'Kamarhati',44,'2006-02-15 04:45:25'),
 (258,'Kamjanets-Podilskyi',100,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (259,'Kamyin',80,'2006-02-15 04:45:25'),
 (260,'Kanazawa',50,'2006-02-15 04:45:25'),
 (261,'Kanchrapara',44,'2006-02-15 04:45:25'),
 (262,'Kansas City',103,'2006-02-15 04:45:25'),
 (263,'Karnal',44,'2006-02-15 04:45:25'),
 (264,'Katihar',44,'2006-02-15 04:45:25'),
 (265,'Kermanshah',46,'2006-02-15 04:45:25'),
 (266,'Kilis',97,'2006-02-15 04:45:25'),
 (267,'Kimberley',85,'2006-02-15 04:45:25'),
 (268,'Kimchon',86,'2006-02-15 04:45:25'),
 (269,'Kingstown',81,'2006-02-15 04:45:25'),
 (270,'Kirovo-Tepetsk',80,'2006-02-15 04:45:25'),
 (271,'Kisumu',52,'2006-02-15 04:45:25'),
 (272,'Kitwe',109,'2006-02-15 04:45:25'),
 (273,'Klerksdorp',85,'2006-02-15 04:45:25'),
 (274,'Kolpino',80,'2006-02-15 04:45:25'),
 (275,'Konotop',100,'2006-02-15 04:45:25'),
 (276,'Koriyama',50,'2006-02-15 04:45:25'),
 (277,'Korla',23,'2006-02-15 04:45:25'),
 (278,'Korolev',80,'2006-02-15 04:45:25'),
 (279,'Kowloon and New Kowloon',42,'2006-02-15 04:45:25'),
 (280,'Kragujevac',108,'2006-02-15 04:45:25'),
 (281,'Ktahya',97,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (282,'Kuching',59,'2006-02-15 04:45:25'),
 (283,'Kumbakonam',44,'2006-02-15 04:45:25'),
 (284,'Kurashiki',50,'2006-02-15 04:45:25'),
 (285,'Kurgan',80,'2006-02-15 04:45:25'),
 (286,'Kursk',80,'2006-02-15 04:45:25'),
 (287,'Kuwana',50,'2006-02-15 04:45:25'),
 (288,'La Paz',60,'2006-02-15 04:45:25'),
 (289,'La Plata',6,'2006-02-15 04:45:25'),
 (290,'La Romana',27,'2006-02-15 04:45:25'),
 (291,'Laiwu',23,'2006-02-15 04:45:25'),
 (292,'Lancaster',103,'2006-02-15 04:45:25'),
 (293,'Laohekou',23,'2006-02-15 04:45:25'),
 (294,'Lapu-Lapu',75,'2006-02-15 04:45:25'),
 (295,'Laredo',103,'2006-02-15 04:45:25'),
 (296,'Lausanne',91,'2006-02-15 04:45:25'),
 (297,'Le Mans',34,'2006-02-15 04:45:25'),
 (298,'Lengshuijiang',23,'2006-02-15 04:45:25'),
 (299,'Leshan',23,'2006-02-15 04:45:25'),
 (300,'Lethbridge',20,'2006-02-15 04:45:25'),
 (301,'Lhokseumawe',45,'2006-02-15 04:45:25'),
 (302,'Liaocheng',23,'2006-02-15 04:45:25'),
 (303,'Liepaja',54,'2006-02-15 04:45:25'),
 (304,'Lilongwe',58,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (305,'Lima',74,'2006-02-15 04:45:25'),
 (306,'Lincoln',103,'2006-02-15 04:45:25'),
 (307,'Linz',9,'2006-02-15 04:45:25'),
 (308,'Lipetsk',80,'2006-02-15 04:45:25'),
 (309,'Livorno',49,'2006-02-15 04:45:25'),
 (310,'Ljubertsy',80,'2006-02-15 04:45:25'),
 (311,'Loja',28,'2006-02-15 04:45:25'),
 (312,'London',102,'2006-02-15 04:45:25'),
 (313,'London',20,'2006-02-15 04:45:25'),
 (314,'Lublin',76,'2006-02-15 04:45:25'),
 (315,'Lubumbashi',25,'2006-02-15 04:45:25'),
 (316,'Lungtan',92,'2006-02-15 04:45:25'),
 (317,'Luzinia',15,'2006-02-15 04:45:25'),
 (318,'Madiun',45,'2006-02-15 04:45:25'),
 (319,'Mahajanga',57,'2006-02-15 04:45:25'),
 (320,'Maikop',80,'2006-02-15 04:45:25'),
 (321,'Malm',90,'2006-02-15 04:45:25'),
 (322,'Manchester',103,'2006-02-15 04:45:25'),
 (323,'Mandaluyong',75,'2006-02-15 04:45:25'),
 (324,'Mandi Bahauddin',72,'2006-02-15 04:45:25'),
 (325,'Mannheim',38,'2006-02-15 04:45:25'),
 (326,'Maracabo',104,'2006-02-15 04:45:25'),
 (327,'Mardan',72,'2006-02-15 04:45:25'),
 (328,'Maring',15,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (329,'Masqat',71,'2006-02-15 04:45:25'),
 (330,'Matamoros',60,'2006-02-15 04:45:25'),
 (331,'Matsue',50,'2006-02-15 04:45:25'),
 (332,'Meixian',23,'2006-02-15 04:45:25'),
 (333,'Memphis',103,'2006-02-15 04:45:25'),
 (334,'Merlo',6,'2006-02-15 04:45:25'),
 (335,'Mexicali',60,'2006-02-15 04:45:25'),
 (336,'Miraj',44,'2006-02-15 04:45:25'),
 (337,'Mit Ghamr',29,'2006-02-15 04:45:25'),
 (338,'Miyakonojo',50,'2006-02-15 04:45:25'),
 (339,'Mogiljov',13,'2006-02-15 04:45:25'),
 (340,'Molodetno',13,'2006-02-15 04:45:25'),
 (341,'Monclova',60,'2006-02-15 04:45:25'),
 (342,'Monywa',64,'2006-02-15 04:45:25'),
 (343,'Moscow',80,'2006-02-15 04:45:25'),
 (344,'Mosul',47,'2006-02-15 04:45:25'),
 (345,'Mukateve',100,'2006-02-15 04:45:25'),
 (346,'Munger (Monghyr)',44,'2006-02-15 04:45:25'),
 (347,'Mwanza',93,'2006-02-15 04:45:25'),
 (348,'Mwene-Ditu',25,'2006-02-15 04:45:25'),
 (349,'Myingyan',64,'2006-02-15 04:45:25'),
 (350,'Mysore',44,'2006-02-15 04:45:25'),
 (351,'Naala-Porto',63,'2006-02-15 04:45:25'),
 (352,'Nabereznyje Telny',80,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (353,'Nador',62,'2006-02-15 04:45:25'),
 (354,'Nagaon',44,'2006-02-15 04:45:25'),
 (355,'Nagareyama',50,'2006-02-15 04:45:25'),
 (356,'Najafabad',46,'2006-02-15 04:45:25'),
 (357,'Naju',86,'2006-02-15 04:45:25'),
 (358,'Nakhon Sawan',94,'2006-02-15 04:45:25'),
 (359,'Nam Dinh',105,'2006-02-15 04:45:25'),
 (360,'Namibe',4,'2006-02-15 04:45:25'),
 (361,'Nantou',92,'2006-02-15 04:45:25'),
 (362,'Nanyang',23,'2006-02-15 04:45:25'),
 (363,'NDjamna',21,'2006-02-15 04:45:25'),
 (364,'Newcastle',85,'2006-02-15 04:45:25'),
 (365,'Nezahualcyotl',60,'2006-02-15 04:45:25'),
 (366,'Nha Trang',105,'2006-02-15 04:45:25'),
 (367,'Niznekamsk',80,'2006-02-15 04:45:25'),
 (368,'Novi Sad',108,'2006-02-15 04:45:25'),
 (369,'Novoterkassk',80,'2006-02-15 04:45:25'),
 (370,'Nukualofa',95,'2006-02-15 04:45:25'),
 (371,'Nuuk',40,'2006-02-15 04:45:25'),
 (372,'Nyeri',52,'2006-02-15 04:45:25'),
 (373,'Ocumare del Tuy',104,'2006-02-15 04:45:25'),
 (374,'Ogbomosho',69,'2006-02-15 04:45:25'),
 (375,'Okara',72,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (376,'Okayama',50,'2006-02-15 04:45:25'),
 (377,'Okinawa',50,'2006-02-15 04:45:25'),
 (378,'Olomouc',26,'2006-02-15 04:45:25'),
 (379,'Omdurman',89,'2006-02-15 04:45:25'),
 (380,'Omiya',50,'2006-02-15 04:45:25'),
 (381,'Ondo',69,'2006-02-15 04:45:25'),
 (382,'Onomichi',50,'2006-02-15 04:45:25'),
 (383,'Oshawa',20,'2006-02-15 04:45:25'),
 (384,'Osmaniye',97,'2006-02-15 04:45:25'),
 (385,'ostka',100,'2006-02-15 04:45:25'),
 (386,'Otsu',50,'2006-02-15 04:45:25'),
 (387,'Oulu',33,'2006-02-15 04:45:25'),
 (388,'Ourense (Orense)',87,'2006-02-15 04:45:25'),
 (389,'Owo',69,'2006-02-15 04:45:25'),
 (390,'Oyo',69,'2006-02-15 04:45:25'),
 (391,'Ozamis',75,'2006-02-15 04:45:25'),
 (392,'Paarl',85,'2006-02-15 04:45:25'),
 (393,'Pachuca de Soto',60,'2006-02-15 04:45:25'),
 (394,'Pak Kret',94,'2006-02-15 04:45:25'),
 (395,'Palghat (Palakkad)',44,'2006-02-15 04:45:25'),
 (396,'Pangkal Pinang',45,'2006-02-15 04:45:25'),
 (397,'Papeete',36,'2006-02-15 04:45:25'),
 (398,'Parbhani',44,'2006-02-15 04:45:25'),
 (399,'Pathankot',44,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (400,'Patiala',44,'2006-02-15 04:45:25'),
 (401,'Patras',39,'2006-02-15 04:45:25'),
 (402,'Pavlodar',51,'2006-02-15 04:45:25'),
 (403,'Pemalang',45,'2006-02-15 04:45:25'),
 (404,'Peoria',103,'2006-02-15 04:45:25'),
 (405,'Pereira',24,'2006-02-15 04:45:25'),
 (406,'Phnom Penh',18,'2006-02-15 04:45:25'),
 (407,'Pingxiang',23,'2006-02-15 04:45:25'),
 (408,'Pjatigorsk',80,'2006-02-15 04:45:25'),
 (409,'Plock',76,'2006-02-15 04:45:25'),
 (410,'Po',15,'2006-02-15 04:45:25'),
 (411,'Ponce',77,'2006-02-15 04:45:25'),
 (412,'Pontianak',45,'2006-02-15 04:45:25'),
 (413,'Poos de Caldas',15,'2006-02-15 04:45:25'),
 (414,'Portoviejo',28,'2006-02-15 04:45:25'),
 (415,'Probolinggo',45,'2006-02-15 04:45:25'),
 (416,'Pudukkottai',44,'2006-02-15 04:45:25'),
 (417,'Pune',44,'2006-02-15 04:45:25'),
 (418,'Purnea (Purnia)',44,'2006-02-15 04:45:25'),
 (419,'Purwakarta',45,'2006-02-15 04:45:25'),
 (420,'Pyongyang',70,'2006-02-15 04:45:25'),
 (421,'Qalyub',29,'2006-02-15 04:45:25'),
 (422,'Qinhuangdao',23,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (423,'Qomsheh',46,'2006-02-15 04:45:25'),
 (424,'Quilmes',6,'2006-02-15 04:45:25'),
 (425,'Rae Bareli',44,'2006-02-15 04:45:25'),
 (426,'Rajkot',44,'2006-02-15 04:45:25'),
 (427,'Rampur',44,'2006-02-15 04:45:25'),
 (428,'Rancagua',22,'2006-02-15 04:45:25'),
 (429,'Ranchi',44,'2006-02-15 04:45:25'),
 (430,'Richmond Hill',20,'2006-02-15 04:45:25'),
 (431,'Rio Claro',15,'2006-02-15 04:45:25'),
 (432,'Rizhao',23,'2006-02-15 04:45:25'),
 (433,'Roanoke',103,'2006-02-15 04:45:25'),
 (434,'Robamba',28,'2006-02-15 04:45:25'),
 (435,'Rockford',103,'2006-02-15 04:45:25'),
 (436,'Ruse',17,'2006-02-15 04:45:25'),
 (437,'Rustenburg',85,'2006-02-15 04:45:25'),
 (438,'s-Hertogenbosch',67,'2006-02-15 04:45:25'),
 (439,'Saarbrcken',38,'2006-02-15 04:45:25'),
 (440,'Sagamihara',50,'2006-02-15 04:45:25'),
 (441,'Saint Louis',103,'2006-02-15 04:45:25'),
 (442,'Saint-Denis',79,'2006-02-15 04:45:25'),
 (443,'Sal',62,'2006-02-15 04:45:25'),
 (444,'Salala',71,'2006-02-15 04:45:25'),
 (445,'Salamanca',60,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (446,'Salinas',103,'2006-02-15 04:45:25'),
 (447,'Salzburg',9,'2006-02-15 04:45:25'),
 (448,'Sambhal',44,'2006-02-15 04:45:25'),
 (449,'San Bernardino',103,'2006-02-15 04:45:25'),
 (450,'San Felipe de Puerto Plata',27,'2006-02-15 04:45:25'),
 (451,'San Felipe del Progreso',60,'2006-02-15 04:45:25'),
 (452,'San Juan Bautista Tuxtepec',60,'2006-02-15 04:45:25'),
 (453,'San Lorenzo',73,'2006-02-15 04:45:25'),
 (454,'San Miguel de Tucumn',6,'2006-02-15 04:45:25'),
 (455,'Sanaa',107,'2006-02-15 04:45:25'),
 (456,'Santa Brbara dOeste',15,'2006-02-15 04:45:25'),
 (457,'Santa F',6,'2006-02-15 04:45:25'),
 (458,'Santa Rosa',75,'2006-02-15 04:45:25'),
 (459,'Santiago de Compostela',87,'2006-02-15 04:45:25'),
 (460,'Santiago de los Caballeros',27,'2006-02-15 04:45:25'),
 (461,'Santo Andr',15,'2006-02-15 04:45:25'),
 (462,'Sanya',23,'2006-02-15 04:45:25'),
 (463,'Sasebo',50,'2006-02-15 04:45:25'),
 (464,'Satna',44,'2006-02-15 04:45:25'),
 (465,'Sawhaj',29,'2006-02-15 04:45:25'),
 (466,'Serpuhov',80,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (467,'Shahr-e Kord',46,'2006-02-15 04:45:25'),
 (468,'Shanwei',23,'2006-02-15 04:45:25'),
 (469,'Shaoguan',23,'2006-02-15 04:45:25'),
 (470,'Sharja',101,'2006-02-15 04:45:25'),
 (471,'Shenzhen',23,'2006-02-15 04:45:25'),
 (472,'Shikarpur',72,'2006-02-15 04:45:25'),
 (473,'Shimoga',44,'2006-02-15 04:45:25'),
 (474,'Shimonoseki',50,'2006-02-15 04:45:25'),
 (475,'Shivapuri',44,'2006-02-15 04:45:25'),
 (476,'Shubra al-Khayma',29,'2006-02-15 04:45:25'),
 (477,'Siegen',38,'2006-02-15 04:45:25'),
 (478,'Siliguri (Shiliguri)',44,'2006-02-15 04:45:25'),
 (479,'Simferopol',100,'2006-02-15 04:45:25'),
 (480,'Sincelejo',24,'2006-02-15 04:45:25'),
 (481,'Sirjan',46,'2006-02-15 04:45:25'),
 (482,'Sivas',97,'2006-02-15 04:45:25'),
 (483,'Skikda',2,'2006-02-15 04:45:25'),
 (484,'Smolensk',80,'2006-02-15 04:45:25'),
 (485,'So Bernardo do Campo',15,'2006-02-15 04:45:25'),
 (486,'So Leopoldo',15,'2006-02-15 04:45:25'),
 (487,'Sogamoso',24,'2006-02-15 04:45:25'),
 (488,'Sokoto',69,'2006-02-15 04:45:25'),
 (489,'Songkhla',94,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (490,'Sorocaba',15,'2006-02-15 04:45:25'),
 (491,'Soshanguve',85,'2006-02-15 04:45:25'),
 (492,'Sousse',96,'2006-02-15 04:45:25'),
 (493,'South Hill',5,'2006-02-15 04:45:25'),
 (494,'Southampton',102,'2006-02-15 04:45:25'),
 (495,'Southend-on-Sea',102,'2006-02-15 04:45:25'),
 (496,'Southport',102,'2006-02-15 04:45:25'),
 (497,'Springs',85,'2006-02-15 04:45:25'),
 (498,'Stara Zagora',17,'2006-02-15 04:45:25'),
 (499,'Sterling Heights',103,'2006-02-15 04:45:25'),
 (500,'Stockport',102,'2006-02-15 04:45:25'),
 (501,'Sucre',14,'2006-02-15 04:45:25'),
 (502,'Suihua',23,'2006-02-15 04:45:25'),
 (503,'Sullana',74,'2006-02-15 04:45:25'),
 (504,'Sultanbeyli',97,'2006-02-15 04:45:25'),
 (505,'Sumqayit',10,'2006-02-15 04:45:25'),
 (506,'Sumy',100,'2006-02-15 04:45:25'),
 (507,'Sungai Petani',59,'2006-02-15 04:45:25'),
 (508,'Sunnyvale',103,'2006-02-15 04:45:25'),
 (509,'Surakarta',45,'2006-02-15 04:45:25'),
 (510,'Syktyvkar',80,'2006-02-15 04:45:25'),
 (511,'Syrakusa',49,'2006-02-15 04:45:25'),
 (512,'Szkesfehrvr',43,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (513,'Tabora',93,'2006-02-15 04:45:25'),
 (514,'Tabriz',46,'2006-02-15 04:45:25'),
 (515,'Tabuk',82,'2006-02-15 04:45:25'),
 (516,'Tafuna',3,'2006-02-15 04:45:25'),
 (517,'Taguig',75,'2006-02-15 04:45:25'),
 (518,'Taizz',107,'2006-02-15 04:45:25'),
 (519,'Talavera',75,'2006-02-15 04:45:25'),
 (520,'Tallahassee',103,'2006-02-15 04:45:25'),
 (521,'Tama',50,'2006-02-15 04:45:25'),
 (522,'Tambaram',44,'2006-02-15 04:45:25'),
 (523,'Tanauan',75,'2006-02-15 04:45:25'),
 (524,'Tandil',6,'2006-02-15 04:45:25'),
 (525,'Tangail',12,'2006-02-15 04:45:25'),
 (526,'Tanshui',92,'2006-02-15 04:45:25'),
 (527,'Tanza',75,'2006-02-15 04:45:25'),
 (528,'Tarlac',75,'2006-02-15 04:45:25'),
 (529,'Tarsus',97,'2006-02-15 04:45:25'),
 (530,'Tartu',30,'2006-02-15 04:45:25'),
 (531,'Teboksary',80,'2006-02-15 04:45:25'),
 (532,'Tegal',45,'2006-02-15 04:45:25'),
 (533,'Tel Aviv-Jaffa',48,'2006-02-15 04:45:25'),
 (534,'Tete',63,'2006-02-15 04:45:25'),
 (535,'Tianjin',23,'2006-02-15 04:45:25'),
 (536,'Tiefa',23,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (537,'Tieli',23,'2006-02-15 04:45:25'),
 (538,'Tokat',97,'2006-02-15 04:45:25'),
 (539,'Tonghae',86,'2006-02-15 04:45:25'),
 (540,'Tongliao',23,'2006-02-15 04:45:25'),
 (541,'Torren',60,'2006-02-15 04:45:25'),
 (542,'Touliu',92,'2006-02-15 04:45:25'),
 (543,'Toulon',34,'2006-02-15 04:45:25'),
 (544,'Toulouse',34,'2006-02-15 04:45:25'),
 (545,'Trshavn',32,'2006-02-15 04:45:25'),
 (546,'Tsaotun',92,'2006-02-15 04:45:25'),
 (547,'Tsuyama',50,'2006-02-15 04:45:25'),
 (548,'Tuguegarao',75,'2006-02-15 04:45:25'),
 (549,'Tychy',76,'2006-02-15 04:45:25'),
 (550,'Udaipur',44,'2006-02-15 04:45:25'),
 (551,'Udine',49,'2006-02-15 04:45:25'),
 (552,'Ueda',50,'2006-02-15 04:45:25'),
 (553,'Uijongbu',86,'2006-02-15 04:45:25'),
 (554,'Uluberia',44,'2006-02-15 04:45:25'),
 (555,'Urawa',50,'2006-02-15 04:45:25'),
 (556,'Uruapan',60,'2006-02-15 04:45:25'),
 (557,'Usak',97,'2006-02-15 04:45:25'),
 (558,'Usolje-Sibirskoje',80,'2006-02-15 04:45:25'),
 (559,'Uttarpara-Kotrung',44,'2006-02-15 04:45:25'),
 (560,'Vaduz',55,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (561,'Valencia',104,'2006-02-15 04:45:25'),
 (562,'Valle de la Pascua',104,'2006-02-15 04:45:25'),
 (563,'Valle de Santiago',60,'2006-02-15 04:45:25'),
 (564,'Valparai',44,'2006-02-15 04:45:25'),
 (565,'Vancouver',20,'2006-02-15 04:45:25'),
 (566,'Varanasi (Benares)',44,'2006-02-15 04:45:25'),
 (567,'Vicente Lpez',6,'2006-02-15 04:45:25'),
 (568,'Vijayawada',44,'2006-02-15 04:45:25'),
 (569,'Vila Velha',15,'2006-02-15 04:45:25'),
 (570,'Vilnius',56,'2006-02-15 04:45:25'),
 (571,'Vinh',105,'2006-02-15 04:45:25'),
 (572,'Vitria de Santo Anto',15,'2006-02-15 04:45:25'),
 (573,'Warren',103,'2006-02-15 04:45:25'),
 (574,'Weifang',23,'2006-02-15 04:45:25'),
 (575,'Witten',38,'2006-02-15 04:45:25'),
 (576,'Woodridge',8,'2006-02-15 04:45:25'),
 (577,'Wroclaw',76,'2006-02-15 04:45:25'),
 (578,'Xiangfan',23,'2006-02-15 04:45:25'),
 (579,'Xiangtan',23,'2006-02-15 04:45:25'),
 (580,'Xintai',23,'2006-02-15 04:45:25'),
 (581,'Xinxiang',23,'2006-02-15 04:45:25'),
 (582,'Yamuna Nagar',44,'2006-02-15 04:45:25'),
 (583,'Yangor',65,'2006-02-15 04:45:25');
INSERT INTO `sakila`.`city` VALUES  (584,'Yantai',23,'2006-02-15 04:45:25'),
 (585,'Yaound',19,'2006-02-15 04:45:25'),
 (586,'Yerevan',7,'2006-02-15 04:45:25'),
 (587,'Yinchuan',23,'2006-02-15 04:45:25'),
 (588,'Yingkou',23,'2006-02-15 04:45:25'),
 (589,'York',102,'2006-02-15 04:45:25'),
 (590,'Yuncheng',23,'2006-02-15 04:45:25'),
 (591,'Yuzhou',23,'2006-02-15 04:45:25'),
 (592,'Zalantun',23,'2006-02-15 04:45:25'),
 (593,'Zanzibar',93,'2006-02-15 04:45:25'),
 (594,'Zaoyang',23,'2006-02-15 04:45:25'),
 (595,'Zapopan',60,'2006-02-15 04:45:25'),
 (596,'Zaria',69,'2006-02-15 04:45:25'),
 (597,'Zeleznogorsk',80,'2006-02-15 04:45:25'),
 (598,'Zhezqazghan',51,'2006-02-15 04:45:25'),
 (599,'Zhoushan',23,'2006-02-15 04:45:25'),
 (600,'Ziguinchor',83,'2006-02-15 04:45:25');
UNLOCK TABLES;
/*!40000 ALTER TABLE `city` ENABLE KEYS */;


--
-- Definition of function `sakila`.`get_customer_balance`
--

DROP FUNCTION IF EXISTS `sakila`.`get_customer_balance`;

DELIMITER $$

CREATE DEFINER=`root`@`%` FUNCTION  `sakila`.`get_customer_balance`(p_customer_id INT, p_effective_date DATETIME) RETURNS decimal(5,2)
    READS SQL DATA
    DETERMINISTIC
BEGIN
       
       
       
       
       
       
  DECLARE v_rentfees DECIMAL(5,2); 
  DECLARE v_overfees INTEGER;      
  DECLARE v_payments DECIMAL(5,2); 
  SELECT IFNULL(SUM(film.rental_rate),0) INTO v_rentfees
    FROM film, inventory, rental
    WHERE film.film_id = inventory.film_id
      AND inventory.inventory_id = rental.inventory_id
      AND rental.rental_date <= p_effective_date
      AND rental.customer_id = p_customer_id;
  SELECT IFNULL(SUM(IF((TO_DAYS(rental.return_date) - TO_DAYS(rental.rental_date)) > film.rental_duration,
        ((TO_DAYS(rental.return_date) - TO_DAYS(rental.rental_date)) - film.rental_duration),0)),0) INTO v_overfees
    FROM rental, inventory, film
    WHERE film.film_id = inventory.film_id
      AND inventory.inventory_id = rental.inventory_id
      AND rental.rental_date <= p_effective_date
      AND rental.customer_id = p_customer_id;
  SELECT IFNULL(SUM(payment.amount),0) INTO v_payments
    FROM payment
    WHERE payment.payment_date <= p_effective_date
    AND payment.customer_id = p_customer_id;
  RETURN v_rentfees + v_overfees - v_payments;
END $$

DELIMITER ;

--
-- Definition of function `sakila`.`inventory_in_stock`
--

DROP FUNCTION IF EXISTS `sakila`.`inventory_in_stock`;

DELIMITER $$

CREATE DEFINER=`root`@`%` FUNCTION  `sakila`.`inventory_in_stock`(p_inventory_id INT) RETURNS tinyint(1)
    READS SQL DATA
BEGIN
    DECLARE v_rentals INT;
    DECLARE v_out     INT;
    
    
    SELECT COUNT(*) INTO v_rentals
    FROM rental
    WHERE inventory_id = p_inventory_id;
    IF v_rentals = 0 THEN
      RETURN TRUE;
    END IF;
    SELECT COUNT(rental_id) INTO v_out
    FROM inventory LEFT JOIN rental USING(inventory_id)
    WHERE inventory.inventory_id = p_inventory_id
    AND rental.return_date IS NULL;
    IF v_out > 0 THEN
      RETURN FALSE;
    ELSE
      RETURN TRUE;
    END IF;
END $$

DELIMITER ;

--
-- Definition of procedure `sakila`.`film_in_stock`
--

DROP PROCEDURE IF EXISTS `sakila`.`film_in_stock`;

DELIMITER $$

CREATE DEFINER=`root`@`%` PROCEDURE  `sakila`.`film_in_stock`(IN p_film_id INT, IN p_store_id INT, OUT p_film_count INT)
    READS SQL DATA
BEGIN
     SELECT inventory_id
     FROM inventory
     WHERE film_id = p_film_id
     AND store_id = p_store_id
     AND inventory_in_stock(inventory_id);
     SELECT FOUND_ROWS() INTO p_film_count;
END $$

DELIMITER ;

--
-- Definition of procedure `sakila`.`film_not_in_stock`
--

DROP PROCEDURE IF EXISTS `sakila`.`film_not_in_stock`;

DELIMITER $$

CREATE DEFINER=`root`@`%` PROCEDURE  `sakila`.`film_not_in_stock`(IN p_film_id INT, IN p_store_id INT, OUT p_film_count INT)
    READS SQL DATA
BEGIN
     SELECT inventory_id
     FROM inventory
     WHERE film_id = p_film_id
     AND store_id = p_store_id
     AND NOT inventory_in_stock(inventory_id);
     SELECT FOUND_ROWS() INTO p_film_count;
END $$

DELIMITER ;

--
-- Definition of view `sakila`.`film_list`
--

DROP TABLE IF EXISTS `sakila`.`film_list`;
DROP VIEW IF EXISTS `sakila`.`film_list`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `sakila`.`film_list` AS select `sakila`.`film`.`film_id` AS `FID`,`sakila`.`film`.`title` AS `title`,`sakila`.`film`.`description` AS `description`,`sakila`.`category`.`name` AS `category`,`sakila`.`film`.`rental_rate` AS `price`,`sakila`.`film`.`length` AS `length`,`sakila`.`film`.`rating` AS `rating`,group_concat(concat(`sakila`.`actor`.`first_name`,_utf8' ',`sakila`.`actor`.`last_name`) separator ', ') AS `actors` from ((((`sakila`.`category` left join `sakila`.`film_category` on((`sakila`.`category`.`category_id` = `sakila`.`film_category`.`category_id`))) left join `sakila`.`film` on((`sakila`.`film_category`.`film_id` = `sakila`.`film`.`film_id`))) join `sakila`.`film_actor` on((`sakila`.`film`.`film_id` = `sakila`.`film_actor`.`film_id`))) join `sakila`.`actor` on((`sakila`.`film_actor`.`actor_id` = `sakila`.`actor`.`actor_id`))) group by `sakila`.`film`.`film_id`;

--
-- Definition of view `sakila`.`actor_info`
--

DROP TABLE IF EXISTS `sakila`.`actor_info`;
DROP VIEW IF EXISTS `sakila`.`actor_info`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY INVOKER VIEW `sakila`.`actor_info` AS select `a`.`actor_id` AS `actor_id`,`a`.`first_name` AS `first_name`,`a`.`last_name` AS `last_name`,group_concat(distinct concat(`c`.`name`,_utf8': ',(select group_concat(`f`.`title` order by `f`.`title` ASC separator ', ') AS `GROUP_CONCAT(f.title ORDER BY f.title SEPARATOR ', ')` from ((`sakila`.`film` `f` join `sakila`.`film_category` `fc` on((`f`.`film_id` = `fc`.`film_id`))) join `sakila`.`film_actor` `fa` on((`f`.`film_id` = `fa`.`film_id`))) where ((`fc`.`category_id` = `c`.`category_id`) and (`fa`.`actor_id` = `a`.`actor_id`)))) order by `c`.`name` ASC separator '; ') AS `film_info` from (((`sakila`.`actor` `a` left join `sakila`.`film_actor` `fa` on((`a`.`actor_id` = `fa`.`actor_id`))) left join `sakila`.`film_category` `fc` on((`fa`.`film_id` = `fc`.`film_id`))) left join `sakila`.`category` `c` on((`fc`.`category_id` = `c`.`category_id`))) group by `a`.`actor_id`,`a`.`first_name`,`a`.`last_name`;

--
-- Definition of view `sakila`.`sales_by_store`
--

DROP TABLE IF EXISTS `sakila`.`sales_by_store`;
DROP VIEW IF EXISTS `sakila`.`sales_by_store`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`%` SQL SECURITY DEFINER VIEW `sakila`.`sales_by_store` AS select concat(`c`.`city`,_utf8',',`cy`.`country`) AS `store`,concat(`m`.`first_name`,_utf8' ',`m`.`last_name`) AS `manager`,sum(`p`.`amount`) AS `total_sales` from (((((((`sakila`.`payment` `p` join `sakila`.`rental` `r` on((`p`.`rental_id` = `r`.`rental_id`))) join `sakila`.`inventory` `i` on((`r`.`inventory_id` = `i`.`inventory_id`))) join `sakila`.`store` `s` on((`i`.`store_id` = `s`.`store_id`))) join `sakila`.`address` `a` on((`s`.`address_id` = `a`.`address_id`))) join `sakila`.`city` `c` on((`a`.`city_id` = `c`.`city_id`))) join `sakila`.`country` `cy` on((`c`.`country_id` = `cy`.`country_id`))) join `sakila`.`staff` `m` on((`s`.`manager_staff_id` = `m`.`staff_id`))) group by `s`.`store_id` order by `cy`.`country`,`c`.`city`;



/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
