#include "edit.h"
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qvbox.h>
#include <qstatusbar.h>
#include <qpixmap.h>
#include "x.xpm"

Edit::Edit(QWidget *parent,const char *, int)
	: QMainWindow(parent, "MySQL Navigator", WStyle_Customize | WStyle_Title | WStyle_NormalBorder | WStyle_SysMenu | WStyle_ContextHelp | WStyle_DialogBorder | WStyle_ContextHelp) 
{
	make_central_widget();	

	make_menubar();	
	
	setIcon(QPixmap(x_xpm));
}

Edit::~Edit()
{
}

void Edit::make_menubar()
{
	QPopupMenu *z = new QPopupMenu();
	z->insertItem(tr("&New"), this, SLOT(slot_new()), CTRL+Key_N);
	z->insertItem(tr("&Open"), this, SLOT(slot_open()), CTRL+Key_O);
	z->insertSeparator();
	z->insertItem(tr("&Save"), this, SLOT(slot_save()), CTRL+Key_S);
	z->insertItem(tr("Save &as..."), this, SLOT(slot_save_as()));
	z->insertSeparator();
	//z->insertItem(tr("&Close"), this, SLOT(slot_close()));
	//z->insertSeparator();
	z->insertItem(tr("Cl&ose"), this, SLOT(slot_close()));
	menuBar()->insertItem(tr("&File"), z);
	
	z = new QPopupMenu();
	z->insertItem(tr("&Undo"), this, SLOT(slot_undo()), CTRL+Key_U);
	z->insertItem(tr("&Redo"), this, SLOT(slot_redo()), CTRL+Key_R);
	z->insertSeparator();
	z->insertItem(tr("&Cut"), this, SLOT(slot_cut()), CTRL+Key_X);
	z->insertItem(tr("C&opy"), this, SLOT(slot_copy()), CTRL+Key_C);
	z->insertItem(tr("&Paste"), this, SLOT(slot_paste()), CTRL+Key_P);
	z->insertItem(tr("&Delete"), this, SLOT(slot_delete()), Key_Delete);
	z->insertSeparator();
	z->insertItem(tr("Select &All"), this, SLOT(slot_select_all()), CTRL+Key_A);
	menuBar()->insertItem(tr("&Edit"), z);
	
	//z = new QPopupMenu();
	//z->insertItem(tr("&About..."), this, SLOT(slot_about()));
	//menuBar()->insertItem(tr("&Help"), z);
}

void Edit::make_central_widget()
{
	QVBox *k=new QVBox(this);
	k->setFrameStyle( QFrame::StyledPanel | QFrame::Sunken );
    workspace = new QWorkspace(k);
    setCentralWidget(k);
				 
    statusBar()->message( tr("Ready..."), 3000 );   
}

void Edit::closeEvent(QCloseEvent *s)
{
	slot_close();

	s->accept();
}
