#include <string.h>
#include <qmessagebox.h>
#include <mainwindow.h>
#include <qdatetime.h>
#include "sql.h"
#include "loglistviewitem.h"

QString SQL::strip_comment(const char *sql)
{
	QString data;
	int size = strlen(sql);	
	int s = 0;

	for(int z = 0; z < size; z++)
	{
		if(s == 1)
		{
			if(sql[z] == '\'')
			{
				if(sql[z - 1] != '\\')
				{
					s = 0;
				}
			}
		}
		else if(s == 2)
		{
			if(sql[z] == '\"')
			{
				if(sql[z - 1] != '\\')
				{
					s = 0;
				}
			}
		}
		else
		{
			if(sql[z] == '\'')
			{
				if(sql[z - 1] != '\\')
				{
					s = 1;
				}
			}
			else if(sql[z] == '\"')
			{
				if(sql[z - 1] != '\\')
				{
					s = 2;
				}
			}

		}

		if(s == 0)
		{
			if(sql[z] != '#')
			{
				data += QChar(sql[z]);
			}
			else
			{
				while(TRUE)
				{
					if(sql[++z] == '\n')
						break;
				}
			}
		}
		else
		{
			data += QChar(sql[z]);
		}
	}

	data = data.stripWhiteSpace();

	if(data.at(data.length() -1) != ';')
		data += ";";

	return data;
}

QList<QString> SQL::split_sql(const char *sql)
{
	QList<QString> data;
	QString *value;
	value = new QString;
	int s = 0;
	int size = strlen(sql);

	for(int z = 0; z < size; z++)
	{
		if(s == 1)
		{
			if(sql[z] == '\'')
			{
				if(sql[z - 1] != '\\')
				{
					s = 0;
				}
			}
		}
		else if(s == 2)
		{
			if(sql[z] == '\"')
			{
				if(sql[z - 1] != '\\')
				{
					s = 0;
				}
			}
		}
		else
		{
			if(sql[z] == '\'')
			{
				if(sql[z - 1] != '\\')
				{
					s = 1;
				}
			}
			else if(sql[z] == '\"')
			{
				if(sql[z - 1] != '\\')
				{
					s = 2;
				}
			}
		}

		if(sql[z] == ';')
		{
			if(s == 0)
			{
				*value  += QChar(sql[z]);
				*value = (*value).stripWhiteSpace();	
				data.append(value);
				value = new QString;
			}
			else
			{
				*value  += QChar(sql[z]);
			}
		}
		else
		{
			*value += QChar(sql[z]);
		}
	}

	return data;
}

SQL::SQL()
{
	target = TARGET_NONE;
}

SQL::~SQL()
{
}

bool SQL::sql_init(int target)
{
	this->target = target;
	return TRUE;
}
bool SQL::sql_connect(const char *host, const char *user, const char *password, const char *database, unsigned int port, const char *socket, unsigned int s)
{
	return TRUE;
}

bool SQL::sql_connect(QMap<QString, QString>)
{
	return TRUE;
}

void SQL::sql_close()
{
}

int SQL::sql_query(const char *sql)
{
	int s = mysql_query(&((MainWindow *)qApp->mainWidget())->mysql, sql);

	if(s)
	{
		// error
		new LogListViewItem(((MainWindow *)qApp->mainWidget())->log, QString::number(((MainWindow *)qApp->mainWidget())->log->childCount() + 1), QTime::currentTime().toString(),  QString::fromLocal8Bit(sql), QString::fromLocal8Bit(mysql_error(&((MainWindow *)qApp->mainWidget())->mysql)));
	}
	else
	{
		new LogListViewItem(((MainWindow *)qApp->mainWidget())->log, QString::number(((MainWindow *)qApp->mainWidget())->log->childCount() + 1), QTime::currentTime().toString(),  QString::fromLocal8Bit(sql), "");
	}

	return s;
}

SQL_RESULT* SQL::sql_store_result()
{
	return NULL;
}

void SQL::sql_free_result(void *s)
{
	mysql_free_result((MYSQL_RES *)s);
}

unsigned int SQL::sql_num_fields(SQL_RESULT *)
{
	return TRUE;
}

unsigned int SQL::sql_num_rows(SQL_RESULT *)
{
	return TRUE;
}

SQL_RESULT* SQL::sql_list_dbs()
{
	return NULL;
}

int SQL::sql_select_db(const char *)
{
	return TRUE;
}

SQL_VALUE::SQL_VALUE()
{
	field = data = NULL;
}

SQL_VALUE::~SQL_VALUE()
{
}

SQL_RESULT::SQL_RESULT()
{
}

SQL_RESULT::~SQL_RESULT()
{
}
