/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util.printf;

import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.printf.DataFormatter;
import com.sap.dbtech.util.printf.FormatException;
import com.sap.dbtech.util.printf.PrintfArgumentMismatch;

class IntegerFormatter
extends DataFormatter {
    protected int radix;

    protected IntegerFormatter(String string) throws FormatException {
        super(string);
        switch (this.kind) {
            case 'o': {
                this.radix = 8;
                break;
            }
            case 'x': {
                this.radix = 16;
                break;
            }
            default: {
                this.radix = 10;
            }
        }
    }

    protected String formatObject(Object object, int n, int n2, int n3, boolean bl, char c) throws PrintfArgumentMismatch {
        Number number;
        try {
            number = (Number)object;
        }
        catch (ClassCastException classCastException) {
            throw new PrintfArgumentMismatch(MessageTranslator.translate("error.format.notanumber", object.toString()));
        }
        if (!bl) {
            c = (char)32;
        }
        long l = number.longValue();
        String string = Long.toString(l, this.radix);
        return this.formatString(string, n, n2, n3, bl, c);
    }
}

