/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util.printf;

import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.printf.DataFormatter;
import com.sap.dbtech.util.printf.FormatException;
import com.sap.dbtech.util.printf.Formatter;
import com.sap.dbtech.util.printf.IntegerFormatter;
import com.sap.dbtech.util.printf.LiteralFormatter;
import com.sap.dbtech.util.printf.OArrayEnumeration;
import com.sap.dbtech.util.printf.PrintfArgumentMismatch;
import com.sap.dbtech.util.printf.StringFormatter;

public class PrintfFormat {
    private Formatter[] formats;
    private int elements;

    public PrintfFormat(String string) throws FormatException {
        this.formats = this.parseFormatString(string);
    }

    private Formatter createFormatter(String string, char c) throws FormatException {
        DataFormatter dataFormatter;
        switch (c) {
            case 's': {
                dataFormatter = new StringFormatter(string);
                break;
            }
            case 'd': 
            case 'i': 
            case 'o': 
            case 'x': {
                dataFormatter = new IntegerFormatter(string);
                break;
            }
            default: {
                throw new FormatException(MessageTranslator.translate("error.format.unknown", String.valueOf(c)));
            }
        }
        return dataFormatter;
    }

    public String format(Object[] objectArray) throws PrintfArgumentMismatch {
        OArrayEnumeration oArrayEnumeration = new OArrayEnumeration(objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.elements; ++i) {
            stringBuffer.append(this.formats[i].format(oArrayEnumeration));
        }
        if (oArrayEnumeration.hasMoreElements()) {
            throw new PrintfArgumentMismatch(MessageTranslator.translate("error.format.toomanyargs"));
        }
        return stringBuffer.toString();
    }

    private Formatter[] parseFormatString(String string) throws FormatException {
        int n = 8;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        Formatter[] formatterArray = new Formatter[n];
        int n5 = 0;
        while (n2 < n4 && (n2 = string.indexOf(37, n3)) != -1) {
            char c;
            if (string.charAt(n2 + 1) == '%') {
                formatterArray[n5] = new LiteralFormatter("%");
                ++n5;
                ++n2;
                continue;
            }
            if (n5 + 3 > n) {
                Formatter[] formatterArray2 = new Formatter[n * 2];
                System.arraycopy(formatterArray, 0, formatterArray2, 0, n);
                n *= 2;
                formatterArray = formatterArray2;
            }
            formatterArray[n5] = new LiteralFormatter(string.substring(n3, n2));
            ++n5;
            n3 = n2;
            int n6 = n2;
            while ('a' > (c = string.charAt(++n2)) || c > 'z' || 'A' <= c && c <= 'Z') {
            }
            formatterArray[n5] = this.createFormatter(string.substring(n3, n2 + 1), c);
            ++n5;
            n3 = n2 + 1;
        }
        formatterArray[n5] = new LiteralFormatter(string.substring(n3));
        this.elements = n5 + 1;
        return formatterArray;
    }
}

