/*
 * Copyright (c) 2004-2005 Ricardo Fernández Pascual r.fernandez at ditec.um.es
 * Copyright (c) 2004-2005 The University of Wroclaw.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *    3. The name of the University may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE UNIVERSITY BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

using System.Threading;
 
namespace Nemerle.Concurrency
{
  public struct BitMask
  {
      mutable i : uint;

      public Set (m : uint) : void
      {
          i |= m
      }

      public Clear (m : uint) : void
      {
          i &= ~m
      }

      public Match (m : uint) : bool
      {
          (~i & m) == 0U
      }
  }

  public class ThreadQueue 
  {
      mutable signaled : bool = false;
      mutable count : int = 0;

      public Empty : bool 
      { 
          get 
          {
              count == 0
          } 
      }

      public Yield (currentLock : object) : void 
      {
          ++count;
          Monitor.Exit (currentLock);
          lock (this)
          {
              while (!signaled)
              {
                  ignore (Monitor.Wait (this))
              }
              signaled = false
          }
          Monitor.Enter (currentLock);
          --count
      }

      public Wakeup () : void
      {
          lock (this)
          {
              unless (signaled)
              {
                  signaled = true;
                  Monitor.Pulse (this)
              }
          }
      }
  }

  public class DummyQueue
  {
      mutable count :int = 0;
      public Add () : void 
      {
          ++count;
      }
      public Take () : void 
      {
          --count;
      }
      public IsEmpty : bool
      {
        get { count == 0; }
      }
  }
}
