//
// This tests checks that the compiler catches the special attributes
// for in a struct for CharSet, and turns the right bit on the TypeAttribute
//
using System;
using System.Reflection;
using System.Runtime.InteropServices;

[StructLayout(LayoutKind.Explicit, Size=32,CharSet=CharSet.Unicode)]
struct MyUnicode
{
	[FieldOffset(0)] public  mutable  fh_float : float;
	[FieldOffset(0)] public  mutable  fh_int : int;
}

[StructLayout(LayoutKind.Explicit, Size=32,CharSet=CharSet.Ansi)]
struct MyAnsi
{
	[FieldOffset(0)] public  mutable  fh_float : float;
	[FieldOffset(0)] public  mutable  fh_int : int;
}
[StructLayout(LayoutKind.Explicit, Size=32,CharSet=CharSet.Auto)]
struct MyAuto
{
	[FieldOffset(0)] public  mutable  fh_float : float;
	[FieldOffset(0)] public  mutable  fh_int : int;
}

class test
{
	
	static Main () :  int
	{
		mutable  errors = 0;
		mutable  t = typeof (MyUnicode);
	{

		when ((t.Attributes %& TypeAttributes.UnicodeClass) != TypeAttributes.UnicodeClass){
			Console.WriteLine ("Class MyUnicode does not have Unicode bit set");
			errors += 1;
		}

		t = typeof (MyAuto);
	{
		when ((t.Attributes %& TypeAttributes.AutoClass) != TypeAttributes.AutoClass){
			Console.WriteLine ("Class MyAuto does not have Auto bit set");
			errors += 2;
		}

		t = typeof (MyAnsi);
	{

		when ((t.Attributes %& TypeAttributes.AnsiClass) != TypeAttributes.AnsiClass){
			Console.WriteLine ("Class MyUnicode does not have Ansi bit set");
			errors += 4;
		}

		 errors;
	}
	}
	}
	}
}
/*
BEGIN-OUTPUT
END-OUTPUT
*/
