using M;

class ExpectStruct [T] where T : struct { }
class ExpectClass [T] where T : class { }
class ExpectNew [T] where T : new () { }

class X {
  private this () { }
  public this (_ : int) { }
}

class Q { }

module M {
  public FunStruct [T] (_ : T) : void
    where T : struct
  { }
  public FunClass [T] (_ : T) : void
    where T : class
  { }
  public FunNew [T] (_ : T) : void
    where T : new ()
  { }
}

_ = ExpectStruct.[int] (); // OK
_ = ExpectStruct.[string] (); // E: must be a value type
_ = ExpectClass.[int] (); // E: must be a reference type
_ = ExpectClass.[string] (); // OK
_ = ExpectClass.[Q] (); // OK
_ = ExpectNew.[int] (); // OK
_ = ExpectNew.[Q] (); // OK
_ = ExpectNew.[string] (); // E: must have a public parameterless constructor
_ = ExpectNew.[System.Console] (); // E: must have a public parameterless constructor
_ = ExpectNew.[X] (); // E: must have a public parameterless constructor

FunStruct (3); // OK
FunStruct ("foo"); // E: must be a value type
FunClass (3);  // E: must be a reference type
FunClass ("foo"); // OK

FunNew (3); // OK
FunNew ("foo"); // E: must have a public parameterless constructor
FunNew (X (3)); // E: must have a public parameterless constructor
FunNew (ExpectStruct.[int] ()); // OK
FunNew (Q ()); // OK
